/*
 * Decompiled with CFR 0.152.
 */
package tiled.mapeditor.actions;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;
import tiled.core.Map;
import tiled.mapeditor.MapEditor;
import tiled.mapeditor.Resources;
import tiled.mapeditor.util.ConfirmableFileFilter;
import tiled.mapeditor.util.ConfirmingFileChooser;
import tiled.view.MapView;

public class SaveAsImageAction
extends AbstractAction {
    private final MapEditor editor;
    private final Frame appFrame;
    private static final String ACTION_NAME = Resources.getString("action.map.saveasimage.name");
    private static final String ACTION_TOOLTIP = Resources.getString("action.map.saveasimage.tooltip");
    private static final String DIALOG_TITLE = Resources.getString("dialog.saveasimage.title");

    public SaveAsImageAction(MapEditor editor) {
        super(ACTION_NAME);
        this.putValue("ShortDescription", ACTION_TOOLTIP);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control shift I"));
        this.editor = editor;
        this.appFrame = editor.getAppFrame();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String[] names;
        if (this.editor.getCurrentMap() == null) {
            return;
        }
        ConfirmingFileChooser chooser = new ConfirmingFileChooser();
        chooser.setDialogTitle(DIALOG_TITLE);
        FileFilter defaultFilter = chooser.getFileFilter();
        for (String name : names = ImageIO.getWriterFormatNames()) {
            if (!name.matches("[A-Z].*")) continue;
            chooser.addChoosableFileFilter(new BasicFileFilter(name, name.toLowerCase()));
        }
        chooser.setFileFilter(defaultFilter);
        if (((JFileChooser)chooser).showSaveDialog(this.appFrame) == 0) {
            this.saveMapImage(chooser.getSelectedFile().getAbsolutePath());
        }
    }

    private void saveMapImage(String filename) {
        Map currentMap = this.editor.getCurrentMap();
        MapView myView = MapView.createViewforMap(currentMap);
        myView.setMode(8, true);
        MapView mapView = this.editor.getMapView();
        myView.setShowGrid(mapView.getShowGrid());
        myView.setZoom(mapView.getZoom());
        Dimension imgSize = myView.getPreferredSize();
        int lastDot = filename.lastIndexOf(46);
        if (lastDot == -1) {
            JOptionPane.showMessageDialog(this.appFrame, "No file format specified.", "Error while saving map image", 0);
            return;
        }
        String format = filename.substring(lastDot + 1);
        try {
            BufferedImage img = new BufferedImage(imgSize.width, imgSize.height, 1);
            Graphics2D g = img.createGraphics();
            g.setClip(0, 0, imgSize.width, imgSize.height);
            myView.paint(g);
            try {
                ImageIO.write((RenderedImage)img, format, new File(filename));
            }
            catch (IOException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(this.appFrame, "Error while saving " + filename + ": " + e.toString(), "Error while saving map image", 0);
            }
        }
        catch (OutOfMemoryError memoryError) {
            JOptionPane.showMessageDialog(this.appFrame, "Out of memory while creating image. Try increasing\nyour maximum heap size or zooming out a bit.", "Out of memory", 0);
        }
    }

    public class BasicFileFilter
    extends ConfirmableFileFilter {
        private final String extension;
        private final String description;

        public BasicFileFilter(String description, String extension) {
            this.description = description;
            this.extension = extension;
        }

        @Override
        public String getDefaultExtension() {
            return this.extension;
        }

        @Override
        public boolean accept(File file) {
            String fileName = file.getPath().toLowerCase();
            return file.isDirectory() || fileName.endsWith("." + this.extension);
        }

        @Override
        public String getDescription() {
            return this.description + " (*." + this.extension + ")";
        }
    }
}

