/*
 * Decompiled with CFR 0.152.
 */
package tiled.mapeditor.animation;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import tiled.core.Sprite;

public class KeyDialog
extends JDialog
implements ActionListener,
MouseListener {
    private Sprite sprite;
    private JDialog owner;
    private JList keysList;
    private JTextField tName;
    private JTextField tStart;
    private JTextField tFinish;
    private JTextField tRate;
    private JRadioButton rbLoop;
    private JRadioButton rbStop;
    private JRadioButton rbReverse;
    private JRadioButton rbAuto;

    public KeyDialog(JDialog o, Sprite s) {
        this.owner = o;
        this.sprite = s;
    }

    private void init() {
        ButtonGroup bg = new ButtonGroup();
        this.setSize(380, 180);
        GridBagConstraints c = new GridBagConstraints();
        JScrollPane sp = new JScrollPane();
        c.fill = 1;
        this.getContentPane().setLayout(new GridBagLayout());
        sp.setSize(50, 200);
        this.keysList = new JList();
        this.queryKeys();
        this.keysList.addMouseListener(this);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        c.gridheight = 6;
        c.gridwidth = 2;
        sp.getViewport().setView(this.keysList);
        this.getContentPane().add((Component)sp, c);
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.5;
        c.weighty = 0.5;
        c.gridx = 2;
        this.tName = new JTextField(32);
        this.tName.setToolTipText("The key name (32) max");
        this.getContentPane().add((Component)this.tName, c);
        c.gridy = 1;
        this.tStart = new JTextField(4);
        this.tStart.setToolTipText("The first frame");
        this.getContentPane().add((Component)this.tStart, c);
        c.gridy = 2;
        this.tFinish = new JTextField(4);
        this.tFinish.setToolTipText("The last frame");
        this.getContentPane().add((Component)this.tFinish, c);
        c.gridy = 3;
        this.tRate = new JTextField(4);
        this.tRate.setToolTipText("The frame rate");
        this.getContentPane().add((Component)this.tRate, c);
        c.gridy = 6;
        c.gridx = 0;
        JButton b = new JButton("New Key");
        b.addActionListener(this);
        this.getContentPane().add((Component)b, c);
        c.gridx = 1;
        b = new JButton("Delete Key");
        b.addActionListener(this);
        this.getContentPane().add((Component)b, c);
        c.gridx = 2;
        b = new JButton("Apply");
        b.addActionListener(this);
        this.getContentPane().add((Component)b, c);
        c.gridx = 3;
        b = new JButton("OK");
        b.addActionListener(this);
        this.getContentPane().add((Component)b, c);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 3;
        c.gridy = 0;
        this.rbLoop = new JRadioButton("Looping");
        this.rbLoop.setActionCommand("loop");
        this.rbLoop.addActionListener(this);
        this.getContentPane().add((Component)this.rbLoop, c);
        bg.add(this.rbLoop);
        this.rbStop = new JRadioButton("Stop");
        this.rbStop.setActionCommand("stop");
        this.rbStop.addActionListener(this);
        c.gridy = 1;
        this.getContentPane().add((Component)this.rbStop, c);
        bg.add(this.rbStop);
        this.rbReverse = new JRadioButton("Reverse");
        this.rbReverse.setActionCommand("reverse");
        this.rbReverse.addActionListener(this);
        c.gridy = 2;
        this.getContentPane().add((Component)this.rbReverse, c);
        bg.add(this.rbReverse);
        this.rbAuto = new JRadioButton("Auto Jump");
        this.rbAuto.setActionCommand("auto");
        this.rbAuto.addActionListener(this);
        c.gridy = 3;
        this.getContentPane().add((Component)this.rbAuto, c);
        bg.add(this.rbAuto);
    }

    private void updateFields() {
        Sprite.KeyFrame key = this.sprite.getKey((String)this.keysList.getSelectedValue());
        if (key != null) {
            this.tName.setText(key.getName());
            this.tRate.setText(String.valueOf(key.getFrameRate()));
            this.rbLoop.setSelected(false);
            this.rbStop.setSelected(false);
            this.rbReverse.setSelected(false);
            this.rbAuto.setSelected(false);
            switch (key.getFlags() & 0xF) {
                case 1: {
                    this.rbLoop.setSelected(true);
                    break;
                }
                case 2: {
                    this.rbStop.setSelected(true);
                    break;
                }
                case 8: {
                    this.rbReverse.setSelected(true);
                    break;
                }
                case 4: {
                    this.rbAuto.setSelected(true);
                }
            }
        }
    }

    private void queryKeys() {
        try {
            this.repaint();
        }
        catch (Exception e) {
            System.out.println("Message: " + e.getMessage());
        }
    }

    public void doKeys() {
        this.init();
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equalsIgnoreCase("New Key")) {
            this.queryKeys();
            this.owner.repaint();
        } else if (e.getActionCommand().equalsIgnoreCase("Delete Key")) {
            this.owner.repaint();
        } else if (e.getActionCommand().equalsIgnoreCase("OK")) {
            this.dispose();
        } else if (e.getActionCommand().equalsIgnoreCase("Apply")) {
            Sprite.KeyFrame k = this.sprite.getKey((String)this.keysList.getSelectedValue());
            if (k != null) {
                k.setName(this.tName.getText());
                k.setFrameRate(Float.parseFloat(this.tRate.getText()));
                if (this.rbLoop.isSelected()) {
                    k.setFlags(1);
                } else if (this.rbStop.isSelected()) {
                    k.setFlags(2);
                } else if (this.rbReverse.isSelected()) {
                    k.setFlags(8);
                } else if (this.rbAuto.isSelected()) {
                    k.setFlags(4);
                }
            } else {
                JOptionPane.showMessageDialog(this, "Selected key not found!", "No Key", 0);
            }
            this.owner.repaint();
            this.queryKeys();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.updateFields();
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

