/*
 * Decompiled with CFR 0.152.
 */
package tiled.mapeditor.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.ListIterator;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import tiled.core.Map;
import tiled.core.MapLayer;
import tiled.core.Tile;
import tiled.core.TileLayer;
import tiled.core.TileSet;
import tiled.mapeditor.Resources;
import tiled.mapeditor.selection.SelectionLayer;
import tiled.mapeditor.util.MultisetListRenderer;
import tiled.mapeditor.widget.VerticalStaticJPanel;

public class SearchDialog
extends JDialog
implements ActionListener {
    private final Map map;
    private JComboBox searchCBox;
    private JComboBox replaceCBox;
    private Point currentMatch;
    private SelectionLayer sl;
    private static final double LIST_TILE_SCALE = 0.5;
    private static final String DIALOG_TITLE = Resources.getString("dialog.search.title");
    private static final String FIND_LABEL = Resources.getString("dialog.search.find.label");
    private static final String REPLACE_LABEL = Resources.getString("dialog.search.replace.label");
    private static final String FIND_BUTTON = Resources.getString("dialog.search.find.button");
    private static final String FIND_ALL_BUTTON = Resources.getString("dialog.search.findall.button");
    private static final String REPLACE_BUTTON = Resources.getString("dialog.search.replace.button");
    private static final String REPLACE_ALL_BUTTON = Resources.getString("dialog.search.replaceall.button");
    private static final String CLOSE_BUTTON = Resources.getString("general.button.close");

    public SearchDialog(JFrame parent) {
        this(parent, null);
    }

    public SearchDialog(JFrame parent, Map map) {
        super(parent, DIALOG_TITLE, false);
        this.map = map;
        this.init();
        this.setLocationRelativeTo(parent);
    }

    private void init() {
        MultisetListRenderer tileListRenderer = new MultisetListRenderer(0.5);
        JPanel searchPanel = new JPanel();
        searchPanel.setBorder(BorderFactory.createEtchedBorder());
        searchPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 2.0;
        c.weighty = 1.0;
        searchPanel.add((Component)new JLabel(FIND_LABEL), c);
        c.gridx = 1;
        this.searchCBox = new JComboBox();
        this.searchCBox.setRenderer(tileListRenderer);
        this.searchCBox.setEditable(false);
        searchPanel.add((Component)this.searchCBox, c);
        c.gridy = 1;
        c.gridx = 0;
        searchPanel.add((Component)new JLabel(REPLACE_LABEL), c);
        c.gridx = 1;
        this.replaceCBox = new JComboBox();
        this.replaceCBox.setRenderer(tileListRenderer);
        this.replaceCBox.setEditable(false);
        searchPanel.add((Component)this.replaceCBox, c);
        this.queryTiles(this.searchCBox);
        this.queryTiles(this.replaceCBox);
        JButton bFind = new JButton(FIND_BUTTON);
        JButton bFindAll = new JButton(FIND_ALL_BUTTON);
        JButton bReplace = new JButton(REPLACE_BUTTON);
        JButton bReplaceAll = new JButton(REPLACE_ALL_BUTTON);
        JButton bClose = new JButton(CLOSE_BUTTON);
        bFind.addActionListener(this);
        bFindAll.addActionListener(this);
        bReplace.addActionListener(this);
        bReplaceAll.addActionListener(this);
        bClose.addActionListener(this);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(2, 2, 5, 5));
        buttonPanel.add(bFind);
        buttonPanel.add(bFindAll);
        buttonPanel.add(bReplace);
        buttonPanel.add(bReplaceAll);
        VerticalStaticJPanel closePanel = new VerticalStaticJPanel();
        closePanel.setLayout(new BorderLayout());
        closePanel.add((Component)bClose, "East");
        JPanel mainPanel = new JPanel();
        mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.add((Component)searchPanel, "North");
        mainPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        mainPanel.add(buttonPanel);
        mainPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        mainPanel.add(closePanel);
        this.getContentPane().add(mainPanel);
        this.getRootPane().setDefaultButton(bFind);
        this.pack();
    }

    private void queryTiles(JComboBox b) {
        for (TileSet set : this.map.getTilesets()) {
            b.addItem(set);
            Iterator tileIterator = set.iterator();
            while (tileIterator.hasNext()) {
                Tile tile = (Tile)tileIterator.next();
                b.addItem(tile);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals(CLOSE_BUTTON)) {
            this.map.removeLayerSpecial(this.sl);
            this.dispose();
        } else if (command.equals(FIND_BUTTON)) {
            if (this.searchCBox.getSelectedItem() instanceof Tile) {
                this.find((Tile)this.searchCBox.getSelectedItem());
            }
        } else if (command.equals(FIND_ALL_BUTTON)) {
            if (this.sl != null) {
                this.map.removeLayerSpecial(this.sl);
            }
            this.sl = new SelectionLayer(this.map.getWidth(), this.map.getHeight());
            Rectangle bounds = new Rectangle();
            ListIterator<MapLayer> itr = this.map.getLayers();
            while (itr.hasNext()) {
                MapLayer layer = (MapLayer)itr.next();
                if (!(layer instanceof TileLayer)) continue;
                layer.getBounds(bounds);
                for (int y = 0; y < bounds.height; ++y) {
                    for (int x = 0; x < bounds.width; ++x) {
                        if (((TileLayer)layer).getTileAt(x, y) != this.searchCBox.getSelectedItem()) continue;
                        this.sl.select(x, y);
                    }
                }
            }
            this.map.addLayerSpecial(this.sl);
            this.map.touch();
        } else if (command.equals(REPLACE_ALL_BUTTON)) {
            if (!(this.searchCBox.getSelectedItem() instanceof TileSet) && !(this.replaceCBox.getSelectedItem() instanceof TileSet)) {
                this.replaceAll((Tile)this.searchCBox.getSelectedItem(), (Tile)this.replaceCBox.getSelectedItem());
            }
        } else if (command.equals(REPLACE_BUTTON) && this.searchCBox.getSelectedItem() instanceof Tile && this.replaceCBox.getSelectedItem() instanceof Tile) {
            if (this.currentMatch == null) {
                this.find((Tile)this.searchCBox.getSelectedItem());
            }
            ListIterator<MapLayer> itr = this.map.getLayers();
            while (itr.hasNext()) {
                MapLayer layer = (MapLayer)itr.next();
                if (!(layer instanceof TileLayer) || ((TileLayer)layer).getTileAt(this.currentMatch.x, this.currentMatch.y) != this.searchCBox.getSelectedItem()) continue;
                ((TileLayer)layer).setTileAt(this.currentMatch.x, this.currentMatch.y, (Tile)this.replaceCBox.getSelectedItem());
                break;
            }
            this.find((Tile)this.searchCBox.getSelectedItem());
        }
    }

    private void replaceAll(Tile f, Tile r) {
        ListIterator<MapLayer> itr = this.map.getLayers();
        while (itr.hasNext()) {
            MapLayer layer = (MapLayer)itr.next();
            if (!(layer instanceof TileLayer)) continue;
            ((TileLayer)layer).replaceTile(f, r);
        }
        this.map.touch();
    }

    private void find(Tile f) {
        int starty;
        boolean bFound = false;
        if (this.sl != null) {
            this.map.removeLayerSpecial(this.sl);
            this.map.touch();
        }
        this.sl = new SelectionLayer(this.map.getWidth(), this.map.getHeight());
        Rectangle bounds = new Rectangle();
        int startx = this.currentMatch == null ? 0 : this.currentMatch.x;
        for (int y = starty = this.currentMatch == null ? 0 : this.currentMatch.y; y < this.map.getHeight() && !bFound; ++y) {
            block1: for (int x = startx; x < this.map.getWidth() && !bFound; ++x) {
                ListIterator<MapLayer> itr = this.map.getLayers();
                while (itr.hasNext()) {
                    MapLayer layer = (MapLayer)itr.next();
                    if (!(layer instanceof TileLayer)) continue;
                    layer.getBounds(bounds);
                    if (((TileLayer)layer).getTileAt(x, y) != this.searchCBox.getSelectedItem() || this.currentMatch != null && this.currentMatch.equals(new Point(x, y))) continue;
                    this.sl.select(x, y);
                    bFound = true;
                    this.currentMatch = new Point(x, y);
                    continue block1;
                }
            }
        }
        if (bFound) {
            this.map.addLayerSpecial(this.sl);
            this.map.touch();
        }
    }
}

