/*
 * Decompiled with CFR 0.152.
 */
package tiled.mapeditor.undo;

import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import tiled.core.MapLayer;

public class MapLayerEdit
extends AbstractUndoableEdit {
    private final MapLayer editedLayer;
    private MapLayer layerUndo;
    private MapLayer layerRedo;
    private String name;
    private boolean inProgress;

    public MapLayerEdit(MapLayer layer) {
        this.editedLayer = layer;
    }

    public MapLayerEdit(MapLayer layer, MapLayer before) {
        this(layer);
        this.start(before);
    }

    public MapLayerEdit(MapLayer layer, MapLayer before, MapLayer after) {
        this(layer, before);
        this.end(after);
    }

    public void start(MapLayer fml) {
        this.layerUndo = fml;
        this.inProgress = true;
    }

    public void end(MapLayer fml) {
        if (!this.inProgress) {
            new Exception("end called before start").printStackTrace();
        }
        if (fml != null) {
            this.layerRedo = fml;
            this.inProgress = false;
        }
    }

    public MapLayer getStart() {
        return this.layerUndo;
    }

    @Override
    public void undo() throws CannotUndoException {
        if (this.editedLayer == null) {
            throw new CannotUndoException();
        }
        this.layerUndo.copyTo(this.editedLayer);
    }

    @Override
    public boolean canUndo() {
        return this.layerUndo != null && this.editedLayer != null;
    }

    @Override
    public void redo() throws CannotRedoException {
        if (this.editedLayer == null) {
            throw new CannotRedoException();
        }
        this.layerRedo.copyTo(this.editedLayer);
    }

    @Override
    public boolean canRedo() {
        return this.layerRedo != null && this.editedLayer != null;
    }

    @Override
    public void die() {
        this.layerUndo = null;
        this.layerRedo = null;
        this.inProgress = false;
    }

    @Override
    public boolean addEdit(UndoableEdit anEdit) {
        if (!this.inProgress || anEdit.getClass() == this.getClass()) {
            // empty if block
        }
        return false;
    }

    public void setPresentationName(String s) {
        this.name = s;
    }

    @Override
    public String getPresentationName() {
        return this.name;
    }
}

