/*
 * Decompiled with CFR 0.152.
 */
package tiled.mapeditor.undo;

import java.awt.Point;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import tiled.core.MapObject;
import tiled.mapeditor.Resources;

public class MoveObjectEdit
extends AbstractUndoableEdit {
    private final MapObject mapObject;
    private final Point moveDist;

    public MoveObjectEdit(MapObject mapObject, Point moveDist) {
        this.mapObject = mapObject;
        this.moveDist = moveDist;
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.mapObject.translate(-this.moveDist.x, -this.moveDist.y);
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.mapObject.translate(this.moveDist.x, this.moveDist.y);
    }

    @Override
    public String getPresentationName() {
        return Resources.getString("action.object.move.name");
    }
}

