/*
 * Decompiled with CFR 0.152.
 */
package tiled.view;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import java.util.Properties;
import tiled.core.Map;
import tiled.core.MapObject;
import tiled.core.ObjectGroup;
import tiled.core.Tile;
import tiled.core.TileLayer;
import tiled.mapeditor.selection.SelectionLayer;
import tiled.view.MapView;

public class OrthoMapView
extends MapView {
    private Polygon propPoly = new Polygon();

    public OrthoMapView(Map map) {
        super(map);
        this.propPoly.addPoint(0, 0);
        this.propPoly.addPoint(12, 0);
        this.propPoly.addPoint(12, 12);
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        Dimension tsize = this.getTileSize();
        if (orientation == 1) {
            return visibleRect.height / tsize.height * tsize.height;
        }
        return visibleRect.width / tsize.width * tsize.width;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        Dimension tsize = this.getTileSize();
        if (orientation == 1) {
            return tsize.height;
        }
        return tsize.width;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension tsize = this.getTileSize();
        return new Dimension(this.map.getWidth() * tsize.width, this.map.getHeight() * tsize.height);
    }

    @Override
    protected void paintLayer(Graphics2D g2d, TileLayer layer) {
        Dimension tsize = this.getTileSize();
        if (tsize.width <= 0 || tsize.height <= 0) {
            return;
        }
        Polygon gridPoly = this.createGridPolygon(0, -tsize.height, 0);
        Rectangle clipRect = g2d.getClipBounds();
        int startX = clipRect.x / tsize.width;
        int startY = clipRect.y / tsize.height;
        int endX = (clipRect.x + clipRect.width) / tsize.width + 1;
        int endY = (clipRect.y + clipRect.height) / tsize.height + 3;
        int y = startY;
        int gy = (startY + 1) * tsize.height;
        while (y < endY) {
            int x = startX;
            int gx = startX * tsize.width;
            while (x < endX) {
                Tile tile = layer.getTileAt(x, y);
                if (tile != null) {
                    if (layer instanceof SelectionLayer) {
                        gridPoly.translate(gx, gy);
                        g2d.fillPolygon(gridPoly);
                        gridPoly.translate(-gx, -gy);
                    } else {
                        tile.draw(g2d, gx, gy, this.zoom);
                    }
                }
                ++x;
                gx += tsize.width;
            }
            ++y;
            gy += tsize.height;
        }
    }

    @Override
    protected void paintObjectGroup(Graphics2D g2d, ObjectGroup og) {
        Dimension tsize = this.getTileSize();
        Rectangle bounds = og.getBounds();
        Iterator<MapObject> itr = og.getObjects();
        g2d.translate(bounds.x * tsize.width, bounds.y * tsize.height);
        while (itr.hasNext()) {
            MapObject mo = itr.next();
            double ox = (double)mo.getX() * this.zoom;
            double oy = (double)mo.getY() * this.zoom;
            Image objectImage = mo.getImage(this.zoom);
            if (objectImage != null) {
                g2d.drawImage(objectImage, (int)ox, (int)oy, null);
            }
            if (mo.getWidth() == 0 || mo.getHeight() == 0) {
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2d.setColor(Color.black);
                g2d.fillOval((int)ox + 1, (int)oy + 1, (int)(10.0 * this.zoom), (int)(10.0 * this.zoom));
                g2d.setColor(Color.orange);
                g2d.fillOval((int)ox, (int)oy, (int)(10.0 * this.zoom), (int)(10.0 * this.zoom));
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            } else {
                g2d.setColor(Color.black);
                g2d.drawRect((int)ox + 1, (int)oy + 1, (int)((double)mo.getWidth() * this.zoom), (int)((double)mo.getHeight() * this.zoom));
                g2d.setColor(Color.orange);
                g2d.drawRect((int)ox, (int)oy, (int)((double)mo.getWidth() * this.zoom), (int)((double)mo.getHeight() * this.zoom));
            }
            if (!(this.zoom > 0.0625)) continue;
            String s = mo.getName() != null ? mo.getName() : "(null)";
            g2d.setColor(Color.black);
            g2d.drawString(s, (int)(ox - 5.0) + 1, (int)(oy - 5.0) + 1);
            g2d.setColor(Color.white);
            g2d.drawString(s, (int)(ox - 5.0), (int)(oy - 5.0));
        }
        g2d.translate(-bounds.x * tsize.width, -bounds.y * tsize.height);
    }

    @Override
    protected void paintGrid(Graphics2D g2d) {
        Dimension tsize = this.getTileSize();
        if (tsize.width <= 0 || tsize.height <= 0) {
            return;
        }
        Rectangle clipRect = g2d.getClipBounds();
        int startX = clipRect.x / tsize.width * tsize.width;
        int startY = clipRect.y / tsize.height * tsize.height;
        int endX = clipRect.x + clipRect.width;
        int endY = clipRect.y + clipRect.height;
        for (int x = startX; x < endX; x += tsize.width) {
            g2d.drawLine(x, clipRect.y, x, clipRect.y + clipRect.height - 1);
        }
        for (int y = startY; y < endY; y += tsize.height) {
            g2d.drawLine(clipRect.x, y, clipRect.x + clipRect.width - 1, y);
        }
    }

    @Override
    protected void paintCoordinates(Graphics2D g2d) {
        Dimension tsize = this.getTileSize();
        if (tsize.width <= 0 || tsize.height <= 0) {
            return;
        }
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        Font font = new Font("SansSerif", 0, tsize.height / 4);
        g2d.setFont(font);
        FontRenderContext fontRenderContext = g2d.getFontRenderContext();
        Rectangle clipRect = g2d.getClipBounds();
        int startX = clipRect.x / tsize.width;
        int startY = clipRect.y / tsize.height;
        int endX = (clipRect.x + clipRect.width) / tsize.width + 1;
        int endY = (clipRect.y + clipRect.height) / tsize.height + 1;
        int gy = startY * tsize.height;
        for (int y = startY; y < endY; ++y) {
            int gx = startX * tsize.width;
            for (int x = startX; x < endX; ++x) {
                String coords = "(" + x + "," + y + ")";
                Rectangle2D textSize = font.getStringBounds(coords, fontRenderContext);
                int fx = gx + (int)(((double)tsize.width - textSize.getWidth()) / 2.0);
                int fy = gy + (int)(((double)tsize.height + textSize.getHeight()) / 2.0);
                g2d.drawString(coords, fx, fy);
                gx += tsize.width;
            }
            gy += tsize.height;
        }
    }

    @Override
    protected void paintPropertyFlags(Graphics2D g2d, TileLayer layer) {
        Dimension tsize = this.getTileSize();
        if (tsize.width <= 0 || tsize.height <= 0) {
            return;
        }
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2d.setComposite(AlphaComposite.SrcAtop);
        g2d.setXORMode(new Color(0.9f, 0.9f, 0.9f, 0.5f));
        Rectangle clipRect = g2d.getClipBounds();
        int startX = clipRect.x / tsize.width;
        int startY = clipRect.y / tsize.height;
        int endX = (clipRect.x + clipRect.width) / tsize.width + 1;
        int endY = (clipRect.y + clipRect.height) / tsize.height + 1;
        int y = startY * tsize.height;
        for (int j = startY; j <= endY; ++j) {
            int x = startX * tsize.width;
            for (int i = startX; i <= endX; ++i) {
                try {
                    Properties p = layer.getTileInstancePropertiesAt(i, j);
                    if (p != null && !p.isEmpty()) {
                        g2d.translate(x + (tsize.width - 13), y + 1);
                        g2d.drawPolygon(this.propPoly);
                        g2d.translate(-(x + (tsize.width - 13)), -(y + 1));
                    }
                }
                catch (Exception e) {
                    System.out.print("Exception\n");
                }
                x += tsize.width;
            }
            y += tsize.height;
        }
    }

    @Override
    public void repaintRegion(Rectangle region) {
        Dimension tsize = this.getTileSize();
        if (tsize.width <= 0 || tsize.height <= 0) {
            return;
        }
        int maxExtraHeight = (int)((double)this.map.getTileHeightMax() * this.zoom - (double)tsize.height);
        int startX = region.x * tsize.width;
        int startY = region.y * tsize.height - maxExtraHeight;
        int endX = (region.x + region.width) * tsize.width;
        int endY = (region.y + region.height) * tsize.height;
        Rectangle dirty = new Rectangle(startX, startY, endX - startX, endY - startY);
        this.repaint(dirty);
    }

    @Override
    public Point screenToTileCoords(int x, int y) {
        Dimension tsize = this.getTileSize();
        return new Point(x / tsize.width, y / tsize.height);
    }

    @Override
    public Point screenToPixelCoords(int x, int y) {
        return new Point((int)((double)x / this.zoom), (int)((double)y / this.zoom));
    }

    protected Dimension getTileSize() {
        return new Dimension((int)((double)this.map.getTileWidth() * this.zoom), (int)((double)this.map.getTileHeight() * this.zoom));
    }

    @Override
    protected Polygon createGridPolygon(int tx, int ty, int border) {
        Dimension tsize = this.getTileSize();
        Polygon poly = new Polygon();
        poly.addPoint(tx - border, ty - border);
        poly.addPoint(tx + tsize.width + border, ty - border);
        poly.addPoint(tx + tsize.width + border, ty + tsize.height + border);
        poly.addPoint(tx - border, ty + tsize.height + border);
        return poly;
    }

    @Override
    public Point tileToScreenCoords(int x, int y) {
        Dimension tsize = this.getTileSize();
        return new Point(x * tsize.width, y * tsize.height);
    }
}

