/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.painter;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.plaf.synthetica.painter.ImagePainter;
import de.javasoft.plaf.synthetica.painter.SyntheticaComponentPainter;
import de.javasoft.plaf.synthetica.painter.UIKey;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.io.Serializable;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.plaf.DimensionUIResource;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.SynthContext;

public class SeparatorPainter
extends SyntheticaComponentPainter {
    public static final String UI_KEY = "Synthetica.SeparatorPainter";
    private static HashMap<String, Image> imgCache = new HashMap();

    protected SeparatorPainter() {
    }

    public static SeparatorPainter getInstance() {
        return SeparatorPainter.getInstance(null);
    }

    public static SeparatorPainter getInstance(SynthContext synthContext) {
        SyntheticaComponentPainter syntheticaComponentPainter = (SyntheticaComponentPainter)instances.get(SeparatorPainter.getPainterClassName(synthContext, SeparatorPainter.class, UI_KEY));
        if (syntheticaComponentPainter == null) {
            syntheticaComponentPainter = SeparatorPainter.getInstance(synthContext, SeparatorPainter.class, UI_KEY);
        }
        return (SeparatorPainter)syntheticaComponentPainter;
    }

    public void paintSeparatorBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
    }

    public void paintSeparatorBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        JComponent jComponent = synthContext.getComponent();
        if (jComponent.getParent() instanceof JPopupMenu || jComponent instanceof JPopupMenu.Separator) {
            Insets insets;
            int n5;
            JPopupMenu jPopupMenu = (JPopupMenu)SwingUtilities.getAncestorOfClass(JPopupMenu.class, jComponent);
            Insets insets2 = jPopupMenu.getInsets();
            String string = "Synthetica.popupMenuSeparator";
            string = SyntheticaLookAndFeel.getString(string, jPopupMenu);
            boolean bl = SyntheticaLookAndFeel.getBoolean("Synthetica.popupMenu.iconSeparator.clip", jPopupMenu, true);
            if (bl && (SyntheticaLookAndFeel.preservePopupIconSpace(jPopupMenu) || SyntheticaLookAndFeel.popupHasCheckRadio(jPopupMenu)) && !SyntheticaLookAndFeel.popupHasCheckRadioWithIcon(jPopupMenu)) {
                boolean bl2 = jPopupMenu.getComponentOrientation().isLeftToRight();
                int n6 = SyntheticaLookAndFeel.getInt("Synthetica.popupMenuSeparator.iconSeparatorGap", jPopupMenu);
                n5 = SyntheticaLookAndFeel.getInt("Synthetica.popupMenu.iconSeparator.gap", jPopupMenu, 24);
                Integer n7 = (Integer)jPopupMenu.getClientProperty("Synthetica.menuItem.maxIconWidth");
                if (n7 != null && n7 > 16) {
                    n5 += n7 - 16;
                }
                int n8 = SyntheticaLookAndFeel.getInt("Synthetica.popupMenu.iconSeparator.width", jPopupMenu, 1);
                int n9 = n5 + n8 + n6 - insets2.left;
                n += bl2 ? n9 : 0;
                n3 -= n9;
            }
            Insets insets3 = insets = SyntheticaLookAndFeel.getInsets("Synthetica.popupMenuSeparator.insets", (Component)jPopupMenu, false);
            n5 = 0;
            if (SyntheticaLookAndFeel.getBoolean("Synthetica.popupMenuSeparator.horizontalTiled", jPopupMenu)) {
                n5 = 1;
            }
            int n10 = 0;
            if (SyntheticaLookAndFeel.getBoolean("Synthetica.popupMenuSeparator.verticalTiled", jPopupMenu)) {
                n10 = 1;
            }
            ImagePainter imagePainter = new ImagePainter(graphics, n, n2, n3, n4, string, insets, insets3, n5, n10);
            imagePainter.draw();
        }
    }

    public void paintSeparatorForeground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        int n6;
        Insets insets;
        String string = "Synthetica.separator";
        JComponent jComponent = synthContext.getComponent();
        Insets insets2 = synthContext.getStyle().getInsets(synthContext, null);
        Insets insets3 = jComponent.getInsets();
        n3 -= insets3.left + insets3.right - insets2.left - insets2.right;
        n4 -= insets3.top + insets3.bottom - insets2.top - insets2.bottom;
        n += insets3.left - insets2.left;
        n2 += insets3.top - insets2.top;
        boolean bl = jComponent instanceof JToolBar.Separator;
        if (bl) {
            string = String.valueOf(string) + ".toolBar";
        } else if (jComponent.getParent() instanceof JComponent && (((JComponent)jComponent.getParent()).getUIClassID().equals("StatusBarUI") || "StatusBar".equals(SyntheticaLookAndFeel.getStyleName(jComponent.getParent())))) {
            string = String.valueOf(string) + ".statusBar";
        }
        string = String.valueOf(string) + ".image";
        string = n5 == 0 ? String.valueOf(string) + ".x" : String.valueOf(string) + ".y";
        UIKey uIKey = new UIKey(string, new SyntheticaState(0), "");
        Insets insets4 = insets = (Insets)uIKey.findProperty(synthContext, "insets", true, 1);
        string = SyntheticaLookAndFeel.getString(string, jComponent);
        if (bl) {
            if (string == null) {
                return;
            }
            Image image = imgCache.get(string);
            if (image == null) {
                image = new ImageIcon(SyntheticaLookAndFeel.class.getResource(string)).getImage();
                imgCache.put(string, image);
            }
            this.adjustToolBarSeparatorSize((JToolBar.Separator)jComponent, image.getWidth(null), image.getHeight(null));
        }
        int n7 = bl ? 0 : (Integer)synthContext.getStyle().get(synthContext, "Separator.thickness");
        int n8 = n5 == 0 || bl ? n3 : n7;
        int n9 = n6 = n5 == 1 || bl ? n4 : n7;
        if (string == null) {
            graphics.setColor(synthContext.getStyle().getColor(synthContext, ColorType.BACKGROUND));
            graphics.fillRect(n, n2, n8, n6);
        } else {
            ImagePainter imagePainter = new ImagePainter(jComponent, 1, 50, 0, 0, graphics, n, n2, n3, n4, string, insets, insets4, 0, 0);
            imagePainter.draw();
        }
    }

    protected void adjustToolBarSeparatorSize(JToolBar.Separator separator, int n, int n2) {
        if (SyntheticaLookAndFeel.getToolbarSeparatorDimension() == null) {
            Serializable serializable;
            int n3 = 0;
            int n4 = 0;
            Component[] componentArray = separator.getParent().getComponents();
            int n5 = componentArray.length;
            int n6 = 0;
            while (n6 < n5) {
                serializable = componentArray[n6];
                if (!(serializable instanceof JToolBar.Separator)) {
                    if (((Component)serializable).getMinimumSize().width > n3) {
                        n3 = ((Component)serializable).getMinimumSize().width;
                    }
                    if (((Component)serializable).getMinimumSize().height > n4) {
                        n4 = ((Component)serializable).getMinimumSize().height;
                    }
                }
                ++n6;
            }
            serializable = null;
            serializable = separator.getOrientation() == 1 ? new DimensionUIResource(n, n4) : new DimensionUIResource(n3, n2);
            if (!((Dimension)serializable).equals(separator.getSize())) {
                separator.setSeparatorSize((Dimension)serializable);
                separator.revalidate();
            }
        }
    }
}

