/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.painter;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.painter.Cacheable;
import de.javasoft.util.JavaVersion;
import de.javasoft.util.OS;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Window;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.synth.SynthContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SyntheticaComponentPainter
implements Cacheable {
    static final boolean JAVA5 = JavaVersion.JAVA5;
    static final boolean JAVA6 = JavaVersion.JAVA6;
    static final boolean JAVA7U8_OR_ABOVE = JavaVersion.JAVA7U8_OR_ABOVE;
    private Object antialiasing_old;
    private Object strokeControl_old;
    private AffineTransform at_old;
    private Paint paint_old;
    private Stroke stroke_old;
    private static final boolean OS_X_QUARTZ_ENABLED = SyntheticaLookAndFeel.isSystemPropertySet("apple.awt.graphics.UseQuartz");
    protected static HashMap<String, SyntheticaComponentPainter> instances = new HashMap();

    SyntheticaComponentPainter() {
    }

    protected static SyntheticaComponentPainter getInstance(SynthContext synthContext, Class<?> clazz, String string) {
        SyntheticaComponentPainter syntheticaComponentPainter = null;
        Object object = synthContext == null ? UIManager.get(string) : SyntheticaLookAndFeel.get(string, synthContext.getComponent());
        try {
            if (object == null && clazz != null) {
                syntheticaComponentPainter = (SyntheticaComponentPainter)clazz.newInstance();
            } else if (object == null) {
                String string2 = string.substring(string.lastIndexOf(46) + 1);
                syntheticaComponentPainter = (SyntheticaComponentPainter)Class.forName(String.valueOf(SyntheticaComponentPainter.class.getPackage().getName()) + "." + string2).newInstance();
            } else if (object instanceof SyntheticaComponentPainter) {
                syntheticaComponentPainter = (SyntheticaComponentPainter)object;
            } else if (object instanceof String) {
                syntheticaComponentPainter = (SyntheticaComponentPainter)Class.forName((String)object).newInstance();
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        instances.put(syntheticaComponentPainter.getClass().getName(), syntheticaComponentPainter);
        return syntheticaComponentPainter;
    }

    protected static String getPainterClassName(SynthContext synthContext, Class<?> clazz, String string) {
        Object object;
        Object object2 = object = synthContext == null ? UIManager.get(string) : SyntheticaLookAndFeel.get(string, synthContext.getComponent());
        if (object == null) {
            return clazz.getName();
        }
        if (object instanceof SyntheticaComponentPainter) {
            return object.getClass().getName();
        }
        return (String)object;
    }

    protected Graphics2D prepareGraphics2D(SynthContext synthContext, Graphics graphics, int n, int n2, boolean bl, boolean bl2, BasicStroke basicStroke) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.antialiasing_old = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        this.strokeControl_old = graphics2D.getRenderingHint(RenderingHints.KEY_STROKE_CONTROL);
        this.at_old = graphics2D.getTransform();
        this.paint_old = graphics2D.getPaint();
        this.stroke_old = graphics2D.getStroke();
        if (bl) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        if (basicStroke == null) {
            basicStroke = this.createStroke(synthContext);
        }
        graphics2D.setStroke(basicStroke);
        if (bl2) {
            double d = (float)n + basicStroke.getLineWidth() / 2.0f;
            double d2 = (float)n2 + basicStroke.getLineWidth() / 2.0f;
            if (OS.getCurrentOS() == OS.Mac && OS_X_QUARTZ_ENABLED) {
                d = Math.round(d - 0.5);
                d2 = Math.round(d2 - 0.5);
            }
            graphics2D.translate(d, d2);
        }
        return graphics2D;
    }

    protected Graphics2D prepareGraphics2D(SynthContext synthContext, Graphics graphics, int n, int n2, boolean bl) {
        return this.prepareGraphics2D(synthContext, graphics, n, n2, bl, true, null);
    }

    protected Graphics2D prepareGraphics2D(SynthContext synthContext, Graphics graphics, int n, int n2, boolean bl, boolean bl2) {
        return this.prepareGraphics2D(synthContext, graphics, n, n2, bl, bl2, null);
    }

    protected Graphics2D prepareGraphics2D(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, BasicStroke basicStroke) {
        return this.prepareGraphics2D(synthContext, graphics, n, n2, true, true, basicStroke);
    }

    protected Graphics2D prepareGraphics2D(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, boolean bl) {
        return this.prepareGraphics2D(synthContext, graphics, n, n2, true, true, null);
    }

    protected void restoreGraphics2D(Graphics2D graphics2D) {
        graphics2D.setStroke(this.stroke_old);
        graphics2D.setPaint(this.paint_old);
        graphics2D.setTransform(this.at_old);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.antialiasing_old);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, this.strokeControl_old);
    }

    protected float getScale() {
        return 1.0f;
    }

    protected BasicStroke createStroke(SynthContext synthContext) {
        return new BasicStroke(1.0f * this.getScale());
    }

    float scaleArc(float f, float f2, float f3, float f4) {
        float f5 = Math.min(f3, f4);
        f = f5 < f2 * this.getScale() ? f5 - (f2 - f) / f2 * f5 : this.scaleArc(f);
        return f;
    }

    protected float scaleArc(float f) {
        return f * this.getScale();
    }

    protected float calcRelativeArc(Graphics2D graphics2D, float f, float f2) {
        float f3 = ((BasicStroke)graphics2D.getStroke()).getLineWidth();
        return f + f3 * f2;
    }

    protected float calcRelativePos(Graphics2D graphics2D, float f, float f2) {
        float f3 = ((BasicStroke)graphics2D.getStroke()).getLineWidth();
        return f + f3 * f2;
    }

    protected float calcRelativeGradientPos(Graphics2D graphics2D, float f, float f2) {
        return this.calcRelativePos(graphics2D, f, f2) - this.getScale() / 2.0f;
    }

    protected static float calcRelativeLength(Graphics2D graphics2D, float f, float f2) {
        float f3 = ((BasicStroke)graphics2D.getStroke()).getLineWidth();
        return f + f2 * f3 - f3;
    }

    protected static Shape subtractStroke(Graphics2D graphics2D, Shape shape) {
        if (!SyntheticaLookAndFeel.getBoolean("Synthetica.2D.subtractStrokeEnabled", null)) {
            return shape;
        }
        Area area = new Area(((BasicStroke)graphics2D.getStroke()).createStrokedShape(shape));
        Area area2 = new Area(shape);
        area2.subtract(area);
        return area2;
    }

    protected Color getSyntheticaBackgroundColor(JComponent jComponent) {
        Color color = null;
        Color color2 = jComponent.getBackground();
        if (color2 != null && !(color2 instanceof ColorUIResource)) {
            color = color2;
        }
        if (jComponent.getClientProperty("Synthetica.background") != null) {
            color = (Color)jComponent.getClientProperty("Synthetica.background");
        }
        float f = (float)SyntheticaLookAndFeel.getInt("Synthetica.background.alpha", jComponent, 10) / 100.0f;
        if (jComponent.getClientProperty("Synthetica.background.alpha") != null) {
            f = ((Float)jComponent.getClientProperty("Synthetica.background.alpha")).floatValue();
        }
        return this.createAlphaColor(color, Float.valueOf(f));
    }

    protected Color createAlphaColor(Color color, Float f) {
        if (color != null) {
            f = Float.valueOf(f == null ? 0.1f : f.floatValue());
            int n = color.getRGB() & ((int)(f.floatValue() * 255.0f) << 24 | 0xFFFFFF);
            color = new Color(n, true);
        }
        return color;
    }

    protected Paint createLinearGradientPaint(float f, float f2, float f3, float f4, float[] fArray, Color[] colorArray) {
        return SyntheticaLookAndFeel.createLinearGradientPaint(f, f2, f3, f4, fArray, colorArray);
    }

    @Override
    public int getCacheHash(SynthContext synthContext, int n, int n2, int n3, String string) {
        JComponent jComponent = synthContext.getComponent();
        Border border = jComponent.getBorder();
        Boolean bl = (Boolean)jComponent.getClientProperty("Synthetica.opaque");
        Color color = (Color)jComponent.getClientProperty("Synthetica.background");
        Float f = (Float)jComponent.getClientProperty("Synthetica.background.alpha");
        Color color2 = jComponent.getBackground();
        String string2 = SyntheticaLookAndFeel.getStyleName(jComponent);
        Window window = SwingUtilities.getWindowAncestor(jComponent);
        int n4 = string.hashCode();
        if (this.getCacheScaleType(string) != Cacheable.ScaleType.NINE_SQUARE) {
            n4 = 31 * n4 + n;
            n4 = 31 * n4 + n2;
        }
        n4 = 31 * n4 + n3;
        n4 = 31 * n4 + (int)this.getScale() * 100;
        n4 = 31 * n4 + this.getClass().hashCode();
        n4 = 31 * n4 + jComponent.getClass().hashCode();
        n4 = 31 * n4 + jComponent.getComponentOrientation().hashCode();
        n4 = 31 * n4 + synthContext.getComponentState();
        int n5 = n4 = border == null ? n4 : 31 * n4 + this.getBorderHashCode(border);
        n4 = bl == null ? n4 : 31 * n4 + (bl != false ? 0 : 1);
        n4 = color == null ? n4 : n4 * 31 + color.getRGB();
        n4 = f == null ? n4 : n4 * 31 + (int)(f.floatValue() * 100.0f);
        n4 = color2 == null ? n4 : n4 * 31 + color2.getRGB();
        n4 = string2 == null ? n4 : 31 * n4 + string2.hashCode();
        n4 = 31 * n4 + (window == null || window.isActive() ? 0 : 1);
        return n4;
    }

    private int getBorderHashCode(Border border) {
        int n;
        int n2 = n = border == null ? 0 : border.getClass().hashCode();
        if (border instanceof CompoundBorder) {
            n = 31 * n + this.getBorderHashCode(((CompoundBorder)border).getInsideBorder());
            n = 31 * n + this.getBorderHashCode(((CompoundBorder)border).getOutsideBorder());
        }
        return n;
    }

    @Override
    public Cacheable.ScaleType getCacheScaleType(String string) {
        return Cacheable.ScaleType.NONE;
    }

    @Override
    public Insets getCacheScaleInsets(SynthContext synthContext, String string) {
        JComponent jComponent = synthContext.getComponent();
        int n = (int)(this.getScale() * 10.0f);
        Insets insets = jComponent == null ? new Insets(n, n, n, n) : jComponent.getInsets();
        return insets;
    }
}

