/*
 * Decompiled with CFR 0.152.
 */
package JCPC.system.cpc.plus;

import JCPC.core.Util;
import JCPC.core.device.Device;
import JCPC.system.cpc.GateArray;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;

public class CPRLoader {
    boolean store = false;
    protected byte[][] cprdata;
    public boolean DEBUG = false;
    protected boolean[] loaded = new boolean[32];
    protected String CPRHeader = "RIFF";
    protected String CPRIdentifier = "AMS!";
    protected int CPRBegin = 16;
    protected int CPRSize;
    byte[] cpr = new byte[524288];
    String newname;
    boolean uselimit = false;

    public static void main(String[] args) {
        CPRLoader load = new CPRLoader();
        load.DEBUG = true;
        load.OpenCPR2();
    }

    public void OpenCPR() {
        String filename = null;
        try {
            FileDialog filedia = new FileDialog(new Frame(), "Open CPR cartridge", 0);
            filedia.setFile("*.CPR; *.BIN");
            filedia.setVisible(true);
            filename = filedia.getFile();
            if (filename != null) {
                filename = filedia.getDirectory() + filedia.getFile();
            }
        }
        catch (Exception e) {
            System.err.println("Load failed...");
            return;
        }
        if (filename == null) {
            filename = "CPC_PLUS.CPR";
            return;
        }
        this.openCPR(filename);
    }

    public void OpenCPR2() {
        String filename = null;
        try {
            FileDialog filedia = new FileDialog(new Frame(), "Open CPR cartridge", 0);
            filedia.setFile("*.CPR; *.BIN");
            filedia.setVisible(true);
            filename = filedia.getFile();
            if (filename != null) {
                filename = filedia.getDirectory() + filedia.getFile();
                this.openCPR2(filename);
            } else {
                System.exit(0);
            }
        }
        catch (Exception e) {
            System.err.println("Load failed...");
            return;
        }
        if (filename == null) {
            filename = "CPC_PLUS.CPR";
            return;
        }
    }

    public void openCPR(String filename) {
        File t = new File(filename);
        try {
            BufferedInputStream bin = new BufferedInputStream(new FileInputStream(t));
            byte[] data = new byte[bin.available()];
            bin.read(data);
            bin.close();
            this.readCPR(data, filename);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void openCPR2(String filename) {
        File t = new File(filename);
        try {
            BufferedInputStream bin = new BufferedInputStream(new FileInputStream(t));
            byte[] data = new byte[bin.available()];
            bin.read(data);
            bin.close();
            this.CPR2BIN(data, filename);
            this.OpenCPR2();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void openCPR(URL u) {
        try {
            int offset;
            URLConnection uc = u.openConnection();
            String contentType = uc.getContentType();
            int contentLength = uc.getContentLength();
            if (contentType.startsWith("text/") || contentLength == -1) {
                throw new IOException("This is not a binary file.");
            }
            InputStream raw = uc.getInputStream();
            BufferedInputStream in = new BufferedInputStream(raw);
            byte[] data = new byte[contentLength];
            int bytesRead = 0;
            for (offset = 0; offset < contentLength && (bytesRead = ((InputStream)in).read(data, offset, data.length - offset)) != -1; offset += bytesRead) {
            }
            ((InputStream)in).close();
            if (offset != contentLength) {
                throw new IOException("Only read " + offset + " bytes; Expected " + contentLength + " bytes");
            }
            this.readCPR(data, u.toString());
        }
        catch (Exception e) {
            System.err.println("File not loadable / not found:" + u.getFile());
        }
    }

    public byte[] getCPR() {
        return this.cpr;
    }

    public byte[] getData(int index) {
        try {
            if (this.cprdata[index] == null || index == 0) {
                // empty if block
            }
            return this.cprdata[index];
        }
        catch (Exception e) {
            return null;
        }
    }

    public void BIN2CPR() {
        if (this.cprdata == null) {
            return;
        }
        int chk = 0;
        for (byte[] cprdata1 : this.cprdata) {
            if (cprdata1 == null) continue;
            ++chk;
        }
        if (chk == 0) {
            return;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            int i;
            int pos = 4;
            int size = 0;
            baos.write("RIFF".getBytes("UTF-8"));
            for (byte[] cprdata1 : this.cprdata) {
                if (cprdata1 == null) continue;
                ++size;
            }
            byte[][] realcpr = new byte[size][16392];
            size = 0;
            for (i = 0; i < (this.uselimit ? 4 : this.cprdata.length); ++i) {
                if (this.cprdata[i] == null) continue;
                String num = "" + size;
                if (size < 10) {
                    num = "0" + num;
                }
                byte[] check = ("cb" + num).getBytes("UTF-8");
                System.arraycopy(check, 0, realcpr[size], 0, check.length);
                System.arraycopy(this.putDWord(16384), 0, realcpr[size], 4, 4);
                System.arraycopy(this.cprdata[i], 0, realcpr[size++], 8, 16384);
                pos += 16392;
            }
            baos.write(this.putDWord(pos));
            baos.write("AMS!".getBytes("UTF-8"));
            for (i = 0; i < realcpr.length; ++i) {
                baos.write(realcpr[i]);
            }
            baos.close();
            if (this.store) {
                byte[] result = baos.toByteArray();
                File io = new File("./" + this.newname + ".cpr");
                BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(io));
                bos.write(result);
                bos.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    byte[] putDWord(int value) {
        try {
            byte[] array = new byte[]{(byte)(value & 0xFF), (byte)((value & 0xFF00) >> 8 & 0xFF), (byte)((value & 0xFF0000) >> 16 & 0xFF), (byte)((value & 0xFF000000) >> 24 & 0xFF)};
            return array;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public void readCPR(byte[] data, String filename) {
        System.out.println("**** Reading ***** " + filename);
        this.newname = filename;
        if (this.cprdata == null) {
            this.cprdata = new byte[32][];
        }
        if (this.CPRHeader.equals(new String(data, 0, this.CPRHeader.length()).toUpperCase())) {
            if (this.CPRIdentifier.equals(new String(data, 8, this.CPRIdentifier.length()).toUpperCase())) {
                int i;
                int i2;
                for (i2 = 0; i2 < 32; ++i2) {
                    this.loaded[i2] = false;
                }
                this.CPRSize = Device.getDWord(data, 4);
                for (i2 = 0; i2 < 32; ++i2) {
                    this.cprdata[i2] = null;
                }
                int pos = 12;
                while (pos < data.length - 10) {
                    try {
                        byte check1 = data[pos++];
                        byte check2 = data[pos++];
                        byte index1 = data[pos++];
                        byte index2 = data[pos++];
                        int length = Device.getDWord(data, pos);
                        pos += 4;
                        if (check1 == 99 && check2 == 98) {
                            int index = 0;
                            String a = "" + (char)index1 + "" + (char)index2;
                            try {
                                index = Integer.parseInt(a);
                            }
                            catch (Exception e) {
                                System.err.println("An error occured!");
                                return;
                            }
                            if (!this.loaded[index &= 0x1F]) {
                                this.cprdata[index] = new byte[16384];
                                System.arraycopy(data, pos, this.cprdata[index], 0, length);
                                this.loaded[index] = true;
                                System.out.println("Storing to position: " + index);
                            } else {
                                byte[] check = new byte[16384];
                                System.arraycopy(data, pos, check, 0, length);
                                for (int i3 = 0; i3 < length; ++i3) {
                                    if (check[i3] == this.cprdata[index][i3]) continue;
                                    System.err.println("Difference encountered! " + Util.hex((short)i3));
                                    System.err.println(Util.dumpBytes(this.cprdata[index], i3, 16));
                                    System.err.println(Util.dumpBytes(check, i3, 16));
                                    this.cprdata[index] = new byte[16384];
                                    System.arraycopy(data, pos, this.cprdata[index], 0, length);
                                    break;
                                }
                            }
                        }
                        pos += length;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        System.out.println("Error in Cartridge file!!!");
                    }
                }
                int s = 0;
                for (i = 0; i < 32; ++i) {
                    if (this.cprdata[i] == null) continue;
                    s += this.cprdata[i].length;
                }
                this.cpr = new byte[s];
                for (i = 0; i < 32; ++i) {
                    if (this.cprdata[i] == null) continue;
                    System.arraycopy(this.cprdata[i], 0, this.cpr, i * 16384, this.cprdata[i].length);
                }
                this.BIN2CPR();
                if (filename != null && this.store) {
                    String newname = filename + ".bin";
                    File out = new File(newname);
                    try {
                        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(out));
                        for (int i4 = 0; i4 < 32; ++i4) {
                            if (this.cprdata[i4] == null) continue;
                            bos.write(this.cprdata[i4]);
                        }
                        bos.close();
                    }
                    catch (Exception exception) {}
                }
            }
        } else {
            int pos = 0;
            try {
                for (int i = 0; i < data.length; i += 16384) {
                    this.cprdata[pos] = new byte[16384];
                    System.arraycopy(data, i, this.cprdata[pos], 0, 16384);
                    ++pos;
                }
                this.cpr = new byte[data.length];
                System.arraycopy(data, 0, this.cpr, 0, this.cpr.length);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        GateArray.cpc.reset();
        GateArray.cpc.getAsic().reset();
    }

    public byte[] CPR2BIN(byte[] data) {
        if (this.cprdata == null) {
            this.cprdata = new byte[32][];
        }
        if (this.CPRHeader.equals(new String(data, 0, this.CPRHeader.length()).toUpperCase()) && this.CPRIdentifier.equals(new String(data, 8, this.CPRIdentifier.length()).toUpperCase())) {
            int i;
            int pos;
            int length;
            int i2;
            for (i2 = 0; i2 < 32; ++i2) {
                this.loaded[i2] = false;
            }
            this.CPRSize = Device.getDWord(data, 4);
            for (i2 = 0; i2 < 32; ++i2) {
                this.cprdata[i2] = null;
            }
            block4: for (pos = 12; pos < this.CPRSize; pos += length) {
                byte check1 = data[pos++];
                byte check2 = data[pos++];
                byte index1 = data[pos++];
                byte index2 = data[pos++];
                length = Device.getDWord(data, pos);
                pos += 4;
                if (check1 != 99 || check2 != 98) continue;
                int index = 0;
                String a = "" + (char)index1 + "" + (char)index2;
                try {
                    index = Integer.parseInt(a);
                }
                catch (Exception e) {
                    System.err.println("An error occured!");
                    return null;
                }
                if (!this.loaded[index &= 0x1F]) {
                    this.cprdata[index] = new byte[16384];
                    System.arraycopy(data, pos, this.cprdata[index], 0, length);
                    this.loaded[index] = true;
                    System.out.println("Storing to position: " + index);
                    continue;
                }
                byte[] check = new byte[16384];
                System.arraycopy(data, pos, check, 0, length);
                for (int i3 = 0; i3 < length; ++i3) {
                    if (check[i3] == this.cprdata[index][i3]) continue;
                    System.err.println("Difference encountered! " + Util.hex((short)i3));
                    System.err.println(Util.dumpBytes(this.cprdata[index], i3, 16));
                    System.err.println(Util.dumpBytes(check, i3, 16));
                    this.cprdata[index] = new byte[16384];
                    System.arraycopy(data, pos, this.cprdata[index], 0, length);
                    continue block4;
                }
            }
            int s = 0;
            for (i = 0; i < 32; ++i) {
                if (this.cprdata[i] == null) continue;
                s += this.cprdata[i].length;
            }
            this.cpr = new byte[s];
            for (i = 0; i < 32; ++i) {
                if (this.cprdata[i] == null) continue;
                System.arraycopy(this.cprdata[i], 0, this.cpr, i * 16384, this.cprdata[i].length);
            }
            int limit = 0;
            for (int i4 = 0; i4 < 32; ++i4) {
                if (this.cprdata[i4] == null) continue;
                ++limit;
            }
            byte[] result = new byte[limit * 16384];
            limit = 0;
            pos = 0;
            for (int i5 = 0; i5 < 32; ++i5) {
                if (this.cprdata[i5] == null) continue;
                System.arraycopy(this.cprdata[i5], 0, result, pos, 16384);
                pos += 16384;
            }
            return result;
        }
        return null;
    }

    public void CPR2BIN(byte[] data, String filename) {
        if (this.cprdata == null) {
            this.cprdata = new byte[32][];
        }
        if (this.CPRHeader.equals(new String(data, 0, this.CPRHeader.length()).toUpperCase())) {
            if (this.CPRIdentifier.equals(new String(data, 8, this.CPRIdentifier.length()).toUpperCase())) {
                int i;
                int length;
                int i2;
                for (i2 = 0; i2 < 32; ++i2) {
                    this.loaded[i2] = false;
                }
                this.CPRSize = Device.getDWord(data, 4);
                for (i2 = 0; i2 < 32; ++i2) {
                    this.cprdata[i2] = null;
                }
                block8: for (int pos = 12; pos < this.CPRSize; pos += length) {
                    byte check1 = data[pos++];
                    byte check2 = data[pos++];
                    byte index1 = data[pos++];
                    byte index2 = data[pos++];
                    length = Device.getDWord(data, pos);
                    pos += 4;
                    if (check1 != 99 || check2 != 98) continue;
                    int index = 0;
                    String a = "" + (char)index1 + "" + (char)index2;
                    try {
                        index = Integer.parseInt(a);
                    }
                    catch (Exception e) {
                        System.err.println("An error occured!");
                        return;
                    }
                    if (!this.loaded[index &= 0x1F]) {
                        this.cprdata[index] = new byte[16384];
                        System.arraycopy(data, pos, this.cprdata[index], 0, length);
                        this.loaded[index] = true;
                        System.out.println("Storing to position: " + index);
                        continue;
                    }
                    byte[] check = new byte[16384];
                    System.arraycopy(data, pos, check, 0, length);
                    for (int i3 = 0; i3 < length; ++i3) {
                        if (check[i3] == this.cprdata[index][i3]) continue;
                        System.err.println("Difference encountered! " + Util.hex((short)i3));
                        System.err.println(Util.dumpBytes(this.cprdata[index], i3, 16));
                        System.err.println(Util.dumpBytes(check, i3, 16));
                        this.cprdata[index] = new byte[16384];
                        System.arraycopy(data, pos, this.cprdata[index], 0, length);
                        continue block8;
                    }
                }
                int s = 0;
                for (i = 0; i < 32; ++i) {
                    if (this.cprdata[i] == null) continue;
                    s += this.cprdata[i].length;
                }
                this.cpr = new byte[s];
                for (i = 0; i < 32; ++i) {
                    if (this.cprdata[i] == null) continue;
                    System.arraycopy(this.cprdata[i], 0, this.cpr, i * 16384, this.cprdata[i].length);
                }
                if (filename != null && this.store) {
                    String newname = filename.replace(".cpr", "") + ".bin";
                    File out = new File(newname);
                    try {
                        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(out));
                        int limit = 0;
                        for (int i4 = 0; i4 < 32; ++i4) {
                            if (this.cprdata[i4] == null || this.uselimit && limit >= 128) continue;
                            limit += 16;
                            bos.write(this.cprdata[i4]);
                        }
                        bos.close();
                    }
                    catch (Exception exception) {}
                }
            }
        } else {
            int pos = 0;
            try {
                for (int i = 0; i < data.length; i += 16384) {
                    this.cprdata[pos] = new byte[16384];
                    System.arraycopy(data, i, this.cprdata[pos], 0, 16384);
                    ++pos;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void readCPR2(byte[] data, String filename) {
        if (this.cprdata == null) {
            this.cprdata = new byte[32][];
        }
        if (this.CPRHeader.equals(new String(data, 0, this.CPRHeader.length()).toUpperCase())) {
            if (this.CPRIdentifier.equals(new String(data, 8, this.CPRIdentifier.length()).toUpperCase())) {
                int i;
                int length;
                int i2;
                for (i2 = 0; i2 < 32; ++i2) {
                    this.loaded[i2] = false;
                }
                this.CPRSize = Device.getDWord(data, 4);
                for (i2 = 0; i2 < 32; ++i2) {
                    this.cprdata[i2] = null;
                }
                block8: for (int pos = 12; pos < this.CPRSize; pos += length) {
                    byte check1 = data[pos++];
                    byte check2 = data[pos++];
                    byte index1 = data[pos++];
                    byte index2 = data[pos++];
                    length = Device.getDWord(data, pos);
                    pos += 4;
                    if (check1 != 99 || check2 != 98) continue;
                    int index = 0;
                    String a = "" + (char)index1 + "" + (char)index2;
                    try {
                        index = Integer.parseInt(a);
                    }
                    catch (Exception e) {
                        System.err.println("An error occured!");
                        return;
                    }
                    if (!this.loaded[index &= 0x1F]) {
                        this.cprdata[index] = new byte[16384];
                        System.arraycopy(data, pos, this.cprdata[index], 0, length);
                        this.loaded[index] = true;
                        System.out.println("Storing to position: " + index);
                        continue;
                    }
                    byte[] check = new byte[16384];
                    System.arraycopy(data, pos, check, 0, length);
                    for (int i3 = 0; i3 < length; ++i3) {
                        if (check[i3] == this.cprdata[index][i3]) continue;
                        System.err.println("Difference encountered! " + Util.hex((short)i3));
                        System.err.println(Util.dumpBytes(this.cprdata[index], i3, 16));
                        System.err.println(Util.dumpBytes(check, i3, 16));
                        this.cprdata[index] = new byte[16384];
                        System.arraycopy(data, pos, this.cprdata[index], 0, length);
                        continue block8;
                    }
                }
                int s = 0;
                for (i = 0; i < 32; ++i) {
                    if (this.cprdata[i] == null) continue;
                    s += this.cprdata[i].length;
                }
                this.cpr = new byte[s];
                for (i = 0; i < 32; ++i) {
                    if (this.cprdata[i] == null) continue;
                    System.arraycopy(this.cprdata[i], 0, this.cpr, i * 16384, this.cprdata[i].length);
                }
                if (filename != null && this.store) {
                    String newname = filename + ".bin";
                    File out = new File(newname);
                    try {
                        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(out));
                        for (int i4 = 0; i4 < 32; ++i4) {
                            if (this.cprdata[i4] == null) continue;
                            bos.write(this.cprdata[i4]);
                        }
                        bos.close();
                    }
                    catch (Exception exception) {}
                }
            }
        } else {
            int pos = 0;
            try {
                for (int i = 0; i < data.length; i += 16384) {
                    this.cprdata[pos] = new byte[16384];
                    System.arraycopy(data, i, this.cprdata[pos], 0, 16384);
                    ++pos;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

