/*
 * Decompiled with CFR 0.152.
 */
package JaC64;

import com.dreamfabric.c64utils.AutoStore;
import com.dreamfabric.jac64.C64Canvas;
import com.dreamfabric.jac64.C64Reader;
import com.dreamfabric.jac64.C64Screen;
import com.dreamfabric.jac64.CPU;
import com.dreamfabric.jac64.DefaultIMon;
import com.dreamfabric.jac64.DirEntry;
import com.dreamfabric.jac64.IMonitor;
import com.dreamfabric.jac64.PatchListener;
import com.dreamfabric.jac64.SELoader;
import com.dreamfabric.jac64.SIDMixer;
import com.dreamfabric.jac64.VICConstants;
import java.applet.Applet;
import java.applet.AudioClip;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JWindow;

public class C64Applet
extends Applet
implements Runnable,
PatchListener {
    private CPU cpu;
    private int[] memory;
    private boolean started = false;
    private boolean stopping = false;
    private C64Reader reader;
    private String currentDisk;
    private String loadFile;
    private boolean stick = true;
    private C64Screen screen;
    private C64Canvas canvas;
    private Vector files;
    private boolean require1541 = false;
    private IMonitor imon = new DefaultIMon();
    private static Color lblue = new Color(VICConstants.COLOR_SETS[0][14]);
    private Thread thread;
    private String autostartDisk;
    private String autostartProgram;
    private String autoText;
    private int autostartID = -1;
    private int defaultStick = 0;
    private int soundOn = 0;
    private int doubleScreen = 0;
    private boolean fullscreen = false;
    private JFrame fullFrame = null;
    private JWindow fullWin = null;

    @Override
    public void init() {
        this.started = false;
        this.stopping = false;
        this.currentDisk = null;
        if (this.cpu == null) {
            SIDMixer.DL_BUFFER_SIZE = 16384;
            System.out.println("starting CPU");
            this.cpu = new CPU(this.imon, this.getCodeBase().toString(), new SELoader());
            System.out.println("Status: initializing");
            this.doubleScreen = this.getParameterAsInt("doubleScreen", 0);
            int freescale = this.getParameterAsInt("freescale", 0);
            this.screen = new C64Screen(this.imon, this.doubleScreen > 0);
            this.cpu.init(this.screen);
            this.screen.init(this.cpu);
            if (freescale != 0) {
                this.screen.setIntegerScaling(false);
            }
            this.memory = this.cpu.getMemory();
            this.setLayout(new BorderLayout());
            this.setBackground(Color.black);
            this.setForeground(lblue);
            this.reader = new C64Reader();
            this.reader.setCPU(this.cpu);
            this.canvas = (C64Canvas)this.screen.getScreen();
            this.fullscreen(this.fullscreen);
            this.screen.registerHotKey(8, 640, "reset()", this.cpu);
            this.screen.registerHotKey(123, 128, "toggleFullscreen()", this);
            this.repaint();
            this.validate();
            this.addKeyListener(this.canvas);
            this.canvas.requestFocus();
            this.cpu.getDrive().setReader(this.reader);
            AudioClip trackSound = null;
            AudioClip motorSound = null;
            URL url = this.getClass().getResource("sounds/track.wav");
            System.out.println("Audio URL:" + url);
            if (url != null) {
                trackSound = Applet.newAudioClip(url);
            }
            if ((url = this.getClass().getResource("sounds/motor.wav")) != null) {
                motorSound = Applet.newAudioClip(url);
            }
            this.screen.setSounds(trackSound, motorSound);
            this.setColorSet(this.getParameterAsInt("colorset", 0));
            int rq1541 = this.getParameterAsInt("require1541", 0);
            this.require1541 = rq1541 == 1;
            int n = 12;
            for (int i = 0; i < n; ++i) {
                String f1 = this.getParameter("hotkey-f" + (i + 1));
                if (f1 == null || f1.length() <= 0) continue;
                this.screen.registerHotKey(112 + i, 512, f1, this);
            }
            System.out.println("*** INIT END ***");
        }
    }

    public void toggleFullscreen() {
        this.fullscreen(!this.fullscreen);
    }

    public void fullscreen(boolean full) {
        this.fullscreen = full;
        if (full) {
            this.remove(this.canvas);
            if (this.fullFrame == null) {
                this.fullFrame = new JFrame("-");
                this.fullWin = new JWindow(this.fullFrame);
                this.fullWin.addKeyListener(this.canvas);
            }
            this.screen.setAutoscale(true);
            this.fullWin.add(this.canvas);
            this.fullWin.setSize(100, 100);
            System.out.println("Setting visible to true!!!");
            this.fullWin.setVisible(true);
            this.fullFrame.setVisible(true);
            GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().setFullScreenWindow(this.fullWin);
            this.fullWin.setFocusable(true);
        } else {
            if (this.fullFrame != null) {
                this.fullFrame.setVisible(false);
                this.fullWin.setVisible(false);
            }
            GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().setFullScreenWindow(null);
            this.add((Component)this.canvas, "Center");
            this.validate();
        }
    }

    private void autoload() {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                C64Applet.this.autoText = C64Applet.this.getParameter("autostartCode");
                C64Applet.this.autostartDisk = C64Applet.this.getParameter("autostartDisk");
                if (C64Applet.this.autostartDisk != null) {
                    C64Applet.this.autostartProgram = C64Applet.this.getParameter("autostartPGM");
                    if (C64Applet.this.autostartProgram == null) {
                        C64Applet.this.autostartProgram = C64Applet.this.getParameter("autostartProgram");
                    }
                } else {
                    C64Applet.this.autostartProgram = C64Applet.this.getParameter("autostartPGM");
                    C64Applet.this.autostartID = C64Applet.this.getParameterAsInt("autostartProgram", -1);
                }
                C64Applet.this.defaultStick = C64Applet.this.getParameterAsInt("joystick", 0);
                C64Applet.this.soundOn = C64Applet.this.getParameterAsInt("soundOn", 1);
                if (C64Applet.this.getParameterAsInt("extendedKeyboard", 0) != 0) {
                    C64Applet.this.screen.setKeyboardEmulation(true);
                    System.out.println("Extended keyboard emulation on!");
                }
                C64Applet.this.loadGamesList();
                C64Applet.this.screen.setSoundOn(C64Applet.this.soundOn == 1);
                C64Applet.this.screen.setStick(C64Applet.this.defaultStick == 0);
                if (C64Applet.this.autostartDisk != null) {
                    if (C64Applet.this.autostartProgram != null) {
                        C64Applet.this.loadGame(C64Applet.this.autostartDisk, C64Applet.this.autostartProgram);
                    } else {
                        C64Applet.this.insertDisk(C64Applet.this.autostartDisk);
                        C64Applet.this.resetAndWait();
                        C64Applet.this.enterText(C64Applet.this.autoText);
                    }
                } else if (C64Applet.this.autostartProgram != null) {
                    System.out.println("Autostart program:" + C64Applet.this.autostartProgram);
                    if (C64Applet.this.files != null && C64Applet.this.autostartProgram.equals("random")) {
                        int randomId = (int)(Math.random() * (double)(C64Applet.this.files.size() / 2));
                        C64Applet.this.loadGame(randomId);
                    } else {
                        C64Applet.this.loadPGM(C64Applet.this.autostartProgram);
                    }
                }
                if (C64Applet.this.autostartID != -1) {
                    System.out.println("AutostartID: " + C64Applet.this.autostartID);
                    C64Applet.this.loadGame(C64Applet.this.autostartID);
                }
                C64Applet.this.started = true;
            }
        });
        t.start();
    }

    @Override
    public void start() {
        System.out.println("Starting applet...");
        if (this.thread == null) {
            this.thread = new Thread(this);
            this.thread.start();
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.autoload();
        } else {
            this.unpause();
            this.started = true;
        }
    }

    @Override
    public void stop() {
        System.out.println("Status: stopping");
        this.stopping = true;
        this.cpu.stop();
        this.screen.motorSound(false);
        this.cpu = null;
        this.screen = null;
    }

    @Override
    public void destroy() {
        System.out.println("APPLET DESTROY CALLED");
        this.screen.getAudioDriver().shutdown();
        this.cpu.stop();
        this.screen.motorSound(false);
    }

    public boolean isStarted() {
        return this.started;
    }

    @Override
    public void run() {
        if (this.started && !this.stopping) {
            System.out.println("Status: running");
            this.cpu.start();
        } else {
            this.cpu.start();
        }
        this.stopping = false;
        this.thread = null;
    }

    private int getParameterAsInt(String paramName, int defVal) {
        String val = this.getParameter(paramName);
        System.out.println(paramName + " = " + val);
        if (val != null) {
            try {
                return Integer.parseInt(val);
            }
            catch (Exception e) {
                System.out.println("Can not parse value: " + val);
            }
        }
        return defVal;
    }

    private void loadGamesList() {
        System.out.println("Trying to load games list");
        try {
            String disk;
            URL url = this.getResource("games.txt");
            LineNumberReader reader = new LineNumberReader(new InputStreamReader(url.openConnection().getInputStream()));
            this.files = new Vector();
            while ((disk = reader.readLine()) != null) {
                if ((disk = disk.trim()).toLowerCase().endsWith(".prg") || disk.toLowerCase().endsWith(".p00")) {
                    this.files.addElement(disk);
                    this.files.addElement(disk);
                    continue;
                }
                String games = reader.readLine();
                if (games == null) continue;
                games = games.trim();
                StringTokenizer stok = new StringTokenizer(games, ",");
                while (stok.hasMoreElements()) {
                    String game = stok.nextToken();
                    this.files.addElement(disk);
                    this.files.addElement(game);
                    System.out.println("Adding: " + game);
                }
            }
        }
        catch (Exception e) {
            System.out.println("Can not load games..." + e);
            System.out.println("No games to load...");
        }
    }

    public void setColorSet(int i) {
        this.screen.setColorSet(i %= VICConstants.COLOR_SETS.length);
    }

    public void poke(int address, int data) {
        if (address < 53248 || address >= 57344) {
            int[] memory = this.cpu.getMemory();
            memory[address & 0xFFFF] = data & 0xFF;
        } else {
            this.cpu.poke(address & 0xFFFF, data & 0xFF);
        }
    }

    public int peek(int address) {
        int[] memory = this.cpu.getMemory();
        return memory[address & 0xFFFF];
    }

    public void pause() {
        this.cpu.setPause(true);
    }

    public void unpause() {
        this.cpu.setPause(false);
    }

    private void loadProgram(int item) {
        String disk = (String)this.files.elementAt(item * 2);
        String name = (String)this.files.elementAt(item * 2 + 1);
        System.out.println("Index:" + item + " -> " + disk + " " + name);
        this.loadProgram(disk, name);
    }

    private boolean loadProgram(String disk, String name) {
        boolean em1541 = this.require1541;
        if (disk.startsWith("@")) {
            disk = disk.substring(1);
            em1541 = true;
        }
        if (disk != this.currentDisk) {
            URL url = this.getResource(disk);
            this.currentDisk = disk;
            if ((disk = disk.toLowerCase()).endsWith(".d64")) {
                if (!this.reader.readDiskFromURL(url)) {
                    System.out.println("Status: problem while loading disk");
                }
            } else if (disk.endsWith(".t64")) {
                if (!this.reader.readTapeFromURL(url)) {
                    System.out.println("Status: problem while loading tape");
                }
            } else if (disk.endsWith(".prg") || disk.endsWith(".p00")) {
                if (!this.reader.readPGM(url, -1)) {
                    System.out.println("Status: problem while loading pgm");
                } else {
                    System.out.println("Status: loaded " + disk);
                }
                return false;
            }
        }
        if (em1541) {
            System.out.println("Loading with C1541 emulation...");
            this.enterText("load \"" + name + "\",8~");
            this.enterText("run~");
            return true;
        }
        for (int i = name.length(); i < 16; ++i) {
            name = name + " ";
        }
        if (this.reader.readFile(name) != null) {
            System.out.println("Status: loaded " + name);
        } else {
            System.out.println("Status: error while loading " + name);
        }
        return false;
    }

    public void loadPGM(String pgm) {
        this.resetAndWait();
        URL url = this.getResource(pgm);
        if (!this.reader.readPGM(url, -1)) {
            System.out.println("Status: problem while loading pgm");
        }
        this.cpu.runBasic();
        this.canvas.requestFocus();
    }

    public void insertDisk(String urlstr) {
        URL url;
        if (urlstr.startsWith("@")) {
            urlstr = urlstr.substring(1);
        }
        if (!this.reader.readDiskFromURL(url = this.getResource(urlstr))) {
            System.out.println("Status: problem while inserting disk: " + url);
        }
    }

    public void enterText(String txt) {
        this.cpu.enterText(txt);
    }

    public void loadPGM(String disk, String game) {
        this.loadGame(disk, game);
    }

    public void loadGame(String disk, String game) {
        this.resetAndWait();
        System.out.println("Loading " + game + " from " + disk);
        if (!this.loadProgram(disk, game)) {
            this.cpu.runBasic();
        }
        this.canvas.requestFocus();
    }

    private void resetAndWait() {
        this.cpu.reset();
        while (!this.screen.ready()) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception e2) {
                System.out.println("Exception while sleeping... C64Applet");
            }
        }
    }

    public void loadGame(int item) {
        this.resetAndWait();
        this.loadProgram(item);
        this.cpu.runBasic();
        this.canvas.requestFocus();
    }

    public void setStick(int stick) {
        System.out.println("Setting stick: one ? " + (stick == 0));
        this.screen.setStick(stick == 0);
        this.canvas.requestFocus();
    }

    public void setSoundOn(boolean on) {
        this.screen.setSoundOn(on);
    }

    public void setScanRate(int rate) {
        this.screen.setScanRate(rate);
    }

    public void reset() {
        System.out.println("Reset - no kill");
        this.cpu.reset();
        this.canvas.requestFocus();
    }

    private URL getResource(String urls) {
        URL url = this.getClass().getResource(urls);
        if (url == null) {
            try {
                url = new URL(this.getCodeBase().toString() + urls);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return url;
    }

    public void setEffect(int id) {
    }

    public void saveFile(String name, String author, String description) {
        if (description == null) {
            description = "";
        }
        String data = "name=" + URLEncoder.encode(name) + "&description=" + URLEncoder.encode(description) + "&author=" + URLEncoder.encode(author) + "&file=" + this.reader.saveFile();
        System.out.println("Saving file: " + data);
        try {
            int c;
            URL url = this.getResource("prgup.php");
            URLConnection urlc = url.openConnection();
            urlc.setDoOutput(true);
            urlc.setUseCaches(false);
            HttpURLConnection httpConnection = (HttpURLConnection)urlc;
            httpConnection.setRequestMethod("POST");
            httpConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            DataOutputStream out = new DataOutputStream(httpConnection.getOutputStream());
            out.writeBytes(data);
            out.flush();
            out.close();
            InputStream is = httpConnection.getInputStream();
            System.out.println("Read back:");
            while ((c = is.read()) != -1) {
                System.out.print((char)c);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    @Override
    public boolean readFile(String str, int adr) {
        str = str.trim();
        System.out.println("Should load: \"" + str + "\"");
        if ("$".equals(str)) {
            System.out.println("Entering basic data");
            ArrayList vc = this.reader.getDirNames();
            int pos = 2048;
            this.memory[pos++] = 0;
            int n = vc.size();
            for (int i = 0; i < n; ++i) {
                DirEntry ent = this.reader.getDirEntry((String)vc.get(i));
                String name = ent.name;
                int nextPos = pos + 5 + name.length();
                System.out.println("Name:  " + name + " " + name.length());
                System.out.println("Next:  " + nextPos);
                System.out.println("Pos:  " + pos);
                this.memory[pos++] = nextPos & 0xFF;
                this.memory[pos++] = nextPos >> 8;
                this.memory[pos++] = ent.size & 0xFF;
                this.memory[pos++] = ent.size >> 8;
                for (int j = 0; j < name.length(); ++j) {
                    this.memory[pos++] = name.charAt(j);
                }
                this.memory[pos++] = 0;
            }
            return true;
        }
        for (int i = str.length(); i < 16; ++i) {
            str = str + " ";
        }
        return this.reader.readFile(str, adr) != null;
    }

    public void setSIDEmulation(int type) {
        this.screen.setSID(type);
    }

    public void enableAutoStore(int max) {
        this.cpu.setCheatEnabled(max);
    }

    public void setAutoStore(int index, String prefix) {
        AutoStore as = new AutoStore(prefix);
        this.cpu.setAutoStore(index, as);
    }

    public void protect(int address, int value) {
        this.cpu.protect(address, value);
    }

    public void monitorRead(int address) {
        this.cpu.monitorRead(address);
    }

    public void monitorWrite(int address) {
        this.cpu.monitorWrite(address);
    }

    public void addAutoStoreRule(int index, String rule) {
        this.cpu.getAutoStore(index).addRule(rule);
    }

    public void addAutoStoreStore(int index, int adr, int len, String name) {
        this.cpu.getAutoStore(index).addStore(adr, len, name);
    }
}

