/*
 * Decompiled with CFR 0.152.
 */
package JaC64;

import com.dreamfabric.c64utils.Debugger;
import com.dreamfabric.jac64.C64Reader;
import com.dreamfabric.jac64.C64Screen;
import com.dreamfabric.jac64.CPU;
import com.dreamfabric.jac64.DirEntry;
import com.dreamfabric.jac64.SELoader;
import com.dreamfabric.jac64.SIDMixer;
import java.applet.Applet;
import java.applet.AudioClip;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.net.URL;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class JaC64
implements ActionListener,
KeyEventDispatcher {
    private static final String ABOUT_MESSAGE = "JaC64 version: 1.11\nJaC64 is a Java-based C64 emulator by Joakim Eriksson\nThe SID emulation use the resid Java port by Ken H\u00e4ndel\n\nFor more information see: http://www.jac64.com/";
    private C64Reader reader;
    private C64Screen scr;
    private boolean fullscreen = false;
    public CPU cpu;
    public JInternalFrame C64Win;
    private KeyListener c64Canvas;
    private FileDialog fileDialog;
    private JMenuItem load;
    private JTable fileTable;
    private JDialog loadFile;
    private DirEntry[] dirEntries;
    private static final String[] SID_TYPES = new String[]{"SID: resid MOS 6581", "SID: resid MOS 8580", "SID: JaC64 Original"};
    private static final String[] JOYSTICK = new String[]{"Joystick in port 1", "Joystick in port 2"};
    private TableModel dataModel = new AbstractTableModel(){
        public final String[] NAMES = new String[]{"File name", "Size", "Type"};

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return JaC64.this.dirEntries != null ? JaC64.this.dirEntries.length : 0;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (col == 0) {
                return ((JaC64)JaC64.this).dirEntries[row].name;
            }
            if (col == 1) {
                return new Integer(((JaC64)JaC64.this).dirEntries[row].size);
            }
            if (col == 2) {
                return JaC64.this.dirEntries[row].getTypeString();
            }
            return "-";
        }

        @Override
        public String getColumnName(int col) {
            return this.NAMES[col];
        }
    };
    JMenuBar jbar = new JMenuBar();

    public JaC64() {
        SIDMixer.DL_BUFFER_SIZE = 16384;
        Debugger monitor = new Debugger();
        this.cpu = new CPU(monitor, "", new SELoader());
        this.scr = new C64Screen(monitor, true);
        this.cpu.init(this.scr);
        this.scr.init(this.cpu);
        this.scr.registerHotKey(8, 640, "reset()", this.cpu);
        this.scr.registerHotKey(123, 128, "toggleFullScreen()", this);
        this.reader = new C64Reader();
        this.reader.setCPU(this.cpu);
        this.cpu.getDrive().setReader(this.reader);
        this.C64Win = new JInternalFrame("JaC64 - A Java C64 Emulator");
        this.C64Win.setDefaultCloseOperation(1);
        this.C64Win.setJMenuBar(this.jbar);
        JMenu filem = new JMenu("File");
        this.jbar.add(filem);
        JMenuItem mi = new JMenuItem("Open File/Disk");
        filem.add(mi);
        mi.addActionListener(this);
        this.load = new JMenuItem("Load File");
        filem.add(this.load);
        this.load.addActionListener(this);
        mi = new JMenuItem("Reset");
        filem.add(mi);
        mi.addActionListener(this);
        mi = new JMenuItem("Boot");
        filem.add(mi);
        mi.addActionListener(this);
        mi = new JMenuItem("Hard Reset");
        filem.add(mi);
        mi.addActionListener(this);
        mi = new JMenuItem("About JaC64");
        filem.add(mi);
        mi.addActionListener(this);
        filem = new JMenu("Settings");
        this.jbar.add(filem);
        JMenu subm = new JMenu("Color Set");
        filem.add(subm);
        this.createRadioMenu(subm, new String[]{"Color Set 1 - JaC64 original", "Color Set 2 - darker", "Color Set 3 - softer", "Color Set 4 - Win VICE"}, 3);
        subm = new JMenu("SID Emulation");
        filem.add(subm);
        this.createRadioMenu(subm, SID_TYPES, 0);
        subm = new JMenu("Joystick Port");
        filem.add(subm);
        this.createRadioMenu(subm, JOYSTICK, 0);
        this.C64Win.setBackground(Color.black);
        this.C64Win.setForeground(Color.black);
        this.C64Win.setLayout(new BorderLayout());
        this.C64Win.getContentPane().add((Component)this.scr.getScreen(), "Center");
        this.C64Win.setFocusable(true);
        this.C64Win.pack();
        this.C64Win.setSize(786, 638);
        this.C64Win.setResizable(true);
        this.C64Win.setVisible(true);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this);
        AudioClip trackSound = null;
        AudioClip motorSound = null;
        URL url = this.getClass().getResource("../sounds/track.wav");
        if (url != null) {
            trackSound = Applet.newAudioClip(url);
        }
        if ((url = this.getClass().getResource("../sounds/motor.wav")) != null) {
            motorSound = Applet.newAudioClip(url);
        }
        this.scr.setSounds(trackSound, motorSound);
        this.c64Canvas = (KeyListener)((Object)this.scr.getScreen());
        this.scr.setColorSet(3);
    }

    private void createRadioMenu(JMenu subm, String[] names, int selected) {
        ButtonGroup group = new ButtonGroup();
        for (int i = 0; i < names.length; ++i) {
            JRadioButtonMenuItem mi = new JRadioButtonMenuItem(names[i]);
            subm.add(mi);
            if (i == selected) {
                mi.setSelected(true);
            }
            mi.addActionListener(this);
            group.add(mi);
        }
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent e) {
        if (this.C64Win.hasFocus()) {
            if (e.getID() == 401) {
                this.c64Canvas.keyPressed(e);
            } else if (e.getID() == 402) {
                if (e.getKeyCode() == 123) {
                    this.cpu.hardReset();
                }
                if (e.getKeyCode() == 122) {
                    this.cpu.reset();
                }
                if (e.getKeyCode() == 120) {
                    this.openDisk();
                }
                if (e.getKeyCode() == 121) {
                    this.loadFile();
                }
                this.c64Canvas.keyReleased(e);
            } else if (e.getID() == 400) {
                this.c64Canvas.keyTyped(e);
            }
            return true;
        }
        return false;
    }

    public void openDisk() {
        this.initFiletable();
        this.readDisk();
    }

    public void initFiletable() {
        if (this.fileTable == null) {
            this.fileTable = new JTable(this.dataModel);
            this.fileTable.getColumnModel().getColumn(1).setMaxWidth(50);
            this.fileTable.getColumnModel().getColumn(2).setMaxWidth(50);
            this.fileTable.setShowGrid(false);
            this.fileTable.setSelectionMode(0);
        }
    }

    public void loadFile() {
        this.initFiletable();
        if (this.loadFile == null) {
            this.loadFile = new JDialog((Frame)new JFrame(), "Load file from disk");
            this.loadFile.setAlwaysOnTop(true);
            this.loadFile.setLayout(new BorderLayout());
            this.loadFile.add((Component)new JScrollPane(this.fileTable), "Center");
            this.loadFile.add((Component)this.fileTable.getTableHeader(), "North");
            JPanel jp = new JPanel();
            JButton jb = new JButton("Load file");
            jp.add(jb);
            jb.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    JaC64.this.reader.readFile(((JaC64)JaC64.this).dirEntries[((JaC64)JaC64.this).fileTable.getSelectedRow()].name);
                    JaC64.this.loadFile.setVisible(false);
                }
            });
            jb = new JButton("Cancel");
            jp.add(jb);
            jb.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    JaC64.this.loadFile.setVisible(false);
                }
            });
            this.loadFile.add((Component)jp, "South");
            this.loadFile.setSize(300, 400);
        }
        this.loadFile.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String cmd = ae.getActionCommand();
        if ("Open File/Disk".equals(cmd)) {
            this.openDisk();
        } else if ("Reset".equals(cmd)) {
            this.cpu.reset();
        } else if ("Boot".equals(cmd)) {
            this.cpu.enterText("LOAD\"*\",8,1\r");
        } else if ("Hard Reset".equals(cmd)) {
            this.cpu.hardReset();
        } else if ("About JaC64".equals(cmd)) {
            this.showAbout();
        } else if ("Load File".equals(cmd)) {
            this.loadFile();
        } else if (cmd.startsWith("Color Set")) {
            int cs = cmd.charAt(10) - 49;
            System.out.println("Color set: " + cs);
            this.scr.setColorSet(cs);
        } else if (cmd.equals(SID_TYPES[0])) {
            this.scr.setSID(1);
        } else if (cmd.equals(SID_TYPES[1])) {
            this.scr.setSID(2);
        } else if (cmd.equals(SID_TYPES[2])) {
            this.scr.setSID(3);
        } else if (cmd.equals(JOYSTICK[0])) {
            this.scr.setStick(true);
        } else if (cmd.equals(JOYSTICK[1])) {
            this.scr.setStick(false);
        }
    }

    private void showAbout() {
        JOptionPane.showMessageDialog(this.C64Win, ABOUT_MESSAGE, "JaC64 - The Java C64 Emulator", 1);
    }

    public void toggleFullScreen() {
        System.out.println("Toggle fullscreen called!");
        this.setFull(!this.fullscreen);
    }

    private void readDisk() {
        if (this.fileDialog == null) {
            this.fileDialog = new FileDialog((Frame)new JFrame(), "Select File/Disk to Load");
        }
        this.fileDialog.setVisible(true);
        String name = this.fileDialog.getDirectory() + this.fileDialog.getFile();
        if (!this.readDisk(name)) {
            this.dirEntries = this.reader.getDirNames().toArray(new DirEntry[0]);
            this.fileTable.tableChanged(new TableModelEvent(this.dataModel));
        }
    }

    private boolean readDisk(String name) {
        System.out.println("READING FROM: " + name);
        if (name.toLowerCase().endsWith(".d64")) {
            this.reader.readDiskFromFile(name);
        } else if (name.toLowerCase().endsWith(".t64")) {
            this.reader.readTapeFromFile(name);
        } else if (name.toLowerCase().endsWith(".prg") || name.toLowerCase().endsWith(".p00")) {
            this.cpu.reset();
            try {
                Thread.sleep(10L);
            }
            catch (Exception e2) {
                System.out.println("Exception while sleeping...");
            }
            while (!this.scr.ready()) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception e2) {
                    System.out.println("Exception while sleeping...");
                }
            }
            this.reader.readPGM(name, -1);
            this.cpu.runBasic();
            return true;
        }
        return false;
    }

    private void setFull(boolean full) {
    }

    public static void main(String[] name) {
        JaC64 test2 = new JaC64();
        JFrame frame = new JFrame("JaC64");
        frame.setLayout(new BorderLayout());
        frame.setJMenuBar(test2.C64Win.getJMenuBar());
        frame.add((Component)test2.C64Win.getContentPane(), "Center");
        frame.setSize(786, 638);
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
        test2.cpu.start();
    }
}

