/*
 * Decompiled with CFR 0.152.
 */
package classes;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;

public class Card {
    public int width;
    public int height;
    public int cardColor;
    public int cardVal;
    public int flipped;
    public int suggested;
    String symbol;
    int[] symbolX;
    int[] symbolY;

    public int getcardValue() {
        return this.cardVal;
    }

    public int getcardColor() {
        return this.cardColor;
    }

    public Card(int w, int h, int colour, int cardValue) {
        this.width = w;
        this.height = h;
        this.cardColor = colour;
        this.cardVal = cardValue;
        if (cardValue >= 2 && cardValue <= 10) {
            this.symbol = cardValue + "";
        } else if (cardValue == 11) {
            this.symbol = "J";
        } else if (cardValue == 12) {
            this.symbol = "Q";
        } else if (cardValue == 13) {
            this.symbol = "K";
        } else if (cardValue == 14 || cardValue == 1) {
            this.symbol = "A";
        }
        if (colour == 0) {
            this.symbolX = new int[5];
            this.symbolY = new int[5];
            this.symbolX[0] = w / 2;
            this.symbolY[0] = h / 2 - h / 5;
            this.symbolX[1] = w / 2 - w / 5;
            this.symbolY[1] = h / 2;
            this.symbolX[2] = w / 2;
            this.symbolY[2] = h / 2 + h / 5;
            this.symbolX[3] = w / 2 + w / 5;
            this.symbolY[3] = h / 2;
            this.symbolX[4] = this.symbolX[0];
            this.symbolY[4] = this.symbolY[0];
        } else if (colour == 1) {
            this.symbolX = new int[4];
            this.symbolY = new int[4];
            this.symbolX[0] = w / 2 - w / 3 - w / 18;
            this.symbolY[0] = h / 2;
            this.symbolX[1] = w / 2;
            this.symbolY[1] = h / 2 + h / 4;
            this.symbolX[2] = w / 2 + w / 3 + w / 18;
            this.symbolY[2] = h / 2;
            this.symbolX[3] = this.symbolX[0];
            this.symbolY[3] = this.symbolY[0];
        } else if (colour == 3) {
            this.symbolX = new int[4];
            this.symbolY = new int[4];
            this.symbolX[0] = w / 2 - w / 3 - w / 18;
            this.symbolY[0] = h / 2;
            this.symbolX[1] = w / 2;
            this.symbolY[1] = h / 2 - h / 4;
            this.symbolX[2] = w / 2 + w / 3 + w / 18;
            this.symbolY[2] = h / 2;
            this.symbolX[3] = this.symbolX[0];
            this.symbolY[3] = this.symbolY[0];
        }
        this.flipped = 0;
        this.suggested = 0;
    }

    public void drawCard(Graphics g, int x, int y) {
        try {
            FontMetrics localFontMetrics = g.getFontMetrics();
            g.setColor(Color.white);
            g.fillRect(x, y, this.width, this.height);
            if (this.suggested == 1) {
                g.setColor(Color.blue);
                g.fillRect(x, y + this.height + 2, this.width, 5);
            }
            if (this.cardColor <= 1) {
                g.setColor(Color.red);
            } else {
                g.setColor(Color.black);
            }
            g.drawString(this.symbol, x + 3, y + 12);
            g.drawString(this.symbol, x + this.width - 3 - localFontMetrics.stringWidth(this.symbol), y + this.height - 3 - localFontMetrics.getMaxDescent());
            if (this.cardColor == 0) {
                int[] arrayOfInt1 = new int[5];
                int[] arrayOfInt2 = new int[5];
                for (int n = 0; n < 5; ++n) {
                    arrayOfInt1[n] = this.symbolX[n] + x;
                    arrayOfInt2[n] = this.symbolY[n] + y;
                }
                g.fillPolygon(arrayOfInt1, arrayOfInt2, 5);
            } else if (this.cardColor == 1) {
                int i = this.width / 2 + x;
                int j = this.height / 2 + y;
                int m = this.width * 5 / 14;
                int k = m / 2;
                int i1 = k / 3;
                g.fillOval(i - m - i1 + 2, j - k, m, m);
                g.fillOval(i, j - k, m, m);
                int[] arrayOfInt1 = new int[4];
                int[] arrayOfInt2 = new int[4];
                for (int n = 0; n < 4; ++n) {
                    arrayOfInt1[n] = this.symbolX[n] + x;
                    arrayOfInt2[n] = this.symbolY[n] + y;
                }
                g.fillPolygon(arrayOfInt1, arrayOfInt2, 4);
            } else if (this.cardColor == 2) {
                int i = this.width / 2 + x;
                int j = this.height / 2 + y;
                int m = this.width / 3;
                int k = m / 2;
                int i1 = k / 3;
                g.fillOval(i - m - i1, j - k, m, m);
                g.fillOval(i, j - k, m, m);
                g.fillOval(i - k, j - m - i1, m, m);
                g.fillRect(i - this.width / 16, j - this.height / 8, this.width / 8, this.height / 4);
            } else if (this.cardColor == 3) {
                int i = this.width / 2 + x;
                int j = this.height / 2 + y;
                int m = this.width / 3;
                int k = m / 2;
                int i1 = k / 3;
                g.fillOval(i - m - i1 + 1, j - k, m, m);
                g.fillOval(i + 1, j - k, m, m);
                g.fillRect(i - this.width / 16, j - this.height / 8, this.width / 8, this.height / 4);
                int[] arrayOfInt1 = new int[4];
                int[] arrayOfInt2 = new int[4];
                for (int n = 0; n < 4; ++n) {
                    arrayOfInt1[n] = this.symbolX[n] + x;
                    arrayOfInt2[n] = this.symbolY[n] + y;
                }
                g.fillPolygon(arrayOfInt1, arrayOfInt2, 4);
            }
            if (this.flipped == 0) {
                g.setColor(new Color(0, 0, 255, 128));
                g.fillRect(x + 4, y + 4, this.width - 8, this.height - 8);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

