/*
 * Decompiled with CFR 0.152.
 */
package com.dreamfabric.c64utils;

import com.dreamfabric.jac64.MOS6510Ops;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;

public class Assembler {
    public static final int DEBUG_LEVEL = 0;
    public static final int CODE = 1;
    public static final int COMMENT = 2;
    public static final int REF_WORD = 0;
    public static final int REF_BYTE = 1;
    public static final int REF_BYTE_LO = 2;
    public static final int REF_BYTE_HI = 3;
    public static final int REF_RELATIVE = 4;
    public static final int[] REF_SIZE = new int[]{2, 1, 1, 1, 1};
    private int mode = 1;
    private int pos = 0;
    private int lastPos = 0;
    private Hashtable labels = new Hashtable();
    private Vector references = new Vector();
    private String currentLine;
    private String[] tokens;
    private int[] memory = new int[65536];
    private int lineNo;
    protected String workingDir;

    public void setMemory(int[] memory) {
        this.memory = memory;
    }

    public void setWorkingDir(String dir) {
        this.workingDir = dir;
        if (!this.workingDir.endsWith("/")) {
            this.workingDir = this.workingDir + "/";
        }
        System.out.println("Set working dir to " + this.workingDir);
    }

    public int[] assemble(String s, int start) {
        String[] lines = Assembler.split(s, "\n", false);
        this.labels.clear();
        this.references.removeAllElements();
        this.setPos(start);
        this.mode = 1;
        int n = lines.length;
        for (int i = 0; i < n; ++i) {
            this.currentLine = lines[i];
            if (this.assembleLine(lines[i], this.memory, this.pos) == 1) break;
            ++this.lineNo;
        }
        this.resolve();
        return this.memory;
    }

    private void setPos(int start) {
        this.lastPos = this.pos = start;
        System.out.println("Location set to: " + start);
    }

    private int assembleLine(String lineOrig, int[] memory, int adr) {
        String line = lineOrig;
        if (this.mode == 2) {
            if (line.endsWith("*/")) {
                this.mode = 1;
            }
            return 0;
        }
        if (line.startsWith("/*")) {
            this.mode = 2;
            return 0;
        }
        this.tokens = Assembler.split(line, " \t", true);
        if (this.tokens == null || this.tokens.length == 0) {
            return 0;
        }
        String label = this.tokens[0].trim();
        if (this.tokens.length == 0 || this.tokens.length == 1 && label.length() == 0) {
            return 0;
        }
        if (label.equals(".end")) {
            return 1;
        }
        String op = null;
        String operand = null;
        if (this.tokens.length > 1) {
            op = this.tokens[1];
        }
        if (this.tokens.length > 2) {
            operand = this.tokens[2];
        }
        if (label.length() > 0 && this.addLabel(label, op, operand)) {
            return 0;
        }
        char c = op.charAt(0);
        if (c == '.') {
            if (op.equals(".word")) {
                this.pos += this.setValue(0, this.pos, operand, true);
            } else if (op.equals(".byte")) {
                this.pos += this.setValue(1, this.pos, operand, true);
            } else if (op.equals(".org")) {
                this.setPos(Assembler.parseInt(operand));
            } else if (op.equals(".align")) {
                int al = Assembler.parseInt(operand);
                System.out.println("Aligning to " + al);
                this.setPos(this.pos - (this.pos & al - 1) + al);
            } else if (op.equals(".binary")) {
                this.loadBinary(operand);
            } else if (op.equals(".wdir")) {
                this.setWorkingDir(operand);
            } else {
                this.error("unhandled operation '" + op + "'");
            }
        } else if (op.equals("*=")) {
            this.setPos(this.resolve(operand, this.pos));
        } else {
            if (op.startsWith(";")) {
                return 0;
            }
            int opI = MOS6510Ops.lookup(op);
            switch (opI) {
                case 8: 
                case 16: 
                case 25: 
                case 42: 
                case 56: 
                case 67: 
                case 74: {
                    this.setBranch(MOS6510Ops.lookup(opI, 2048), operand);
                    break;
                }
                case 0: 
                case 4: 
                case 6: 
                case 9: 
                case 15: 
                case 17: 
                case 18: 
                case 22: 
                case 26: 
                case 27: 
                case 31: 
                case 34: 
                case 39: 
                case 40: 
                case 44: 
                case 45: 
                case 53: 
                case 55: 
                case 57: 
                case 58: 
                case 64: 
                case 65: 
                case 68: 
                case 73: 
                case 75: {
                    memory[this.pos++] = MOS6510Ops.lookup(opI, 0);
                    break;
                }
                case 1: 
                case 5: 
                case 11: 
                case 13: 
                case 14: 
                case 19: 
                case 21: 
                case 24: 
                case 28: 
                case 30: 
                case 36: 
                case 37: 
                case 38: 
                case 49: 
                case 50: 
                case 51: 
                case 60: 
                case 61: 
                case 63: 
                case 69: 
                case 70: 
                case 72: {
                    c = operand.charAt(0);
                    if (c == '#') {
                        this.setOP(opI, 256, this.pos++);
                        this.pos += this.setValue(1, this.pos, operand.substring(1));
                        break;
                    }
                    if (c == '(') {
                        String oplow = operand.toLowerCase();
                        int adrMode = 3072;
                        int size = 0;
                        if (oplow.endsWith(")")) {
                            operand = operand.substring(1, operand.length() - 1);
                        } else if (oplow.endsWith(",x)")) {
                            adrMode = 2304;
                            size = 1;
                            operand = operand.substring(1, operand.length() - 3);
                        } else if (oplow.endsWith("),y")) {
                            adrMode = 2560;
                            size = 1;
                            operand = operand.substring(1, operand.length() - 3);
                        } else {
                            this.error("Illegal syntax on indirection op " + op);
                        }
                        this.setOP(opI, adrMode, this.pos++);
                        this.pos += this.setValue(size, this.pos, operand);
                        break;
                    }
                    String oplow = operand.toLowerCase();
                    int adrMode = 768;
                    int adrModeZ = 512;
                    int size = 0;
                    if (oplow.endsWith(",x")) {
                        operand = operand.substring(0, operand.length() - 2);
                        adrMode = 1536;
                        adrModeZ = 1024;
                    } else if (oplow.endsWith(",y")) {
                        operand = operand.substring(0, operand.length() - 2);
                        adrMode = 1792;
                        adrModeZ = 1280;
                    }
                    if (this.byteSize(operand)) {
                        size = 1;
                        adrMode = adrModeZ;
                    }
                    this.setOP(opI, adrMode, this.pos++);
                    this.pos += this.setValue(size, this.pos, operand);
                    break;
                }
                case 10: {
                    this.setOP(opI, 0, this.pos++);
                    this.pos += this.setValue(0, this.pos, operand);
                    break;
                }
                default: {
                    this.error("Unhandled OP: '" + op + "' at " + this.hex4(this.pos));
                }
            }
        }
        this.lastPos = this.pos;
        return 0;
    }

    private int handleStringConstant(int pos, String operand) {
        int num;
        block4: {
            char c;
            block3: {
                c = operand.charAt(0);
                num = 0;
                if (c != '\"') break block3;
                int n = operand.length();
                for (int i = 1; i < n; ++i) {
                    c = operand.charAt(i);
                    if (c == '\"') continue;
                    this.memory[pos] = c;
                    ++pos;
                    ++num;
                }
                break block4;
            }
            if (c != '\'') break block4;
            boolean stuffed = false;
            int n = operand.length();
            for (int i = 1; i < n; ++i) {
                c = operand.charAt(i);
                if (c != '\'' || stuffed) {
                    this.memory[pos] = c;
                    ++pos;
                    ++num;
                    stuffed = false;
                    continue;
                }
                stuffed = true;
            }
        }
        return num;
    }

    public InputStream openBinary(String binary) {
        return null;
    }

    private void loadBinary(String binary) {
        try {
            InputStream fs;
            if (this.workingDir == null) {
                this.workingDir = "";
            }
            if ((fs = this.openBinary(this.workingDir + binary)) == null) {
                return;
            }
            int data = 0;
            int initPos = this.pos;
            while ((data = fs.read()) != -1) {
                this.memory[this.pos++] = data & 0xFF;
            }
            System.out.println("Loaded binary file at: " + this.hex4(initPos) + " len: " + (this.pos - initPos));
            fs.close();
        }
        catch (Exception e) {
            this.error("Could not load binary file " + binary);
        }
    }

    private void setOP(int opI, int mode, int pos) {
        int opR = MOS6510Ops.lookup(opI, mode);
        if (opR == -1) {
            this.error(MOS6510Ops.modeString(mode) + " mode not available for " + MOS6510Ops.INS_STR[opI]);
        }
        this.memory[pos] = opR;
    }

    private int setValue(int type, int pos, String value) {
        return this.setValue(type, pos, value, false);
    }

    private int setValue(int type, int pos, String value, boolean allowArrays) {
        int val;
        if (allowArrays) {
            char c = value.charAt(0);
            if (c == '\'' || c == '\"') {
                int lp = this.currentLine.indexOf(c);
                return this.handleStringConstant(pos, this.currentLine.substring(lp));
            }
            if (this.tokens.length > 3) {
                return this.setValueArr(type, pos, this.tokens, 2);
            }
            if (value.indexOf(44) > 0) {
                String[] tok2 = Assembler.split(value, ",", true);
                return this.setValueArr(type, pos, tok2, 0);
            }
        }
        if ((val = Assembler.parseInt(value)) != -1) {
            this.setValue(type, pos, val);
            return REF_SIZE[type];
        }
        this.createRef(type, pos, value);
        return REF_SIZE[type];
    }

    private int setValueArr(int type, int pos, String[] tokens, int start) {
        int len = 0;
        System.out.println("*** Possible array!!!");
        int n = tokens.length;
        for (int i = start; i < n; ++i) {
            if (tokens[i].startsWith(";")) {
                return len;
            }
            if (tokens[i].indexOf(44) >= 0) {
                len += this.setValueArr(type, pos + len, Assembler.split(tokens[i], ",", true), 0);
                continue;
            }
            len += this.setValue(type, pos + len, tokens[i], false);
            System.out.println("Arr[" + (i - start) + "] = " + tokens[i]);
        }
        return len;
    }

    private void setValue(int type, int pos, int value) {
        switch (type) {
            case 0: {
                this.setWordValue(pos, value);
                break;
            }
            case 3: {
                this.setByteValue(pos, value >> 8);
                break;
            }
            case 1: 
            case 2: {
                this.setByteValue(pos, value & 0xFF);
                break;
            }
            case 4: {
                this.setRelValue(pos, value);
            }
        }
    }

    private void error(String s) {
        throw new IllegalArgumentException(s + " at line " + this.lineNo);
    }

    private void resolve() {
        int n = this.references.size();
        for (int i = 0; i < n; i += 2) {
            String name = (String)this.references.elementAt(i);
            int[] data = (int[])this.references.elementAt(i + 1);
            int type = data[0];
            int pos = data[1];
            int val = this.resolve(name, pos);
            this.setValue(type, pos, val);
        }
    }

    private int resolve(String name, int pos) {
        char c = name.charAt(0);
        if (c == '<') {
            return this.resolve(name.substring(1), pos) & 0xFF;
        }
        if (c == '>') {
            return this.resolve(name.substring(1), pos) >> 8;
        }
        int n = name.length();
        for (int i = 0; i < n; ++i) {
            c = name.charAt(i);
            if (c == '+') {
                return this.resolve(name.substring(0, i), pos) + this.resolve(name.substring(i + 1), pos);
            }
            if (c == '-') {
                return this.resolve(name.substring(0, i), pos) - this.resolve(name.substring(i + 1), pos);
            }
            if (c == '/') {
                return this.resolve(name.substring(0, i), pos) / this.resolve(name.substring(i + 1), pos);
            }
            if (c != '*') continue;
            if (i == 0) {
                if (n != 1) continue;
                return pos - 1;
            }
            return this.resolve(name.substring(0, i), pos) * this.resolve(name.substring(i + 1), pos);
        }
        int adr = this.getLabelAddress(name);
        if (adr == -1) {
            int val = Assembler.parseInt(name);
            if (val == -1) {
                this.error("### Could not find label " + name);
            }
            return val;
        }
        return adr;
    }

    private void setBranch(int op, String line) {
        this.memory[this.pos++] = op;
        this.setValue(4, this.pos, line);
        ++this.pos;
    }

    private boolean byteSize(String s) {
        int x = Assembler.parseInt(s);
        return x != -1 && x < 256;
    }

    public static int parseInt(String s) {
        char c = s.charAt(0);
        if (s.endsWith(",")) {
            s = s.substring(0, s.length() - 1);
            System.out.println("Ends with , => " + s);
        }
        int val = -1;
        try {
            if (c == '$') {
                s = s.substring(1);
                val = Integer.parseInt(s, 16);
            } else if (c == '%') {
                s = s.substring(1);
                val = Integer.parseInt(s, 2);
            } else if (c == '@') {
                s = s.substring(1);
                val = Integer.parseInt(s, 8);
            } else {
                val = Integer.parseInt(s);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return val;
    }

    private void setWordValue(int pos, int val) {
        this.memory[pos] = val & 0xFF;
        this.memory[pos + 1] = val >> 8 & 0xFF;
    }

    private void setByteValue(int pos, int val) {
        this.memory[pos] = val & 0xFF;
    }

    private void setRelValue(int pos, int val) {
        this.memory[pos] = val - (pos + 1) & 0xFF;
    }

    private void createRef(int type, int pos, String s) {
        s = s.toLowerCase().trim();
        this.references.addElement(s);
        this.references.addElement(new int[]{type, pos});
    }

    private boolean addLabel(String label, String op, String operand) {
        if (label.startsWith(";")) {
            return true;
        }
        boolean rval = false;
        if (op == null || op != null && op.startsWith(";")) {
            rval = true;
        }
        if ("*".equals(label)) {
            if ("=".equals(op)) {
                this.setPos(Assembler.parseInt(operand));
                System.out.println("*** New location: " + this.hex4(this.pos));
            }
            return true;
        }
        int[] lpos = new int[1];
        if ("=".equals(op) || ".equ".equals(op)) {
            lpos[0] = Assembler.parseInt(operand);
            rval = true;
        } else {
            if (".org".equals(op)) {
                this.setPos(Assembler.parseInt(operand));
                rval = true;
            }
            lpos[0] = this.pos;
        }
        this.labels.put(label, lpos);
        return rval;
    }

    public int getLabelAddress(String label) {
        int[] lpos = (int[])this.labels.get(label);
        if (lpos != null) {
            return lpos[0];
        }
        return -1;
    }

    public void setByteValue(String label, int val) {
        System.out.println("Setting byte value of " + label + " to " + Integer.toString(val, 16));
        int a = this.getLabelAddress(label);
        if (a == -1) {
            throw new IllegalArgumentException("Can not find label: " + label);
        }
        this.setByteValue(a, val);
    }

    public void setWordValue(String label, int val) {
        System.out.println("Setting word value of " + label + " to " + Integer.toString(val, 16));
        int a = this.getLabelAddress(label);
        if (a == -1) {
            throw new IllegalArgumentException("Can not find label: " + label);
        }
        this.setWordValue(a, val);
    }

    private String hex4(int pos) {
        String s = null;
        s = pos < 16 ? "$000" : (pos < 256 ? "$00" : (pos < 4096 ? "$0" : "$"));
        return s + Integer.toString(pos, 16);
    }

    private String hex2(int pos) {
        String s = null;
        s = pos < 16 ? "$0" : "$";
        return s + Integer.toString(pos, 16);
    }

    private static String[] split(String data, String splits, boolean trim) {
        Vector<String> strings = new Vector<String>();
        int lastPos = 0;
        boolean mode = false;
        int n = data.length();
        for (int i = 0; i < n; ++i) {
            char c = data.charAt(i);
            if (splits.indexOf(c) != -1) {
                if (!mode) {
                    if (lastPos != 0 && lastPos + 1 < n) {
                        ++lastPos;
                    }
                    strings.addElement(data.substring(lastPos, i));
                }
                lastPos = i;
                mode = true;
                continue;
            }
            mode = false;
        }
        if (lastPos != 0 && lastPos + 1 < data.length()) {
            ++lastPos;
        }
        strings.addElement(data.substring(lastPos, data.length()));
        String[] retval = new String[strings.size()];
        int n2 = retval.length;
        for (int i = 0; i < n2; ++i) {
            retval[i] = (String)strings.elementAt(i);
        }
        return retval;
    }
}

