/*
 * Decompiled with CFR 0.152.
 */
package com.dreamfabric.c64utils;

import com.dreamfabric.jac64.Hex;
import com.dreamfabric.jac64.IMonitor;
import com.dreamfabric.jac64.M6510Ops;
import com.dreamfabric.jac64.MOS6510Core;
import com.dreamfabric.jac64.MOS6510Ops;

public class Debugger
implements IMonitor,
M6510Ops {
    private boolean DEBUG = false;
    private boolean DEBUG_IRQ = true;
    private boolean noinstructions = false;
    private int level = 10;
    String prefix = "";
    public long lastCycles = 0L;
    private MOS6510Core cpu;
    private int[] memory;

    @Override
    public void init(MOS6510Core cpu) {
        this.cpu = cpu;
        this.memory = cpu.getMemory();
    }

    @Override
    public boolean isEnabled() {
        return this.DEBUG;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    @Override
    public void info(Object o) {
        this.output((String)o);
    }

    @Override
    public void warning(Object o) {
        this.output((String)o);
    }

    @Override
    public void error(Object o) {
        this.output((String)o);
    }

    private void output(String s) {
        if (this.prefix != null) {
            if (s.startsWith(this.prefix)) {
                System.out.println(s);
            }
        } else {
            System.out.println(s);
        }
    }

    private int fetchByte(int pc) {
        return this.memory[pc];
    }

    @Override
    public void disAssemble(int[] memory, int pc, int acc, int x, int y, byte status, int interruptInExec, int lastInterrupt) {
        if (this.DEBUG || interruptInExec > 0) {
            int startPC = pc;
            StringBuffer line = new StringBuffer();
            if (!this.noinstructions) {
                int i;
                line.append(Integer.toHexString(pc));
                for (int i2 = 5 - line.length(); i2 >= 0; --i2) {
                    line.append(" ");
                }
                int data = MOS6510Ops.INSTRUCTION_SET[memory[pc++]];
                int op = data & 0xFF;
                int addrMode = data & 0xF00;
                int adMode = addrMode >> 8;
                boolean read = (data & 0x1000) != 0;
                boolean write = (data & 0x2000) != 0;
                int adr = 0;
                int tmp = 0;
                int p1 = memory[pc];
                line.append(MOS6510Ops.INS_STR[op]);
                line.append(MOS6510Ops.ADR_STR_PRE[adMode]);
                switch (addrMode) {
                    case 256: {
                        ++pc;
                        data = p1;
                        line.append("$" + Hex.hex2(data));
                        break;
                    }
                    case 768: {
                        int n = ++pc;
                        ++pc;
                        adr = (this.fetchByte(n) << 8) + p1;
                        line.append("$" + Hex.hex2(adr));
                        if (!read) break;
                        data = this.fetchByte(adr);
                        line.append("=" + Hex.hex2(data));
                        break;
                    }
                    case 512: {
                        ++pc;
                        adr = p1;
                        line.append("$" + Hex.hex2(adr));
                        if (!read) break;
                        data = this.fetchByte(adr);
                        line.append("=" + Hex.hex2(data));
                        break;
                    }
                    case 1024: 
                    case 1280: {
                        ++pc;
                        this.fetchByte(p1);
                        adr = addrMode == 1024 ? p1 + x & 0xFF : p1 + y & 0xFF;
                        line.append("$" + Hex.hex2(adr));
                        if (!read) break;
                        data = this.fetchByte(adr);
                        line.append("=" + Hex.hex2(data));
                        break;
                    }
                    case 1536: 
                    case 1792: {
                        int n = ++pc;
                        ++pc;
                        adr = this.fetchByte(n) << 8;
                        p1 = addrMode == 1536 ? (p1 += x) : (p1 += y);
                        data = this.fetchByte(adr + (p1 & 0xFF));
                        line.append("$" + Hex.hex2(adr += p1));
                        if (!read || p1 <= 255 && !write) break;
                        data = this.fetchByte(adr);
                        line.append("=" + Hex.hex2(data));
                        break;
                    }
                    case 2048: {
                        adr = ++pc + (byte)p1;
                        tmp = ((adr ^ pc) & 0xFF00) > 0 ? 2 : 1;
                        line.append("$" + Hex.hex2(adr));
                        break;
                    }
                    case 2816: {
                        data = acc;
                        write = false;
                        break;
                    }
                    case 2304: {
                        ++pc;
                        tmp = p1 + x & 0xFF;
                        adr = this.fetchByte(tmp + 1) << 8;
                        line.append("$" + Hex.hex2(adr |= this.fetchByte(tmp)));
                        if (!read) break;
                        data = this.fetchByte(adr);
                        line.append("=" + Hex.hex2(data));
                        break;
                    }
                    case 2560: {
                        ++pc;
                        adr = this.fetchByte(p1 + 1) << 8;
                        p1 = this.fetchByte(p1);
                        data = this.fetchByte(adr + ((p1 += y) & 0xFF));
                        line.append("$" + Hex.hex2(adr += p1));
                        if (!read || p1 <= 255 && !write) break;
                        data = this.fetchByte(adr);
                        line.append("=" + Hex.hex2(data));
                        break;
                    }
                    case 3072: {
                        adr = (this.fetchByte(++pc) << 8) + p1;
                        tmp = adr & 0xFFF00 | adr + 1 & 0xFF;
                        adr = (this.fetchByte(tmp) << 8) + this.fetchByte(adr);
                        line.append("$" + Hex.hex2(adr));
                    }
                }
                line.append(MOS6510Ops.ADR_STR_POST[adMode]);
                StringBuffer bytes = new StringBuffer();
                for (i = startPC; i < pc; ++i) {
                    bytes.append(Integer.toString(memory[i], 16));
                    bytes.append(" ");
                }
                for (i = 9 - bytes.length(); i > 0; --i) {
                    bytes.append(" ");
                }
                if (interruptInExec > 0) {
                    if (lastInterrupt == 1) {
                        bytes.append("[NMI] " + interruptInExec + " ");
                    } else {
                        bytes.append("[IRQ] " + interruptInExec + " ");
                    }
                } else {
                    bytes.append("        ");
                }
                if (line.length() > 6) {
                    line.insert(6, bytes.toString());
                }
                for (i = 45 - line.length(); i > 0; --i) {
                    line.append(" ");
                }
                if (!this.noinstructions) {
                    line.append("A:");
                    line.append(Hex.hex2(acc));
                    line.append(" X:");
                    line.append(Hex.hex2(x));
                    line.append(" Y:");
                    line.append(Hex.hex2(y));
                    line.append(" ");
                    boolean carry = (status & 1) != 0;
                    boolean zero = (status & 2) != 0;
                    boolean disableInterupt = (status & 4) != 0;
                    boolean decimal = (status & 8) != 0;
                    boolean brk = (status & 0x10) != 0;
                    boolean overflow = (status & 0x40) != 0;
                    boolean sign = (status & 0x80) != 0;
                    line.append(carry ? "C" : "-");
                    line.append(zero ? "Z" : "-");
                    line.append(disableInterupt ? "I" : "-");
                    line.append(decimal ? "D" : "-");
                    line.append(brk ? "B" : "-");
                    line.append(overflow ? "O" : "-");
                    line.append(sign ? "S" : "-");
                    if (this.DEBUG_IRQ) {
                        line.append(" ");
                        line.append(this.cpu.NMILow ? "N" : "-");
                        line.append(this.cpu.getIRQLow() ? "I" : "-");
                    }
                    line.append(" S:" + Hex.hex2(this.cpu.getSP()));
                    line.append(" " + Hex.hex2((int)(this.cpu.cycles - this.lastCycles)));
                    this.getFunction(memory, startPC, line);
                }
                System.out.println(line);
                this.lastCycles = this.cpu.cycles;
            }
        }
    }

    public void getFunction(int[] memory, int startPC, StringBuffer line) {
        if ((memory[1] & 3) == 3) {
            switch (startPC) {
                case 40960: {
                    line.append("  % -\tRestart Vectors\t\t\t\tWORD");
                    break;
                }
                case 40972: {
                    line.append("  % stmdsp\tBASIC Command Vectors\t\t\tWORD");
                    break;
                }
                case 41042: {
                    line.append("  % fundsp\tBASIC Function Vectors\t\t\tWORD");
                    break;
                }
                case 41088: {
                    line.append("  % optab\tBASIC Operator Vectors\t\t\tWORD");
                    break;
                }
                case 41118: {
                    line.append("  % reslst\tBASIC Command Keyword Table\t\tDATA");
                    break;
                }
                case 41257: {
                    line.append("  % msclst\tBASIC Misc. Keyword Table\t\tDATA");
                    break;
                }
                case 41280: {
                    line.append("  % oplist\tBASIC Operator Keyword Table\t\tDATA");
                    break;
                }
                case 41293: {
                    line.append("  % funlst\tBASIC Function Keyword Table\t\tDATA");
                    break;
                }
                case 41374: {
                    line.append("  % errtab\tError Message Table\t\t\tDATA");
                    break;
                }
                case 41768: {
                    line.append("  % errptr\tError Message Pointers\t\t\tWORD");
                    break;
                }
                case 41828: {
                    line.append("  % okk\tMisc. Messages\t\t\t\tTEXT");
                    break;
                }
                case 41866: {
                    line.append("  % fndfor\tFind FOR/GOSUB Entry on Stack");
                    break;
                }
                case 41912: {
                    line.append("  % bltu\tOpen Space in Memory");
                    break;
                }
                case 41979: {
                    line.append("  % getstk\tCheck Stack Depth");
                    break;
                }
                case 41992: {
                    line.append("  % reason\tCheck Memory Overlap / Array area overflow check");
                    break;
                }
                case 42037: {
                    line.append("  % omerr\tOutput ?OUT OF MEMORY Error");
                    break;
                }
                case 42039: {
                    line.append("  % error\tError Routine");
                    break;
                }
                case 42089: {
                    line.append("  % errfin\tBreak Entry");
                    break;
                }
                case 42100: {
                    line.append("  % ready\tRestart BASIC");
                    break;
                }
                case 42112: {
                    line.append("  % main\tInput & Identify BASIC Line");
                    break;
                }
                case 42140: {
                    line.append("  % main1\tGet Line Number & Tokenise Text");
                    break;
                }
                case 42146: {
                    line.append("  % inslin\tInsert BASIC Text");
                    break;
                }
                case 42291: {
                    line.append("  % linkprg\tRechain Lines");
                    break;
                }
                case 42336: {
                    line.append("  % inlin\tInput Line Into Buffer");
                    break;
                }
                case 42361: {
                    line.append("  % crunch\tTokenise Input Buffer");
                    break;
                }
                case 42515: {
                    line.append("  % fndlin\tSearch for Line Number");
                    break;
                }
                case 42562: {
                    line.append("  % scrtch\tPerform [new]");
                    break;
                }
                case 42590: {
                    line.append("  % clear\tPerform [clr]");
                    break;
                }
                case 42638: {
                    line.append("  % stxpt\tReset TXTPTR");
                    break;
                }
                case 42652: {
                    line.append("  % list\tPerform [list]");
                    break;
                }
                case 42775: {
                    line.append("  % qplop\tHandle LIST Character");
                    break;
                }
                case 42818: {
                    line.append("  % for\tPerform [for]");
                    break;
                }
                case 42926: {
                    line.append("  % newstt\tBASIC Warm Start");
                    break;
                }
                case 42948: {
                    line.append("  % ckeol\tCheck End of Program");
                    break;
                }
                case 42977: {
                    line.append("  % gone\tPrepare to execute statement");
                    break;
                }
                case 42989: {
                    line.append("  % gone3\tPerform BASIC Keyword,Execute command in A");
                    break;
                }
                case 43037: {
                    line.append("  % restor\tPerform [restore]");
                    break;
                }
                case 43052: {
                    line.append("  % stop\tPerform [stop], [end], break");
                    break;
                }
                case 43095: {
                    line.append("  % cont\tPerform [cont]");
                    break;
                }
                case 43121: {
                    line.append("  % run\tPerform [run]");
                    break;
                }
                case 43139: {
                    line.append("  % gosub\tPerform [gosub]");
                    break;
                }
                case 43168: {
                    line.append("  % goto\tPerform [goto]");
                    break;
                }
                case 43218: {
                    line.append("  % return\tPerform [return]");
                    break;
                }
                case 43256: {
                    line.append("  % data\tPerform [data]");
                    break;
                }
                case 43270: {
                    line.append("  % datan\tSearch for Next Statement / Line");
                    break;
                }
                case 43304: {
                    line.append("  % if\tPerform [if]");
                    break;
                }
                case 43323: {
                    line.append("  % rem\tPerform [rem]");
                    break;
                }
                case 43339: {
                    line.append("  % ongoto\tPerform [on]");
                    break;
                }
                case 43371: {
                    line.append("  % linget\tFetch linnum From BASIC");
                    break;
                }
                case 43429: {
                    line.append("  % let\tPerform [let]");
                    break;
                }
                case 43460: {
                    line.append("  % putint\tAssign Integer");
                    break;
                }
                case 43478: {
                    line.append("  % ptflpt\tAssign Floating Point");
                    break;
                }
                case 43481: {
                    line.append("  % putstr\tAssign String");
                    break;
                }
                case 43491: {
                    line.append("  % puttim\tAssign TI$");
                    break;
                }
                case 43564: {
                    line.append("  % getspt\tAdd Digit to FAC#1");
                    break;
                }
                case 43648: {
                    line.append("  % printn\tPerform [print]#");
                    break;
                }
                case 43654: {
                    line.append("  % cmd\tPerform [cmd]");
                    break;
                }
                case 43674: {
                    line.append("  % strdon\tPrint String From Memory");
                    break;
                }
                case 43680: {
                    line.append("  % print\tPerform [print]");
                    break;
                }
                case 43704: {
                    line.append("  % varop\tOutput Variable");
                    break;
                }
                case 43735: {
                    line.append("  % crdo\tOutput CR/LF");
                    break;
                }
                case 43752: {
                    line.append("  % comprt\tHandle comma, TAB(, SPC(");
                    break;
                }
                case 43806: {
                    line.append("  % strout\tOutput String");
                    break;
                }
                case 43835: {
                    line.append("  % outspc\tOutput Format Character");
                    break;
                }
                case 43853: {
                    line.append("  % doagin\tHandle Bad Data");
                    break;
                }
                case 43899: {
                    line.append("  % get\tPerform [get]");
                    break;
                }
                case 43941: {
                    line.append("  % inputn\tPerform [input#]");
                    break;
                }
                case 43967: {
                    line.append("  % input\tPerform [input]");
                    break;
                }
                case 44010: {
                    line.append("  % bufful\tRead Input Buffer");
                    break;
                }
                case 44025: {
                    line.append("  % qinlin\tDo Input Prompt");
                    break;
                }
                case 44038: {
                    line.append("  % read\tPerform [read]");
                    break;
                }
                case 44085: {
                    line.append("  % rdget\tGeneral Purpose Read Routine");
                    break;
                }
                case 44284: {
                    line.append("  % exint\tInput Error Messages\t\t\tTEXT");
                    break;
                }
                case 44318: {
                    line.append("  % next\tPerform [next]");
                    break;
                }
                case 44385: {
                    line.append("  % donext\tCheck Valid Loop");
                    break;
                }
                case 44426: {
                    line.append("  % frmnum\tConfirm Result");
                    break;
                }
                case 44446: {
                    line.append("  % frmevl\tEvaluate Expression in Text");
                    break;
                }
                case 44675: {
                    line.append("  % eval\tEvaluate Single Term");
                    break;
                }
                case 44712: {
                    line.append("  % pival\tConstant - pi\t\t\t\tDATA");
                    break;
                }
                case 44717: {
                    line.append("  % qdot\tContinue Expression");
                    break;
                }
                case 44785: {
                    line.append("  % parchk\tExpression in Brackets");
                    break;
                }
                case 44791: {
                    line.append("  % chkcls\tConfirm Character");
                    break;
                }
                case 44794: {
                    line.append("  % -\t-test '('-");
                    break;
                }
                case 44797: {
                    line.append("  % -\t-test comma-");
                    break;
                }
                case 44808: {
                    line.append("  % synerr\tOutput ?SYNTAX Error");
                    break;
                }
                case 44813: {
                    line.append("  % domin\tSet up NOT Function");
                    break;
                }
                case 44820: {
                    line.append("  % rsvvar\tIdentify Reserved Variable");
                    break;
                }
                case 44840: {
                    line.append("  % isvar\tSearch for Variable");
                    break;
                }
                case 44872: {
                    line.append("  % tisasc\tConvert TI to ASCII String");
                    break;
                }
                case 44967: {
                    line.append("  % isfun\tIdentify Function Type");
                    break;
                }
                case 44977: {
                    line.append("  % strfun\tEvaluate String Function");
                    break;
                }
                case 45009: {
                    line.append("  % numfun\tEvaluate Numeric Function");
                    break;
                }
                case 45030: {
                    line.append("  % orop\tPerform [or], [and]");
                    break;
                }
                case 45078: {
                    line.append("  % dorel\tPerform <, =, >");
                    break;
                }
                case 45083: {
                    line.append("  % numrel\tNumeric Comparison");
                    break;
                }
                case 45102: {
                    line.append("  % strrel\tString Comparison");
                    break;
                }
                case 45182: {
                    line.append("  % dim\tPerform [dim]");
                    break;
                }
                case 45195: {
                    line.append("  % ptrget\tIdentify Variable");
                    break;
                }
                case 45287: {
                    line.append("  % ordvar\tLocate Ordinary Variable");
                    break;
                }
                case 45341: {
                    line.append("  % notfns\tCreate New Variable");
                    break;
                }
                case 45352: {
                    line.append("  % notevl\tCreate Variable");
                    break;
                }
                case 45460: {
                    line.append("  % aryget\tAllocate Array Pointer Space");
                    break;
                }
                case 45477: {
                    line.append("  % n32768\tConstant 32768 in Flpt\t\t\tDATA");
                    break;
                }
                case 45482: {
                    line.append("  % facinx\tFAC#1 to Integer in (AC/YR)");
                    break;
                }
                case 45490: {
                    line.append("  % intidx\tEvaluate Text for Integer (convert)");
                    break;
                }
                case 45503: {
                    line.append("  % ayint\tFloat (FAC#1) to Positive Integer (convert)");
                    break;
                }
                case 45521: {
                    line.append("  % isary\tGet Array Parameters");
                    break;
                }
                case 45592: {
                    line.append("  % fndary\tFind Array");
                    break;
                }
                case 45637: {
                    line.append("  % bserr\t?BAD SUBSCRIPT/?ILLEGAL QUANTITY");
                    break;
                }
                case 45665: {
                    line.append("  % notfdd\tCreate Array");
                    break;
                }
                case 45838: {
                    line.append("  % inlpn2\tLocate Element in Array");
                    break;
                }
                case 45900: {
                    line.append("  % umult\tNumber of Bytes in Subscript");
                    break;
                }
                case 45949: {
                    line.append("  % fre\tPerform [fre]");
                    break;
                }
                case 45969: {
                    line.append("  % givayf\tConvert Integer in (AC/YR) to Flpt");
                    break;
                }
                case 45982: {
                    line.append("  % pos\tPerform [pos]");
                    break;
                }
                case 45990: {
                    line.append("  % errdir\tConfirm Program Mode");
                    break;
                }
                case 46049: {
                    line.append("  % getfnm\tCheck Syntax of FN");
                    break;
                }
                case 46068: {
                    line.append("  % fndoer\tPerform [fn]");
                    break;
                }
                case 46181: {
                    line.append("  % strd\tPerform [str$]");
                    break;
                }
                case 46215: {
                    line.append("  % strlit\tSet Up String");
                    break;
                }
                case 46293: {
                    line.append("  % putnw1\tSave String Descriptor");
                    break;
                }
                case 46324: {
                    line.append("  % getspa\tAllocate Space for String");
                    break;
                }
                case 46374: {
                    line.append("  % garbag\tGarbage Collection");
                    break;
                }
                case 46525: {
                    line.append("  % dvars\tSearch for Next String");
                    break;
                }
                case 46598: {
                    line.append("  % grbpas\tCollect a String");
                    break;
                }
                case 46653: {
                    line.append("  % cat\tConcatenate Two Strings");
                    break;
                }
                case 46714: {
                    line.append("  % movins\tStore String in High RAM");
                    break;
                }
                case 46755: {
                    line.append("  % frestr\tPerform String Housekeeping");
                    break;
                }
                case 46811: {
                    line.append("  % frefac\tClean Descriptor Stack");
                    break;
                }
                case 46828: {
                    line.append("  % chrd\tPerform [chr$]");
                    break;
                }
                case 46848: {
                    line.append("  % leftd\tPerform [left$]");
                    break;
                }
                case 46892: {
                    line.append("  % rightd\tPerform [right$]");
                    break;
                }
                case 46903: {
                    line.append("  % midd\tPerform [mid$]");
                    break;
                }
                case 46945: {
                    line.append("  % pream\tPull sTring Parameters");
                    break;
                }
                case 46972: {
                    line.append("  % len\tPerform [len]");
                    break;
                }
                case 46978: {
                    line.append("  % len1\tExit String Mode");
                    break;
                }
                case 46987: {
                    line.append("  % asc\tPerform [asc]");
                    break;
                }
                case 47003: {
                    line.append("  % gtbytc\tEvaluate Text to 1 Byte in XR");
                    break;
                }
                case 47021: {
                    line.append("  % val\tPerform [val]");
                    break;
                }
                case 47029: {
                    line.append("  % strval\tConvert ASCII String to Flpt");
                    break;
                }
                case 47083: {
                    line.append("  % getnum\tGet parameters for POKE/WAIT");
                    break;
                }
                case 47095: {
                    line.append("  % getadr\tConvert FAC#1 to Integer in LINNUM");
                    break;
                }
                case 47117: {
                    line.append("  % peek\tPerform [peek]");
                    break;
                }
                case 47140: {
                    line.append("  % poke\tPerform [poke]");
                    break;
                }
                case 47149: {
                    line.append("  % wait\tPerform [wait]");
                    break;
                }
                case 47177: {
                    line.append("  % faddh\tAdd 0.5 to FAC#1");
                    break;
                }
                case 47184: {
                    line.append("  % fsub\tPerform Subtraction");
                    break;
                }
                case 47202: {
                    line.append("  % fadd5\tNormalise Addition");
                    break;
                }
                case 47207: {
                    line.append("  % fadd\tPerform Addition");
                    break;
                }
                case 47431: {
                    line.append("  % negfac\t2's Complement FAC#1");
                    break;
                }
                case 47486: {
                    line.append("  % overr\tOutput ?OVERFLOW Error");
                    break;
                }
                case 47491: {
                    line.append("  % mulshf\tMultiply by Zero Byte");
                    break;
                }
                case 47548: {
                    line.append("  % fone\tTable of Flpt Constants\t\t\tDATA");
                    break;
                }
                case 47594: {
                    line.append("  % log\tPerform [log]");
                    break;
                }
                case 47656: {
                    line.append("  % fmult\tPerform Multiply");
                    break;
                }
                case 47705: {
                    line.append("  % mulply\tMultiply by a Byte");
                    break;
                }
                case 47756: {
                    line.append("  % conupk\tLoad FAC#2 From Memory");
                    break;
                }
                case 47799: {
                    line.append("  % muldiv\tTest Both Accumulators");
                    break;
                }
                case 47828: {
                    line.append("  % mldvex\tOverflow / Underflow");
                    break;
                }
                case 47842: {
                    line.append("  % mul10\tMultiply FAC#1 by 10");
                    break;
                }
                case 47865: {
                    line.append("  % tenc\tConstant 10 in Flpt\t\t\tDATA");
                    break;
                }
                case 47870: {
                    line.append("  % div10\tDivide FAC#1 by 10");
                    break;
                }
                case 47879: {
                    line.append("  % fdiv\tDivide FAC#2 by Flpt at (AC/YR)");
                    break;
                }
                case 47887: {
                    line.append("  % fdivt\tDivide FAC#2 by FAC#1");
                    break;
                }
                case 48034: {
                    line.append("  % movfm\tLoad FAC#1 From Memory");
                    break;
                }
                case 48071: {
                    line.append("  % mov2f\tStore FAC#1 in Memory");
                    break;
                }
                case 48124: {
                    line.append("  % movfa\tCopy FAC#2 into FAC#1");
                    break;
                }
                case 48140: {
                    line.append("  % movaf\tCopy FAC#1 into FAC#2");
                    break;
                }
                case 48155: {
                    line.append("  % round\tRound FAC#1");
                    break;
                }
                case 48171: {
                    line.append("  % sign\tCheck Sign of FAC#1");
                    break;
                }
                case 48185: {
                    line.append("  % sgn\tPerform [sgn]");
                    break;
                }
                case 48216: {
                    line.append("  % abs\tPerform [abs]");
                    break;
                }
                case 48219: {
                    line.append("  % fcomp\tCompare FAC#1 With Memory");
                    break;
                }
                case 48283: {
                    line.append("  % qint\tConvert FAC#1 to Integer");
                    break;
                }
                case 48332: {
                    line.append("  % int\tPerform [int]");
                    break;
                }
                case 48371: {
                    line.append("  % fin\tConvert ASCII String to a Float in FAC#1");
                    break;
                }
                case 48563: {
                    line.append("  % n0999\tString Conversion Constants\t\tDATA");
                    break;
                }
                case 48578: {
                    line.append("  % inprt\tOutput 'IN' and Line Number");
                    break;
                }
                case 48605: {
                    line.append("  % fout\tConvert FAC#1 to ASCII String");
                    break;
                }
                case 48744: {
                    line.append("  % foutim\tConvert TI to String");
                    break;
                }
                case 48913: {
                    line.append("  % fhalf\tTable of Constants\t\t\tDATA");
                    break;
                }
                case 49009: {
                    line.append("  % sqr\tPerform [sqr]");
                    break;
                }
                case 49019: {
                    line.append("  % fpwrt\tPerform power ($)");
                    break;
                }
                case 49076: {
                    line.append("  % negop\tNegate FAC#1");
                    break;
                }
                case 49087: {
                    line.append("  % logeb2\tTable of Constants\t\t\tDATA");
                    break;
                }
                case 49133: {
                    line.append("  % exp\tPerform [exp]");
                    break;
                }
                case 57344: {
                    line.append("  % (exp continues)\tEXP continued From BASIC ROM");
                    break;
                }
                case 57411: {
                    line.append("  % polyx\tSeries Evaluation");
                    break;
                }
                case 57485: {
                    line.append("  % rmulc\tConstants for RND\t\t\tDATA");
                    break;
                }
                case 57495: {
                    line.append("  % rnd\tPerform [rnd]");
                    break;
                }
                case 57593: {
                    line.append("  % bioerr\tHandle I/O Error in BASIC");
                    break;
                }
                case 57612: {
                    line.append("  % bchout\tOutput Character");
                    break;
                }
                case 57618: {
                    line.append("  % bchin\tInput Character");
                    break;
                }
                case 57624: {
                    line.append("  % bckout\tSet Up For Output");
                    break;
                }
                case 57630: {
                    line.append("  % bckin\tSet Up For Input");
                    break;
                }
                case 57636: {
                    line.append("  % bgetin\tGet One Character");
                    break;
                }
                case 57642: {
                    line.append("  % sys\tPerform [sys]");
                    break;
                }
                case 57686: {
                    line.append("  % savet\tPerform [save]");
                    break;
                }
                case 57701: {
                    line.append("  % verfyt\tPerform [verify / load]");
                    break;
                }
                case 57790: {
                    line.append("  % opent\tPerform [open]");
                    break;
                }
                case 57799: {
                    line.append("  % closet\tPerform [close]");
                    break;
                }
                case 57812: {
                    line.append("  % slpara\tGet Parameters For LOAD/SAVE");
                    break;
                }
                case 57856: {
                    line.append("  % combyt\tGet Next One Byte Parameter");
                    break;
                }
                case 57862: {
                    line.append("  % deflt\tCheck Default Parameters");
                    break;
                }
                case 57870: {
                    line.append("  % cmmerr\tCheck For Comma");
                    break;
                }
                case 57881: {
                    line.append("  % ocpara\tGet Parameters For OPEN/CLOSE");
                    break;
                }
                case 57956: {
                    line.append("  % cos\tPerform [cos]");
                    break;
                }
                case 57963: {
                    line.append("  % sin\tPerform [sin]");
                    break;
                }
                case 58036: {
                    line.append("  % tan\tPerform [tan]");
                    break;
                }
                case 58080: {
                    line.append("  % pi2\tTable of Trig Constants\t\t\tDATA");
                    break;
                }
                case 58126: {
                    line.append("  % atn\tPerform [atn]");
                    break;
                }
                case 58174: {
                    line.append("  % atncon\tTable of ATN Constants\t\t\tDATA");
                    break;
                }
                case 58235: {
                    line.append("  % bassft\tBASIC Warm Start [RUNSTOP-RESTORE]");
                    break;
                }
                case 58260: {
                    line.append("  % init\tBASIC Cold Start");
                    break;
                }
                case 58274: {
                    line.append("  % initat\tCHRGET For Zero-page");
                    break;
                }
                case 58298: {
                    line.append("  % rndsed\tRND Seed For zero-page\t\t\tDATA");
                    break;
                }
                case 58303: {
                    line.append("  % initcz\tInitialize BASIC RAM");
                    break;
                }
                case 58402: {
                    line.append("  % initms\tOutput Power-Up Message");
                    break;
                }
                case 58439: {
                    line.append("  % bvtrs\tTable of BASIC Vectors (for 0300)\tWORD");
                    break;
                }
                case 58451: {
                    line.append("  % initv\tInitialize Vectors");
                    break;
                }
                case 58463: {
                    line.append("  % words\tPower-Up Message\t\t\tDATA");
                    break;
                }
                case 58541: {
                    line.append("  % -\tPatch for BASIC Call to CHKOUT");
                    break;
                }
                case 58551: {
                    line.append("  % -\tUnused Bytes For Future Patches\t\tEMPTY");
                    break;
                }
                case 58586: {
                    line.append("  % -\tReset Character Colour");
                    break;
                }
                case 58592: {
                    line.append("  % -\tPause After Finding Tape File");
                    break;
                }
                case 58604: {
                    line.append("  % -\tRS-232 Timing Table -- PAL\t\tDATA");
                    break;
                }
                case 58624: {
                    line.append("  % iobase\tGet I/O Address");
                    break;
                }
                case 58629: {
                    line.append("  % screen\tGet Screen Size");
                    break;
                }
                case 58634: {
                    line.append("  % plot\tPut / Get Row And Column");
                    break;
                }
                case 58648: {
                    line.append("  % cint1\tInitialize I/O");
                    break;
                }
                case 58692: {
                    line.append("  % -\tClear Screen");
                    break;
                }
                case 58726: {
                    line.append("  % -\tHome Cursor");
                    break;
                }
                case 58732: {
                    line.append("  % -\tSet Screen Pointers");
                    break;
                }
                case 58778: {
                    line.append("  % -\tSet I/O Defaults (Unused Entry)");
                    break;
                }
                case 58784: {
                    line.append("  % -\tSet I/O Defaults");
                    break;
                }
                case 58804: {
                    line.append("  % lp2\tGet Character From Keyboard Buffer");
                    break;
                }
                case 58826: {
                    line.append("  % -\tInput From Keyboard");
                    break;
                }
                case 58930: {
                    line.append("  % -\tInput From Screen or Keyboard");
                    break;
                }
                case 59012: {
                    line.append("  % -\tQuotes Test");
                    break;
                }
                case 59025: {
                    line.append("  % -\tSet Up Screen Print");
                    break;
                }
                case 59062: {
                    line.append("  % -\tAdvance Cursor");
                    break;
                }
                case 59117: {
                    line.append("  % -\tRetreat Cursor");
                    break;
                }
                case 59137: {
                    line.append("  % -\tBack on to Previous Line");
                    break;
                }
                case 59158: {
                    line.append("  % -\tOutput to Screen");
                    break;
                }
                case 59178: {
                    line.append("  % -\t-unshifted characters-");
                    break;
                }
                case 59348: {
                    line.append("  % -\t-shifted characters-");
                    break;
                }
                case 59516: {
                    line.append("  % -\tGo to Next Line");
                    break;
                }
                case 59537: {
                    line.append("  % -\tOutput ");
                    break;
                }
                case 59553: {
                    line.append("  % -\tCheck Line Decrement");
                    break;
                }
                case 59571: {
                    line.append("  % -\tCheck Line Increment");
                    break;
                }
                case 59595: {
                    line.append("  % -\tSet Colour Code");
                    break;
                }
                case 59610: {
                    line.append("  % -\tColour Code Table");
                    break;
                }
                case 59626: {
                    line.append("  % -\tScroll Screen");
                    break;
                }
                case 59749: {
                    line.append("  % -\tOpen A Space On The Screen");
                    break;
                }
                case 59848: {
                    line.append("  % -\tMove A Screen Line");
                    break;
                }
                case 59872: {
                    line.append("  % -\tSyncronise Colour Transfer");
                    break;
                }
                case 59888: {
                    line.append("  % -\tSet Start of Line");
                    break;
                }
                case 59903: {
                    line.append("  % -\tClear Screen Line");
                    break;
                }
                case 59923: {
                    line.append("  % -\tPrint To Screen");
                    break;
                }
                case 59940: {
                    line.append("  % -\tSyncronise Colour Pointer");
                    break;
                }
                case 59953: {
                    line.append("  % -\tMain IRQ Entry Point");
                    break;
                }
                case 60039: {
                    line.append("  % scnkey\tScan Keyboard");
                    break;
                }
                case 60125: {
                    line.append("  % -\tProcess Key Image");
                    break;
                }
                case 60281: {
                    line.append("  % -\tPointers to Keyboard decoding tables\tWORD");
                    break;
                }
                case 60289: {
                    line.append("  % -\tKeyboard 1 -- unshifted\t\t\tDATA");
                    break;
                }
                case 60354: {
                    line.append("  % -\tKeyboard 2 -- Shifted\t\t\tDATA");
                    break;
                }
                case 60419: {
                    line.append("  % -\tKeyboard 3 -- Commodore\t\t\tDATA");
                    break;
                }
                case 60484: {
                    line.append("  % -\tGraphics/Text Control");
                    break;
                }
                case 60536: {
                    line.append("  % -\tKeyboard 4 -- Control\t\t\tDATA");
                    break;
                }
                case 60601: {
                    line.append("  % -\tVideo Chip Setup Table\t\t\tDATA");
                    break;
                }
                case 60647: {
                    line.append("  % -\tShift-Run Equivalent");
                    break;
                }
                case 60656: {
                    line.append("  % -\tLow Byte Screen Line Addresses\t\tDATA");
                    break;
                }
                case 60681: {
                    line.append("  % talk\tSend TALK Command on Serial Bus");
                    break;
                }
                case 60684: {
                    line.append("  % listn\tSend LISTEN Command on Serial Bus");
                    break;
                }
                case 60736: {
                    line.append("  % -\tSend Data On Serial Bus");
                    break;
                }
                case 60845: {
                    line.append("  % -\tFlag Errors");
                    break;
                }
                case 63239: {
                    line.append("  % -\tStatus #80 - device not present");
                    break;
                }
                case 60848: {
                    line.append("  % -\tStatus #03 - write timeout");
                    break;
                }
                case 60857: {
                    line.append("  % second\tSend LISTEN Secondary Address");
                    break;
                }
                case 60862: {
                    line.append("  % -\tClear ATN");
                    break;
                }
                case 60871: {
                    line.append("  % tksa\tSend TALK Secondary Address");
                    break;
                }
                case 60876: {
                    line.append("  % -\tWait For Clock");
                    break;
                }
                case 60893: {
                    line.append("  % ciout\tSend Serial Deferred");
                    break;
                }
                case 60911: {
                    line.append("  % untlk\tSend UNTALK / UNLISTEN");
                    break;
                }
                case 60947: {
                    line.append("  % acptr\tReceive From Serial Bus");
                    break;
                }
                case 61061: {
                    line.append("  % -\tSerial Clock On");
                    break;
                }
                case 61070: {
                    line.append("  % -\tSerial Clock Off");
                    break;
                }
                case 61079: {
                    line.append("  % -\tSerial Output 1");
                    break;
                }
                case 61088: {
                    line.append("  % -\tSerial Output 0");
                    break;
                }
                case 61097: {
                    line.append("  % -\tGet Serial Data And Clock In");
                    break;
                }
                case 61107: {
                    line.append("  % -\tDelay 1 ms");
                    break;
                }
                case 61115: {
                    line.append("  % -\tRS-232 Send");
                    break;
                }
                case 61190: {
                    line.append("  % -\tSend New RS-232 Byte");
                    break;
                }
                case 61230: {
                    line.append("  % -\t'No DSR' / 'No CTS' Error");
                    break;
                }
                case 61241: {
                    line.append("  % -\tDisable Timer");
                    break;
                }
                case 61258: {
                    line.append("  % -\tCompute Bit Count");
                    break;
                }
                case 61273: {
                    line.append("  % -\tRS-232 Receive");
                    break;
                }
                case 61310: {
                    line.append("  % -\tSet Up To Receive");
                    break;
                }
                case 61328: {
                    line.append("  % -\tProcess RS-232 Byte");
                    break;
                }
                case 61409: {
                    line.append("  % -\tSubmit to RS-232");
                    break;
                }
                case 61453: {
                    line.append("  % -\tNo DSR (Data Set Ready) Error");
                    break;
                }
                case 61463: {
                    line.append("  % -\tSend to RS-232 Buffer");
                    break;
                }
                case 61517: {
                    line.append("  % -\tInput From RS-232");
                    break;
                }
                case 61574: {
                    line.append("  % -\tGet From RS-232");
                    break;
                }
                case 61604: {
                    line.append("  % -\tSerial Bus Idle");
                    break;
                }
                case 61629: {
                    line.append("  % -\tTable of Kernal I/O Messages\t\tDATA");
                    break;
                }
                case 61739: {
                    line.append("  % -\tPrint Message if Direct");
                    break;
                }
                case 61743: {
                    line.append("  % -\tPrint Message");
                    break;
                }
                case 61758: {
                    line.append("  % getin\tGet a byte");
                    break;
                }
                case 61783: {
                    line.append("  % chrin\tInput a byte");
                    break;
                }
                case 61849: {
                    line.append("  % -\tGet From Tape / Serial / RS-232");
                    break;
                }
                case 61898: {
                    line.append("  % chrout\tOutput One Character");
                    break;
                }
                case 61966: {
                    line.append("  % chkin\tSet Input Device");
                    break;
                }
                case 62032: {
                    line.append("  % chkout\tSet Output Device");
                    break;
                }
                case 62097: {
                    line.append("  % close\tClose File");
                    break;
                }
                case 62223: {
                    line.append("  % -\tFind File");
                    break;
                }
                case 62239: {
                    line.append("  % -\tSet File values");
                    break;
                }
                case 62255: {
                    line.append("  % clall\tAbort All Files");
                    break;
                }
                case 62259: {
                    line.append("  % clrchn\tRestore Default I/O");
                    break;
                }
                case 62282: {
                    line.append("  % open\tOpen File");
                    break;
                }
                case 62421: {
                    line.append("  % -\tSend Secondary Address");
                    break;
                }
                case 62473: {
                    line.append("  % -\tOpen RS-232");
                    break;
                }
                case 62622: {
                    line.append("  % load\tLoad RAM");
                    break;
                }
                case 62648: {
                    line.append("  % -\tLoad File From Serial Bus");
                    break;
                }
                case 62771: {
                    line.append("  % -\tLoad File From Tape");
                    break;
                }
                case 62895: {
                    line.append("  % -\tPrint 'SEARCHING'");
                    break;
                }
                case 62913: {
                    line.append("  % -\tPrint Filename");
                    break;
                }
                case 62930: {
                    line.append("  % -\tPrint 'LOADING / VERIFYING'");
                    break;
                }
                case 62941: {
                    line.append("  % save\tSave RAM");
                    break;
                }
                case 62970: {
                    line.append("  % -\tSave to Serial Bus");
                    break;
                }
                case 63065: {
                    line.append("  % -\tSave to Tape");
                    break;
                }
                case 63119: {
                    line.append("  % -\tPrint 'SAVING'");
                    break;
                }
                case 63131: {
                    line.append("  % udtim\tBump Clock");
                    break;
                }
                case 63197: {
                    line.append("  % rdtim\tGet Time");
                    break;
                }
                case 63204: {
                    line.append("  % settim\tSet Time");
                    break;
                }
                case 63213: {
                    line.append("  % stop\tCheck STOP Key");
                    break;
                }
                case 63227: {
                    line.append("  % -\t'too many files'");
                    break;
                }
                case 63230: {
                    line.append("  % -\t'file open'");
                    break;
                }
                case 63233: {
                    line.append("  % -\t'file not open'");
                    break;
                }
                case 63236: {
                    line.append("  % -\t'file not found'");
                    break;
                }
                case 63242: {
                    line.append("  % -\t'not input file'");
                    break;
                }
                case 63245: {
                    line.append("  % -\t'not output file'");
                    break;
                }
                case 63248: {
                    line.append("  % -\t'missing filename'");
                    break;
                }
                case 63251: {
                    line.append("  % -\t'illegal device number'");
                    break;
                }
                case 63277: {
                    line.append("  % -\tFind Any Tape Header");
                    break;
                }
                case 63338: {
                    line.append("  % -\tWrite Tape Header");
                    break;
                }
                case 63440: {
                    line.append("  % -\tGet Buffer Address");
                    break;
                }
                case 63447: {
                    line.append("  % -\tSet Buffer Stat / End Pointers");
                    break;
                }
                case 63466: {
                    line.append("  % -\tFind Specific Tape Header");
                    break;
                }
                case 63501: {
                    line.append("  % -\tBump Tape Pointer");
                    break;
                }
                case 63511: {
                    line.append("  % -\tPrint 'PRESS PLAY ON TAPE'");
                    break;
                }
                case 63534: {
                    line.append("  % -\tCheck Tape Status");
                    break;
                }
                case 63544: {
                    line.append("  % -\tPrint 'PRESS RECORD...'");
                    break;
                }
                case 63553: {
                    line.append("  % -\tInitiate Tape Read");
                    break;
                }
                case 63588: {
                    line.append("  % -\tInitiate Tape Write");
                    break;
                }
                case 63605: {
                    line.append("  % -\tCommon Tape Code");
                    break;
                }
                case 63696: {
                    line.append("  % -\tCheck Tape Stop");
                    break;
                }
                case 63714: {
                    line.append("  % -\tSet Read Timing");
                    break;
                }
                case 63788: {
                    line.append("  % -\tRead Tape Bits");
                    break;
                }
                case 64096: {
                    line.append("  % -\tStore Tape Characters");
                    break;
                }
                case 64398: {
                    line.append("  % -\tReset Tape Pointer");
                    break;
                }
                case 64407: {
                    line.append("  % -\tNew Character Setup");
                    break;
                }
                case 64422: {
                    line.append("  % -\tSend Tone to Tape");
                    break;
                }
                case 64456: {
                    line.append("  % -\tWrite Data to Tape");
                    break;
                }
                case 64461: {
                    line.append("  % -\tIRQ Entry Point");
                    break;
                }
                case 64599: {
                    line.append("  % -\tWrite Tape Leader");
                    break;
                }
                case 64659: {
                    line.append("  % -\tRestore Normal IRQ");
                    break;
                }
                case 64696: {
                    line.append("  % -\tSet IRQ Vector");
                    break;
                }
                case 64714: {
                    line.append("  % -\tKill Tape Motor");
                    break;
                }
                case 64721: {
                    line.append("  % -\tCheck Read / Write Pointer");
                    break;
                }
                case 64731: {
                    line.append("  % -\tBump Read / Write Pointer");
                    break;
                }
                case 64738: {
                    line.append("  % -\tPower-Up RESET Entry");
                    break;
                }
                case 64770: {
                    line.append("  % -\tCheck For 8-ROM");
                    break;
                }
                case 64786: {
                    line.append("  % -\t8-ROM Mask '80CBM'\t\t\tDATA");
                    break;
                }
                case 64789: {
                    line.append("  % restor\tRestore Kernal Vectors (at 0314)");
                    break;
                }
                case 64794: {
                    line.append("  % vector\tChange Vectors For User");
                    break;
                }
                case 64816: {
                    line.append("  % -\tKernal Reset Vectors\t\t\tWORD");
                    break;
                }
                case 64848: {
                    line.append("  % ramtas\tInitialise System Constants");
                    break;
                }
                case 64923: {
                    line.append("  % -\tIRQ Vectors For Tape I/O\t\tWORD");
                    break;
                }
                case 64931: {
                    line.append("  % ioinit\tInitialise I/O");
                    break;
                }
                case 64989: {
                    line.append("  % -\tEnable Timer");
                    break;
                }
                case 65017: {
                    line.append("  % setnam\tSet Filename");
                    break;
                }
                case 65024: {
                    line.append("  % setlfs\tSet Logical File Parameters");
                    break;
                }
                case 65031: {
                    line.append("  % readst\tGet I/O Status Word");
                    break;
                }
                case 65048: {
                    line.append("  % setmsg\tControl OS Messages");
                    break;
                }
                case 65057: {
                    line.append("  % settmo\tSet IEEE Timeout");
                    break;
                }
                case 65061: {
                    line.append("  % memtop\tRead / Set Top of Memory");
                    break;
                }
                case 65076: {
                    line.append("  % membot\tRead / Set Bottom of Memory");
                    break;
                }
                case 65091: {
                    line.append("  % -\tNMI Transfer Entry");
                    break;
                }
                case 65126: {
                    line.append("  % -\tWarm Start Basic [BRK]");
                    break;
                }
                case 65212: {
                    line.append("  % -\tExit Interrupt");
                    break;
                }
                case 65218: {
                    line.append("  % -\tRS-232 Timing Table - NTSC\tDATA");
                    break;
                }
                case 65238: {
                    line.append("  % -\tNMI RS-232 In");
                    break;
                }
                case 65287: {
                    line.append("  % -\tNMI RS-232 Out");
                    break;
                }
                case 65347: {
                    line.append("  % -\tFake IRQ Entry");
                    break;
                }
                case 65352: {
                    line.append("  % -\tIRQ Entry");
                    break;
                }
                case 65371: {
                    line.append("  % cint\tInitialize screen editor");
                    break;
                }
                case 65408: {
                    line.append("  % -\tKernal Version Number [03]\tDATA");
                    break;
                }
                case 65409: {
                    line.append("  % cint\t\tInit Editor & Video Chips");
                    break;
                }
                case 65412: {
                    line.append("  % ioinit\t\tInit I/O Devices, Ports & Timers");
                    break;
                }
                case 65415: {
                    line.append("  % ramtas\t\tInit Ram & Buffers");
                    break;
                }
                case 65418: {
                    line.append("  % restor\t\tRestore Vectors");
                    break;
                }
                case 65421: {
                    line.append("  % vector\t\tChange Vectors For User");
                    break;
                }
                case 65424: {
                    line.append("  % setmsg\t\tControl OS Messages");
                    break;
                }
                case 65427: {
                    line.append("  % secnd\t\tSend SA After Listen");
                    break;
                }
                case 65430: {
                    line.append("  % tksa\t\tSend SA After Talk");
                    break;
                }
                case 65433: {
                    line.append("  % memtop\t\tSet/Read System RAM Top");
                    break;
                }
                case 65436: {
                    line.append("  % membot\t\tSet/Read System RAM Bottom");
                    break;
                }
                case 65439: {
                    line.append("  % scnkey\t\tScan Keyboard");
                    break;
                }
                case 65442: {
                    line.append("  % settmo\t\tSet Timeout In IEEE");
                    break;
                }
                case 65445: {
                    line.append("  % acptr\t\tHandshake Serial Byte In");
                    break;
                }
                case 65448: {
                    line.append("  % ciout\t\tHandshake Serial Byte Out");
                    break;
                }
                case 65451: {
                    line.append("  % untalk\t\tCommand Serial Bus UNTALK");
                    break;
                }
                case 65454: {
                    line.append("  % unlsn\t\tCommand Serial Bus UNLISTEN");
                    break;
                }
                case 65457: {
                    line.append("  % listn\t\tCommand Serial Bus LISTEN");
                    break;
                }
                case 65460: {
                    line.append("  % talk\t\tCommand Serial Bus TALK");
                    break;
                }
                case 65463: {
                    line.append("  % readss\t\tRead I/O Status Word");
                    break;
                }
                case 65466: {
                    line.append("  % setlfs\t\tSet Logical File Parameters");
                    break;
                }
                case 65469: {
                    line.append("  % setnam\t\tSet Filename");
                    break;
                }
                case 65472: {
                    line.append("  % (iopen)\t\tOpen Vector [f34a]");
                    break;
                }
                case 65475: {
                    line.append("  % (iclose)   \tClose Vector [f291]");
                    break;
                }
                case 65478: {
                    line.append("  % (ichkin)   \tSet Input [f20e]");
                    break;
                }
                case 65481: {
                    line.append("  % (ichkout)\tSet Output [f250]");
                    break;
                }
                case 65484: {
                    line.append("  % (iclrch)\tRestore I/O Vector [f333]");
                    break;
                }
                case 65487: {
                    line.append("  % (ichrin)\tInput Vector, chrin [f157]");
                    break;
                }
                case 65490: {
                    line.append("  % (ichrout)\tOutput Vector, chrout [f1ca]");
                    break;
                }
                case 65493: {
                    line.append("  % load\t\tLoad RAM From Device");
                    break;
                }
                case 65496: {
                    line.append("  % save\t\tSave RAM To Device");
                    break;
                }
                case 65499: {
                    line.append("  % settim\t\tSet Real-Time Clock");
                    break;
                }
                case 65502: {
                    line.append("  % rdtim\t\tRead Real-Time Clock");
                    break;
                }
                case 65505: {
                    line.append("  % (istop)\t\tTest-Stop Vector [f6ed]");
                    break;
                }
                case 65508: {
                    line.append("  % (igetin)\tGet From Keyboad [f13e]");
                    break;
                }
                case 65511: {
                    line.append("  % (iclall)\tClose All Channels And Files [f32f]");
                    break;
                }
                case 65514: {
                    line.append("  % udtim\t\tIncrement Real-Time Clock");
                    break;
                }
                case 65517: {
                    line.append("  % screen\t\tReturn Screen Organization");
                    break;
                }
                case 65520: {
                    line.append("  % plot\t\tRead / Set Cursor X/Y Position");
                    break;
                }
                case 65523: {
                    line.append("  % iobase\t\tReturn I/O Base Address");
                    break;
                }
                case 65526: {
                    line.append("  % - [5252]");
                    break;
                }
                case 65528: {
                    line.append("  % SYSTEM [5942]");
                    break;
                }
                case 65530: {
                    line.append("  % NMI [fe43]");
                    break;
                }
                case 65532: {
                    line.append("  % RESET [fce2]");
                    break;
                }
                case 65534: {
                    line.append("  % IRQ [ff48]");
                    break;
                }
                case 48589: {
                    line.append("  % Print number from AX");
                }
            }
        }
    }

    @Override
    public void setEnabled(boolean b) {
        this.DEBUG = b;
    }

    @Override
    public void setLevel(int level) {
        this.level = level;
    }

    @Override
    public int getLevel() {
        return this.level;
    }
}

