/*
 * Decompiled with CFR 0.152.
 */
package com.dreamfabric.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class DCheckBox
extends JComponent {
    private static final long serialVersionUID = -8566093291874184047L;
    private static final RenderingHints AALIAS = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    private static final Dimension MIN_SIZE = new Dimension(14, 14);
    private static final Color DEFAULT_FOCUS_COLOR = new Color(0x8080FF);
    private static final Color COLOR_LIGHT = new Color(224, 224, 224, 96);
    private static final Color COLOR_SELECTED = new Color(240, 64, 64, 128);
    private static final Color COLOR_SELECTED_LIGHT = new Color(255, 96, 96, 160);
    private Color focusColor;
    private ChangeEvent changeEvent = null;
    private EventListenerList listenerList = new EventListenerList();
    private boolean selected = false;

    public DCheckBox() {
        this.setFocusable(true);
        this.focusColor = DEFAULT_FOCUS_COLOR;
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                DCheckBox.this.repaint();
            }

            @Override
            public void focusLost(FocusEvent e) {
                DCheckBox.this.repaint();
            }
        });
        this.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                int k = e.getKeyCode();
                if (k == 32) {
                    DCheckBox.this.selected = !DCheckBox.this.selected;
                    DCheckBox.this.repaint();
                    DCheckBox.this.fireChangeEvent();
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                DCheckBox.this.requestFocus();
                if (me.getX() < 14 && me.getY() < 14) {
                    DCheckBox.this.selected = !DCheckBox.this.selected;
                    DCheckBox.this.fireChangeEvent();
                }
                DCheckBox.this.repaint();
            }

            @Override
            public void mouseClicked(MouseEvent me) {
            }
        });
        this.setPreferredSize(MIN_SIZE);
    }

    public void setSelected(boolean sel) {
        if (this.selected != sel) {
            this.selected = sel;
            this.repaint();
        }
    }

    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public void paint(Graphics g) {
        if (g instanceof Graphics2D) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setBackground(this.getParent().getBackground());
            g2d.addRenderingHints(AALIAS);
            g2d.translate(1, 1);
            this.drawCheckBox(g2d);
        }
    }

    void drawCheckBox(Graphics2D g2d) {
        if (this.hasFocus()) {
            g2d.setColor(this.focusColor);
            g2d.fillOval(0, 0, 12, 12);
        }
        g2d.setColor(Color.black);
        g2d.fillOval(2, 2, 8, 8);
        if (this.selected) {
            g2d.setColor(COLOR_SELECTED);
            g2d.fillOval(1, 1, 10, 10);
            g2d.setColor(COLOR_SELECTED_LIGHT);
            g2d.fillOval(3, 3, 6, 6);
        }
        g2d.setColor(COLOR_LIGHT);
        g2d.fillOval(3, 3, 5, 5);
        g2d.fillOval(4, 4, 2, 2);
    }

    public void addChangeListener(ChangeListener cl) {
        this.listenerList.add(ChangeListener.class, cl);
    }

    public void removeChangeListener(ChangeListener cl) {
        this.listenerList.remove(ChangeListener.class, cl);
    }

    protected void fireChangeEvent() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)listeners[i + 1]).stateChanged(this.changeEvent);
        }
    }
}

