/*
 * Decompiled with CFR 0.152.
 */
package com.dreamfabric.jac64;

import com.dreamfabric.jac64.AudioDriver;
import com.dreamfabric.jac64.AudioDriverSE;
import com.dreamfabric.jac64.C1541Chips;
import com.dreamfabric.jac64.C64Canvas;
import com.dreamfabric.jac64.CIA;
import com.dreamfabric.jac64.CPU;
import com.dreamfabric.jac64.ExtChip;
import com.dreamfabric.jac64.IMonitor;
import com.dreamfabric.jac64.Keyboard;
import com.dreamfabric.jac64.Observer;
import com.dreamfabric.jac64.RESIDChip;
import com.dreamfabric.jac64.SIDChip;
import com.dreamfabric.jac64.TFE_CS8900;
import com.dreamfabric.jac64.VICConstants;
import java.applet.AudioClip;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.awt.image.MemoryImageSource;
import javax.swing.JPanel;

public class C64Screen
extends ExtChip
implements Observer,
MouseListener,
MouseMotionListener {
    public static final String version = "1.11";
    public static final int SERIAL_ATN = 8;
    public static final int SERIAL_CLK_OUT = 16;
    public static final int SERIAL_DATA_OUT = 32;
    public static final int SERIAL_CLK_IN = 64;
    public static final int SERIAL_DATA_IN = 128;
    public static final int RESID_6581 = 1;
    public static final int RESID_8580 = 2;
    public static final int JACSID = 3;
    public static final boolean IRQDEBUG = false;
    public static final boolean SPRITEDEBUG = false;
    public static final boolean IODEBUG = false;
    public static final boolean VIC_MEM_DEBUG = false;
    public static final boolean BAD_LINE_DEBUG = false;
    public static final boolean STATE_DEBUG = false;
    public static final boolean DEBUG_IEC = false;
    public static final boolean DEBUG_CYCLES = false;
    public static final int IO_UPDATE = 37;
    private static final int VIC_IRQ = 1;
    public static final int CYCLES_PER_LINE = 63;
    public static final int IO_OFFSET = 12288;
    public static final boolean SOUND_AVAIABLE = true;
    public static final Color TRANSPARENT_BLACK = new Color(0, 0, 64, 64);
    public static final Color DARKER_0 = new Color(0, 0, 64, 32);
    public static final Color LIGHTER_0 = new Color(224, 224, 255, 48);
    public static final Color DARKER_N = new Color(0, 0, 64, 112);
    public static final Color LIGHTER_N = new Color(224, 224, 255, 160);
    public static final Color LED_ON = new Color(96, 223, 96, 192);
    public static final Color LED_OFF = new Color(32, 96, 32, 192);
    public static final Color LED_BORDER = new Color(64, 96, 64, 160);
    public static final int LABEL_COUNT = 32;
    private Color[] darks = new Color[32];
    private Color[] lites = new Color[32];
    private int colIndex = 0;
    private static final int SC_WIDTH = 384;
    private static final int SC_HEIGHT = 284;
    private final int SC_XOFFS = 32;
    private final int SC_SPXOFFS = 8;
    private final int FIRST_VISIBLE_VBEAM = 15;
    private final int SC_SPYOFFS = 16;
    private IMonitor monitor;
    private int targetScanTime = 20000;
    private int actualScanTime = 20000;
    private long lastScan = 0L;
    private long nextIOUpdate = 0L;
    private boolean DOUBLE = false;
    private int reset = 100;
    private C64Canvas canvas;
    private int[] memory;
    private Keyboard keyboard;
    ExtChip sidChip;
    CIA[] cia;
    C1541Chips c1541Chips;
    TFE_CS8900 tfe;
    int iecLines = 0;
    int cia2PRA = 0;
    int cia2DDRA = 0;
    AudioClip trackSound = null;
    AudioClip motorSound = null;
    private int lastTrack = 0;
    private int lastSector = 0;
    private boolean ledOn = false;
    private boolean motorOn = false;
    boolean emulateDisk = false;
    private int[] cbmcolor = VICConstants.COLOR_SETS[0];
    public int vicBank;
    public int charSet;
    public int videoMatrix;
    public int videoMode;
    int irqMask = 0;
    int irqFlags = 0;
    int control1 = 0;
    int control2 = 0;
    int sprXMSB = 0;
    int sprEN = 0;
    int sprYEX = 0;
    int sprXEX = 0;
    int sprPri = 0;
    int sprMul = 0;
    int sprCol = 0;
    int sprBgCol = 0;
    int sprMC0 = 0;
    int sprMC1 = 0;
    int vicMem = 0;
    int vicMemDDRA = 0;
    int vicMemDATA = 0;
    public int vbeam = 0;
    public int raster = 0;
    int bCol = 0;
    int[] bgCol = new int[4];
    private int vicBase = 0;
    private boolean badLine = false;
    private int spr0BlockSel;
    int vc = 0;
    int vcBase = 0;
    int rc = 0;
    int vmli = 0;
    int vPos = 0;
    int mpos = 0;
    int displayWidth = 384;
    int displayHeight = 284;
    int offsetX = 0;
    int offsetY = 0;
    boolean gfxVisible = false;
    boolean paintBorder = false;
    boolean paintSideBorder = false;
    int borderColor = this.cbmcolor[0];
    int bgColor = this.cbmcolor[1];
    private boolean extended = false;
    private boolean multiCol = false;
    private boolean blankRow = false;
    private boolean hideColumn = false;
    int[] multiColor = new int[4];
    int[] collissionMask = new int[432];
    Sprite[] sprites = new Sprite[8];
    private Color[] colors = null;
    private int horizScroll = 0;
    private int vScroll = 0;
    private Image image;
    private Graphics g2;
    private int charMemoryIndex = 0;
    private int[] vicCharCache = new int[40];
    private int[] vicColCache = new int[40];
    public Image screen = null;
    private MemoryImageSource mis = null;
    private AudioDriver audioDriver;
    int[] mem = new int[112896];
    int rnd = 754;
    String message;
    String tmsg = "";
    int frame = 0;
    private boolean updating = false;
    boolean displayEnabled = true;
    boolean irqTriggered = false;
    long lastLine = 0L;
    long firstLine = 0L;
    long lastIRQ = 0L;
    int potx = 0;
    int poty = 0;
    boolean button1 = false;
    boolean button2 = false;
    private static final int[] IO_ADDRAND = new int[]{53311, 53311, 53311, 53311, 54303, 54303, 54303, 54303, 55551, 55807, 56063, 56319, 56335, 56591, 57087, 57343};
    private int borderState = 0;
    private boolean notVisible = false;
    private int xPos = 0;
    private long lastCycle = 0L;
    public static final int IMG_TOTWIDTH = 384;
    public static final int IMG_TOTHEIGHT = 284;
    public Image crtImage;
    long repaint = 0L;

    public C64Screen(IMonitor m, boolean dob) {
        this.monitor = m;
        this.DOUBLE = dob;
        this.setScanRate(50.0);
        this.makeColors(this.darks, DARKER_0, DARKER_N);
        this.makeColors(this.lites, LIGHTER_0, LIGHTER_N);
    }

    public void setAutoscale(boolean val) {
        this.DOUBLE = val;
        this.canvas.setAutoscale(val);
    }

    private void makeColors(Color[] colors, Color c1, Color c2) {
        int a0 = c1.getAlpha();
        int r0 = c1.getRed();
        int g0 = c1.getGreen();
        int b0 = c1.getBlue();
        int an = c2.getAlpha();
        int rn = c2.getRed();
        int gn = c2.getGreen();
        int bn = c2.getBlue();
        int lc = 16;
        int n = lc;
        for (int i = 0; i < n; ++i) {
            Color color = new Color(((lc - i) * r0 + i * rn) / lc, ((lc - i) * g0 + i * gn) / lc, ((lc - i) * b0 + i * bn) / lc, ((lc - i) * a0 + i * an) / lc);
            colors[32 - i - 1] = color;
            colors[i] = color;
        }
    }

    public void setColorSet(int c) {
        if (c >= 0 && c < VICConstants.COLOR_SETS.length) {
            this.cbmcolor = VICConstants.COLOR_SETS[c];
            this.borderColor = this.cbmcolor[this.bCol];
            this.bgColor = this.cbmcolor[this.bgCol[0]];
            int n = 8;
            for (int i = 0; i < n; ++i) {
                this.sprites[i].color[0] = this.bgColor;
                this.sprites[i].color[1] = this.cbmcolor[this.sprMC0];
                this.sprites[i].color[3] = this.cbmcolor[this.sprMC1];
            }
        }
    }

    public CIA[] getCIAs() {
        return this.cia;
    }

    public void setSID(int sid) {
        switch (sid) {
            case 1: 
            case 2: {
                if (!(this.sidChip instanceof RESIDChip)) {
                    if (this.sidChip != null) {
                        this.sidChip.stop();
                    }
                    this.sidChip = new RESIDChip(this.cpu, this.audioDriver);
                }
                ((RESIDChip)this.sidChip).setChipVersion(sid);
                break;
            }
            case 3: {
                if (this.sidChip instanceof SIDChip) break;
                if (this.sidChip != null) {
                    this.sidChip.stop();
                }
                this.sidChip = new SIDChip(this.cpu, this.audioDriver);
            }
        }
    }

    public void setScanRate(double hertz) {
        this.targetScanTime = (int)(1000000.0 / hertz);
        float diff = 0.9692308f;
    }

    public int getScanRate() {
        return 1000000 / this.targetScanTime;
    }

    public int getActualScanRate() {
        return 1000000 / this.actualScanTime;
    }

    public void setIntegerScaling(boolean yes) {
        this.canvas.setIntegerScaling(yes);
    }

    public JPanel getScreen() {
        return this.canvas;
    }

    public AudioDriver getAudioDriver() {
        return this.audioDriver;
    }

    public boolean ready() {
        return this.keyboard.ready;
    }

    public void setDisplayFactor(double f) {
        this.displayWidth = (int)(384.0 * f);
        this.displayHeight = (int)(284.0 * f);
        this.crtImage = null;
    }

    public void setDisplayOffset(int x, int y) {
        this.offsetX = x;
        this.offsetY = y;
    }

    public void dumpGfxStat() {
        this.monitor.info("Char MemoryIndex: 0x" + Integer.toString(this.charMemoryIndex, 16));
        this.monitor.info("CharSet adr: 0x" + Integer.toString(this.charSet, 16));
        this.monitor.info("VideoMode: " + this.videoMode);
        this.monitor.info("Vic Bank: 0x" + Integer.toString(this.vicBank, 16));
        this.monitor.info("Video Matrix: 0x" + Integer.toString(this.videoMatrix, 16));
        this.monitor.info("Text: extended = " + this.extended + " multicol = " + this.multiCol);
        this.monitor.info("24 Rows on? " + ((this.control1 & 8) == 0 ? "yes" : "no"));
        this.monitor.info("YScroll = " + (this.control1 & 7));
        this.monitor.info("$d011 = " + this.control1);
        this.monitor.info("IRQ Latch: " + Integer.toString(this.irqFlags, 16));
        this.monitor.info("IRQ  Mask: " + Integer.toString(this.irqMask, 16));
        this.monitor.info("IRQ RPos : " + this.raster);
        int n = 8;
        for (int i = 0; i < n; ++i) {
            this.monitor.info("Sprite " + (i + 1) + " pos = " + this.sprites[i].x + ", " + this.sprites[i].y);
        }
        this.monitor.info("IRQFlags: " + this.getIRQFlags());
        this.monitor.info("NMIFlags: " + this.getNMIFlags());
        this.monitor.info("CPU IRQLow: " + this.cpu.getIRQLow());
        this.monitor.info("CPU NMILow: " + this.cpu.NMILow);
        this.monitor.info("Current CPU cycles: " + this.cpu.cycles);
        this.monitor.info("Next IO update: " + this.nextIOUpdate);
    }

    public void setSoundOn(boolean on) {
        this.audioDriver.setSoundOn(on);
    }

    public void setStick(boolean one) {
        this.keyboard.setStick(one);
    }

    public void registerHotKey(int key, int mod, String script, Object o) {
        this.keyboard.registerHotKey(key, mod, script, o);
    }

    public void setKeyboardEmulation(boolean extended) {
        this.monitor.info("Keyboard extended: " + extended);
        this.keyboard.stickExits = !extended;
        this.keyboard.extendedKeyboardEmulation = extended;
    }

    public void init(CPU cpu) {
        int i;
        super.init(cpu);
        this.memory = cpu.getMemory();
        this.c1541Chips = cpu.getDrive().chips;
        this.c1541Chips.initIEC2(this);
        this.c1541Chips = cpu.getDrive().chips;
        this.c1541Chips.setObserver(this);
        int n = this.sprites.length;
        for (i = 0; i < n; ++i) {
            this.sprites[i] = new Sprite();
            this.sprites[i].spriteNo = i;
        }
        this.cia = new CIA[2];
        this.cia[0] = new CIA(cpu, 68608, this);
        this.cia[1] = new CIA(cpu, 68864, this);
        this.tfe = new TFE_CS8900(69120);
        this.keyboard = new Keyboard(this, this.cia[0], this.memory);
        this.canvas = new C64Canvas(this, this.DOUBLE, this.keyboard);
        this.canvas.addMouseMotionListener(this);
        this.canvas.addMouseListener(this);
        this.audioDriver = new AudioDriverSE();
        this.audioDriver.init(44000, 22000);
        this.setSID(1);
        this.charMemoryIndex = 118784;
        for (i = 0; i < 109056; ++i) {
            this.mem[i] = this.cbmcolor[6];
        }
        this.mis = new MemoryImageSource(384, 284, this.mem, 0, 384);
        this.mis.setAnimated(true);
        this.mis.setFullBufferUpdates(true);
        this.screen = this.canvas.createImage(this.mis);
        this.initUpdate();
    }

    @Override
    public void update(Object src, Object data) {
        if (src != this.c1541Chips) {
            this.message = (String)data;
        } else {
            this.updateDisk(src, data);
        }
    }

    void restoreKey(boolean down) {
        if (down) {
            this.setNMI(1);
        } else {
            this.clearNMI(1);
        }
    }

    @Override
    public int performRead(int address, long cycles) {
        int pos = address >> 8 & 0xF;
        int val = 0;
        switch (address &= IO_ADDRAND[pos]) {
            case 53248: 
            case 53250: 
            case 53252: 
            case 53254: 
            case 53256: 
            case 53258: 
            case 53260: 
            case 53262: {
                return this.sprites[address - 53248 >> 1].x & 0xFF;
            }
            case 53249: 
            case 53251: 
            case 53253: 
            case 53255: 
            case 53257: 
            case 53259: 
            case 53261: 
            case 53263: {
                return this.sprites[address - 53248 >> 1].y;
            }
            case 53264: {
                return this.sprXMSB;
            }
            case 53265: {
                return this.control1 & 0x7F | (this.vbeam & 0x100) >> 1;
            }
            case 53266: {
                return this.vbeam & 0xFF;
            }
            case 53267: 
            case 53268: {
                return 0;
            }
            case 53269: {
                return this.sprEN;
            }
            case 53270: {
                return this.control2;
            }
            case 53271: {
                return this.sprYEX;
            }
            case 53272: {
                return this.vicMem;
            }
            case 53273: {
                return this.irqFlags;
            }
            case 53274: {
                return this.irqMask;
            }
            case 53275: {
                return this.sprPri;
            }
            case 53276: {
                return this.sprMul;
            }
            case 53277: {
                return this.sprXEX;
            }
            case 53278: {
                val = this.sprCol;
                this.sprCol = 0;
                return val;
            }
            case 53279: {
                val = this.sprBgCol;
                this.sprBgCol = 0;
                return val;
            }
            case 53280: {
                return this.bCol | 0xF0;
            }
            case 53281: 
            case 53282: 
            case 53283: 
            case 53284: {
                return this.bgCol[address - 53281] | 0xF0;
            }
            case 53285: {
                return this.sprMC0 | 0xF0;
            }
            case 53286: {
                return this.sprMC1 | 0xF0;
            }
            case 53287: 
            case 53288: 
            case 53289: 
            case 53290: 
            case 53291: 
            case 53292: 
            case 53293: 
            case 53294: {
                return this.sprites[address - 53287].col | 0xF0;
            }
            case 54299: 
            case 54300: {
                return this.sidChip.performRead(12288 + address, cycles);
            }
            case 54297: {
                return this.potx;
            }
            case 54298: {
                return this.poty;
            }
            case 56320: {
                return this.keyboard.readDC00(this.cpu.lastReadOP);
            }
            case 56321: {
                return this.keyboard.readDC01(this.cpu.lastReadOP);
            }
            case 56576: {
                val = (this.cia2PRA | ~this.cia2DDRA) & 0x3F | this.iecLines & this.c1541Chips.iecLines;
                return val &= 0xFF;
            }
        }
        if (pos == 4) {
            return this.sidChip.performRead(address + 12288, cycles);
        }
        if (pos == 13) {
            return this.cia[1].performRead(address + 12288, cycles);
        }
        if (pos == 12) {
            return this.cia[0].performRead(address + 12288, cycles);
        }
        if (pos == 14) {
            return this.tfe.performRead(address + 12288, cycles);
        }
        if (pos >= 8) {
            return this.memory[12288 + address] | 0xF0;
        }
        return 255;
    }

    @Override
    public void performWrite(int address, int data, long cycles) {
        int pos = address >> 8 & 0xF;
        this.memory[(address &= C64Screen.IO_ADDRAND[pos]) + 12288] = data;
        switch (address) {
            case 53248: 
            case 53250: 
            case 53252: 
            case 53254: 
            case 53256: 
            case 53258: 
            case 53260: 
            case 53262: {
                int sprite = address - 53248 >> 1;
                this.sprites[sprite].x &= 0x100;
                this.sprites[sprite].x += data;
                break;
            }
            case 53249: 
            case 53251: 
            case 53253: 
            case 53255: 
            case 53257: 
            case 53259: 
            case 53261: 
            case 53263: {
                this.sprites[address - 53248 >> 1].y = data;
                break;
            }
            case 53264: {
                this.sprXMSB = data;
                int i = 0;
                int m = 1;
                int n = 8;
                while (i < n) {
                    this.sprites[i].x &= 0xFF;
                    this.sprites[i].x = this.sprites[i].x | ((data & m) != 0 ? 256 : 0);
                    ++i;
                    m <<= 1;
                }
                break;
            }
            case 53265: {
                this.raster = this.raster & 0xFF | data << 1 & 0x100;
                this.control1 = data;
                if (this.vScroll != (data & 7)) {
                    this.vScroll = data & 7;
                    boolean oldBadLine = this.badLine;
                    this.badLine = this.displayEnabled && this.vbeam >= 48 && this.vbeam <= 247 && (this.vbeam & 7) == this.vScroll;
                }
                this.extended = (data & 0x40) != 0;
                this.blankRow = (data & 8) == 0;
                this.videoMode = (this.extended ? 2 : 0) | (this.multiCol ? 1 : 0) | ((data & 0x20) != 0 ? 4 : 0);
                break;
            }
            case 53266: {
                this.raster = this.raster & 0x100 | data;
                break;
            }
            case 53267: 
            case 53268: {
                break;
            }
            case 53269: {
                this.sprEN = data;
                int i = 0;
                int m = 1;
                int n = 8;
                while (i < n) {
                    this.sprites[i].enabled = (data & m) != 0;
                    ++i;
                    m <<= 1;
                }
                break;
            }
            case 53270: {
                this.control2 = data;
                this.horizScroll = data & 7;
                this.multiCol = (data & 0x10) != 0;
                this.hideColumn = (data & 8) == 0;
                this.videoMode = (this.extended ? 2 : 0) | (this.multiCol ? 1 : 0) | ((this.control1 & 0x20) != 0 ? 4 : 0);
                break;
            }
            case 53271: {
                this.sprYEX = data;
                int i = 0;
                int m = 1;
                int n = 8;
                while (i < n) {
                    this.sprites[i].expandY = (data & m) != 0;
                    ++i;
                    m <<= 1;
                }
                break;
            }
            case 53272: {
                this.vicMem = data;
                this.setVideoMem();
                break;
            }
            case 53273: {
                if ((data & 0x80) != 0) {
                    data = 255;
                }
                int latchval = 0xFF ^ data;
                this.irqFlags &= latchval;
                if ((this.irqMask & 0xF & this.irqFlags) != 0) break;
                this.clearIRQ(1);
                break;
            }
            case 53274: {
                this.irqMask = data;
                if ((this.irqMask & 0xF & this.irqFlags) != 0) {
                    this.irqFlags |= 0x80;
                    this.setIRQ(1);
                    break;
                }
                this.clearIRQ(1);
                break;
            }
            case 53275: {
                this.sprPri = data;
                int i = 0;
                int m = 1;
                int n = 8;
                while (i < n) {
                    this.sprites[i].priority = (data & m) != 0;
                    ++i;
                    m <<= 1;
                }
                break;
            }
            case 53276: {
                this.sprMul = data;
                int i = 0;
                int m = 1;
                int n = 8;
                while (i < n) {
                    this.sprites[i].multicolor = (data & m) != 0;
                    ++i;
                    m <<= 1;
                }
                break;
            }
            case 53277: {
                this.sprXEX = data;
                int i = 0;
                int m = 1;
                int n = 8;
                while (i < n) {
                    this.sprites[i].expandX = (data & m) != 0;
                    ++i;
                    m <<= 1;
                }
                break;
            }
            case 53280: {
                this.bCol = data & 0xF;
                this.borderColor = this.cbmcolor[this.bCol];
                break;
            }
            case 53281: {
                this.bgCol[0] = data & 0xF;
                this.bgColor = this.cbmcolor[this.bgCol[0]];
                int n = 8;
                for (int i = 0; i < n; ++i) {
                    this.sprites[i].color[0] = this.bgColor;
                }
                break;
            }
            case 53282: 
            case 53283: 
            case 53284: {
                this.bgCol[address - 53281] = data & 0xF;
                break;
            }
            case 53285: {
                this.sprMC0 = data & 0xF;
                int n = 8;
                for (int i = 0; i < n; ++i) {
                    this.sprites[i].color[1] = this.cbmcolor[this.sprMC0];
                }
                break;
            }
            case 53286: {
                this.sprMC1 = data & 0xF;
                int n = 8;
                for (int i = 0; i < n; ++i) {
                    this.sprites[i].color[3] = this.cbmcolor[this.sprMC1];
                }
                break;
            }
            case 53287: 
            case 53288: 
            case 53289: 
            case 53290: 
            case 53291: 
            case 53292: 
            case 53293: 
            case 53294: {
                this.sprites[address - 53287].color[2] = this.cbmcolor[data & 0xF];
                this.sprites[address - 53287].col = data & 0xF;
                break;
            }
            case 56320: 
            case 56321: 
            case 56322: 
            case 56323: {
                this.cia[0].performWrite(address + 12288, data, this.cpu.cycles);
                this.keyboard.updateKeyboard();
                break;
            }
            case 56576: {
                this.cia[1].performWrite(address + 12288, data, this.cpu.cycles);
                this.cia2PRA = data;
                data = ~this.cia2PRA & this.cia2DDRA;
                int oldLines = this.iecLines;
                this.iecLines = data << 2 & 0x80 | data << 2 & 0x40 | data << 1 & 0x10;
                if (((oldLines ^ this.iecLines) & 0x10) != 0) {
                    this.c1541Chips.atnChanged((this.iecLines & 0x10) == 0);
                }
                this.c1541Chips.updateIECLines();
                this.setVideoMem();
                break;
            }
            case 56578: {
                this.cia2DDRA = data;
                this.cia[1].performWrite(address + 12288, data, this.cpu.cycles);
                this.setVideoMem();
                break;
            }
            default: {
                if (pos == 4) {
                    this.sidChip.performWrite(address + 12288, data, cycles);
                    break;
                }
                if (pos == 13) {
                    this.cia[1].performWrite(address + 12288, data, cycles);
                    break;
                }
                if (pos == 12) {
                    this.cia[0].performWrite(address + 12288, data, cycles);
                    break;
                }
                if (pos != 14) break;
                this.tfe.performWrite(address + 12288, data, cycles);
            }
        }
    }

    private void printIECLines() {
        System.out.print("IEC/F: ");
        if ((this.iecLines & 0x10) == 0) {
            System.out.print("A1");
        } else {
            System.out.print("A0");
        }
        int sdata = (this.iecLines & 0x40) == 0 ? 1 : 0;
        System.out.print(" C" + sdata);
        sdata = (this.iecLines & 0x80) == 0 ? 1 : 0;
        System.out.print(" D" + sdata);
        sdata = (this.c1541Chips.iecLines & 0x40) == 0 ? 1 : 0;
        System.out.print(" c" + sdata);
        sdata = (this.c1541Chips.iecLines & 0x80) == 0 ? 1 : 0;
        System.out.print(" d" + sdata);
        System.out.println(" => C" + ((this.iecLines & this.c1541Chips.iecLines & 0x80) == 0 ? 1 : 0) + " D" + ((this.iecLines & this.c1541Chips.iecLines & 0x40) == 0 ? 1 : 0));
    }

    private void setVideoMem() {
        this.vicBank = (~(~this.cia2DDRA | this.cia2PRA) & 3) << 14;
        this.charSet = this.vicBank | (this.vicMem & 0xE) << 10;
        this.videoMatrix = this.vicBank | (this.vicMem & 0xF0) << 6;
        this.vicBase = this.vicBank | (this.vicMem & 8) << 10;
        this.spr0BlockSel = 1016 + this.videoMatrix;
        this.charMemoryIndex = (this.vicMem & 0xC) != 4 || (this.vicBank & 0x4000) == 16384 ? this.charSet : ((this.vicMem & 2) == 0 ? 0 : 2048) + 118784;
    }

    private void initUpdate() {
        int i;
        this.vc = 0;
        this.vcBase = 0;
        this.vmli = 0;
        this.updating = true;
        for (i = 0; i < 8; ++i) {
            this.sprites[i].nextByte = 0;
            this.sprites[i].painting = false;
            this.sprites[i].spriteReg = 0;
        }
        if (this.colors == null) {
            this.colors = new Color[16];
            for (i = 0; i < 16; ++i) {
                this.colors[i] = new Color(this.cbmcolor[i]);
            }
        }
        this.canvas.setBackground(this.colors[this.memory[65568] & 0xF]);
    }

    @Override
    public final void clock(long cycles) {
        if (this.lastCycle + 1L < cycles) {
            System.out.println("More than one cycle passed: " + (cycles - this.lastCycle) + " at " + cycles + " PC: " + Integer.toHexString(this.cpu.pc));
        }
        if (this.lastCycle == cycles) {
            System.out.println("No diff since last update!!!: " + (cycles - this.lastCycle) + " at " + cycles + " PC: " + Integer.toHexString(this.cpu.pc));
        }
        this.lastCycle = cycles;
        int vicCycle = (int)(cycles - this.lastLine);
        if (this.notVisible && vicCycle < 62) {
            return;
        }
        if (this.badLine) {
            this.gfxVisible = true;
        }
        switch (vicCycle) {
            case 0: {
                int irqComp;
                this.vbeam = (this.vbeam + 1) % 312;
                if (this.vbeam == 0) {
                    ++this.frame;
                }
                this.vPos = this.vbeam - 16;
                if (this.vbeam == 15) {
                    ++this.colIndex;
                    if (this.colIndex >= 32) {
                        this.colIndex = 0;
                    }
                    this.initUpdate();
                }
                if ((this.irqMask & 2) != 0 && this.sprBgCol != 0 && (this.irqFlags & 2) == 0) {
                    this.irqFlags |= 0x52;
                    this.setIRQ(1);
                }
                if ((this.irqMask & 4) != 0 && this.sprCol != 0 && (this.irqFlags & 4) == 0) {
                    this.irqFlags |= 0x54;
                    this.setIRQ(1);
                }
                if ((irqComp = this.raster) > 312) {
                    irqComp &= 0xFF;
                }
                if ((this.irqFlags & 1) == 0 && irqComp == this.vbeam) {
                    this.irqFlags |= 1;
                    if ((this.irqMask & 1) != 0) {
                        this.irqFlags |= 0x80;
                        this.irqTriggered = true;
                        this.setIRQ(1);
                        this.lastIRQ = this.cpu.cycles;
                    }
                } else {
                    this.irqTriggered = false;
                }
                this.notVisible = false;
                if (this.vPos < 0 || this.vPos >= 284) {
                    this.cpu.baLowUntil = 0L;
                    this.notVisible = true;
                    break;
                }
                if (this.vbeam == 48) {
                    boolean bl = this.displayEnabled = (this.control1 & 0x10) != 0;
                    this.borderState = this.displayEnabled ? (this.borderState &= 0xFFFFFFFB) : (this.borderState |= 4);
                }
                this.badLine = this.displayEnabled && this.vbeam >= 48 && this.vbeam <= 247 && (this.vbeam & 7) == this.vScroll;
                int n = 384;
                for (int i = 0; i < n; ++i) {
                    this.collissionMask[i] = 0;
                }
                break;
            }
            case 1: {
                if (this.sprites[3].dma) {
                    this.sprites[3].readSpriteData();
                }
                if (!this.sprites[5].dma) break;
                this.cpu.baLowUntil = this.lastLine + 6L;
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                if (this.sprites[4].dma) {
                    this.sprites[4].readSpriteData();
                }
                if (!this.sprites[6].dma) break;
                this.cpu.baLowUntil = this.lastLine + 8L;
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                if (this.sprites[5].dma) {
                    this.sprites[5].readSpriteData();
                }
                if (!this.sprites[7].dma) break;
                this.cpu.baLowUntil = this.lastLine + 10L;
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                if (!this.sprites[6].dma) break;
                this.sprites[6].readSpriteData();
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                int i;
                int n;
                if (this.sprites[7].dma) {
                    this.sprites[7].readSpriteData();
                }
                if (this.blankRow) {
                    if (this.vbeam == 247) {
                        this.borderState |= 1;
                    }
                } else {
                    if (this.vbeam == 251) {
                        this.borderState |= 1;
                    }
                    if (this.vbeam == 51) {
                        this.borderState &= 0xFE;
                        n = 7;
                        for (i = 0; i < n; ++i) {
                            if (this.sprites[i].painting) continue;
                            this.sprites[i].lineFinished = true;
                        }
                    }
                }
                if (this.vbeam != 55) break;
                this.borderState &= 0xFE;
                n = 7;
                for (i = 0; i < n; ++i) {
                    if (this.sprites[i].painting) continue;
                    this.sprites[i].lineFinished = true;
                }
                break;
            }
            case 10: {
                break;
            }
            case 11: {
                if (!this.badLine) break;
                this.cpu.baLowUntil = this.lastLine + 54L;
                break;
            }
            case 12: {
                this.mpos = this.vPos * 384;
                this.drawBackground();
                this.xPos = 16;
                this.mpos += 8;
                break;
            }
            case 13: {
                this.drawBackground();
                this.drawSprites();
                this.mpos += 8;
                this.vc = this.vcBase;
                this.vmli = 0;
                if (!this.badLine) break;
                this.cpu.baLowUntil = this.lastLine + 54L;
                this.rc = 0;
                break;
            }
            case 14: {
                this.drawBackground();
                this.drawSprites();
                this.mpos += 8;
                if (!this.badLine) break;
                this.cpu.baLowUntil = this.lastLine + 54L;
                break;
            }
            case 15: {
                this.drawBackground();
                this.drawSprites();
                this.mpos += 8;
                if (this.badLine) {
                    this.cpu.baLowUntil = this.lastLine + 54L;
                }
                int n = 8;
                for (int i = 0; i < n; ++i) {
                    if (this.sprites[i].nextByte != 63) continue;
                    this.sprites[i].dma = false;
                }
                break;
            }
            case 16: {
                if (!this.hideColumn) {
                    this.borderState &= 0xFD;
                }
                if (this.badLine) {
                    this.cpu.baLowUntil = this.lastLine + 54L;
                    this.vicCharCache[this.vmli] = this.memory[this.videoMatrix + (this.vcBase & 0x3FF)];
                    this.vicColCache[this.vmli] = this.memory[67584 + (this.vcBase & 0x3FF)];
                }
                this.drawGraphics(this.mpos + this.horizScroll);
                this.drawSprites();
                if (this.borderState != 0) {
                    this.drawBackground();
                }
                this.mpos += 8;
                break;
            }
            case 17: {
                if (this.hideColumn) {
                    this.borderState &= 0xFD;
                }
                if (this.badLine) {
                    this.cpu.baLowUntil = this.lastLine + 54L;
                    this.vicCharCache[this.vmli] = this.memory[this.videoMatrix + (this.vcBase + this.vmli & 0x3FF)];
                    this.vicColCache[this.vmli] = this.memory[67584 + (this.vcBase + this.vmli & 0x3FF)];
                }
                this.drawGraphics(this.mpos + this.horizScroll);
                this.drawSprites();
                this.mpos += 8;
                break;
            }
            default: {
                if (this.badLine) {
                    this.cpu.baLowUntil = this.lastLine + 54L;
                    this.vicCharCache[this.vmli] = this.memory[this.videoMatrix + (this.vcBase + this.vmli & 0x3FF)];
                    this.vicColCache[this.vmli] = this.memory[67584 + (this.vcBase + this.vmli & 0x3FF)];
                }
                this.drawGraphics(this.mpos + this.horizScroll);
                this.drawSprites();
                this.mpos += 8;
                break;
            }
            case 54: {
                if (this.badLine) {
                    this.cpu.baLowUntil = this.lastLine + 54L;
                    this.vicCharCache[this.vmli] = this.memory[this.videoMatrix + (this.vcBase + this.vmli & 0x3FF)];
                    this.vicColCache[this.vmli] = this.memory[67584 + (this.vcBase + this.vmli & 0x3FF)];
                }
                int mult = 1;
                int ypos = this.vPos + 16;
                int n = 8;
                for (int i = 0; i < n; ++i) {
                    Sprite sprite = this.sprites[i];
                    if (sprite.enabled && sprite.y == (ypos & 0xFF) && ypos < 270) {
                        sprite.nextByte = 0;
                        sprite.dma = true;
                        sprite.expFlipFlop = true;
                    }
                    mult <<= 1;
                }
                if (this.sprites[0].dma) {
                    this.cpu.baLowUntil = this.lastLine + 59L;
                }
                this.drawGraphics(this.mpos + this.horizScroll);
                this.drawSprites();
                this.mpos += 8;
                break;
            }
            case 55: {
                if (this.hideColumn) {
                    this.borderState |= 2;
                }
                if (this.badLine) {
                    this.cpu.baLowUntil = this.lastLine + 54L;
                    this.vicCharCache[this.vmli] = this.memory[this.videoMatrix + (this.vcBase + this.vmli & 0x3FF)];
                    this.vicColCache[this.vmli] = this.memory[67584 + (this.vcBase + this.vmli & 0x3FF)];
                }
                this.drawGraphics(this.mpos + this.horizScroll);
                this.drawSprites();
                if (this.borderState != 0) {
                    this.drawBackground();
                }
                this.mpos += 8;
                break;
            }
            case 56: {
                if (!this.hideColumn) {
                    this.borderState |= 2;
                }
                this.drawBackground();
                this.drawSprites();
                this.mpos += 8;
                int n = 8;
                for (int i = 0; i < n; ++i) {
                    Sprite sprite = this.sprites[i];
                    if (sprite.dma) continue;
                    sprite.painting = false;
                }
                if (!this.sprites[1].dma) break;
                this.cpu.baLowUntil = this.lastLine + 61L;
                break;
            }
            case 57: {
                int n = 8;
                for (int i = 0; i < n; ++i) {
                    Sprite sprite = this.sprites[i];
                    if (!sprite.dma) continue;
                    sprite.painting = true;
                }
                this.drawBackground();
                this.drawSprites();
                this.mpos += 8;
                if (this.rc == 7) {
                    this.vcBase = this.vc;
                    this.gfxVisible = false;
                }
                if (this.badLine || this.gfxVisible) {
                    this.rc = this.rc + 1 & 7;
                    this.gfxVisible = true;
                }
                if (this.sprites[0].painting) {
                    this.sprites[0].readSpriteData();
                }
                if (!this.sprites[2].dma) break;
                this.cpu.baLowUntil = this.lastLine + 63L;
                break;
            }
            case 58: {
                this.drawBackground();
                this.drawSprites();
                this.mpos += 8;
                break;
            }
            case 59: {
                this.drawBackground();
                this.drawSprites();
                this.mpos += 8;
                if (!this.sprites[1].painting) break;
                this.sprites[1].readSpriteData();
                break;
            }
            case 60: {
                this.drawSprites();
                break;
            }
            case 61: {
                if (this.sprites[2].painting) {
                    this.sprites[2].readSpriteData();
                }
                if (!this.sprites[3].dma) break;
                this.cpu.baLowUntil = this.lastLine + 65L;
                break;
            }
            case 62: {
                for (int i = 0; i < this.sprites.length; ++i) {
                    this.sprites[i].reset();
                }
                this.lastLine += 63L;
                if (this.updating && this.vPos == 285) {
                    this.mis.newPixels();
                    this.canvas.repaint();
                    this.actualScanTime = (this.actualScanTime * 9 + (int)(this.audioDriver.getMicros() - this.lastScan)) / 10;
                    this.lastScan = this.audioDriver.getMicros();
                    this.updating = false;
                }
                this.notVisible = false;
            }
        }
    }

    private void drawBackground() {
        int bpos = this.mpos;
        int currentBg = this.borderState > 0 ? this.borderColor : this.bgColor;
        for (int i = 0; i < 8; ++i) {
            this.mem[bpos++] = currentBg;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void drawGraphics(int mpos) {
        block24: {
            int pix;
            block23: {
                int data;
                block22: {
                    int pix2;
                    block28: {
                        int bgcol;
                        int penColor;
                        block26: {
                            block27: {
                                int position;
                                block25: {
                                    if (!this.gfxVisible || this.paintBorder || (this.borderState & 1) == 1) {
                                        int color = this.paintBorder || this.borderState > 0 ? this.borderColor : this.bgColor;
                                        int i = mpos -= this.horizScroll;
                                        int n = mpos + 8;
                                        while (true) {
                                            if (i >= n) {
                                                ++this.vmli;
                                                return;
                                            }
                                            this.mem[i] = color;
                                            ++i;
                                        }
                                    }
                                    int collX = (this.vmli << 3) + this.horizScroll + 32;
                                    if (this.vmli == 0) {
                                        int i;
                                        int n = i + 8;
                                        for (i = mpos - this.horizScroll; i < n; ++i) {
                                            this.mem[i] = this.bgColor;
                                        }
                                    }
                                    position = 0;
                                    data = 0;
                                    penColor = 0;
                                    bgcol = this.bgColor;
                                    if ((this.control1 & 0x20) != 0) break block25;
                                    if (this.multiCol) {
                                        this.multiColor[0] = this.bgColor;
                                        this.multiColor[1] = this.cbmcolor[this.bgCol[1]];
                                        this.multiColor[2] = this.cbmcolor[this.bgCol[2]];
                                    }
                                    int pcol = this.vicColCache[this.vmli] & 0xF;
                                    penColor = this.cbmcolor[pcol];
                                    if (this.extended) {
                                        data = this.vicCharCache[this.vmli];
                                        position = this.charMemoryIndex + ((data & 0x3F) << 3);
                                        bgcol = this.cbmcolor[this.bgCol[data >> 6]];
                                    } else {
                                        position = this.charMemoryIndex + (this.vicCharCache[this.vmli] << 3);
                                    }
                                    data = this.memory[position + this.rc];
                                    if (!this.multiCol || pcol <= 7) break block26;
                                    this.multiColor[3] = this.cbmcolor[pcol & 7];
                                    break block27;
                                }
                                try {
                                    position = this.vicBase + (this.vc & 0x3FF) * 8 + this.rc;
                                    if (this.multiCol) {
                                        this.multiColor[0] = this.bgColor;
                                    }
                                    int vmliData = this.vicCharCache[this.vmli];
                                    penColor = this.cbmcolor[(vmliData & 0xF0) >> 4];
                                    bgcol = this.cbmcolor[vmliData & 0xF];
                                    data = this.memory[position];
                                    if (this.multiCol) {
                                        this.multiColor[1] = this.cbmcolor[vmliData >> 4 & 0xF];
                                        this.multiColor[2] = this.cbmcolor[vmliData & 0xF];
                                        this.multiColor[3] = this.cbmcolor[this.vicColCache[this.vmli] & 0xF];
                                        break block22;
                                    }
                                    for (pix = 0; pix < 8; ++pix) {
                                        if ((data & 1 << pix) > 0) {
                                            this.mem[7 - pix + mpos] = penColor;
                                            this.collissionMask[collX + 7 - pix] = 256;
                                            continue;
                                        }
                                        this.mem[7 - pix + mpos] = bgcol;
                                        this.collissionMask[collX + 7 - pix] = 0;
                                    }
                                    break block23;
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                    break block24;
                                }
                            }
                            for (pix2 = 0; pix2 < 8; pix2 += 2) {
                                int tmp = data >> pix2 & 3;
                                int n = this.multiColor[tmp];
                                this.mem[mpos + 7 - pix2] = n;
                                this.mem[mpos + 6 - pix2] = n;
                                tmp = tmp > 1 ? 256 : 0;
                                int n2 = tmp;
                                this.collissionMask[collX + 6 - pix2] = n2;
                                this.collissionMask[collX + 7 - pix2] = n2;
                            }
                            break block28;
                        }
                        for (pix2 = 0; pix2 < 8; ++pix2) {
                            if ((data & 1 << pix2) > 0) {
                                this.mem[mpos + 7 - pix2] = penColor;
                                this.collissionMask[collX + 7 - pix2] = 256;
                                continue;
                            }
                            this.mem[mpos + 7 - pix2] = bgcol;
                            this.collissionMask[collX + 7 - pix2] = 0;
                        }
                    }
                    if (this.multiCol && this.extended) {
                        for (pix2 = 0; pix2 < 8; ++pix2) {
                            this.mem[mpos + 7 - pix2] = -16777216;
                        }
                    }
                    break block24;
                }
                for (int pix3 = 0; pix3 < 8; pix3 += 2) {
                    int tmp = data >> pix3 & 3;
                    int n = this.multiColor[tmp];
                    this.mem[mpos + 7 - pix3] = n;
                    this.mem[mpos + 6 - pix3] = n;
                    tmp = tmp > 1 ? 256 : 0;
                    int n3 = tmp;
                    this.collissionMask[collX + 6 - pix3] = n3;
                    this.collissionMask[collX + 7 - pix3] = n3;
                }
            }
            if (this.extended) {
                for (pix = 0; pix < 8; ++pix) {
                    this.mem[mpos + 7 - pix] = -16777216;
                }
            }
        }
        ++this.vc;
        ++this.vmli;
    }

    private final void drawSprites() {
        int smult = 256;
        int lastX = this.xPos - 8;
        for (int i = 7; i >= 0; --i) {
            int minX;
            Sprite sprite = this.sprites[i];
            smult >>= 1;
            if (sprite.lineFinished || !sprite.painting) continue;
            int x = sprite.x + 8;
            int mpos = this.vPos * 384;
            if (x >= this.xPos) continue;
            int m = this.xPos;
            for (int j = minX = lastX > x ? lastX : x; j < m; ++j) {
                int c = sprite.getPixel();
                if (c == 0 || this.borderState != 0) continue;
                int n = j;
                int n2 = this.collissionMask[n] | smult;
                this.collissionMask[n] = n2;
                int tmp = n2;
                if (!sprite.priority || (tmp & 0x100) == 0) {
                    this.mem[mpos + j] = sprite.color[c];
                }
                if (tmp == smult) continue;
                if ((tmp & 0x100) != 0) {
                    this.sprBgCol |= smult;
                }
                if ((tmp & 0xFF) == smult) continue;
                this.sprCol |= tmp & 0xFF;
            }
        }
        this.xPos += 8;
    }

    @Override
    public void stop() {
        this.motorSound(false);
        this.sidChip.stop();
        this.audioDriver.shutdown();
    }

    @Override
    public void reset() {
        this.initUpdate();
        this.sidChip.reset();
        this.lastLine = this.cpu.cycles;
        this.nextIOUpdate = this.cpu.cycles + 47L;
        for (int i = 0; i < this.mem.length; ++i) {
            this.mem[i] = 0;
        }
        this.reset = 100;
        this.sprCol = 0;
        this.sprBgCol = 0;
        this.cia[0].reset();
        this.cia[1].reset();
        this.keyboard.reset();
        this.motorSound(false);
        this.resetInterrupts();
    }

    public void paint(Graphics g) {
        if (g == null) {
            return;
        }
        if (this.image == null) {
            this.image = this.canvas.createImage(384, 284);
            this.g2 = this.image.getGraphics();
            this.g2.setFont(new Font("Monospaced", 0, 11));
        }
        if (this.crtImage == null) {
            this.crtImage = new BufferedImage(this.displayWidth, this.displayHeight, 2);
            Graphics gcrt = this.crtImage.getGraphics();
            gcrt.setColor(TRANSPARENT_BLACK);
            int n = this.displayHeight;
            for (int i = 0; i < n; i += 2) {
                gcrt.drawLine(0, i, this.displayWidth, i);
            }
        }
        this.g2.drawImage(this.screen, 0, 0, null);
        if (this.reset > 0) {
            this.g2.setColor(this.darks[this.colIndex]);
            int xp = 44;
            if (this.reset < 44) {
                xp = this.reset;
            }
            this.g2.drawString("JaC64 1.11 - Java C64 - www.jac64.com", xp + 1, 9);
            this.g2.setColor(this.lites[this.colIndex]);
            this.g2.drawString("JaC64 1.11 - Java C64 - www.jac64.com", xp, 8);
            --this.reset;
        } else {
            String msg = "JaC64 ";
            if (this.message != null && this.message != "") {
                msg = msg + this.message;
            } else {
                this.colIndex = 0;
            }
            msg = msg + this.tmsg;
            this.g2.setColor(this.darks[this.colIndex]);
            this.g2.drawString(msg, 1, 9);
            this.g2.setColor(this.lites[this.colIndex]);
            this.g2.drawString(msg, 0, 8);
            if (this.ledOn) {
                this.g2.setColor(LED_ON);
            } else {
                this.g2.setColor(LED_OFF);
            }
            this.g2.fillRect(372, 3, 7, 1);
            this.g2.setColor(LED_BORDER);
            this.g2.drawRect(371, 2, 8, 2);
        }
        g.fillRect(0, 0, this.offsetX, this.displayHeight + this.offsetY * 2);
        g.fillRect(this.offsetX + this.displayWidth, 0, this.offsetX, this.displayHeight + this.offsetY * 2);
        g.fillRect(0, 0, this.displayWidth + this.offsetX * 2, this.offsetY);
        g.fillRect(0, this.displayHeight + this.offsetY, this.displayWidth + this.offsetX * 2, this.offsetY);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2d.drawImage(this.image, this.offsetX, this.offsetY, this.displayWidth, this.displayHeight, null);
        g.drawImage(this.crtImage, this.offsetX, this.offsetY, this.displayWidth, this.displayHeight, null);
    }

    public void updateDisk(Object obs, Object msg) {
        if (msg == C1541Chips.HEAD_MOVED) {
            if (this.lastTrack != this.c1541Chips.currentTrack) {
                this.lastTrack = this.c1541Chips.currentTrack;
                this.trackSound();
            } else {
                this.trackSound();
            }
        }
        this.lastSector = this.c1541Chips.currentSector;
        if (this.motorOn != this.c1541Chips.motorOn) {
            this.motorSound(this.c1541Chips.motorOn);
        }
        this.tmsg = " track: " + this.lastTrack + " / " + this.lastSector;
        this.ledOn = this.c1541Chips.ledOn;
        this.motorOn = this.c1541Chips.motorOn;
    }

    private void trackSound() {
        if (this.trackSound != null) {
            this.trackSound.play();
        }
    }

    public void motorSound(boolean on) {
        if (this.motorSound != null) {
            if (on) {
                this.motorSound.loop();
            } else {
                this.motorSound.stop();
            }
        }
    }

    public void setSounds(AudioClip track, AudioClip motor) {
        this.trackSound = track;
        this.motorSound = motor;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.potx = e.getX() & 0xFF;
        this.poty = 255 - (e.getY() & 0xFF);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.potx = e.getX() & 0xFF;
        this.poty = 255 - (e.getY() & 0xFF);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getButton() == 1) {
            this.button1 = true;
        } else {
            this.button2 = true;
        }
        this.keyboard.setButtonval(255 - (this.button1 | this.button2 ? 16 : 0));
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.getButton() == 1) {
            this.button1 = false;
        } else {
            this.button2 = false;
        }
        this.keyboard.setButtonval(255 - (this.button1 | this.button2 ? 16 : 0));
    }

    private class Sprite {
        boolean painting = false;
        boolean dma = false;
        int nextByte;
        int pointer;
        int x;
        int y;
        int spriteNo;
        int spriteReg;
        boolean enabled;
        boolean expFlipFlop;
        boolean multicolor = false;
        boolean expandX = false;
        boolean expandY = false;
        boolean priority = false;
        boolean lineFinished = false;
        int pixelsLeft = 0;
        int currentPixel = 0;
        int col;
        int[] color = new int[4];

        private Sprite() {
        }

        int getPixel() {
            if (this.lineFinished) {
                return 0;
            }
            --this.pixelsLeft;
            if (this.pixelsLeft > 0) {
                return this.currentPixel;
            }
            if (this.pixelsLeft <= 0 && this.spriteReg == 0) {
                this.currentPixel = 0;
                this.lineFinished = true;
                return 0;
            }
            if (this.multicolor) {
                this.currentPixel = (this.spriteReg & 0xC00000) >> 22;
                this.spriteReg = this.spriteReg << 2 & 0xFFFFFF;
                this.pixelsLeft = 2;
            } else {
                this.currentPixel = (this.spriteReg & 0x800000) >> 22;
                this.spriteReg = this.spriteReg << 1 & 0xFFFFFF;
                this.pixelsLeft = 1;
            }
            if (this.expandX) {
                this.pixelsLeft <<= 1;
            }
            return this.currentPixel;
        }

        void reset() {
            this.lineFinished = false;
        }

        void readSpriteData() {
            this.pointer = C64Screen.this.vicBank + C64Screen.this.memory[C64Screen.this.spr0BlockSel + this.spriteNo] * 64;
            this.spriteReg = (C64Screen.this.memory[this.pointer + this.nextByte++] & 0xFF) << 16 | (C64Screen.this.memory[this.pointer + this.nextByte++] & 0xFF) << 8 | C64Screen.this.memory[this.pointer + this.nextByte++];
            if (!this.expandY) {
                this.expFlipFlop = false;
            }
            if (this.expFlipFlop) {
                this.nextByte -= 3;
            }
            this.expFlipFlop = !this.expFlipFlop;
            this.pixelsLeft = 0;
        }
    }
}

