/*
 * Decompiled with CFR 0.152.
 */
package com.dreamfabric.jac64;

import com.dreamfabric.c64utils.AutoStore;
import com.dreamfabric.jac64.C1541Emu;
import com.dreamfabric.jac64.DefaultIMon;
import com.dreamfabric.jac64.Hex;
import com.dreamfabric.jac64.IMonitor;
import com.dreamfabric.jac64.Loader;
import com.dreamfabric.jac64.MOS6510Core;
import com.dreamfabric.jac64.PatchListener;
import com.dreamfabric.jac64.TimeEvent;

public class CPU
extends MOS6510Core {
    public static final boolean DEBUG_EVENT = false;
    public static final int IO_OFFSET = 12288;
    public static final int BASIC_ROM2 = 106496;
    public static final int KERNAL_ROM2 = 122880;
    public static final int CHAR_ROM2 = 118784;
    public static final boolean EMULATE_1541 = true;
    public static final int CH_PROTECT = 1;
    public static final int CH_MONITOR_WRITE = 2;
    public static final int CH_MONITOR_READ = 4;
    private int romFlag = 40960;
    public boolean basicROM = true;
    public boolean kernalROM = true;
    public boolean charROM = false;
    public boolean ioON = true;
    public boolean running = true;
    public boolean pause = false;
    private static final long CYCLES_PER_DEBUG = 10000000L;
    public static final boolean DEBUG = false;
    private C1541Emu c1541;
    private Loader loader;
    private int windex = 0;
    private int[] cheatMon;
    private AutoStore[] autoStore;

    public CPU(IMonitor m, String cb, Loader loader) {
        super(m, cb);
        this.memory = new int[131072];
        this.loader = loader;
        DefaultIMon d = new DefaultIMon();
        this.c1541 = new C1541Emu(d, cb);
    }

    public C1541Emu getDrive() {
        return this.c1541;
    }

    private final void schedule(long cycles) {
        this.chips.clock(cycles);
        while (cycles >= this.scheduler.nextTime) {
            TimeEvent t = this.scheduler.popFirst();
            if (t != null) {
                t.execute(cycles);
                continue;
            }
            return;
        }
    }

    @Override
    protected final int fetchByte(int adr) {
        ++this.cycles;
        this.schedule(this.cycles);
        while (this.baLowUntil > this.cycles) {
            ++this.cycles;
            this.schedule(this.cycles);
        }
        if ((this.romFlag & adr) == this.romFlag) {
            this.rindex = adr | 0x10000;
            return this.memory[this.rindex];
        }
        if ((adr & 0xF000) == 53248) {
            if (this.ioON) {
                this.rindex = adr;
                return this.chips.performRead(this.rindex, this.cycles);
            }
            if (this.charROM) {
                this.rindex = adr | 0x10000;
                return this.memory[this.rindex];
            }
            this.rindex = adr;
            return this.memory[this.rindex];
        }
        this.rindex = adr;
        return this.memory[this.rindex];
    }

    @Override
    protected final void writeByte(int adr, int data) {
        ++this.cycles;
        this.schedule(this.cycles);
        if (adr <= 1) {
            this.memory[adr] = data;
            int p = this.memory[0] ^ 0xFF | this.memory[1];
            this.kernalROM = (p & 2) == 2;
            this.basicROM = (p & 3) == 3;
            this.charROM = (p & 3) != 0 && (p & 4) == 0;
            boolean bl = this.ioON = (p & 3) != 0 && (p & 4) != 0;
            this.romFlag = this.basicROM ? 40960 : (this.kernalROM ? 57344 : 65536);
        }
        if (this.ioON && ((adr &= 0xFFFF) & 0xF000) == 53248) {
            this.chips.performWrite(adr, data, this.cycles);
        } else {
            this.windex = adr;
            this.memory[this.windex] = data;
        }
    }

    private void fixRindex(int adr) {
        if (this.basicROM && (adr & 0xE000) == 40960 || this.kernalROM && (adr & 0xE000) == 57344 || this.charROM && (adr & 0xF000) == 53248) {
            adr |= 0x10000;
        }
        this.rindex = adr;
    }

    public void poke(int address, int data) {
        this.writeByte(address & 0xFFFF, data & 0xFF);
    }

    @Override
    public void patchROM(PatchListener list) {
        this.list = list;
        int pos = 128158;
        this.memory[pos++] = 32;
        this.memory[pos++] = 210;
        this.memory[pos++] = 245;
        System.out.println("Patched LOAD at: " + Hex.hex2(pos));
        this.memory[pos++] = 76;
        this.memory[pos++] = 96;
    }

    public void runBasic() {
        this.memory[631] = 82;
        this.memory[632] = 85;
        this.memory[633] = 78;
        this.memory[634] = 13;
        this.memory[198] = 4;
    }

    public void enterText(String txt) {
        System.out.println("Entering text into textbuffer: " + txt);
        txt = txt.toUpperCase();
        int len = txt.length();
        int pos = 0;
        int n = len;
        for (int i = 0; i < n; ++i) {
            int c = txt.charAt(i);
            if (c == 126) {
                c = 13;
            }
            this.memory[631 + pos] = c;
            if (++pos != 5) continue;
            this.memory[198] = pos;
            pos = 0;
            int tries = 5;
            while (tries > 0 && this.memory[198] > 0) {
                try {
                    Thread.sleep(50L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (--tries != 0) continue;
                System.out.println("Buffer still full: " + this.memory[198]);
            }
        }
        this.memory[198] = pos;
        int tries = 5;
        while (tries > 0 && this.memory[198] > 0) {
            try {
                Thread.sleep(50L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (--tries != 0) continue;
            System.out.println("Buffer still full: " + this.memory[198]);
        }
    }

    @Override
    protected void installROMS() {
        this.loadROM(this.loader.getResourceStream("/roms/kernal.c64"), 122880, 8192);
        this.loadROM(this.loader.getResourceStream("/roms/basic.c64"), 106496, 8192);
        this.loadROM(this.loader.getResourceStream("/roms/chargen.c64"), 118784, 4096);
    }

    public void run(int address) {
        this.reset();
        this.running = true;
        this.setPC(address);
        this.loop();
    }

    @Override
    public void unknownInstruction(int pc, int op) {
        switch (op) {
            case 77: {
                this.cycles += 100L;
                break;
            }
            case 76: {
                if (this.acc == 0) {
                    this.monitor.info("**** LOAD FILE! ***** PC = " + Integer.toString(pc, 16) + " => " + Integer.toString(this.rindex, 16));
                } else {
                    this.monitor.info("**** VERIFY!    ***** PC = " + pc + " => " + this.rindex);
                }
                int mptr = this.memory[187] + (this.memory[188] << 8);
                int len = this.memory[183];
                this.monitor.info("Filename len:" + len);
                String name = "";
                for (int i = 0; i < len; ++i) {
                    name = name + (char)this.memory[mptr++];
                }
                name = name + '\n';
                int sec = this.memory[185];
                this.monitor.info("name = " + name);
                this.monitor.info("Sec Address: " + sec);
                int loadAdr = -1;
                if (sec == 0) {
                    loadAdr = this.memory[43] + (this.memory[44] << 8);
                }
                if (this.list != null && this.list.readFile(name, loadAdr)) {
                    this.acc = 0;
                }
                --pc;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        this.run(64738);
        if (this.pause) {
            while (this.pause) {
                System.out.println("Entering pause mode...");
                CPU cPU = this;
                synchronized (cPU) {
                    try {
                        this.wait();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                System.out.println("Exiting pause mode...");
                this.loop();
            }
        }
    }

    public synchronized void setPause(boolean p) {
        if (p) {
            this.pause = true;
            this.running = false;
        } else {
            this.pause = false;
            this.running = true;
        }
        this.notify();
    }

    public synchronized void stop() {
        this.running = false;
        this.pause = false;
        this.notify();
    }

    @Override
    public void reset() {
        this.writeByte(1, 7);
        super.reset();
        this.c1541.reset();
    }

    public void setPC(int startAdress) {
        this.pc = startAdress;
    }

    @Override
    public String getName() {
        return "C64 CPU";
    }

    public void loop() {
        if (this.cheatMon != null) {
            this.cheatLoop();
            return;
        }
        long next_print = this.cycles + 10000000L;
        this.monitor.info("Starting CPU at: " + Integer.toHexString(this.pc));
        try {
            while (this.running) {
                if (this.monitor.isEnabled() && this.baLowUntil <= this.cycles) {
                    this.fixRindex(this.pc);
                    this.monitor.disAssemble(this.memory, this.rindex, this.acc, this.x, this.y, (byte)this.getStatusByte(), this.interruptInExec, this.lastInterrupt);
                }
                this.emulateOp();
                this.c1541.tick(this.cycles);
                ++this.nr_ins;
                if (next_print >= this.cycles) continue;
                long sec = System.currentTimeMillis() - this.lastMillis;
                int level = this.monitor.getLevel();
                this.nr_irq = 0L;
                this.nr_ins = 0L;
                this.lastMillis = System.currentTimeMillis();
                next_print = this.cycles + 10000000L;
            }
        }
        catch (Exception e) {
            this.monitor.error("Exception in loop " + this.pc + " : " + e);
            e.printStackTrace();
            this.monitor.disAssemble(this.memory, this.rindex, this.acc, this.x, this.y, (byte)this.getStatusByte(), this.interruptInExec, this.lastInterrupt);
        }
    }

    public void setAutoStore(int index, AutoStore au) {
        this.autoStore[index] = au;
    }

    public AutoStore getAutoStore(int index) {
        return this.autoStore[index];
    }

    public void setCheatEnabled(int maxAutostores) {
        this.cheatMon = new int[65536];
        this.autoStore = new AutoStore[maxAutostores];
    }

    public void protect(int address, int value) {
        this.cheatMon[address] = this.cheatMon[address] & 0xFF | value << 8 | 1;
    }

    public void monitorRead(int address) {
        int n = address;
        this.cheatMon[n] = this.cheatMon[n] | 4;
    }

    public void monitorWrite(int address) {
        int n = address;
        this.cheatMon[n] = this.cheatMon[n] | 2;
    }

    public void cheatLoop() {
        try {
            while (this.running) {
                int i;
                int n;
                int t;
                this.emulateOp();
                if (this.rindex < 65536 && (t = this.cheatMon[this.rindex]) != 0 && (t & 4) != 0) {
                    n = this.autoStore.length;
                    for (i = 0; i < n; ++i) {
                        if (this.autoStore[i] == null) continue;
                        this.autoStore[i].checkRules(this.memory);
                    }
                }
                if (this.windex < 65536 && (t = this.cheatMon[this.windex]) != 0) {
                    if ((t & 1) != 0) {
                        this.memory[this.windex] = this.cheatMon[this.windex] >> 16 & 0xFF;
                    }
                    if ((t & 2) != 0) {
                        n = this.autoStore.length;
                        for (i = 0; i < n; ++i) {
                            if (this.autoStore[i] == null) continue;
                            this.autoStore[i].checkRules(this.memory);
                        }
                    }
                }
                this.c1541.tick(this.cycles);
            }
        }
        catch (Exception e) {
            this.monitor.error("Exception in loop " + this.pc + " : " + e);
            e.printStackTrace();
            this.monitor.disAssemble(this.memory, this.rindex, this.acc, this.x, this.y, (byte)this.getStatusByte(), this.interruptInExec, this.lastInterrupt);
        }
    }
}

