/*
 * Decompiled with CFR 0.152.
 */
package com.dreamfabric.jac64;

import com.dreamfabric.jac64.AudioDriver;
import com.dreamfabric.jac64.SIDMixerListener;
import com.dreamfabric.jac64.SIDVoice;
import com.dreamfabric.jac64.SIDVoice6581;

public class SIDMixer {
    public static int BYTES_PER_SAMPLE = 2;
    public static final boolean NO_SOUND = false;
    public static final boolean DEBUG = false;
    public static int DL_BUFFER_SIZE = 88000;
    public static final int SYNCH_BUFFER = 1760;
    public static final int EFX_NONE = 0;
    public static final int EFX_FLANGER_1 = 1;
    public static final int EFX_FLANGER_2 = 2;
    public static final int EFX_FLANGER_3 = 3;
    public static final int EFX_PHASER_1 = 4;
    public static final int EFX_PHASER_2 = 5;
    public static final int EFX_CHORUS_1 = 6;
    public static final int EFX_CHORUS_2 = 7;
    public static final int EFX_ECHO_1 = 8;
    public static final int EFX_ECHO_2 = 9;
    public static final int EFX_REV_SMALL = 10;
    public static final int EFX_REV_MED = 11;
    public static final int EFX_REV_LARGE = 12;
    public static final int EFX_FSWEEP = 13;
    public static final int EFX_FSWEEP_RES = 14;
    private String[] efxNames = new String[]{"EFX_NONE", "EFX_FLANGER_1", "EFX_FLANGER_2", "EFX_FLANGER_3", "EFX_PHASER_1", "EFX_PHASER_2", "EFX_CHORUS_1", "EFX_CHORUS_2", "EFX_ECHO_1", "EFX_ECHO_2", "EFX_REV_SMALL", "EFX_REV_MED", "EFX_REV_LARGE", "EFX_FSWEEP", "EFX_FSWEEP_RES"};
    public boolean fullSpeed = false;
    private SIDVoice psid;
    private SIDVoice6581[] channels;
    private boolean soundOn = true;
    private SIDMixerListener listener = null;
    private AudioDriver driver;
    byte[] buffer = new byte[88];
    byte[] syncBuffer = new byte[4096];
    int[] intBuffer = new int[44];
    int[] noFltBuffer = new int[44];
    boolean effects = false;
    public static final int LFO_WAVELEN = 500;
    int[] echo;
    int echoSize = 0;
    int echoPos = 0;
    int echoLFODiff = 0;
    int echoLFODiffMax = 0;
    int echoLFODepth = 50;
    int echoFeedback = 0;
    int echoLFOSpeed = 0;
    int echoLFOPos = 0;
    int echoDW = 50;
    int maxefx;
    int minefx;
    int sidVol = 15;
    int[] sidVolArr = new int[44];
    long lastCycles = 0L;
    int filterVal = 0;
    public int cutoff = 0;
    public int resonance = 0;
    int filterOn = 0;
    int masterVolume = 100;
    boolean lpOn = false;
    boolean hpOn = false;
    boolean bpOn = false;
    long vlp;
    long vhp;
    long vbp;
    long w0;
    long div1024Q;
    long exVlp;
    long exVhp;
    long exVo;
    long exw0lp;
    long exw0hp;
    int irq = 0;
    int[] sine10Hz;
    public static final int SLEEP_SYNC = 1;
    private int sleep = 100;
    private int syncMode = 0;
    private double avg = 10.0;
    private long lastTime = System.currentTimeMillis();
    private long micros = 0L;

    public SIDMixer() {
    }

    public SIDMixer(SIDVoice6581[] channels, SIDVoice sample, AudioDriver driver) {
        this.init(channels, sample, driver);
    }

    public void init(SIDVoice6581[] channels, SIDVoice sample, AudioDriver driver) {
        this.channels = channels;
        this.psid = sample;
        this.driver = driver;
        System.out.println("Micros per SIDGen: " + this.getMicrosPerGen());
        this.exw0hp = 105L;
        this.exw0lp = 104858L;
        this.sine10Hz = new int[500];
        int n = 500;
        for (int i = 0; i < n; ++i) {
            this.sine10Hz[i] = (int)(500.0 + 500.0 * Math.sin((double)(i * 2) * 3.1415 / 500.0));
        }
        this.setEFX(8);
        this.setEFX(0);
    }

    public void setListener(SIDMixerListener front) {
        this.listener = front;
    }

    public void setEchoTime(int millisDelay) {
        int sampleSize = millisDelay * 44000 / 1000;
        System.out.println("SamplesDelay: " + sampleSize);
        this.echoSize = sampleSize;
        this.echo = new int[this.echoSize];
        this.echoLFODiffMax = this.echoSize * this.echoLFODepth / 110;
        this.echoLFODiff = 0;
        this.echoPos = 0;
    }

    public int getEchoTime() {
        return 1000 * this.echoSize / 44000;
    }

    public int getEFXCount() {
        return this.efxNames.length;
    }

    public String getEFXName(int efx) {
        return this.efxNames[efx];
    }

    public void setEchoFeedback(int percen) {
        this.echoFeedback = percen;
    }

    public int getEchoFeedback() {
        return this.echoFeedback;
    }

    public void setEchoLFOSpeed(int hzd10) {
        this.echoLFOSpeed = hzd10;
    }

    public int getEchoLFOSpeed() {
        return this.echoLFOSpeed;
    }

    public void setEchoDW(int percent) {
        this.echoDW = percent;
    }

    public int getEchoDW() {
        return this.echoDW;
    }

    public void setEchoLFODepth(int percent) {
        this.echoLFODepth = percent;
        this.echoLFODiffMax = this.echoSize * this.echoLFODepth / 110;
    }

    public int getEchoLFODepth() {
        return this.echoLFODepth;
    }

    public boolean getEffectsOn() {
        return this.effects;
    }

    public void setEFX(int fx) {
        this.effects = true;
        switch (fx %= this.efxNames.length) {
            case 0: {
                this.effects = false;
                break;
            }
            case 1: {
                this.setEchoTime(5);
                this.setEchoFeedback(75);
                this.setEchoLFOSpeed(1);
                this.setEchoLFODepth(35);
                this.setEchoDW(33);
                break;
            }
            case 2: {
                this.setEchoTime(15);
                this.setEchoFeedback(70);
                this.setEchoLFOSpeed(5);
                this.setEchoLFODepth(35);
                this.setEchoDW(35);
                break;
            }
            case 3: {
                this.setEchoTime(2);
                this.setEchoFeedback(85);
                this.setEchoLFOSpeed(3);
                this.setEchoLFODepth(55);
                this.setEchoDW(30);
                break;
            }
            case 4: {
                this.setEchoTime(10);
                this.setEchoFeedback(0);
                this.setEchoLFOSpeed(1);
                this.setEchoLFODepth(75);
                this.setEchoDW(50);
                break;
            }
            case 5: {
                this.setEchoTime(3);
                this.setEchoFeedback(0);
                this.setEchoLFOSpeed(2);
                this.setEchoLFODepth(85);
                this.setEchoDW(40);
                break;
            }
            case 6: {
                this.setEchoTime(25);
                this.setEchoFeedback(60);
                this.setEchoLFOSpeed(1);
                this.setEchoLFODepth(35);
                this.setEchoDW(35);
                break;
            }
            case 7: {
                this.setEchoTime(30);
                this.setEchoFeedback(50);
                this.setEchoLFOSpeed(5);
                this.setEchoLFODepth(25);
                this.setEchoDW(35);
                break;
            }
            case 8: {
                this.setEchoTime(150);
                this.setEchoFeedback(0);
                this.setEchoLFOSpeed(0);
                this.setEchoLFODepth(0);
                this.setEchoDW(33);
                break;
            }
            case 9: {
                this.setEchoTime(300);
                this.setEchoFeedback(33);
                this.setEchoLFOSpeed(0);
                this.setEchoLFODepth(0);
                this.setEchoDW(45);
                break;
            }
            case 10: {
                this.setEchoTime(70);
                this.setEchoFeedback(40);
                this.setEchoLFOSpeed(0);
                this.setEchoLFODepth(0);
                this.setEchoDW(33);
                break;
            }
            case 11: {
                this.setEchoTime(130);
                this.setEchoFeedback(50);
                this.setEchoLFOSpeed(0);
                this.setEchoLFODepth(0);
                this.setEchoDW(33);
                break;
            }
            case 12: {
                this.setEchoTime(100);
                this.setEchoFeedback(70);
                this.setEchoLFOSpeed(0);
                this.setEchoLFODepth(0);
                this.setEchoDW(40);
            }
        }
        if (this.listener != null) {
            this.listener.updateValues();
        }
    }

    public void setEffectsOn(boolean fx) {
        this.effects = fx;
    }

    public boolean isEffectsOn() {
        return this.effects;
    }

    public void setFilterCutoffLO(int data) {
        this.cutoff = this.cutoff & 0xFF8 | data & 7;
        this.recalcFilter();
    }

    public void setFilterCutoffHI(int data) {
        this.cutoff = this.cutoff & 7 | data << 3;
        this.recalcFilter();
    }

    public void setFilterResonance(int data) {
        this.resonance = data;
        this.recalcFilter();
    }

    public void setFilterCtrl(int data) {
        this.lpOn = (data & 0x10) > 0;
        this.bpOn = (data & 0x20) > 0;
        this.hpOn = (data & 0x40) > 0;
        this.recalcFilter();
    }

    public void setFilterOn(int on) {
        this.filterOn = on;
    }

    public void setMoogFilterOn(boolean on) {
    }

    public boolean isMoogFilterOn() {
        return false;
    }

    public void setMoogResonance(int percent) {
    }

    public int getMoogResonance() {
        return 0;
    }

    public void setMoogCutoff(int frq) {
    }

    public int getMoogCutoff() {
        return 0;
    }

    public void setMoogSpeed(int hz10) {
    }

    public int getMoogSpeed() {
        return 0;
    }

    public void setMoogDepth(int dep) {
    }

    public int getMoogDepth() {
        return 0;
    }

    public void setVolume(int vol) {
        this.sidVol = vol;
    }

    public void setVolume(int vol, long cycles) {
        if (this.lastCycles > 0L) {
            int pos = (int)((cycles - this.lastCycles) / 32L);
            this.sidVolArr[pos % 44] = vol;
        } else {
            this.sidVol = vol;
        }
    }

    private void recalcFilter() {
        int fCutoff = 30 + 12000 * this.cutoff / 2048;
        this.w0 = (long)(Math.PI * 2 * (double)fCutoff * 1.048576);
        this.div1024Q = (int)(1024.0 / (0.707 + 1.0 * (double)this.resonance / 15.0));
    }

    public void stop() {
        this.setVolume(0);
    }

    public void reset() {
        this.exVo = 0L;
        this.exVhp = 0L;
        this.exVlp = 0L;
        this.cutoff = 0;
        this.resonance = 0;
        this.w0 = 0L;
        this.div1024Q = 0L;
        this.filterOn = 0;
        this.maxefx = 0;
        this.minefx = 0;
        int n = 44;
        for (int i = 0; i < n; ++i) {
            this.sidVolArr[i] = -1;
        }
        this.setVolume(15);
        this.recalcFilter();
    }

    public void printStatus() {
        System.out.println("SIDMixer  ----------------------------");
        System.out.println("Volume: " + this.sidVol);
        System.out.println("FilterOn: " + this.filterOn);
        System.out.println("Cutoff: " + this.cutoff);
        System.out.println("Resonance: " + this.resonance);
        System.out.println("Max Efx:" + this.maxefx);
        System.out.println("Min Efx:" + this.minefx);
    }

    public void setFullSpeed(boolean fs) {
        System.out.println("Set full speed: " + fs);
        this.fullSpeed = fs;
    }

    public boolean fullSpeed() {
        return this.fullSpeed;
    }

    public int[] getBuffer() {
        return this.intBuffer;
    }

    public boolean updateSound(long cycles) {
        boolean trueIRQ;
        ++this.irq;
        boolean bl = trueIRQ = this.irq % 20 == 0;
        if (trueIRQ && this.syncMode == 1 && !this.fullSpeed) {
            long elapsed = System.currentTimeMillis() - this.lastTime;
            this.lastTime = System.currentTimeMillis();
            this.avg = 0.99 * this.avg + 0.01 * (double)elapsed;
            if (this.avg < 20.0) {
                ++this.sleep;
            }
            if (this.avg > 20.0) {
                --this.sleep;
            }
            System.out.println("Avg: " + this.avg + " Sleep: " + (double)this.sleep / 10.0 + " " + (this.driver.getMicros() - this.micros));
            double slm = 19.75 - (double)(this.driver.getMicros() - this.micros) / 1000.0;
            try {
                Thread.sleep((int)slm);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.micros = this.driver.getMicros();
        }
        if (!this.driver.hasSound()) {
            return trueIRQ;
        }
        if ((this.fullSpeed || this.syncMode == 1) && this.driver.available() < 88) {
            return false;
        }
        this.lastCycles = cycles;
        if (this.soundOn) {
            int i;
            int i2;
            int j;
            int m;
            if (this.psid != null) {
                int[] tBuf = this.psid.generateSound(cycles);
                m = 44;
                for (j = 0; j < m; ++j) {
                    this.intBuffer[j] = 0;
                    this.noFltBuffer[j] = tBuf[j] << 4;
                }
            } else {
                m = 44;
                for (j = 0; j < m; ++j) {
                    this.intBuffer[j] = 0;
                    this.noFltBuffer[j] = 0;
                }
            }
            int n = this.channels.length;
            for (i2 = 0; i2 < n; ++i2) {
                int[] buf = this.channels[i2].generateSound(cycles);
                int[] tBuf = (this.filterOn & 1 << i2) > 0 ? this.intBuffer : this.noFltBuffer;
                int m2 = 44;
                for (int j2 = 0; j2 < m2; ++j2) {
                    int n2 = j2;
                    tBuf[n2] = tBuf[n2] + (buf[j2] >> 2);
                }
            }
            n = 44;
            for (i2 = 0; i2 < n; ++i2) {
                int inval = this.intBuffer[i2];
                if (this.filterOn > 0) {
                    this.vbp -= 8L * this.w0 * this.vhp >> 20;
                    this.vlp -= 8L * this.w0 * this.vbp >> 20;
                    this.vhp = (this.vbp * this.div1024Q >> 10) - this.vlp - (long)inval;
                    this.vbp -= 8L * this.w0 * this.vhp >> 20;
                    this.vlp -= 8L * this.w0 * this.vbp >> 20;
                    this.vhp = (this.vbp * this.div1024Q >> 10) - this.vlp - (long)inval;
                    this.vbp -= 7L * this.w0 * this.vhp >> 20;
                    this.vlp -= 7L * this.w0 * this.vbp >> 20;
                    this.vhp = (this.vbp * this.div1024Q >> 10) - this.vlp - (long)inval;
                    inval = (int)((this.bpOn ? this.vbp : 0L) + (this.hpOn ? this.vhp : 0L) + (this.lpOn ? this.vlp : 0L));
                }
                inval += this.noFltBuffer[i2];
                if (this.sidVolArr[i2] != -1) {
                    this.sidVol = this.sidVolArr[i2];
                    this.sidVolArr[i2] = -1;
                }
                inval = inval * this.sidVol >> 2;
                this.exVlp += (8L * this.exw0lp >> 8) * ((long)inval - this.exVlp) >> 12;
                this.exVhp += this.exw0hp * 8L * (this.exVlp - this.exVhp) >> 20;
                this.exVlp += (8L * this.exw0lp >> 8) * ((long)inval - this.exVlp) >> 12;
                this.exVhp += this.exw0hp * 8L * (this.exVlp - this.exVhp) >> 20;
                this.exVo = this.exVlp - this.exVhp;
                this.exVlp += (7L * this.exw0lp >> 8) * ((long)inval - this.exVlp) >> 12;
                this.exVhp += this.exw0hp * 7L * (this.exVlp - this.exVhp) >> 20;
                this.intBuffer[i2] = (int)this.exVo;
            }
            if (this.effects) {
                n = 44;
                for (i2 = 0; i2 < n; ++i2) {
                    int exVal = this.intBuffer[i2];
                    int echoRead = (this.echoPos + this.echoLFODiff) % this.echoSize;
                    int out = (exVal * (100 - this.echoDW) + this.echo[echoRead] * this.echoDW) / 100;
                    if (out > Short.MAX_VALUE) {
                        out = Short.MAX_VALUE;
                    }
                    if (out < -32767) {
                        out = -32767;
                    }
                    this.intBuffer[i2] = out;
                    if ((exVal += this.echo[echoRead] * this.echoFeedback / 100) > this.maxefx) {
                        this.maxefx = exVal;
                    }
                    if (exVal < this.minefx) {
                        this.minefx = exVal;
                    }
                    if (exVal > Short.MAX_VALUE) {
                        exVal = Short.MAX_VALUE;
                    }
                    if (exVal < -32767) {
                        exVal = -32767;
                    }
                    this.echo[this.echoPos] = exVal;
                    this.echoPos = (this.echoPos + 1) % this.echoSize;
                }
            }
            int bIndex = 0;
            if (BYTES_PER_SAMPLE == 2) {
                int n3 = 44;
                for (i = 0; i < n3; ++i) {
                    this.buffer[bIndex++] = (byte)(this.intBuffer[i] & 0xFF);
                    this.buffer[bIndex++] = (byte)(this.intBuffer[i] >> 8);
                }
            } else {
                int n4 = 44;
                for (i = 0; i < n4; ++i) {
                    this.buffer[bIndex++] = (byte)(this.intBuffer[i] >> 8);
                }
            }
        }
        this.driver.write(this.buffer);
        if (trueIRQ) {
            this.echoLFODiff = this.echoLFODiffMax * this.sine10Hz[this.echoLFOPos] / 1000;
            this.echoLFOPos = (this.echoLFOPos + this.echoLFOSpeed) % 500;
        }
        return trueIRQ;
    }

    public int getMicrosPerGen() {
        long mpg = 44000000L;
        return (int)(mpg / 44000L);
    }

    public boolean soundOn() {
        return this.soundOn;
    }

    public void setSoundOn(boolean on) {
        this.soundOn = on;
        if (!this.soundOn) {
            int n = this.buffer.length;
            for (int i = 0; i < n; ++i) {
                this.buffer[i] = 0;
            }
        }
    }
}

