/*
 * Decompiled with CFR 0.152.
 */
package com.dreamfabric.jac64;

import com.dreamfabric.jac64.RS6581Waves;
import com.dreamfabric.jac64.SIDVoice;

public class SIDVoice6581
extends SIDVoice {
    public static final int UPDATE_CYCLES = 1000;
    public static final int PER_SEC = 1000;
    public static final boolean DEBUG = false;
    private int[] memory;
    private int sidbase = 0;
    public static final int SAMPLE_RATE = 44000;
    public static final double FRQCONV = 0.058725380897521974;
    public static final int TRIANGLE = 1;
    public static final int SAW = 2;
    public static final int PULSE = 4;
    public static final int NOISE = 8;
    public static final int NONE = 0;
    private int[] ST_LOOKUP = RS6581Waves.wave6581__ST;
    private int[] PST_LOOKUP = RS6581Waves.wave6581_PST;
    private int[] PT_LOOKUP = RS6581Waves.wave6581_P_T;
    private int[] PS_LOOKUP = RS6581Waves.wave6581_PS_;
    public static final String[] WAVE = new String[]{"NONE", "TRIANGLE", "SAW", "TRI_SAW", "PULSE", "TRI_PULSE", "SAW_PULSE", "TRI_SAW_PULSE", "NOISE", "NOISE_T", "NOISE_S", "NOISE_TS", "NOISE_P", "NOISE_TP", "NOISE_SP", "NOISE_TSP"};
    private final int ATTACK = 1;
    private final int DECAY = 2;
    private final int SUSTAIN = 3;
    private final int RELEASE = 4;
    private final int FINISHED = 5;
    public static final String[] ADSR_PHASES = new String[]{"-", "Attack", "Decay", "Sustain", "Relase", "Finished"};
    static final int waveLen = 44000;
    private static int[] sawWave;
    private static int[] triangleWave;
    private static int[] triangleWaveD2;
    private static int[] pulseWave;
    public static final int GENLEN = 44;
    public static final int GENS_PER_IRQ = 20;
    public static final int SAMPLE_BITS = 12;
    public static final int MAXGENLEN = 440;
    public static final double SAMPLES_PER_MICRO = 0.044;
    public static final int CYCLES_PER_SAMPLE = 22;
    public static final int VOLUME_SIZE = 4096;
    public static final int DELAY_LEN = 880;
    byte[] buffer = new byte[4096];
    int delPos = 0;
    int diffMin = 0;
    int diffDt = 1;
    int[] delay = new int[880];
    int generated;
    int smp;
    int pwid = 22000;
    long nextSample = 0L;
    long next_nextSample;
    int noiseData = 0;
    long noise_reg = 0x7FFFF8L;
    boolean debugGen = false;
    boolean sync = false;
    boolean ring = false;
    boolean testBit = false;
    int testZero = 0;
    private int[] outBuffer;
    long[] attackTime = new long[]{2000L, 8000L, 16000L, 24000L, 38000L, 56000L, 68000L, 80000L, 100000L, 250000L, 500000L, 800000L, 1000000L, 3000000L, 5000000L, 8000000L};
    public static final int ADSR_BITS = 22;
    public static final int ADSR_RATE_BITS = 32;
    long ATTACK_MAX = 1069547520L;
    long RELEASE_FINISH_LEVEL = 0x3FFFFFL;
    int ATTACK_FUZZ = 128;
    long[] attackDelta = new long[this.attackTime.length];
    long[] decayExp = new long[]{4216751472L, 4275278366L, 4285111523L, 4288394265L, 4290814737L, 4292149050L, 4292646253L, 4292994329L, 4293388850L, 4294335848L, 4294651560L, 4294769958L, 4294809425L, 4294914671L, 4294935721L, 4294947561L};
    long adsrLevel22 = 0L;
    long adsrSusLevel22 = 0L;
    long decayFactor = 0L;
    long releaseFactor = 0L;
    long currentDecayFactor = 0L;
    long currentAttackRate = 0L;
    int adsrPhase = 1;
    int adsrBug = 0;
    int ad;
    int sr;
    public static int frqFac;
    public double adsrLevel;
    long lastAttackTime = 0L;
    boolean soundOn = false;
    public static final int FRQ_BITS = 4;
    public static final long WAVELEN = 704000L;
    public static final long WAVELEN_HALF = 352000L;
    public long frq = 1L;
    public double trueFrq = 0.0;
    public int wave;
    public long next_frq;
    public SIDVoice6581 next;
    private long lastCycles = 0L;
    private int decayTimes = 0;
    public int lastSample = 0;
    public int adsrVol = 0;
    long nanos;
    long total;
    int[] pwidArr = new int[44];

    public SIDVoice6581(int[] mem, int sb) {
        int i;
        this.intBuffer = new int[2048];
        this.outBuffer = new int[2048];
        this.memory = mem;
        this.sidbase = sb;
        System.out.println("SIDBASE: " + this.sidbase);
        System.out.println("GENLEN: 44");
        int n = this.attackTime.length;
        for (int i2 = 0; i2 < n; ++i2) {
            long attack;
            int noSamples = (int)(44000L * this.attackTime[i2] / 1000000L);
            this.attackDelta[i2] = attack = 1069547520L / (long)noSamples;
        }
        if (sawWave == null) {
            sawWave = new int[44000];
            triangleWave = new int[44000];
            triangleWaveD2 = new int[44000];
            pulseWave = new int[88000];
        }
        double val = 0.0;
        double dval = 0.09306818181818181;
        for (i = 0; i < 44000; ++i) {
            SIDVoice6581.sawWave[i] = (int)val;
            val += dval;
        }
        for (i = 0; i < 44000; ++i) {
            SIDVoice6581.pulseWave[i] = 4095;
            SIDVoice6581.pulseWave[i + 44000] = 0;
        }
        val = 0.0;
        dval = 0.18613636363636363;
        for (i = 0; i < 22000; ++i) {
            SIDVoice6581.triangleWave[i] = (int)val;
            SIDVoice6581.triangleWave[i + 22000] = (int)(4095.0 - val);
            SIDVoice6581.triangleWaveD2[i] = (int)(val / 2.0);
            SIDVoice6581.triangleWaveD2[i + 22000] = (int)((4095.0 - val) / 2.0);
            val += dval;
        }
    }

    public void init() {
        this.wave = 0;
        this.sync = false;
        this.testBit = false;
        this.ring = false;
        this.nextSample = 0L;
        this.next_nextSample = 0L;
        this.next_frq = 0L;
        this.setControl(0, 0L);
    }

    public void setControl(int data, long cycles) {
        this.wave = data >> 4;
        boolean oldTest = this.testBit;
        boolean bl = this.testBit = (data & 8) != 0;
        if (oldTest && !this.testBit) {
            this.testZero = 0;
            this.nextSample = 0L;
            this.noise_reg = 0x7FFFF8L;
        }
        if ((data & 1) > 0) {
            this.soundOn(cycles);
        } else {
            this.soundOff(cycles);
        }
        this.sync = (data & 2) != 0;
        this.ring = (data & 4) != 0;
    }

    public void soundOn(long cycles) {
        if (!this.soundOn) {
            if ((this.sr & 0xF) > this.ad >> 4) {
                this.adsrBug = 1441;
            }
            this.currentAttackRate = this.attackDelta[(this.memory[this.sidbase + 5] & 0xF0) >> 4];
            this.decayFactor = this.decayExp[this.memory[this.sidbase + 5] & 0xF];
            this.releaseFactor = this.decayExp[this.memory[this.sidbase + 6] & 0xF];
            this.adsrSusLevel22 = (this.memory[this.sidbase + 6] & 0xF8) << 22;
            this.currentDecayFactor = this.decayFactor;
            this.adsrPhase = 1;
            this.lastAttackTime = cycles;
            this.soundOn = true;
        }
    }

    public void soundOff(long cycles) {
        this.adsrPhase = 4;
        this.soundOn = false;
        this.debugGen = false;
        this.currentDecayFactor = this.releaseFactor;
        this.adsrSusLevel22 = this.RELEASE_FINISH_LEVEL;
    }

    public void setAD(int data, long cycles) {
        this.currentAttackRate = this.attackDelta[(this.memory[this.sidbase + 5] & 0xF0) >> 4];
        this.decayFactor = this.decayExp[this.memory[this.sidbase + 5] & 0xF];
        this.ad = data;
        if (this.adsrPhase != 4) {
            if (this.currentDecayFactor > this.decayFactor) {
                this.adsrBug = 1441;
            }
            this.currentDecayFactor = this.decayFactor;
        }
    }

    public void setSR(int data, long cycles) {
        int tmp = (this.memory[this.sidbase + 6] & 0xF0) + 8 << 22;
        this.releaseFactor = this.decayExp[this.memory[this.sidbase + 6] & 0xF];
        this.sr = data;
        if (this.adsrPhase == 4) {
            if (this.currentDecayFactor > this.releaseFactor) {
                this.adsrBug = 1441;
            }
            this.currentDecayFactor = this.releaseFactor;
        } else if (this.adsrPhase == 3 && (long)tmp < this.adsrSusLevel22) {
            this.currentDecayFactor = this.releaseFactor;
            this.adsrPhase = 4;
        }
        this.adsrSusLevel22 = tmp;
    }

    public void reset() {
        this.init();
        this.soundOff(0L);
    }

    public void printStatus() {
        System.out.println("SID: " + this.getSIDNo() + " ----------------------------");
        System.out.println("Wave: " + WAVE[this.wave]);
        System.out.println("Frequency: " + this.frq + "  PWid:" + this.pwid + " " + this.trueFrq);
        System.out.println("ADSRLevel: " + (this.adsrLevel22 >> 22));
        System.out.println("ADSRPhase: " + ADSR_PHASES[this.adsrPhase]);
        System.out.println("AD reg: " + Integer.toString(this.memory[this.sidbase + 5], 16));
        System.out.println("SR reg: " + Integer.toString(this.memory[this.sidbase + 6], 16));
        System.out.println("WavePos: " + this.nextSample + " pulse => " + (this.nextSample < (long)this.pwid ? "0xfff" : "0"));
        if (this.ring) {
            System.out.println("RING MODULATION");
        }
        if (this.sync) {
            System.out.println("SYNCHRONIZATION");
        }
        if (this.testBit) {
            System.out.println("TEST BIT SET!");
        }
    }

    private int getSIDNo() {
        return (this.sidbase & 0xF) / 7;
    }

    @Override
    public int[] generateSound(long cycles) {
        this.updateSound(cycles);
        this.generated = 0;
        return this.outBuffer;
    }

    public void updatePulseWidth(long cycles) {
        if ((this.wave & 4) != 0 && this.lastCycles > 0L) {
            int pos = (int)((cycles - this.lastCycles) / 32L);
            this.pwidArr[pos % 44] = (((this.memory[this.sidbase + 3] & 0xF) << 8) + this.memory[this.sidbase + 2]) * 44000 / 4095;
        } else {
            this.pwid = (((this.memory[this.sidbase + 3] & 0xF) << 8) + this.memory[this.sidbase + 2]) * 44000 / 4095;
        }
    }

    public void updateSound(long cycles) {
        int i;
        this.lastCycles = cycles;
        this.frq = (int)(0.5 + (double)(16 * ((this.memory[this.sidbase + 1] << 8) + this.memory[this.sidbase])) * 0.058725380897521974);
        this.trueFrq = (double)(16 * ((this.memory[this.sidbase + 1] << 8) + this.memory[this.sidbase])) * 0.058725380897521974;
        this.pwid = (((this.memory[this.sidbase + 3] & 0xF) << 8) + this.memory[this.sidbase + 2]) * 44000 / 4095;
        if (frqFac != 16) {
            this.frq = this.frq * (long)frqFac >> 4;
            this.trueFrq = this.trueFrq * (double)frqFac / 16.0;
        }
        if (this.next != null) {
            this.next_frq = this.next.frq;
        }
        int bIndex = this.generated;
        switch (this.wave) {
            case 0: {
                for (i = 0; i < 44; ++i) {
                    this.intBuffer[bIndex++] = 4095;
                    this.nextSample = (this.nextSample + this.frq) % 704000L;
                }
                break;
            }
            case 1: {
                int i2;
                if (this.ring) {
                    boolean msb0 = false;
                    for (i2 = 0; i2 < 44; ++i2) {
                        msb0 = this.nextSample >= 352000L;
                        boolean msb = msb0 ^ this.next_nextSample >= 352000L;
                        long samp = this.nextSample;
                        if (msb0 != msb) {
                            samp += msb0 ? -352000L : 352000L;
                        }
                        this.intBuffer[bIndex++] = triangleWave[(int)(samp >> 4)];
                        this.nextSample = (this.nextSample + this.frq) % 704000L;
                        this.next_nextSample = (this.next_nextSample + this.next_frq) % 704000L;
                    }
                } else if (!this.sync) {
                    for (i = 0; i < 44; ++i) {
                        this.intBuffer[bIndex++] = triangleWave[(int)(this.nextSample >> 4)];
                        this.nextSample = (this.nextSample + this.frq) % 704000L;
                    }
                } else {
                    for (i = 0; i < 44; ++i) {
                        this.intBuffer[bIndex++] = triangleWave[(int)(this.nextSample >> 4)];
                        this.nextSample = (this.nextSample + this.frq) % 704000L;
                        this.next_nextSample += this.next_frq;
                        if (this.next_nextSample <= 704000L) continue;
                        this.nextSample = 0L;
                        this.next_nextSample -= 704000L;
                    }
                }
                break;
            }
            case 2: {
                if (!this.sync) {
                    for (i = 0; i < 44; ++i) {
                        this.intBuffer[bIndex++] = sawWave[(int)(this.nextSample >> 4)];
                        this.nextSample = (this.nextSample + this.frq) % 704000L;
                    }
                } else {
                    for (i = 0; i < 44; ++i) {
                        this.intBuffer[bIndex++] = sawWave[(int)(this.nextSample >> 4)];
                        this.nextSample = (this.nextSample + this.frq) % 704000L;
                        this.next_nextSample += this.next_frq;
                        if (this.next_nextSample <= 704000L) continue;
                        this.nextSample = 0L;
                        this.next_nextSample -= 704000L;
                    }
                }
                break;
            }
            case 3: {
                if (!this.sync) {
                    for (i = 0; i < 44; ++i) {
                        this.intBuffer[bIndex++] = this.ST_LOOKUP[sawWave[(int)(this.nextSample >> 4)]];
                        this.nextSample = (this.nextSample + this.frq) % 704000L;
                    }
                } else {
                    for (i = 0; i < 44; ++i) {
                        this.intBuffer[bIndex++] = this.ST_LOOKUP[sawWave[(int)(this.nextSample >> 4)]];
                        this.nextSample = (this.nextSample + this.frq) % 704000L;
                        this.next_nextSample += this.next_frq;
                        if (this.next_nextSample <= 704000L) continue;
                        this.nextSample = 0L;
                        this.next_nextSample -= 704000L;
                    }
                }
                break;
            }
            case 4: {
                if (!this.sync) {
                    for (i = 0; i < 44; ++i) {
                        if (this.pwidArr[i] != -1) {
                            this.pwid = this.pwidArr[i];
                            this.pwidArr[i] = -1;
                        }
                        this.intBuffer[bIndex++] = pulseWave[this.pwid + (int)(this.nextSample >> 4)];
                        this.nextSample = (this.nextSample + this.frq) % 704000L;
                    }
                } else {
                    for (i = 0; i < 44; ++i) {
                        if (this.pwidArr[i] != -1) {
                            this.pwid = this.pwidArr[i];
                            this.pwidArr[i] = -1;
                        }
                        this.intBuffer[bIndex++] = pulseWave[this.pwid + (int)(this.nextSample >> 4)];
                        this.nextSample = (this.nextSample + this.frq) % 704000L;
                        this.next_nextSample += this.next_frq;
                        if (this.next_nextSample <= 704000L) continue;
                        this.nextSample = 0L;
                        this.next_nextSample -= 704000L;
                    }
                }
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                int sam1;
                int[] lookupW;
                int[] lookup;
                if (this.wave == 6) {
                    lookup = this.PS_LOOKUP;
                    lookupW = sawWave;
                } else if (this.wave == 5) {
                    lookup = this.PT_LOOKUP;
                    lookupW = triangleWaveD2;
                } else {
                    lookup = this.PST_LOOKUP;
                    lookupW = sawWave;
                }
                if (!this.sync) {
                    for (i = 0; i < 44; ++i) {
                        if (this.pwidArr[i] != -1) {
                            this.pwid = this.pwidArr[i];
                            this.pwidArr[i] = -1;
                        }
                        sam1 = pulseWave[this.pwid + (int)(this.nextSample >> 4)];
                        this.intBuffer[bIndex++] = sam1 != 0 ? lookup[lookupW[(int)(this.nextSample >> 4)]] : 0;
                        this.nextSample = (this.nextSample + this.frq) % 704000L;
                    }
                } else {
                    for (i = 0; i < 44; ++i) {
                        if (this.pwidArr[i] != -1) {
                            this.pwid = this.pwidArr[i];
                            this.pwidArr[i] = -1;
                        }
                        sam1 = pulseWave[this.pwid + (int)(this.nextSample >> 4)];
                        this.intBuffer[bIndex++] = sam1 != 0 ? lookup[lookupW[(int)(this.nextSample >> 4)]] : 0;
                        this.nextSample = (this.nextSample + this.frq) % 704000L;
                        this.next_nextSample += this.next_frq;
                        if (this.next_nextSample <= 704000L) continue;
                        this.nextSample = 0L;
                        this.next_nextSample -= 704000L;
                    }
                }
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                int i2;
                int delay = 1375;
                for (i2 = 0; i2 < 44; ++i2) {
                    int newNoiseData = 0;
                    int loops = 0;
                    while (delay < 0) {
                        int bit0 = (int)(this.noise_reg >> 22 ^ this.noise_reg >> 17) & 1;
                        this.noise_reg <<= 1;
                        this.noise_reg &= 0x7FFFFFL;
                        this.noise_reg |= (long)bit0;
                        if (loops < 4) {
                            newNoiseData += (int)((this.noise_reg & 0x400000L) >> 11 | (this.noise_reg & 0x100000L) >> 10 | (this.noise_reg & 0x10000L) >> 7 | (this.noise_reg & 0x2000L) >> 5 | (this.noise_reg & 0x800L) >> 4 | (this.noise_reg & 0x80L) >> 1 | (this.noise_reg & 0x10L) << 1 | (this.noise_reg & 4L) << 2);
                            ++loops;
                        }
                        delay += 1375;
                    }
                    if (loops > 0) {
                        this.noiseData = newNoiseData / loops;
                    }
                    delay = (int)((long)delay - this.frq);
                    this.intBuffer[bIndex++] = this.noiseData;
                    this.nextSample = (this.nextSample + this.frq) % 704000L;
                }
                break;
            }
            default: {
                System.out.println("WAVE NOT IMPLEMENTED: " + this.wave);
            }
        }
        bIndex = this.generated;
        for (i = 0; i < 44; ++i) {
            if (this.adsrBug > 0) {
                --this.adsrBug;
            } else if (this.adsrPhase == 1) {
                this.adsrLevel22 += this.currentAttackRate;
                if (this.adsrLevel22 + (long)this.ATTACK_FUZZ > this.ATTACK_MAX) {
                    this.adsrLevel22 = this.ATTACK_MAX;
                    this.adsrPhase = 2;
                }
            } else if (this.adsrPhase == 2 || this.adsrPhase == 4) {
                ++this.decayTimes;
                this.adsrLevel22 = this.adsrLevel22 * this.currentDecayFactor >> 32;
                if (this.adsrLevel22 < this.adsrSusLevel22) {
                    if (this.adsrPhase == 2) {
                        this.decayTimes = 0;
                        this.adsrLevel22 = this.adsrSusLevel22;
                        this.adsrPhase = 3;
                    } else {
                        this.adsrSusLevel22 = 0L;
                        this.adsrPhase = 5;
                    }
                }
            }
            this.adsrVol = (int)(this.adsrLevel22 >> 22);
            this.adsrLevel = (double)(this.adsrLevel22 >> 22) / 255.0;
            if (this.testBit) {
                ++this.testZero;
                this.outBuffer[bIndex] = 0;
            } else {
                this.outBuffer[bIndex] = 1024 + (this.intBuffer[bIndex] * this.adsrVol >> 7);
            }
            ++bIndex;
        }
    }

    public int lastSample() {
        return this.intBuffer[this.smp++ % 44] >> 3 & 0xFF;
    }

    static {
        frqFac = 16;
    }
}

