/*
 * Decompiled with CFR 0.152.
 */
package com.dreamfabric.jsidplay;

public final class FastFourierTransform {
    private static int bitrev(int j, int nu) {
        int j1 = j;
        int k = 0;
        for (int i = 1; i <= nu; ++i) {
            int j2 = j1 / 2;
            k = 2 * k + j1 - 2 * j2;
            j1 = j2;
        }
        return k;
    }

    public static final float[] fftMag(float[] x) {
        float ti;
        float tr;
        int i;
        int n = x.length;
        int nu = (int)(Math.log(n) / Math.log(2.0));
        int n2 = n / 2;
        int nu1 = nu - 1;
        float[] xre = new float[n];
        float[] xim = new float[n];
        float[] mag = new float[n2];
        for (int i2 = 0; i2 < n; ++i2) {
            xre[i2] = x[i2];
            xim[i2] = 0.0f;
        }
        int k = 0;
        for (int l = 1; l <= nu; ++l) {
            while (k < n) {
                for (i = 1; i <= n2; ++i) {
                    float p = FastFourierTransform.bitrev(k >> nu1, nu);
                    float arg = (float)Math.PI * 2 * p / (float)n;
                    float c = (float)Math.cos(arg);
                    float s = (float)Math.sin(arg);
                    tr = xre[k + n2] * c + xim[k + n2] * s;
                    ti = xim[k + n2] * c - xre[k + n2] * s;
                    xre[k + n2] = xre[k] - tr;
                    xim[k + n2] = xim[k] - ti;
                    int n3 = k;
                    xre[n3] = xre[n3] + tr;
                    int n4 = k++;
                    xim[n4] = xim[n4] + ti;
                }
                k += n2;
            }
            k = 0;
            --nu1;
            n2 /= 2;
        }
        for (k = 0; k < n; ++k) {
            int r = FastFourierTransform.bitrev(k, nu);
            if (r <= k) continue;
            tr = xre[k];
            ti = xim[k];
            xre[k] = xre[r];
            xim[k] = xim[r];
            xre[r] = tr;
            xim[r] = ti;
        }
        mag[0] = (float)Math.sqrt(xre[0] * xre[0] + xim[0] * xim[0]) / (float)n;
        for (i = 1; i < n / 2; ++i) {
            mag[i] = 2.0f * (float)Math.sqrt(xre[i] * xre[i] + xim[i] * xim[i]) / (float)n;
        }
        return mag;
    }
}

