/*
 * Decompiled with CFR 0.152.
 */
package com.dreamfabric.jsidplay;

import com.dreamfabric.jac64.Hex;
import com.dreamfabric.jac64.IMonitor;
import com.dreamfabric.jac64.Loader;
import com.dreamfabric.jac64.MOS6510Core;
import com.dreamfabric.jac64.PatchListener;
import com.dreamfabric.jac64.TimeEvent;

public class JSCPU
extends MOS6510Core {
    public static final int IO_OFFSET = 12288;
    public static final int BASIC_ROM2 = 106496;
    public static final int KERNAL_ROM2 = 122880;
    public static final int CHAR_ROM2 = 118784;
    public boolean basicROM = true;
    public boolean kernalROM = true;
    public boolean charROM = false;
    public boolean ioON = true;
    private int romFlag = 40960;
    public boolean running = true;
    public boolean exit = false;
    private static final long CYCLES_PER_DEBUG = 100000000L;
    public static final boolean DEBUG = false;
    private static final long IO_UPDATE = 63L;
    private long nextIOUpdate = 0L;
    private Loader loader;
    private boolean freeze = false;

    public JSCPU(IMonitor m, String cb, Loader loader) {
        super(m, cb);
        this.loader = loader;
        this.memory = new int[131072];
    }

    private final void schedule(long cycles) {
        TimeEvent t;
        this.chips.clock(cycles);
        if (cycles >= this.scheduler.nextTime && (t = this.scheduler.popFirst()) != null) {
            t.execute(cycles);
        }
    }

    @Override
    protected final int fetchByte(int adr) {
        ++this.cycles;
        this.schedule(this.cycles);
        if ((this.romFlag & adr) == this.romFlag) {
            this.rindex = adr | 0x10000;
            return this.memory[this.rindex];
        }
        if ((adr & 0xF000) == 53248) {
            if (this.ioON) {
                this.rindex = adr;
                return this.chips.performRead(this.rindex, this.cycles);
            }
            if (this.charROM) {
                this.rindex = adr | 0x10000;
                return this.memory[this.rindex];
            }
            this.rindex = adr;
            return this.memory[this.rindex];
        }
        this.rindex = adr;
        return this.memory[this.rindex];
    }

    @Override
    public String getName() {
        return "jsidplay CPU";
    }

    private void fixRindex(int adr) {
        if (this.basicROM && (adr & 0xE000) == 40960 || this.kernalROM && (adr & 0xE000) == 57344 || this.charROM && (adr & 0xF000) == 53248) {
            adr |= 0x10000;
        }
        this.rindex = adr;
    }

    @Override
    protected final void writeByte(int adr, int data) {
        ++this.cycles;
        this.schedule(this.cycles);
        if (adr <= 1) {
            this.memory[adr] = data;
            int p = this.memory[0] ^ 0xFF | this.memory[1];
            this.kernalROM = (p & 2) == 2;
            this.basicROM = (p & 3) == 3;
            this.charROM = (p & 3) != 0 && (p & 4) == 0;
            boolean bl = this.ioON = (p & 3) != 0 && (p & 4) != 0;
            this.romFlag = this.basicROM ? 40960 : (this.kernalROM ? 57344 : 65536);
        }
        if (this.ioON && ((adr &= 0xFFFF) & 0xF000) == 53248) {
            this.chips.performWrite(adr, data, this.cycles);
        } else {
            this.memory[adr] = data;
        }
    }

    @Override
    public void patchROM(PatchListener list) {
        this.list = list;
        int pos = 128158;
        this.memory[pos++] = 32;
        this.memory[pos++] = 210;
        this.memory[pos++] = 245;
        System.out.println("Patched LOAD at: " + Hex.hex2(pos));
        this.memory[pos++] = 76;
        this.memory[pos++] = 96;
    }

    public void runBasic() {
        this.memory[631] = 82;
        this.memory[632] = 85;
        this.memory[633] = 78;
        this.memory[634] = 13;
        this.memory[198] = 4;
    }

    @Override
    protected void installROMS() {
        this.loadROM(this.loader.getResourceStream("/roms/kernal.c64"), 122880, 8192);
        this.loadROM(this.loader.getResourceStream("/roms/basic.c64"), 106496, 8192);
        this.loadROM(this.loader.getResourceStream("/roms/chargen.c64"), 118784, 4096);
    }

    public void run(int address) {
        this.reset();
        this.exit = false;
        this.running = true;
        this.loop(address);
    }

    public void start() {
        while (!this.exit) {
            this.run(64738);
            if (this.exit) continue;
            this.monitor.info("Resetting!!!!");
            this.reset();
        }
        System.out.println("CPU Thread exited...");
    }

    public void stop() {
        this.running = false;
        this.exit = true;
        this.chips.stop();
    }

    @Override
    public void reset() {
        this.running = false;
        this.exit = false;
        this.writeByte(1, 7);
        this.unfreeze();
        this.chips.reset();
        super.reset();
    }

    public void freeze() {
        this.freeze = true;
    }

    public void unfreeze() {
        this.freeze = false;
    }

    public void loop(int startAdress) {
        this.pc = startAdress;
        boolean wasdebug = false;
        long next_print = this.cycles + 100000000L;
        this.monitor.info("Starting CPU at: " + Integer.toHexString(this.pc));
        try {
            while (this.running) {
                if (this.monitor.isEnabled()) {
                    this.fixRindex(this.pc);
                    this.monitor.disAssemble(this.memory, this.rindex, this.acc, this.x, this.y, (byte)this.getStatusByte(), this.interruptInExec, this.lastInterrupt);
                }
                this.emulateOp();
                while (this.freeze) {
                    Thread.currentThread();
                    Thread.sleep(100L);
                }
                if (this.nextIOUpdate < this.cycles) {
                    this.chips.clock(this.cycles);
                    this.nextIOUpdate += 63L;
                    if (next_print < this.cycles) {
                        long sec = System.currentTimeMillis() - this.lastMillis;
                        int level = this.monitor.getLevel();
                        if (level > 1) {
                            this.monitor.info("--------------------------");
                            this.monitor.info("Nr ins:" + this.nr_ins + " sec:" + sec + " -> " + this.nr_ins * 1000L / sec + " ins/s   clk: " + this.cycles + " clk/s: " + 100000000000L / sec + "\n" + this.nr_irq * 1000L / sec);
                            if (level > 2) {
                                this.monitor.disAssemble(this.memory, this.rindex, this.acc, this.x, this.y, (byte)this.getStatusByte(), this.interruptInExec, this.lastInterrupt);
                            }
                            this.monitor.info("--------------------------");
                        }
                        this.nr_irq = 0L;
                        this.nr_ins = 0L;
                        this.lastMillis = System.currentTimeMillis();
                        next_print = this.cycles + 100000000L;
                    }
                }
                ++this.nr_ins;
            }
        }
        catch (Exception e) {
            this.monitor.error("Exception in loop " + this.pc + " : " + e);
            e.printStackTrace();
            this.monitor.disAssemble(this.memory, this.rindex, this.acc, this.x, this.y, (byte)this.getStatusByte(), this.interruptInExec, this.lastInterrupt);
        }
    }
}

