/*
 * Decompiled with CFR 0.152.
 */
package com.dreamfabric.jsidplay;

import com.dreamfabric.jac64.VICConstants;
import com.dreamfabric.jsidplay.FastFourierTransform;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;

public class SIDMixerDisplay
extends JComponent {
    private static final int SAMPLE_SIZE = 512;
    private static final int STEP_SIZE = 4;
    private int[] sampleBuffer = new int[512];
    private int samplePos = 0;
    private boolean fftDone = false;
    private float[] fSamples = new float[512];
    private float[] fft;
    private static int[] COLOR_SET = VICConstants.COLOR_SETS[2];
    private static final Color PENCOLOR = new Color(COLOR_SET[14]);
    private static final Color BORDERCOLOR = new Color(COLOR_SET[6]);

    public SIDMixerDisplay() {
        this.setBackground(BORDERCOLOR);
        this.setForeground(PENCOLOR);
        this.setDoubleBuffered(true);
        this.setOpaque(true);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(240, 32);
    }

    public void updateSamples(int[] samples, int count) {
        int n = count;
        for (int i = 0; i < n; i += 2) {
            this.samplePos = (this.samplePos + 1) % 512;
            this.sampleBuffer[this.samplePos] = samples[i];
        }
        this.fftDone = false;
    }

    private void doFFT() {
        if (!this.fftDone) {
            int n = 512;
            for (int i = 0; i < n; ++i) {
                this.fSamples[i] = this.sampleBuffer[i];
            }
            this.fft = FastFourierTransform.fftMag(this.fSamples);
            this.fftDone = true;
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        int i;
        this.doFFT();
        int height = this.getHeight();
        int width = this.getWidth() - 4;
        float w = (float)width * 0.49f / 128.0f;
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), height);
        g.setColor(this.getForeground());
        int last = height * this.sampleBuffer[this.samplePos % 512] / 16000;
        int n = 511;
        for (i = 0; i < n; i += 4) {
            int x = 2 + (int)(w * (float)(i / 4));
            int n2 = height / 2 - last;
            last = height * this.sampleBuffer[(this.samplePos + i + 1) % 512] / 16000;
            g.drawLine(x, n2, x + 1, height / 2 - last);
        }
        this.fft[0] = 0.0f;
        n = this.fft.length * 2 / 4;
        for (i = 0; i < n; ++i) {
            int fftI = (int)((double)this.fft[i] / 20.0);
            int x = 4 + width / 2 + (int)(w * (float)i);
            g.fillRect(x, height - fftI, 1, fftI);
        }
    }
}

