/*
 * Decompiled with CFR 0.152.
 */
package com.dreamfabric.jsidplay;

import com.dreamfabric.gui.DCheckBox;
import com.dreamfabric.gui.DKnob2;
import com.dreamfabric.jac64.SIDMixer;
import com.dreamfabric.jac64.SIDMixerListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.RenderingHints;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SIDMixerFront
implements ChangeListener,
SIDMixerListener {
    private JPanel panel = new JPanel(new GridLayout(2, 1));
    private DKnob2 delay;
    private DKnob2 feedback;
    private DKnob2 lfoDepth;
    private DKnob2 lfoSpeed;
    private DKnob2 wetDryMix;
    private DKnob2 filterCutoff;
    private DKnob2 filterResonance;
    private DKnob2 filterLFODepth;
    private DKnob2 filterLFOSpeed;
    private DKnob2 volume;
    private DCheckBox delayUnitOn;
    private DCheckBox filterOn;
    private SIDMixer mixer;
    private static final RenderingHints AALIAS = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);

    public SIDMixerFront(SIDMixer delayUnit) {
        JPanel panel = new JPanel(new BorderLayout(2, 4));
        JPanel jp = new JPanel(new GridLayout(1, 5));
        panel.setBackground(new Color(205, 205, 190));
        jp.setBackground(new Color(205, 205, 190));
        panel.setBorder(new SoftBevelBorder(0));
        JLabel jl = new JLabel(" SIDMixer Delay Unit"){

            @Override
            public void paint(Graphics g) {
                if (g instanceof Graphics2D) {
                    Graphics2D g2d = (Graphics2D)g;
                    g2d.addRenderingHints(AALIAS);
                }
                super.paint(g);
            }
        };
        jl.setForeground(new Color(128, 64, 64));
        jl.setFont(new Font("sans-serif", 3, 11));
        JPanel labPanel = new JPanel(new BorderLayout());
        labPanel.setOpaque(false);
        labPanel.add((Component)this.makeLabel("Delay On:"), "Center");
        this.delayUnitOn = new DCheckBox();
        labPanel.add((Component)this.delayUnitOn, "East");
        this.delayUnitOn.addChangeListener(this);
        JPanel epanel = new JPanel(new BorderLayout());
        epanel.setOpaque(false);
        epanel.add((Component)jl, "West");
        epanel.add((Component)labPanel, "East");
        panel.add((Component)epanel, "North");
        panel.add((Component)jp, "Center");
        this.delay = new DKnob2("Delay", "ms");
        jp.add(this.delay);
        this.delay.setInterval(1, 50, 2000);
        this.feedback = new DKnob2("Feedback", "%");
        jp.add(this.feedback);
        this.lfoDepth = new DKnob2("LFO Depth", "%");
        jp.add(this.lfoDepth);
        this.lfoSpeed = new DKnob2("LFO Speed", "Hz");
        jp.add(this.lfoSpeed);
        this.lfoSpeed.setInterval(1, 100);
        this.lfoSpeed.setDivisor(10);
        this.wetDryMix = new DKnob2("Wet/Dry Mix");
        jp.add(this.wetDryMix);
        this.wetDryMix.setValue(0.5f);
        this.delay.addChangeListener(this);
        this.feedback.addChangeListener(this);
        this.lfoSpeed.addChangeListener(this);
        this.lfoDepth.addChangeListener(this);
        this.wetDryMix.addChangeListener(this);
        if (delayUnit != null) {
            delayUnit.setListener(this);
            this.mixer = delayUnit;
        }
        this.panel.add(panel);
        panel = new JPanel(new BorderLayout(2, 4));
        jp = new JPanel(new GridLayout(1, 5));
        panel.setBackground(new Color(205, 205, 190));
        jp.setBackground(new Color(205, 205, 190));
        panel.setBorder(new SoftBevelBorder(0));
        jl = this.makeLabel(" SIDMixer Filter Sweep and Volume");
        labPanel = new JPanel(new BorderLayout());
        labPanel.setOpaque(false);
        labPanel.add((Component)this.makeLabel("Filter On:"), "Center");
        this.filterOn = new DCheckBox();
        labPanel.add((Component)this.filterOn, "East");
        this.filterOn.addChangeListener(this);
        epanel = new JPanel(new BorderLayout());
        epanel.setOpaque(false);
        epanel.add((Component)jl, "West");
        epanel.add((Component)labPanel, "East");
        panel.add((Component)epanel, "North");
        panel.add((Component)jp, "Center");
        this.filterCutoff = new DKnob2("Cutoff", "Hz");
        jp.add(this.filterCutoff);
        this.filterCutoff.setInterval(0, 8000);
        this.filterCutoff.setIntValue(4000);
        this.mixer.setMoogCutoff(4000);
        this.filterResonance = new DKnob2("Resonance", "");
        jp.add(this.filterResonance);
        this.filterResonance.setInterval(0, 100);
        this.filterResonance.setDivisor(100);
        this.filterLFODepth = new DKnob2("LFO Depth", "");
        jp.add(this.filterLFODepth);
        this.filterLFOSpeed = new DKnob2("LFO Speed", "Hz");
        jp.add(this.filterLFOSpeed);
        this.filterLFOSpeed.setInterval(1, 100);
        this.filterLFOSpeed.setDivisor(10);
        this.volume = new DKnob2("Volume");
        jp.add(this.volume);
        this.volume.setValue(0.5f);
        this.volume.addChangeListener(this);
        this.filterResonance.addChangeListener(this);
        this.filterCutoff.addChangeListener(this);
        this.filterLFOSpeed.addChangeListener(this);
        this.filterLFODepth.addChangeListener(this);
        this.panel.add(panel);
        this.updateValues();
    }

    private JLabel makeLabel(String label) {
        JLabel jl = new JLabel(label){

            @Override
            public void paint(Graphics g) {
                if (g instanceof Graphics2D) {
                    Graphics2D g2d = (Graphics2D)g;
                    g2d.addRenderingHints(AALIAS);
                }
                super.paint(g);
            }
        };
        jl.setForeground(new Color(128, 64, 64));
        jl.setFont(new Font("sans-serif", 3, 11));
        return jl;
    }

    public JPanel getPanel() {
        return this.panel;
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        if (this.mixer == null) {
            return;
        }
        Object src = ce.getSource();
        if (src == this.delay) {
            this.mixer.setEchoTime(this.delay.getIntValue());
        } else if (src == this.feedback) {
            this.mixer.setEchoFeedback(this.feedback.getIntValue());
        } else if (src == this.lfoSpeed) {
            this.mixer.setEchoLFOSpeed(this.lfoSpeed.getIntValue());
        } else if (src == this.lfoDepth) {
            this.mixer.setEchoLFODepth(this.lfoDepth.getIntValue());
        } else if (src == this.wetDryMix) {
            this.mixer.setEchoDW(this.wetDryMix.getIntValue());
        } else if (src == this.delayUnitOn) {
            this.mixer.setEffectsOn(this.delayUnitOn.isSelected());
        } else if (src != this.volume) {
            if (src == this.filterOn) {
                this.mixer.setMoogFilterOn(this.filterOn.isSelected());
            } else if (src == this.filterResonance) {
                this.mixer.setMoogResonance(this.filterResonance.getIntValue());
            } else if (src == this.filterCutoff) {
                this.mixer.setMoogCutoff(this.filterCutoff.getIntValue());
            } else if (src == this.filterLFOSpeed) {
                this.mixer.setMoogSpeed(this.filterLFOSpeed.getIntValue());
            } else if (src == this.filterLFODepth) {
                this.mixer.setMoogDepth(this.filterLFODepth.getIntValue());
            }
        }
    }

    @Override
    public void updateValues() {
        this.delay.setIntValue(this.mixer.getEchoTime());
        this.feedback.setIntValue(this.mixer.getEchoFeedback());
        this.lfoSpeed.setIntValue(this.mixer.getEchoLFOSpeed());
        this.lfoDepth.setIntValue(this.mixer.getEchoLFODepth());
        this.wetDryMix.setIntValue(this.mixer.getEchoDW());
        this.delayUnitOn.setSelected(this.mixer.isEffectsOn());
        this.filterCutoff.setIntValue(this.mixer.getMoogCutoff());
        this.filterResonance.setIntValue(this.mixer.getMoogResonance());
        this.filterLFODepth.setIntValue(this.mixer.getMoogDepth());
        this.filterLFOSpeed.setIntValue(this.mixer.getMoogSpeed());
        this.filterOn.setSelected(this.mixer.isMoogFilterOn());
    }

    public static void main(String[] args) {
        SIDMixerFront front = new SIDMixerFront(null);
        JFrame win = new JFrame("Delay Unit Test!");
        win.getContentPane().setLayout(new BorderLayout());
        win.setSize(320, 140);
        win.getContentPane().add((Component)front.getPanel(), "Center");
        win.setVisible(true);
    }
}

