/*
 * Decompiled with CFR 0.152.
 */
package com.vwp.sound.mod.modplay;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Vector;

public class PlayList
implements Iterator {
    private Vector list;
    private int position;
    private String playListName = "no-name";

    public PlayList(String fileName) throws IOException {
        this.playListName = fileName;
        LineNumberReader lnr = new LineNumberReader(new FileReader(fileName));
        this.loadList(lnr);
    }

    public PlayList(String[] modules) throws IOException {
        StringBuffer sb = new StringBuffer();
        int n = 0;
        while (n < modules.length) {
            sb.append(modules[n]);
            sb.append("\n");
            ++n;
        }
        LineNumberReader lnr = new LineNumberReader(new StringReader(sb.toString()));
        this.loadList(lnr);
    }

    private void loadList(LineNumberReader lnr) throws IOException {
        this.position = -1;
        this.list = new Vector();
        String line = null;
        while ((line = lnr.readLine()) != null) {
            File file = new File(line = line.trim());
            if (!file.exists() || !file.isFile()) continue;
            this.list.add(line);
        }
    }

    public String getPlayListName() {
        return this.playListName;
    }

    public boolean hasNext() {
        return this.position + 1 < this.list.size();
    }

    public Object next() {
        if (this.hasNext()) {
            return this.list.elementAt(++this.position);
        }
        throw new NoSuchElementException();
    }

    public String nextFileName() {
        return (String)this.next();
    }

    public void remove() {
        this.list.removeElementAt(this.position);
    }

    public int getNumberOfFileNames() {
        return this.list.size();
    }

    public String getRandomFileName() {
        int pos = (int)(Math.random() * (double)this.list.size());
        this.position = pos - 1;
        return this.nextFileName();
    }
}

