/*
 * Decompiled with CFR 0.152.
 */
package com.vwp.sound.mod.modplay.loader;

import com.vwp.sound.mod.modplay.loader.InvalidFormatException;
import com.vwp.sound.mod.modplay.loader.ModuleLoader;
import com.vwp.sound.mod.modplay.loader.S3MUnits;
import com.vwp.sound.mod.modplay.module.Instrument;
import com.vwp.sound.mod.modplay.module.Module;
import com.vwp.sound.mod.modplay.module.Pattern;
import com.vwp.sound.mod.modplay.module.Sample;
import com.vwp.sound.mod.modplay.module.Track;
import com.vwp.sound.mod.modplay.player.autoeffect.AutoEffect;
import com.vwp.sound.mod.util.io.RandomAccess;
import com.vwp.sound.mod.util.io.RandomAccessArray;
import java.io.IOException;
import java.util.ArrayList;

public class ITLoader
extends ModuleLoader {
    private Module module;

    public ITLoader(String name, byte[] data) throws IOException, InvalidFormatException {
        this.load(name, new RandomAccessArray(data));
    }

    private void load(String name, RandomAccess ra) throws IOException, InvalidFormatException {
        String id = ra.readString(4);
        String modName = ra.readZeroPaddedString(26);
        ra.skipBytes(2);
        int positionCount = ra.readUnsignedShort();
        int instrumentCount = ra.readUnsignedShort();
        int sampleCount = ra.readUnsignedShort();
        int patternCount = ra.readUnsignedShort();
        short trackerVersion = ra.readShort();
        int trackerMinor = (trackerVersion & 0xFF00) >> 8;
        int trackerMajor = trackerVersion & 0xFF;
        String tracker = "ImpulseTracker " + trackerMajor + "." + trackerMinor;
        short compatVersoin = ra.readShort();
        int compatMinor = (compatVersoin & 0xFF00) >> 8;
        int compatMajor = compatVersoin & 0xFF;
        String cfr_ignored_0 = String.valueOf(compatMajor) + "." + compatMinor;
        ra.readUnsignedShort();
        int special = ra.readUnsignedShort();
        boolean hasSongMessage = (special & 1) > 0;
        double gVolume = (double)ra.readUnsignedByte() / 128.0;
        double mixVolume = (double)ra.readUnsignedByte() / 128.0;
        double globalVolume = gVolume * mixVolume;
        int speed = ra.readUnsignedByte();
        int tempo = ra.readUnsignedByte();
        ra.readUnsignedByte();
        ra.readUnsignedByte();
        int messageLenght = ra.readUnsignedShort();
        int messageOffset = ra.readUnsignedInt();
        String message = hasSongMessage ? this.readMessage(ra, messageOffset, messageLenght) : null;
        ra.skipBytes(4);
        double[] panning = new double[64];
        int n = 0;
        while (n < panning.length) {
            int p = ra.readUnsignedByte();
            if ((p & 0x80) > 0) {
                p &= 0xFFFFFF7F;
            } else if (p == 100) {
                p = 0;
            }
            panning[n] = (double)(n - 32) / 32.0;
            ++n;
        }
        double[] volume = new double[64];
        int n2 = 0;
        while (n2 < volume.length) {
            volume[n2] = (double)ra.readUnsignedByte() / 64.0;
            ++n2;
        }
        int[] positions = new int[positionCount];
        int n3 = 0;
        while (n3 < positions.length) {
            positions[n3] = ra.readUnsignedByte();
            ++n3;
        }
        int instrumentOffset = ra.readUnsignedInt();
        int sampleOffset = ra.readUnsignedInt();
        int patternOffset = ra.readUnsignedInt();
        ra.seek(sampleOffset);
        Sample[] samples = this.loadSamples(ra, sampleCount);
        ra.seek(instrumentOffset);
        Instrument[] instruments = this.loadInstruments(ra, instrumentCount, samples);
        ra.seek(patternOffset);
        Pattern[] patterns = this.loadPatterns(ra, patternCount);
        this.module = new Module(modName, id, tracker, instruments, patterns, positions, 0, tempo, speed, globalVolume, 0, volume, panning);
        this.module.setDescription(message);
    }

    public Module getModule() {
        return this.module;
    }

    private String readMessage(RandomAccess ra, int offset, int length) throws IOException {
        long pos = ra.getPosition();
        ra.seek(offset);
        String msg = ra.readZeroPaddedString(length);
        char[] cmsg = msg.toCharArray();
        int i = 0;
        while (i < cmsg.length) {
            if (cmsg[i] == '\r') {
                cmsg[i] = 10;
            }
            ++i;
        }
        ra.seek(pos);
        return new String(cmsg);
    }

    private Sample[] loadSamples(RandomAccess ra, int sampleCount) throws IOException, InvalidFormatException {
        ArrayList<Sample> samples = new ArrayList<Sample>();
        int n = 0;
        while (n < sampleCount) {
            samples.add(this.loadSample(ra));
            ++n;
        }
        return samples.toArray(new Sample[0]);
    }

    private Sample loadSample(RandomAccess ra) throws IOException, InvalidFormatException {
        String id = ra.readString(4);
        if (!id.equals("IMPS")) {
            throw new InvalidFormatException("Sample ID should be 'IMPS', was '" + id + "'");
        }
        ra.readString(12);
        ra.readUnsignedByte();
        ra.readUnsignedByte();
        int flags = ra.readUnsignedByte();
        this.isEnabled(flags, 0);
        boolean bits16 = this.isEnabled(flags, 1);
        this.isEnabled(flags, 2);
        this.isEnabled(flags, 3);
        boolean loop = this.isEnabled(flags, 4);
        this.isEnabled(flags, 5);
        boolean pingPongLoop = this.isEnabled(flags, 6);
        this.isEnabled(flags, 7);
        double volume = (double)ra.readUnsignedByte() / 64.0;
        String name = ra.readZeroPaddedString(26);
        boolean signedSampleData = this.isEnabled(ra.readUnsignedByte(), 0);
        int pan = ra.readUnsignedByte();
        this.isEnabled(pan, 7);
        double panning = (double)this.clear(pan, 7) / 64.0;
        int length = ra.readUnsignedInt();
        int loopStart = ra.readUnsignedInt();
        int loopEnd = ra.readUnsignedInt();
        int c5speed = ra.readUnsignedByte();
        ra.readUnsignedInt();
        ra.readUnsignedInt();
        int samplePointer = ra.readUnsignedInt();
        ra.readUnsignedByte();
        ra.readUnsignedByte();
        ra.readUnsignedByte();
        ra.readUnsignedByte();
        int loopType = loop ? (pingPongLoop ? 2 : 1) : 0;
        Sample s = new Sample(id, name, volume, panning, length, loopType, loopStart, loopEnd, 0.0, 0.0, new S3MUnits(c5speed, false));
        long currentPos = ra.getPosition();
        ra.seek(samplePointer);
        s.setData(this.loadSampleData(ra, length, signedSampleData, bits16));
        ra.seek(currentPos);
        return s;
    }

    private short[] loadSampleData(RandomAccess ra, int length, boolean singed, boolean bits16) {
        return new short[0];
    }

    private Instrument[] loadInstruments(RandomAccess ra, int instrumentCount, Sample[] samples) {
        Instrument[] instruments = new Instrument[instrumentCount];
        int n = 0;
        while (n < instruments.length) {
            instruments[n] = new Instrument("", new int[0], samples, new AutoEffect[0], 0.0);
            ++n;
        }
        return instruments;
    }

    private Pattern[] loadPatterns(RandomAccess ra, int patternCount) {
        Track[] tracks = new Track[64];
        int n = 0;
        while (n < tracks.length) {
            tracks[n] = new Track(1);
            ++n;
        }
        Pattern[] patterns = new Pattern[patternCount];
        int n2 = 0;
        while (n2 < patterns.length) {
            patterns[n2] = new Pattern(tracks, 1);
            ++n2;
        }
        return patterns;
    }

    private boolean isEnabled(int flags, int bit) {
        return (flags & 1 << bit) > 0;
    }

    private int clear(int flags, int bit) {
        return flags & ~(1 << bit);
    }
}

