/*
 * Decompiled with CFR 0.152.
 */
package com.vwp.sound.mod.modplay.loader;

import com.vwp.sound.mod.modplay.module.ModuleUnits;

public class ModUnits
implements ModuleUnits {
    public static final String NAME = "mod";
    private static double maxNote;
    private static double minNote;
    private static double minPeriod;
    private static double maxPeriod;
    private static double ac;
    public static final double TRADITIONAL_MAX_PERIOD = 856.0;
    public static final double TRADITIONAL_MIN_PERIOD = 113.0;
    public static final double NEW_MAX_PERIOD = 1712.0;
    public static final double NEW_MIN_PERIOD = 57.0;
    public static final double PAL = 7093789.2;
    public static final double NTSC = 7159090.5;

    public ModUnits(double amigaClock, boolean traditional) {
        ac = amigaClock;
        if (traditional) {
            minPeriod = 113.0;
            maxPeriod = 856.0;
            maxNote = this.period2note(minPeriod);
            minNote = this.period2note(maxPeriod);
        } else {
            minPeriod = 57.0;
            maxPeriod = 1712.0;
            maxNote = this.period2note(minPeriod);
            minNote = this.period2note(maxPeriod);
        }
    }

    public double period2rate(double period) {
        return ac / (2.0 * period);
    }

    public double rate2period(double rate) {
        return ac / (2.0 * rate);
    }

    public double period2note(double period) {
        return this.rate2note(this.period2rate(period));
    }

    public double note2period(double note) {
        return this.rate2period(this.note2rate(note));
    }

    public double note2rate(double note) {
        double c0rate = ac / (2.0 * maxPeriod);
        return c0rate * Math.pow(2.0, note / 12.0);
    }

    public double rate2note(double rate) {
        double c0rate = ac / (2.0 * maxPeriod);
        return 12.0 * Math.log(rate / c0rate) / Math.log(2.0);
    }

    public double addPeriod(double note, double period) {
        return this.period2note(this.note2period(note) + period);
    }

    public double getUpperNoteLimit() {
        return maxNote;
    }

    public double getLowerNoteLimit() {
        return minNote;
    }

    public double getAmigaClock() {
        return ac;
    }

    public String getName() {
        return NAME;
    }
}

