/*
 * Decompiled with CFR 0.152.
 */
package com.vwp.sound.mod.modplay.module;

import com.vwp.sound.mod.modplay.loader.InvalidFormatException;
import com.vwp.sound.mod.modplay.module.ModInfo;
import com.vwp.sound.mod.modplay.module.S3MInfo;
import com.vwp.sound.mod.modplay.module.XMInfo;
import com.vwp.sound.mod.util.io.RandomAccess;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public abstract class ModuleInfo {
    private String type;
    private String fileName;
    private String name;
    private String id;
    private String tracker;
    private int instrumentCount;
    private int trackCount;
    private int patternCount;
    private int positionCount;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        if (this.name.trim().length() > 0) {
            return this.name;
        }
        return new File(this.getFileName()).getName();
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void setTracker(String tracker) {
        this.tracker = tracker;
    }

    public String getTracker() {
        return this.tracker;
    }

    public void setInstrumentCount(int instrumentCount) {
        this.instrumentCount = instrumentCount;
    }

    public int getInstrumentCount() {
        return this.instrumentCount;
    }

    public void setPatternCount(int patternCount) {
        this.patternCount = patternCount;
    }

    public int getPatternCount() {
        return this.patternCount;
    }

    public void setPositionCount(int positionCount) {
        this.positionCount = positionCount;
    }

    public int getPositionCount() {
        return this.positionCount;
    }

    public void setTrackCount(int trackCount) {
        this.trackCount = trackCount;
    }

    public int getTrackCount() {
        return this.trackCount;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public static ModuleInfo get(String file) throws InvalidFormatException, FileNotFoundException {
        ModuleInfo info = null;
        if (file.toLowerCase().endsWith(".mod")) {
            info = new ModInfo();
        } else if (file.toLowerCase().endsWith(".xm")) {
            info = new XMInfo();
        } else if (file.toLowerCase().endsWith(".s3m")) {
            info = new S3MInfo();
        }
        ((ModuleInfo)info).load(file);
        return info;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ModuleInfo)) {
            return false;
        }
        ModuleInfo mi = (ModuleInfo)o;
        return this.getFileName().equals(mi.getFileName());
    }

    protected abstract void load(String var1) throws InvalidFormatException, FileNotFoundException;

    public String toString() {
        return String.valueOf(ModuleInfo.pad("[" + this.getType() + "]", 5, ' ', true)) + "  " + ModuleInfo.pad(ModuleInfo.shorten(this.getName().trim(), 25), 25, ' ', true) + " " + ModuleInfo.pad(String.valueOf(this.getPositionCount()), 4, ' ', false);
    }

    private static String pad(String str, int len, char padding, boolean left) {
        StringBuffer sb = new StringBuffer();
        sb.append(str);
        int count = str.length();
        while (count++ < len) {
            if (left) {
                sb.append(padding);
                continue;
            }
            sb.insert(0, padding);
        }
        return sb.toString();
    }

    private static String shorten(String str, int maxLen) {
        if (str.length() <= maxLen) {
            return str;
        }
        return String.valueOf(str.substring(0, maxLen - 3)) + "...";
    }

    protected String readStringZ(RandomAccess raf, int len) throws IOException {
        int count = len;
        int data = -1;
        StringBuffer sb = new StringBuffer();
        while (count-- > 0 && (data = raf.read()) != 0) {
            sb.append((char)data);
        }
        return sb.toString();
    }

    protected int readShort(RandomAccess raf) throws IOException {
        int b2 = raf.readUnsignedByte();
        int b1 = raf.readUnsignedByte();
        return (b1 << 8) + b2;
    }
}

