/*
 * Decompiled with CFR 0.152.
 */
package com.vwp.sound.mod.sound.output;

import com.vwp.sound.mod.modplay.player.PlayerException;
import com.vwp.sound.mod.sound.output.Output;
import com.vwp.sound.mod.sound.output.SoundDataFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;

public class JavaSoundOutput
implements Output {
    private int[] supportedRates = new int[]{11025, 22050, 44100};
    private int[] supportedBits = new int[]{8, 16};
    private int[] supportedChannels = new int[]{1, 2};
    private SoundDataFormat format;
    private SourceDataLine sdl;
    private AudioFormat af;
    private boolean opened = false;
    private int bufferTime;
    private boolean signed = true;
    private boolean bigendian = false;
    private long deliveredData = 0L;
    byte[] mixbuffer = new byte[1000];
    static /* synthetic */ Class class$0;

    public JavaSoundOutput(SoundDataFormat format, int bufferTime) throws PlayerException {
        this.bufferTime = bufferTime;
        this.format = format;
        this.init();
    }

    public boolean supports(SoundDataFormat format) {
        boolean rateSupported = false;
        int rate = format.getRate();
        int n = 0;
        while (n < this.supportedRates.length) {
            if (this.supportedRates[n] == rate) {
                rateSupported = true;
            }
            ++n;
        }
        boolean bitsSupported = false;
        int bits = format.getBits();
        int n2 = 0;
        while (n2 < this.supportedBits.length) {
            if (this.supportedBits[n2] == bits) {
                bitsSupported = true;
            }
            ++n2;
        }
        boolean channelsSupported = false;
        int channels = format.getChannels();
        int n3 = 0;
        while (n3 < this.supportedChannels.length) {
            if (this.supportedChannels[n3] == channels) {
                channelsSupported = true;
            }
            ++n3;
        }
        return rateSupported && bitsSupported && channelsSupported;
    }

    public SoundDataFormat getFormat() {
        return this.format;
    }

    private void init() throws PlayerException {
        Line l;
        DataLine.Info dli;
        if (!this.supports(this.format)) {
            throw new PlayerException("data format not supported: " + this.format);
        }
        this.af = new AudioFormat(this.format.getRate(), this.format.getBits(), this.format.getChannels(), this.signed, this.bigendian);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("javax.sound.sampled.SourceDataLine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (AudioSystem.isLineSupported(dli = new DataLine.Info(clazz, this.af))) {
            l = null;
            try {
                l = AudioSystem.getLine(dli);
            }
            catch (LineUnavailableException lineUnavailableException) {
                throw new PlayerException("Can't get line");
            }
            if (!(l instanceof SourceDataLine)) {
                throw new PlayerException("line not a SourceDataLine!");
            }
        } else {
            throw new PlayerException("Line not supported");
        }
        this.sdl = (SourceDataLine)l;
        if (this.sdl == null) {
            throw new PlayerException("line not found");
        }
    }

    public boolean isOpen() {
        return this.opened;
    }

    public boolean open() {
        boolean res = true;
        this.opened = true;
        try {
            this.sdl.open(this.af);
            this.sdl.start();
        }
        catch (Exception exception) {
            res = false;
            this.opened = false;
        }
        return res;
    }

    public boolean close() {
        boolean res = true;
        try {
            this.sdl.stop();
            this.sdl.close();
        }
        catch (Exception exception) {
            System.err.println("Could not close or stop SoundDataLine: " + this.sdl);
            res = false;
        }
        this.opened = false;
        return res;
    }

    public int write(byte[] data, int ofs, int len) {
        int maxTries = 10;
        int totWrite = 0;
        int nofs = ofs;
        int nlen = len;
        while (nofs < ofs + len && maxTries > 0) {
            int written = 0;
            written = this.format.getBits() == 16 && this.format.getChannels() == 2 && this.format.getRate() == 44100 ? this.sdl.write(data, nofs, nlen) : this.writeConv(data, nofs, nlen);
            nofs += written;
            nlen -= written;
            totWrite += written;
            --maxTries;
            this.deliveredData += (long)written;
            int deliveredTime = (int)(1000L * this.deliveredData / 176400L);
            long pos = this.sdl.getMicrosecondPosition() / 1000L;
            long sleepTime = (long)deliveredTime - pos - (long)this.bufferTime;
            if (sleepTime < 0L) {
                sleepTime = 0L;
            }
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException interruptedException) {}
        }
        return totWrite;
    }

    protected int writeConv(byte[] data, int ofs, int len) {
        double grad = 44100.0 / (double)this.format.getRate();
        int length = 0;
        if (this.format.getBits() == 8 && this.format.getChannels() == 1) {
            length = this.mono8(data, ofs, len, grad);
        } else if (this.format.getBits() == 8 && this.format.getChannels() == 2) {
            length = this.stereo8(data, ofs, len, grad);
        } else if (this.format.getBits() == 16 && this.format.getChannels() == 1) {
            length = this.mono16(data, ofs, len, grad);
        } else if (this.format.getBits() == 16 && this.format.getChannels() == 2) {
            length = this.stereo16(data, ofs, len, grad);
        }
        return length;
    }

    protected int mono8(byte[] data, int ofs, int len, double grad) {
        int offset = ofs;
        double add = 0.0;
        while (offset < len + ofs) {
            int n = 0;
            while (offset < len + ofs && n < this.mixbuffer.length) {
                this.mixbuffer[n] = (byte)(data[offset + 1] + data[offset + 3] >> 1);
                ++n;
                offset = ofs + (int)(add += grad) * 4;
            }
            this.writeData(this.mixbuffer, 0, n);
        }
        return offset - ofs;
    }

    protected int stereo8(byte[] data, int ofs, int len, double grad) {
        int offset = ofs;
        double add = 0.0;
        while (offset < len + ofs) {
            int n = 0;
            while (offset < len + ofs && n < this.mixbuffer.length) {
                this.mixbuffer[n + 0] = data[offset + 1];
                this.mixbuffer[n + 1] = data[offset + 3];
                n += 2;
                offset = ofs + (int)(add += grad) * 4;
            }
            this.writeData(this.mixbuffer, 0, n);
        }
        return offset - ofs;
    }

    protected int mono16(byte[] data, int ofs, int len, double grad) {
        int offset = 0;
        double add = 0.0;
        while (offset < len + ofs) {
            int n = 0;
            while (offset < len + ofs && n < this.mixbuffer.length) {
                this.mixbuffer[n + 0] = (byte)(data[offset + 0] + data[offset + 2] >> 1);
                this.mixbuffer[n + 1] = (byte)(data[offset + 1] + data[offset + 3] >> 1);
                n += 2;
                offset = ofs + (int)(add += grad) * 4;
            }
            this.writeData(this.mixbuffer, 0, n);
        }
        return offset - ofs;
    }

    protected int stereo16(byte[] data, int ofs, int len, double grad) {
        int offset = 0;
        double add = 0.0;
        while (offset < len + ofs) {
            int n = 0;
            while (offset < len + ofs && n < this.mixbuffer.length) {
                this.mixbuffer[n + 0] = data[offset + 0];
                this.mixbuffer[n + 1] = data[offset + 1];
                this.mixbuffer[n + 2] = data[offset + 2];
                this.mixbuffer[n + 3] = data[offset + 3];
                n += 4;
                offset = ofs + (int)(add += grad) * 4;
            }
            this.writeData(this.mixbuffer, 0, n);
        }
        return offset - ofs;
    }

    private void writeData(byte[] data, int ofs, int len) {
        int count = 0;
        int written = 0;
        while (written < len) {
            written += this.sdl.write(data, ofs + written, len - written);
            if (++count < 100) continue;
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
            count = 0;
        }
    }
}

