/*
 * Decompiled with CFR 0.152.
 */
package com.vwp.sound.mod.util.io;

import java.io.IOException;
import java.io.Writer;

public class IndentingWriter
extends Writer {
    private static final String INDENT = "  ";
    private String indent = "";
    private Writer writer;
    private char lastChar = (char)32;

    public IndentingWriter(Writer writer) {
        this.writer = writer;
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        int i = off;
        while (i < off + len) {
            char c = cbuf[i];
            if (this.lastChar == '\n') {
                this.writer.write(this.indent);
            }
            this.writer.write(c);
            this.lastChar = c;
            ++i;
        }
    }

    public void writeln() throws IOException {
        this.write("\n");
    }

    public void writeln(String str) throws IOException {
        this.write(str);
        this.write("\n");
    }

    public void writeRaw(String data) throws IOException {
        this.writer.write(data);
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    public void close() throws IOException {
        this.writer.close();
    }

    public void indent() {
        this.indent = String.valueOf(this.indent) + INDENT;
    }

    public void unindent() {
        if (this.indent.length() >= INDENT.length()) {
            this.indent = this.indent.substring(2);
        }
    }
}

