/*
 * Decompiled with CFR 0.152.
 */
package com.vwp.sound.mod.util.io;

import com.vwp.sound.mod.util.io.AbstractRandomAccess;
import java.io.IOException;

public class RandomAccessArray
extends AbstractRandomAccess {
    private byte[] data;
    private int pos;

    public RandomAccessArray(byte[] data) {
        this.data = data;
        this.pos = 0;
    }

    public void seek(long pos) throws IOException {
        this.checkBounds(pos);
        this.pos = (int)pos;
    }

    public void skipBytes(int skip) throws IOException {
        this.checkBounds(this.pos + skip);
        this.pos += skip;
    }

    public long getPosition() {
        return this.pos;
    }

    private void checkBounds(long newPos) throws IOException {
        if (newPos < 0L || newPos >= (long)this.data.length) {
            throw new IOException("Array index out of bounds: " + newPos);
        }
    }

    public byte readByte() throws IOException {
        int data = this.read();
        if (data == -1) {
            throw new IOException("End of data");
        }
        return (byte)data;
    }

    public short readShort() throws IOException {
        return (short)(this.readByte() << 8 | this.readByte());
    }

    public int readInt() throws IOException {
        return this.readByte() << 24 | this.readByte() << 16 | this.readByte() << 8 | this.readByte() << 0;
    }

    public int readUnsignedByte() throws IOException {
        return this.read() & 0xFF;
    }

    public int read() throws IOException {
        this.checkBounds(this.pos);
        return this.data[this.pos++] & 0xFF;
    }

    public void close() {
    }
}

