/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jl.player;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JFrame;
import javazoom.jl.decoder.JavaLayerException;
import javazoom.jl.player.AudioDevice;
import javazoom.jl.player.FactoryRegistry;
import javazoom.jl.player.Player;

public class jlp
implements ActionListener {
    jlp player;
    public boolean playing = false;
    int delay = 0;
    private String fFilename = null;
    private boolean remote = false;
    public JButton play = new JButton("Play");
    public Player mixer;
    public AudioDevice dev;

    public void initJlp() {
        this.play.addActionListener(this);
        if (this.player == null) {
            String[] arg = new String[]{"-url", "http://streaming.rolandradio.net/rolandradio.64.stereo"};
            this.player = jlp.createInstance(arg);
        }
    }

    public void playMus() {
        if (this.delay > 0) {
            return;
        }
        this.delay = 200;
        Thread playit = new Thread(){

            @Override
            public void run() {
                if (jlp.this.player != null) {
                    if (jlp.this.playing) {
                        System.out.println("Stopping");
                        jlp.this.playing = false;
                        while (jlp.this.delay > 0) {
                            --jlp.this.delay;
                            try {
                                Thread.sleep(1L);
                            }
                            catch (Exception exception) {}
                        }
                        jlp.this.play.setText("Play");
                        jlp.this.player.mixer.close();
                    } else {
                        System.out.println("Playing");
                        jlp.this.playing = true;
                        while (jlp.this.delay > 0) {
                            --jlp.this.delay;
                            try {
                                Thread.sleep(1L);
                            }
                            catch (Exception exception) {}
                        }
                        jlp.this.play.setText("Stop");
                        jlp.this.player.play();
                    }
                }
                System.out.println(jlp.this.playing);
            }
        };
        playit.start();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.playMus();
    }

    public void stop() {
        if (this.player != null) {
            this.player.stop();
        }
    }

    public static void main(String[] args) {
        jlp lp = new jlp();
        lp.initJlp();
        JFrame fram = new JFrame("Frame");
        fram.setLayout(new BorderLayout());
        fram.add((Component)lp.play, "Center");
        fram.pack();
        fram.setVisible(true);
    }

    public static jlp createInstance(String[] args) {
        jlp player = new jlp();
        if (!player.parseArgs(args)) {
            player = null;
        }
        return player;
    }

    private jlp() {
    }

    public jlp(String filename) {
        this.init(filename);
    }

    protected void init(String filename) {
        this.fFilename = filename;
    }

    protected boolean parseArgs(String[] args) {
        boolean parsed = false;
        if (args.length == 1) {
            this.init(args[0]);
            parsed = true;
            this.remote = false;
        } else if (args.length == 2) {
            if (!args[0].equals("-url")) {
                this.showUsage();
            } else {
                this.init(args[1]);
                parsed = true;
                this.remote = true;
            }
        } else {
            this.showUsage();
        }
        return parsed;
    }

    public void showUsage() {
        System.out.println("Usage: jlp [-url] <filename>");
        System.out.println("");
        System.out.println(" e.g. : java javazoom.jl.player.jlp localfile.mp3");
        System.out.println("        java javazoom.jl.player.jlp -url http://www.server.com/remotefile.mp3");
        System.out.println("        java javazoom.jl.player.jlp -url http://www.shoutcastserver.com:8000");
    }

    public void play() {
        try {
            System.out.println("playing " + this.fFilename + "...");
            InputStream in = null;
            in = this.remote ? this.getURLInputStream() : this.getInputStream();
            this.dev = this.getAudioDevice();
            this.mixer = new Player(in, this.dev);
            this.mixer.play();
        }
        catch (IOException iOException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected InputStream getURLInputStream() throws Exception {
        URL url = new URL(this.fFilename);
        InputStream fin = url.openStream();
        BufferedInputStream bin = new BufferedInputStream(fin);
        return bin;
    }

    protected InputStream getInputStream() throws IOException {
        FileInputStream fin = new FileInputStream(this.fFilename);
        BufferedInputStream bin = new BufferedInputStream(fin);
        return bin;
    }

    protected AudioDevice getAudioDevice() throws JavaLayerException {
        return FactoryRegistry.systemRegistry().createAudioDevice();
    }
}

