/*
 * Decompiled with CFR 0.152.
 */
package jemu.core.device.filesystem;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import jemu.core.device.filesystem.DskSector;
import jemu.core.device.filesystem.DskSectorCatalogs;
import jemu.core.device.filesystem.DskTrack;
import jemu.core.device.filesystem.DskType;
import jemu.core.device.filesystem.NewFreeCatResult;

public class DskMaster {
    public int[] sectorSizes = new int[]{128, 256, 512, 1024, 2048, 4096, 6144};
    List<DskSector> allSectors = new ArrayList<DskSector>();
    List<Integer> allCatsId = new ArrayList<Integer>();
    List<DskSector> allCatsSector = new ArrayList<DskSector>();
    Comparator<DskSector> sectorComparator = new Comparator<DskSector>(){

        @Override
        public int compare(DskSector o1, DskSector o2) {
            if (o1.trackC < o2.trackC) {
                return -1;
            }
            if (o1.trackC > o2.trackC) {
                return 1;
            }
            if (o1.sideH < o2.sideH) {
                return -1;
            }
            if (o1.sideH > o2.sideH) {
                return 1;
            }
            if (o1.sectorIdR < o2.sectorIdR) {
                return -1;
            }
            if (o1.sectorIdR > o2.sectorIdR) {
                return 1;
            }
            throw new Error("Damn");
        }
    };
    DskType type;

    DskSector find0F(DskTrack track, int sectorId) {
        for (DskSector sector : track.sectors) {
            if ((sector.sectorIdR & 0xF) != (sectorId & 0xF)) continue;
            return sector;
        }
        return null;
    }

    public List<Integer> findCatsId(byte[] entriesSector) {
        ArrayList<Integer> cats = new ArrayList<Integer>();
        int k = 2;
        if (null != this.type) {
            switch (this.type) {
                case VORTEX: {
                    k = 1;
                    break;
                }
                case PARADOS80: 
                case PARADOS41: 
                case PARADOS40D: 
                case SS40: 
                case SYSTEM: 
                case DOSD10: 
                case DOSD40: 
                case SDOS: {
                    k = 2;
                    break;
                }
                case DOSD2: 
                case DOSD20: {
                    k = 4;
                    break;
                }
            }
        }
        ArrayList<DskSector> allCSectors = new ArrayList<DskSector>(this.allSectors);
        Collections.sort(allCSectors, this.sectorComparator);
        for (DskSector sector : allCSectors) {
            if (sector instanceof DskSectorCatalogs || this.type == DskType.SYSTEM && sector.trackC < 2 || this.type == DskType.VORTEX && sector.trackC < 1) continue;
            int pair = 0;
            int k1 = 0;
            int k2 = 0;
            for (byte b : entriesSector) {
                if (this.type == DskType.DOSD2 || this.type == DskType.DOSD10 || this.type == DskType.DOSD20) {
                    if (pair == 0) {
                        k1 = b & 0xFF;
                    } else {
                        k2 = b & 0xFF;
                        if (k1 + (k2 <<= 8) == k) {
                            cats.add(k1 + k2);
                            this.allCatsId.add(k1 + k2);
                        }
                    }
                    pair = (pair + 1) % 2;
                    continue;
                }
                if (this.type != DskType.PARADOS80 && this.type != DskType.PARADOS40D && this.type != DskType.DOSD40 && this.type != DskType.SDOS && this.type != DskType.PARADOS41 && this.type != DskType.SS40 && this.type != DskType.SYSTEM && this.type != DskType.VORTEX || (b & 0xFF) != k) continue;
                cats.add(b & 0xFF);
                this.allCatsId.add(b & 0xFF);
            }
            ++k;
        }
        return cats;
    }

    public List<DskSector> findCatsSector(byte[] entriesSector) {
        ArrayList<DskSector> cats = new ArrayList<DskSector>();
        float k = 2.0f;
        if (null != this.type) {
            switch (this.type) {
                case VORTEX: {
                    k = 1.0f;
                    break;
                }
                case PARADOS80: 
                case PARADOS41: 
                case PARADOS40D: 
                case SS40: 
                case SYSTEM: 
                case DOSD10: 
                case DOSD40: 
                case SDOS: {
                    k = 2.0f;
                    break;
                }
                case DOSD2: 
                case DOSD20: {
                    k = 4.0f;
                    break;
                }
            }
        }
        ArrayList<DskSector> allCSectors = new ArrayList<DskSector>(this.allSectors);
        Collections.sort(allCSectors, this.sectorComparator);
        for (DskSector sector : allCSectors) {
            if (sector instanceof DskSectorCatalogs || this.type == DskType.SYSTEM && sector.trackC < 2 || this.type == DskType.VORTEX && sector.trackC < 1) continue;
            int pair = 0;
            int k1 = 0;
            int k2 = 0;
            for (byte b : entriesSector) {
                if (this.type == DskType.DOSD2 || this.type == DskType.DOSD10 || this.type == DskType.DOSD20) {
                    if (pair == 0) {
                        k1 = b & 0xFF;
                    } else {
                        k2 = b & 0xFF;
                        if ((double)(k1 + (k2 <<= 8)) == Math.floor(k)) {
                            cats.add(sector);
                            this.allCatsSector.add(sector);
                        }
                    }
                    pair = (pair + 1) % 2;
                    continue;
                }
                if (this.type != DskType.PARADOS80 && this.type != DskType.PARADOS41 && this.type != DskType.PARADOS40D && this.type != DskType.SS40 && this.type != DskType.SYSTEM && this.type != DskType.VORTEX && this.type != DskType.DOSD40 && this.type != DskType.SDOS || (double)(b & 0xFF) != Math.floor(k)) continue;
                cats.add(sector);
                this.allCatsSector.add(sector);
            }
            if (null == this.type) continue;
            switch (this.type) {
                case PARADOS41: 
                case SS40: 
                case SYSTEM: {
                    k = (float)((double)k + 0.5);
                    break;
                }
                case PARADOS80: 
                case PARADOS40D: 
                case DOSD10: 
                case DOSD40: 
                case SDOS: 
                case DOSD2: 
                case DOSD20: {
                    k = (float)((double)k + 0.25);
                    break;
                }
                case VORTEX: {
                    k = (float)((double)k + 0.125);
                    break;
                }
            }
        }
        return cats;
    }

    public NewFreeCatResult nextFreeCat() {
        NewFreeCatResult cats = new NewFreeCatResult();
        int catIdModulo = 0;
        int catIdModuloMod = 0;
        if (null != this.type) {
            switch (this.type) {
                case VORTEX: {
                    cats.catId = 1;
                    catIdModuloMod = 8;
                    break;
                }
                case PARADOS41: 
                case SS40: 
                case SYSTEM: {
                    cats.catId = 2;
                    catIdModuloMod = 2;
                    break;
                }
                case PARADOS80: 
                case PARADOS40D: 
                case DOSD10: 
                case DOSD40: 
                case SDOS: {
                    cats.catId = 2;
                    catIdModuloMod = 4;
                    break;
                }
                case DOSD2: 
                case DOSD20: {
                    cats.catId = 4;
                    catIdModuloMod = 4;
                    break;
                }
            }
        }
        ArrayList<DskSector> allCSectors = new ArrayList<DskSector>(this.allSectors);
        Collections.sort(allCSectors, this.sectorComparator);
        for (int i = 0; i < allCSectors.size(); ++i) {
            DskSector sector = (DskSector)allCSectors.get(i);
            if (sector instanceof DskSectorCatalogs || this.type == DskType.SYSTEM && sector.trackC < 2 || this.type == DskType.VORTEX && sector.trackC < 1) continue;
            if (!this.allCatsId.contains(cats.catId)) {
                this.allCatsId.add(cats.catId);
                DskSector nextSector = (DskSector)allCSectors.get(i + 1);
                this.allCatsSector.add((DskSector)allCSectors.get(i));
                this.allCatsSector.add((DskSector)allCSectors.get(i + 1));
                if (this.type == DskType.PARADOS80 || this.type == DskType.PARADOS40D || this.type == DskType.DOSD2 || this.type == DskType.SDOS || this.type == DskType.DOSD40 || this.type == DskType.DOSD20 || this.type == DskType.DOSD10 || this.type == DskType.VORTEX) {
                    this.allCatsSector.add((DskSector)allCSectors.get(i + 2));
                    this.allCatsSector.add((DskSector)allCSectors.get(i + 3));
                    if (this.type == DskType.VORTEX) {
                        this.allCatsSector.add((DskSector)allCSectors.get(i + 4));
                        this.allCatsSector.add((DskSector)allCSectors.get(i + 5));
                        this.allCatsSector.add((DskSector)allCSectors.get(i + 6));
                        this.allCatsSector.add((DskSector)allCSectors.get(i + 7));
                    }
                }
                cats.catSectors.add((DskSector)allCSectors.get(i));
                cats.catSectors.add((DskSector)allCSectors.get(i + 1));
                if (this.type == DskType.PARADOS80 || this.type == DskType.PARADOS40D || this.type == DskType.DOSD2 || this.type == DskType.SDOS || this.type == DskType.DOSD40 || this.type == DskType.DOSD20 || this.type == DskType.DOSD10 || this.type == DskType.VORTEX) {
                    cats.catSectors.add((DskSector)allCSectors.get(i + 2));
                    cats.catSectors.add((DskSector)allCSectors.get(i + 3));
                    if (this.type == DskType.VORTEX) {
                        cats.catSectors.add((DskSector)allCSectors.get(i + 4));
                        cats.catSectors.add((DskSector)allCSectors.get(i + 5));
                        cats.catSectors.add((DskSector)allCSectors.get(i + 6));
                        cats.catSectors.add((DskSector)allCSectors.get(i + 7));
                    }
                }
                return cats;
            }
            if (++catIdModulo % catIdModuloMod != 0) continue;
            ++cats.catId;
        }
        return cats;
    }

    public String arrayToString(byte[] bufferHeader) {
        return new String(bufferHeader, Charset.forName("ISO-8859-1"));
    }

    public byte[] stringToArray(String realname2cpcname) {
        return realname2cpcname.getBytes(Charset.forName("ISO-8859-1"));
    }

    public String realname2realname(String realname) {
        return this.cpcname2realname(this.realname2cpcname(realname));
    }

    public String cpcname2realname(String cpcname) {
        String realname = cpcname.substring(0, 8) + "." + cpcname.substring(8, 11);
        return realname;
    }

    public String realname2cpcname(String realname) {
        String cpcname = realname;
        if (cpcname.contains(".")) {
            int point = cpcname.lastIndexOf(".");
            String filename = cpcname.substring(0, point);
            filename = filename + "        ";
            filename = filename.substring(0, 8);
            String extension = cpcname.substring(point + 1, cpcname.length());
            extension = extension + "   ";
            extension = extension.substring(0, 3);
            cpcname = filename + extension;
        } else {
            cpcname = cpcname + "           ";
            cpcname = cpcname.substring(0, 11);
        }
        return cpcname;
    }

    public boolean catalogToCreate(int trackC, int sideH, int sectorIdR) {
        if (null != this.type) {
            switch (this.type) {
                case PARADOS41: 
                case SS40: {
                    if (trackC != 0 || sideH != 0 || (sectorIdR & 0xF) > 4) break;
                    return true;
                }
                case SYSTEM: {
                    if (trackC != 2 || sideH != 0 || (sectorIdR & 0xF) > 4) break;
                    return true;
                }
                case VORTEX: {
                    if (trackC != 1 || sideH != 0 || (sectorIdR & 0xF) > 8) break;
                    return true;
                }
                case PARADOS80: 
                case PARADOS40D: 
                case DOSD10: 
                case DOSD40: 
                case SDOS: {
                    if (trackC != 0 || sideH != 0 || (sectorIdR & 0xF) > 8) break;
                    return true;
                }
                case DOSD2: {
                    if (trackC == 0 && sideH == 0) {
                        return true;
                    }
                    if (trackC != 0 || sideH != 1 || (sectorIdR & 0xF) > 7) break;
                    return true;
                }
                case DOSD20: {
                    if (trackC == 0 && sideH == 0) {
                        return true;
                    }
                    if (trackC != 0 || sideH != 1 || (sectorIdR & 0xF) > 6) break;
                    return true;
                }
            }
        }
        return false;
    }

    public List<DskSectorCatalogs> buildCatalogs(List<DskTrack> tracks) {
        ArrayList<DskSectorCatalogs> catalogs = new ArrayList<DskSectorCatalogs>();
        if (this.type == DskType.SS40 || this.type == DskType.PARADOS41) {
            DskTrack track0 = tracks.get(0);
            catalogs.add((DskSectorCatalogs)this.find0F(track0, 193));
            catalogs.add((DskSectorCatalogs)this.find0F(track0, 194));
            catalogs.add((DskSectorCatalogs)this.find0F(track0, 195));
            catalogs.add((DskSectorCatalogs)this.find0F(track0, 196));
        } else if (this.type == DskType.SYSTEM && tracks.get((int)1).side == 0) {
            DskTrack track2 = tracks.get(2);
            catalogs.add((DskSectorCatalogs)this.find0F(track2, 65));
            catalogs.add((DskSectorCatalogs)this.find0F(track2, 66));
            catalogs.add((DskSectorCatalogs)this.find0F(track2, 67));
            catalogs.add((DskSectorCatalogs)this.find0F(track2, 68));
        } else if (this.type == DskType.SYSTEM && tracks.get((int)1).side == 1) {
            DskTrack track2side0 = tracks.get(4);
            catalogs.add((DskSectorCatalogs)this.find0F(track2side0, 65));
            catalogs.add((DskSectorCatalogs)this.find0F(track2side0, 66));
            catalogs.add((DskSectorCatalogs)this.find0F(track2side0, 67));
            catalogs.add((DskSectorCatalogs)this.find0F(track2side0, 68));
        } else if (this.type == DskType.PARADOS80 || this.type == DskType.PARADOS40D || this.type == DskType.DOSD10 || this.type == DskType.DOSD40 || this.type == DskType.SDOS) {
            DskTrack track0 = tracks.get(0);
            catalogs.add((DskSectorCatalogs)this.find0F(track0, 33));
            catalogs.add((DskSectorCatalogs)this.find0F(track0, 34));
            catalogs.add((DskSectorCatalogs)this.find0F(track0, 35));
            catalogs.add((DskSectorCatalogs)this.find0F(track0, 36));
            catalogs.add((DskSectorCatalogs)this.find0F(track0, 37));
            catalogs.add((DskSectorCatalogs)this.find0F(track0, 38));
            catalogs.add((DskSectorCatalogs)this.find0F(track0, 39));
            catalogs.add((DskSectorCatalogs)this.find0F(track0, 40));
        } else if (this.type == DskType.VORTEX) {
            DskTrack track1side0 = tracks.get(2);
            catalogs.add((DskSectorCatalogs)this.find0F(track1side0, 1));
            catalogs.add((DskSectorCatalogs)this.find0F(track1side0, 2));
            catalogs.add((DskSectorCatalogs)this.find0F(track1side0, 3));
            catalogs.add((DskSectorCatalogs)this.find0F(track1side0, 4));
            catalogs.add((DskSectorCatalogs)this.find0F(track1side0, 5));
            catalogs.add((DskSectorCatalogs)this.find0F(track1side0, 6));
            catalogs.add((DskSectorCatalogs)this.find0F(track1side0, 7));
            catalogs.add((DskSectorCatalogs)this.find0F(track1side0, 8));
        } else if (this.type == DskType.DOSD2) {
            DskTrack track0 = tracks.get(0);
            DskTrack track0side1 = tracks.get(1);
            catalogs.add((DskSectorCatalogs)this.find0F(track0, 33));
            catalogs.add((DskSectorCatalogs)this.find0F(track0, 34));
            catalogs.add((DskSectorCatalogs)this.find0F(track0, 35));
            catalogs.add((DskSectorCatalogs)this.find0F(track0, 36));
            catalogs.add((DskSectorCatalogs)this.find0F(track0, 37));
            catalogs.add((DskSectorCatalogs)this.find0F(track0, 38));
            catalogs.add((DskSectorCatalogs)this.find0F(track0, 39));
            catalogs.add((DskSectorCatalogs)this.find0F(track0, 40));
            catalogs.add((DskSectorCatalogs)this.find0F(track0, 41));
            catalogs.add((DskSectorCatalogs)this.find0F(track0side1, 33));
            catalogs.add((DskSectorCatalogs)this.find0F(track0side1, 34));
            catalogs.add((DskSectorCatalogs)this.find0F(track0side1, 35));
            catalogs.add((DskSectorCatalogs)this.find0F(track0side1, 36));
            catalogs.add((DskSectorCatalogs)this.find0F(track0side1, 37));
            catalogs.add((DskSectorCatalogs)this.find0F(track0side1, 38));
            catalogs.add((DskSectorCatalogs)this.find0F(track0side1, 39));
        } else if (this.type == DskType.DOSD20) {
            DskTrack track0 = tracks.get(0);
            DskTrack track0side1 = tracks.get(1);
            catalogs.add((DskSectorCatalogs)this.find0F(track0, 49));
            catalogs.add((DskSectorCatalogs)this.find0F(track0, 50));
            catalogs.add((DskSectorCatalogs)this.find0F(track0, 51));
            catalogs.add((DskSectorCatalogs)this.find0F(track0, 52));
            catalogs.add((DskSectorCatalogs)this.find0F(track0, 53));
            catalogs.add((DskSectorCatalogs)this.find0F(track0, 54));
            catalogs.add((DskSectorCatalogs)this.find0F(track0, 55));
            catalogs.add((DskSectorCatalogs)this.find0F(track0, 56));
            catalogs.add((DskSectorCatalogs)this.find0F(track0, 57));
            catalogs.add((DskSectorCatalogs)this.find0F(track0, 58));
            catalogs.add((DskSectorCatalogs)this.find0F(track0side1, 49));
            catalogs.add((DskSectorCatalogs)this.find0F(track0side1, 50));
            catalogs.add((DskSectorCatalogs)this.find0F(track0side1, 51));
            catalogs.add((DskSectorCatalogs)this.find0F(track0side1, 52));
            catalogs.add((DskSectorCatalogs)this.find0F(track0side1, 53));
            catalogs.add((DskSectorCatalogs)this.find0F(track0side1, 54));
        }
        return catalogs;
    }

    public static int ChecksumAMSDOS(byte[] pHeader) {
        int Checksum = 0;
        for (int i = 0; i < 67; ++i) {
            int CheckSumByte = pHeader[i] & 0xFF;
            Checksum += CheckSumByte;
        }
        return Checksum;
    }

    public static boolean CheckAMSDOS(byte[] pHeader) {
        int CalculatedChecksum;
        try {
            CalculatedChecksum = DskMaster.ChecksumAMSDOS(pHeader);
        }
        catch (Exception e) {
            return false;
        }
        try {
            int ChecksumFromHeader = pHeader[67] & 0xFF | (pHeader[68] & 0xFF) << 8;
            if (ChecksumFromHeader == CalculatedChecksum && ChecksumFromHeader != 0) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public int getFileLengthAMSDOSHeader(byte[] pHeader) {
        return DskMaster.getWord(pHeader, 24);
    }

    public static int getWord(byte[] buffer, int offs) {
        return buffer[offs] & 0xFF | buffer[offs + 1] << 8 & 0xFF00;
    }

    public byte[] GenerateAMSDOSHeader(String filename, long fileLength) {
        byte[] pHeader = new byte[128];
        pHeader[0] = 0;
        byte[] name = this.stringToArray(this.realname2cpcname(filename).substring(0, 8));
        System.arraycopy(name, 0, pHeader, 1, 8);
        byte[] ext = this.stringToArray(this.realname2cpcname(filename).substring(8, 11));
        System.arraycopy(ext, 0, pHeader, 9, 3);
        pHeader[16] = 0;
        pHeader[17] = 0;
        pHeader[18] = 2;
        pHeader[21] = 0;
        pHeader[22] = 1;
        pHeader[23] = 0;
        pHeader[24] = (byte)(fileLength & 0xFFL);
        pHeader[25] = (byte)((fileLength & 0xFF00L) >> 8);
        pHeader[26] = 0;
        pHeader[27] = 1;
        pHeader[64] = (byte)(fileLength & 0xFFL);
        pHeader[65] = (byte)((fileLength & 0xFF00L) >> 8);
        pHeader[66] = (byte)((fileLength & 0xFF0000L) >> 16);
        int check = DskMaster.ChecksumAMSDOS(pHeader);
        pHeader[67] = (byte)(check & 0xFF);
        pHeader[68] = (byte)((check & 0xFF00) >> 8);
        return pHeader;
    }
}

