/*
 * Decompiled with CFR 0.152.
 */
package jemu.core.device.sound;

import jemu.core.Util;
import jemu.core.device.Device;
import jemu.core.device.IOPort;
import jemu.core.device.sound.JavaSound;
import jemu.core.device.sound.SoundDevice;
import jemu.core.device.sound.SoundUtil;
import jemu.settings.Settings;
import jemu.system.cpc.CPC;
import jemu.system.cpc.CPCMemory;
import jemu.ui.Desktop;
import jemu.ui.Display;
import jemu.ui.ScreenCapture;
import jemu.ui.Switches;

public class AY_3_8910
extends SoundDevice {
    public static boolean build;
    int[] mfpPrediv = new int[]{0, 4, 10, 16, 50, 64, 100, 200};
    protected int[] Buffered = new int[1000];
    public static final double[] LOG_VOLUME;
    byte[] regis = new byte[14];
    public static final double[] LOG_VOLUME_A;
    public static final double[] LOG_VOLUME_B;
    public static final double[] LOG_VOLUME_C;
    public static final double[] LOG_VOLUME_D;
    public static final double[] LOG_VOLUME_L;
    protected double outvolume = 1.0;
    protected int vuL;
    protected int vuR;
    protected int leftchange;
    protected int rightchange;
    protected int midchange;
    public boolean register13Updated = false;
    public static boolean digiblast;
    public static int leftChannel;
    public static int rightChannel;
    public static int tapeNoise;
    public static int blasterA;
    public static int blasterB;
    protected int volumen = 0;
    int volcount;
    int vucount;
    protected int digibuffer = 20000;
    public static int digicount;
    public final int BDIR_MASK = 4;
    public final int BC2_MASK = 2;
    public final int BC1_MASK = 1;
    public final int PORT_A = 0;
    public final int PORT_B = 1;
    protected static final int INACTIVE = 0;
    protected static final int LATCH = 1;
    protected static final int READ = 2;
    protected static final int WRITE = 3;
    protected static final int[] STATES;
    protected static final int AFINE = 0;
    protected static final int ACOARSE = 1;
    protected static final int BFINE = 2;
    protected static final int BCOARSE = 3;
    protected static final int CFINE = 4;
    protected static final int CCOARSE = 5;
    protected static final int NOISEPERIOD = 6;
    protected static final int ENABLE = 7;
    protected static final int AVOL = 8;
    protected static final int BVOL = 9;
    protected static final int CVOL = 10;
    protected static final int EFINE = 11;
    protected static final int ECOARSE = 12;
    protected static final int ESHAPE = 13;
    protected static final int REG_PORTA = 14;
    protected static final int REG_PORTB = 15;
    protected static final int ENABLE_A = 1;
    protected static final int ENABLE_B = 2;
    protected static final int ENABLE_C = 4;
    protected static final int NOISE_A = 8;
    protected static final int NOISE_B = 16;
    protected static final int NOISE_C = 32;
    protected static final int PORT_A_OUT = 64;
    protected static final int PORT_B_OUT = 128;
    protected static final int NOISE_ALL = 56;
    protected static final int A = 0;
    protected static final int B = 1;
    protected static final int C = 2;
    protected static final int NOISE = 3;
    protected static final int ENVELOPE = 4;
    protected int step = 32768;
    protected int maxReg = 15;
    protected static int[] regs;
    protected int selReg = 0;
    protected int bdirBC2BC1 = 0;
    protected int state = 0;
    protected int clockSpeed = 1000000;
    protected IOPort[] ports = new IOPort[]{new IOPort(0), new IOPort(0)};
    protected int[] envelope = new int[3];
    protected int[] output = new int[4];
    protected int[] count = new int[5];
    protected int[] period = new int[5];
    protected int[] volume = new int[5];
    protected int outN;
    protected int random = 1;
    protected int countEnv;
    protected int hold;
    protected int alternate;
    protected int attack;
    protected int holding;
    protected int updateStep;
    int pt;
    int oldwrite = 0;
    protected boolean blockWRITE = false;
    public static boolean liveNoise;
    int po;
    int lowpass = 0;
    public static boolean Speaker;
    int ppo = -600000;
    int t;
    int p;
    int q;
    int r;
    public static int skip;
    int leftc;
    int center;
    int rightc;
    int leftO;
    int rightO;
    public static boolean changeformat;
    public static int buffersize;
    public static int updatecount;
    int[] circlebuffer = new int[1600];
    int writepos = 1599;
    int readpos = 0;

    public byte[] getPSGRegisters() {
        for (int i = 0; i < 14; ++i) {
            this.regis[i] = (byte)this.getRegister(i);
        }
        return this.regis;
    }

    public void writePSGRegisters(byte[] regs) {
        for (int i = 0; i < 14; ++i) {
            this.setRegister(i, regs[i] & 0xFF);
        }
    }

    public static void main(String[] args) {
        for (int i = 1; i <= LOG_VOLUME_A.length; ++i) {
            int k = (int)(LOG_VOLUME_A[LOG_VOLUME_A.length - i] * 17.0);
            System.out.print(k + ",");
        }
        System.out.println();
    }

    public AY_3_8910() {
        super("AY-3-8910/2/3 Programmable Sound Generator");
        this.setClockSpeed(this.clockSpeed);
        int pufferSize = Settings.getInt("audio_puffersize", 4096);
        this.player = SoundUtil.getSoundPlayer(pufferSize, true);
        this.player.setFormat(2);
    }

    @Override
    public void reset() {
        this.selReg = 0;
        this.random = 1;
        this.rightc = 0;
        this.center = 0;
        this.leftc = 0;
        this.countEnv = 0;
        for (int r = 0; r < this.maxReg; ++r) {
            this.setRegister(r, 0);
        }
        this.setRegister(0, 90);
        this.setRegister(2, 90);
        this.setRegister(4, 90);
        this.setRegister(6, 1);
        this.setRegister(7, 63);
        this.setRegister(11, 13);
        this.setRegister(13, 24);
    }

    public void setClockSpeed(int value) {
        this.clockSpeed = value;
        this.updateStep = (int)((long)this.step * 8L * (long)JavaSound.SAMPLE_RATE / (long)this.clockSpeed);
        this.output[3] = 255;
        for (int i = 0; i <= 4; ++i) {
            this.period[i] = this.count[i] = this.updateStep;
        }
        this.period[4] = 0;
        this.count[3] = Short.MAX_VALUE;
    }

    public void changeClockSpeed(int value) {
        this.clockSpeed = value;
        this.updateStep = (int)((long)this.step * 8L * (long)JavaSound.SAMPLE_RATE / (long)this.clockSpeed);
    }

    public void changePlayer() {
        if (build) {
            this.player.init();
            this.changeClockSpeed(this.clockSpeed);
        }
        build = true;
    }

    public void setSelectedRegister(int value) {
        Desktop.selpsg = this.selReg = value & 0xF;
    }

    public int getSelectedRegister() {
        return this.selReg;
    }

    public void resetRegisters() {
        for (int r = 0; r < 16; ++r) {
            this.setRegister(r, 0);
        }
        this.setRegister(0, 90);
        this.setRegister(2, 90);
        this.setRegister(4, 90);
        this.setRegister(6, 1);
        this.setRegister(7, 63);
        this.setRegister(11, 13);
        this.setRegister(13, 24);
    }

    public void setBDIR_BC2_BC1_old(int value, int dataValue) {
        if (this.bdirBC2BC1 != value) {
            this.bdirBC2BC1 = value;
            this.state = STATES[this.bdirBC2BC1];
            if (this.blockWRITE && this.state == 3) {
                this.blockWRITE = false;
                return;
            }
            this.writePort(20, dataValue);
        }
    }

    public void setBDIR_BC2_BC1(int value, int dataValue) {
        if (this.bdirBC2BC1 != value) {
            this.bdirBC2BC1 = value;
            this.state = STATES[this.bdirBC2BC1];
            if (this.state == 1) {
                this.selReg = value & 0x1F;
            }
            if (this.blockWRITE && this.state == 3) {
                this.blockWRITE = false;
            } else if (!this.blockWRITE) {
                this.writePort(20, dataValue);
                return;
            }
            if (dataValue > 7) {
                this.writePort(20, dataValue);
            }
        }
    }

    public int getBDIR_BC2_BC1() {
        return this.bdirBC2BC1;
    }

    @Override
    public int readPort(int port) {
        if (this.selReg != 0) {
            return this.state == 2 ? this.readRegister(this.selReg) : 255;
        }
        return 255;
    }

    public void setReg(int value) {
        this.setRegister(this.selReg, value);
    }

    @Override
    public void writePort(int port, int value) {
        switch (this.state) {
            case 1: {
                Desktop.selpsg = this.selReg = value & 0x1F;
                break;
            }
            case 3: {
                if (port != 20) {
                    this.blockWRITE = true;
                }
                this.setReg(value & 0xFF);
            }
        }
    }

    public int getRegister(int index) {
        return regs[index];
    }

    public static String getReg(int index) {
        return Util.hex(regs[index]).substring(6);
    }

    public static int getR13() {
        return regs[13];
    }

    public int readRegister(int index) {
        if (index <= this.maxReg) {
            return index < 14 ? regs[index] : this.ports[index - 14].read();
        }
        return 255;
    }

    public boolean registerUpdated() {
        return this.register13Updated;
    }

    public void resetUpdated() {
        this.register13Updated = false;
    }

    public void setRegister(int index, int value) {
        if (index == 13) {
            this.register13Updated = true;
        }
        if (index < 14) {
            if (index == 13 || regs[index] != value) {
                AY_3_8910.regs[index] = value;
                switch (index) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        int val = ((regs[((index >>= 1) << 1) + 1] & 0xF) << 8 | regs[index << 1]) * this.updateStep;
                        int last = this.period[index];
                        val = val < 32768 ? 32768 : val;
                        this.period[index] = val;
                        int newCount = this.count[index] - (val - last);
                        this.count[index] = newCount < 1 ? 1 : newCount;
                        break;
                    }
                    case 6: {
                        int val = (value & 0x1F) * this.updateStep;
                        if (!Switches.ayeffect) {
                            val *= 2;
                        }
                        int last = this.period[3];
                        val = val == 0 ? this.updateStep : val;
                        this.period[3] = val;
                        int newCount = this.count[3] - (val - last);
                        this.count[3] = newCount < 1 ? 1 : newCount;
                        break;
                    }
                    case 7: {
                        break;
                    }
                    case 8: 
                    case 9: 
                    case 10: {
                        this.volume[index - 8] = (value & 0x10) == 0 ? value & 0xF : this.volume[4];
                        break;
                    }
                    case 11: 
                    case 12: {
                        int val = (regs[12] << 8 | regs[11]) * this.updateStep << 1;
                        int last = this.period[4];
                        this.period[4] = val;
                        int newCount = this.count[4] - (val - last);
                        this.count[4] = newCount < 1 ? 1 : newCount;
                        break;
                    }
                    case 13: {
                        int n = this.attack = (value & 4) == 0 ? 0 : 15;
                        if ((value & 8) == 0) {
                            this.hold = 1;
                            this.alternate = this.attack;
                        } else {
                            this.hold = value & 1;
                            this.alternate = value & 2;
                            if (this.hold != 0) {
                                this.attack = this.alternate;
                            }
                        }
                        this.count[4] = this.period[4];
                        this.countEnv = 15;
                        this.holding = 0;
                        int vol = this.volume[4] = this.attack ^ 0xF;
                        if ((regs[8] & 0x10) != 0) {
                            this.volume[0] = vol;
                        }
                        if ((regs[9] & 0x10) != 0) {
                            this.volume[1] = vol;
                        }
                        if ((regs[10] & 0x10) == 0) break;
                        this.volume[2] = vol;
                        break;
                    }
                }
            }
        } else {
            this.ports[index - 14].write(value);
        }
    }

    public void writeAudio() {
        int add;
        int enable = regs[7];
        if ((enable & 1) != 0) {
            if (this.count[0] <= this.step) {
                this.count[0] = this.count[0] + this.step;
            }
            this.output[0] = 1;
        }
        if ((enable & 2) != 0) {
            if (this.count[1] <= this.step) {
                this.count[1] = this.count[1] + this.step;
            }
            this.output[1] = 1;
        }
        if ((enable & 4) != 0) {
            if (this.count[2] <= this.step) {
                this.count[2] = this.count[2] + this.step;
            }
            this.output[2] = 1;
        }
        this.outN = this.output[3] | enable;
        if ((enable & 0x38) == 56 && this.count[3] <= this.step) {
            this.count[3] = this.count[3] + this.step;
        }
        int[] cnt = new int[3];
        int left = this.step;
        do {
            add = this.count[3] < left ? this.count[3] : left;
            for (int chan = 0; chan <= 2; ++chan) {
                int chcnt = this.count[chan];
                if ((this.outN & 8 << chan) != 0) {
                    int val;
                    block47: {
                        int n = val = this.output[chan] == 0 ? cnt[chan] : cnt[chan] + chcnt;
                        if ((chcnt -= add) <= 0) {
                            int p = this.period[chan];
                            do {
                                if ((chcnt += p) > 0) {
                                    int n2 = chan;
                                    this.output[n2] = this.output[n2] ^ 1;
                                    if (this.output[n2] != 0) {
                                        val += p - chcnt;
                                    }
                                    break block47;
                                }
                                val += p;
                            } while ((chcnt += p) <= 0);
                            if (this.output[chan] == 0) {
                                val -= chcnt;
                            }
                        } else if (this.output[chan] != 0) {
                            val -= chcnt;
                        }
                    }
                    cnt[chan] = val;
                } else if ((chcnt -= add) <= 0) {
                    int p = this.period[chan];
                    do {
                        if ((chcnt += p) <= 0) continue;
                        int n = chan;
                        this.output[n] = this.output[n] ^ 1;
                        break;
                    } while ((chcnt += p) <= 0);
                }
                this.count[chan] = chcnt;
            }
            this.count[3] = this.count[3] - add;
            if (this.count[3] > 0) continue;
            int val = this.random + 1;
            if ((val & 2) != 0) {
                this.output[3] = this.output[3] ^ 0xFF;
                this.outN = this.output[3] | enable;
            }
            this.random = (this.random & 1) == 0 ? this.random >> 1 : (this.random ^ 0x28000) >> 1;
            this.count[3] = this.count[3] + this.period[3];
        } while ((left -= add) > 0);
        if (this.holding == 0 && this.period[4] != 0 && (this.count[4] = this.count[4] - this.step) <= 0) {
            int ce = this.countEnv;
            int p = this.period[4];
            do {
                --ce;
            } while ((this.count[4] = this.count[4] + p) <= 0);
            if (ce < 0) {
                if (this.hold != 0) {
                    if (this.alternate != 0) {
                        this.attack ^= 0xF;
                    }
                    this.holding = 1;
                    ce = 0;
                } else {
                    if (this.alternate != 0 && (ce & 0x10) != 0) {
                        this.attack ^= 0xF;
                    }
                    ce &= 0xF;
                }
            }
            this.countEnv = ce;
            int vol = this.volume[4] = ce ^ this.attack;
            if ((regs[8] & 0x10) != 0) {
                this.volume[0] = vol;
            }
            if ((regs[9] & 0x10) != 0) {
                this.volume[1] = vol;
            }
            if ((regs[10] & 0x10) != 0) {
                this.volume[2] = vol;
            }
        }
        if (Switches.VSoftOutput) {
            this.leftc = (int)(LOG_VOLUME_B[this.volume[0]] * (double)(cnt[0] >> 13));
            this.center = (int)(LOG_VOLUME_B[this.volume[1]] * (double)(cnt[1] >> 13));
            this.rightc = (int)(LOG_VOLUME_B[this.volume[2]] * (double)(cnt[2] >> 13));
        } else if (Switches.LION) {
            this.leftc = (int)(LOG_VOLUME_C[this.volume[0]] * (double)(cnt[0] >> 13));
            this.center = (int)(LOG_VOLUME_C[this.volume[1]] * (double)(cnt[1] >> 13));
            this.rightc = (int)(LOG_VOLUME_C[this.volume[2]] * (double)(cnt[2] >> 13));
        } else if (Switches.HACKER) {
            this.leftc = (int)(LOG_VOLUME_D[this.volume[0]] * (double)(cnt[0] >> 13));
            this.center = (int)(LOG_VOLUME_D[this.volume[1]] * (double)(cnt[1] >> 13));
            this.rightc = (int)(LOG_VOLUME_D[this.volume[2]] * (double)(cnt[2] >> 13));
        } else if (Switches.CPCE95) {
            this.leftc = (int)(LOG_VOLUME[this.volume[0]] * (double)(cnt[0] >> 13));
            this.center = (int)(LOG_VOLUME[this.volume[1]] * (double)(cnt[1] >> 13));
            this.rightc = (int)(LOG_VOLUME[this.volume[2]] * (double)(cnt[2] >> 13));
        } else if (Switches.linear) {
            this.leftc = (int)(LOG_VOLUME_L[this.volume[0]] * (double)(cnt[0] >> 13));
            this.center = (int)(LOG_VOLUME_L[this.volume[1]] * (double)(cnt[1] >> 13));
            this.rightc = (int)(LOG_VOLUME_L[this.volume[2]] * (double)(cnt[2] >> 13));
        } else {
            this.leftc = (int)(LOG_VOLUME_A[this.volume[0]] * (double)(cnt[0] >> 13));
            this.center = (int)(LOG_VOLUME_A[this.volume[1]] * (double)(cnt[1] >> 13));
            this.rightc = (int)(LOG_VOLUME_A[this.volume[2]] * (double)(cnt[2] >> 13));
        }
        this.leftc = (int)((double)this.leftc * Switches.volume);
        this.center = (int)((double)this.center * Switches.volume);
        this.rightc = (int)((double)this.rightc * Switches.volume);
        if (!Switches.ayeffect && !Speaker) {
            this.center = (int)((double)this.center * 0.75);
        }
        if (Desktop.chanA.isSelected()) {
            this.leftc = 0;
        }
        if (Desktop.chanB.isSelected()) {
            this.center = 0;
        }
        if (Desktop.chanC.isSelected()) {
            this.rightc = 0;
        }
        if (digiblast) {
            this.BvuMeter();
        } else {
            this.vuMeter(this.leftc, this.center, this.rightc);
        }
        leftChannel = this.leftc + this.center;
        rightChannel = this.center + this.rightc;
        this.soundOutput(leftChannel, rightChannel);
    }

    public void setReadDevice(int port, Device device, int readPort) {
        this.ports[port].setInputDevice(device, readPort);
    }

    public void soundOutput(int left, int right) {
        if (digiblast && this.readRegister(7) != 63 && (this.readRegister(8) != 0 || this.readRegister(9) != 0 || this.readRegister(10) != 0)) {
            digiblast = false;
        }
        if (digiblast) {
            leftChannel = blasterA;
            rightChannel = blasterB;
        }
        if (Switches.audioenabler != 1) {
            rightChannel = 0;
            leftChannel = 0;
        }
        if (ScreenCapture.record) {
            rightChannel = 0;
            leftChannel = 0;
        }
        if (digicount != 0) {
            ++digicount;
        }
        if (digicount >= this.digibuffer) {
            digiblast = false;
            digicount = 0;
        }
        if (updatecount != 0 && ++updatecount > 1000) {
            updatecount = 0;
            this.updateBuffer();
        }
        if (Switches.dbeffect) {
            this.buffer_write(rightChannel);
            rightChannel = this.buffer_read();
        }
        if (Speaker) {
            int val = this.leftc + this.center + this.rightc;
            this.leftO = 0;
            this.rightO = digiblast ? rightChannel : val;
        } else {
            this.leftO = leftChannel;
            this.rightO = rightChannel;
        }
        this.player.writeStereo(this.leftO, this.rightO);
        if (CPC.playmovie || Switches.FloppySound && Switches.audioenabler == 1) {
            if (tapeNoise == 0 && liveNoise) {
                this.player.writeMono(CPCMemory.byteNoise >> 5);
            } else {
                this.player.writeMono(tapeNoise);
            }
        } else {
            this.player.writeMono(0);
        }
        if (changeformat) {
            changeformat = false;
            this.changePlayer();
            CPC.replay = true;
        }
    }

    protected void updateBuffer() {
        if (buffersize != this.circlebuffer.length) {
            System.out.println("Changing buffersize to: " + buffersize);
            try {
                this.writepos = buffersize - 1;
                this.readpos = 0;
                this.circlebuffer = new int[buffersize];
            }
            catch (Exception e) {
                updatecount = 1;
            }
        }
    }

    void buffer_write(int val) {
        try {
            this.circlebuffer[this.writepos] = val;
            this.writepos = (this.writepos + 1) % this.circlebuffer.length;
        }
        catch (Exception e) {
            updatecount = 1;
        }
    }

    int buffer_read() {
        try {
            int val = this.circlebuffer[this.readpos];
            this.readpos = (this.readpos + 1) % this.circlebuffer.length;
            return val;
        }
        catch (Exception e) {
            updatecount = 1;
            return 0;
        }
    }

    public void setWriteDevice(int port, Device device, int writePort) {
        this.ports[port].setOutputDevice(device, writePort);
    }

    public void vuMeter(int left, int mid, int right) {
        ++this.volcount;
        if (this.volcount >= 1024) {
            this.volcount = 0;
            if (left > this.leftchange) {
                this.leftchange = left;
            } else if (this.leftchange > 0) {
                --this.leftchange;
            }
            if (mid > this.midchange) {
                this.midchange = mid;
            } else if (this.midchange > 0) {
                --this.midchange;
            }
            if (right > this.rightchange) {
                this.rightchange = right;
            } else if (this.rightchange > 0) {
                --this.rightchange;
            }
            try {
                if (Desktop.midvumeter.isShowing()) {
                    Desktop.midvumeter.setValue(this.midchange);
                    Desktop.leftvumeter.setValue(this.leftchange);
                    Desktop.rightvumeter.setValue(this.rightchange);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            Display.left = this.leftchange;
            Display.right = this.rightchange;
        }
    }

    public void BvuMeter() {
        ++this.volcount;
        if (this.volcount >= 768) {
            this.volcount = 0;
            int left = blasterA;
            if (left > this.leftchange) {
                this.leftchange = left;
            } else if (this.leftchange > 0) {
                --this.leftchange;
            }
            int right = blasterB;
            if (right > this.rightchange) {
                this.rightchange = right;
            } else if (this.rightchange > 0) {
                --this.rightchange;
            }
            try {
                if (Desktop.midvumeter.isShowing()) {
                    Desktop.leftvumeter.setValue((this.leftchange ^ 0x80) / 2);
                    Desktop.rightvumeter.setValue((this.rightchange ^ 0x80) / 2);
                    Desktop.midvumeter.setValue(0);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static {
        LOG_VOLUME = new double[]{0.08286408, 0.1171875, 0.1657282, 0.234375, 0.3314563, 0.46875, 0.6629126, 0.9375, 1.325825, 1.875, 2.65165, 3.75, 5.303301, 7.5, 10.6066, 15.0};
        LOG_VOLUME_A = new double[]{0.0, 0.291348135, 0.377409018, 0.405813687, 0.599450675, 0.741130694, 1.12748913, 2.08514534, 2.36758984, 4.09155413, 5.64934768, 6.96772717, 8.8908217, 10.8194095, 12.9095903, 15.0};
        LOG_VOLUME_B = new double[]{0.0, 0.291348135, 0.377409018, 0.405813687, 0.599450675, 0.886930648, 1.23529412, 2.01945525, 2.37857633, 3.8237583, 5.34195468, 6.70450904, 8.46166171, 10.6250858, 12.6333257, 15.0};
        LOG_VOLUME_C = new double[]{0.0, 0.065461203, 0.107576104, 0.151979858, 0.258640421, 0.412680247, 0.651865415, 0.883955138, 1.386587319, 1.959029526, 2.947585259, 4.071183337, 5.990386816, 8.165712977, 11.66994735, 15.0};
        LOG_VOLUME_D = new double[]{0.0, 0.102998397, 0.189059281, 0.283588921, 0.439230945, 0.601052872, 0.86472877, 1.151522087, 1.639047837, 2.20233463, 3.133211261, 4.184023804, 5.984893568, 7.983291371, 11.30785076, 15.0};
        LOG_VOLUME_L = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0};
        digiblast = false;
        digicount = 0;
        STATES = new int[]{0, 1, 0, 2, 1, 0, 3, 1};
        regs = new int[16];
        liveNoise = true;
        Speaker = false;
        skip = 10;
        changeformat = false;
        buffersize = 1600;
        updatecount = 0;
    }
}

