/*
 * Decompiled with CFR 0.152.
 */
package jemu.core.device.sound;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import jemu.core.device.sound.BufferDisplay;
import jemu.core.device.sound.JavaSound;
import jemu.system.cpc.CPC;

public class AudioCapture
extends JInternalFrame {
    protected int samplerate = 22050;
    protected boolean initialized = false;
    protected JButton selectB = new JButton("Select file");
    protected JButton startB = new JButton("Start recording");
    protected JButton stopB = new JButton("Stop recording");
    protected JButton pauseB = new JButton("Pause");
    public boolean stopCapture = false;
    public boolean doCapture = false;
    public boolean doInit = false;
    protected int counter = 0;
    protected int Subchunk2Size = 0;
    protected int ChunkSize = 0;
    protected RandomAccessFile file;
    protected String filename;
    BufferDisplay gfx = new BufferDisplay();
    protected int flashCol = 0;
    protected boolean doStartCapture = false;
    Color DARK_GREEN = new Color(0, 64, 0);
    Color DARK_RED = new Color(64, 0, 0);
    protected byte[] WAV_HEADER = new byte[]{82, 73, 70, 70, 0, 0, 0, 0, 87, 65, 86, 69, 102, 109, 116, 32, 16, 0, 0, 0, 1, 0, 2, 0, 68, -84, 0, 0, 68, -84, 0, 0, 2, 0, 8, 0, 100, 97, 116, 97, 0, 0, 0, 0};
    int pc;

    public void select() {
        this.startB.setEnabled(false);
        FileDialog filedia = new FileDialog(new Frame(), "Record WAV file", 1);
        filedia.setFile("*.wav");
        filedia.setVisible(true);
        this.filename = filedia.getDirectory() + filedia.getFile();
        if (this.filename != null) {
            try {
                File check = new File(this.filename);
                check.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.filename.toLowerCase().endsWith(".wav")) {
                this.filename = this.filename.substring(0, this.filename.length() - 4);
            }
            this.startB.setEnabled(true);
        }
    }

    public void init() {
        if (this.filename != null) {
            try {
                this.file = new RandomAccessFile(this.filename + ".tmp", "rw");
                this.file.write(new byte[44]);
                this.doCapture = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.doInit = false;
    }

    public void PaintBuffer(byte[] input) {
        try {
            this.pc = 0;
            this.gfx.paintWAV(input);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void Capture(byte[] input, int length) {
        ++this.flashCol;
        if (!(input[1] == -128 && input[2] == -128 || this.doStartCapture)) {
            System.out.println("recording started...");
            this.doStartCapture = true;
        }
        if (this.doStartCapture) {
            try {
                if (this.flashCol == 50) {
                    this.startB.setBackground(Color.GREEN);
                }
                if (this.flashCol == 100) {
                    this.startB.setBackground(this.DARK_GREEN);
                    this.flashCol = 0;
                }
                this.file.write(input);
                this.counter += length;
                this.Subchunk2Size = this.counter;
                this.ChunkSize = 36 + this.Subchunk2Size;
                this.samplerate = JavaSound.SAMPLE_RATE;
                this.putLong(this.WAV_HEADER, 24, this.samplerate);
                this.putLong(this.WAV_HEADER, 28, this.samplerate * 2);
                this.putLong(this.WAV_HEADER, 40, this.Subchunk2Size);
                this.putLong(this.WAV_HEADER, 4, this.ChunkSize);
            }
            catch (Exception exception) {}
        } else {
            if (this.flashCol == 50) {
                this.startB.setBackground(Color.RED);
            }
            if (this.flashCol == 100) {
                this.startB.setBackground(this.DARK_RED);
                this.flashCol = 0;
            }
        }
    }

    public void stopCapture() {
        this.doInit = false;
        this.doCapture = false;
        this.stopCapture = false;
        this.startB.setBackground(null);
        try {
            this.file.seek(0L);
            this.file.write(this.WAV_HEADER, 0, 44);
            this.file.close();
            File file1 = new File(this.filename + ".tmp");
            File file2 = new File(this.filename + ".wav");
            file1.renameTo(file2);
        }
        catch (IOException e) {
            System.err.println("error writing header!");
        }
    }

    public void showCapture() {
        this.startB.setEnabled(false);
        this.stopB.setEnabled(false);
        this.pauseB.setEnabled(false);
        if (!this.initialized) {
            this.startB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AudioCapture.this.startB.setForeground(Color.WHITE);
                    AudioCapture.this.doStartCapture = false;
                    AudioCapture.this.startB.setEnabled(false);
                    AudioCapture.this.selectB.setEnabled(false);
                    AudioCapture.this.stopB.setEnabled(true);
                    AudioCapture.this.pauseB.setEnabled(true);
                    AudioCapture.this.init();
                }
            });
            this.stopB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AudioCapture.this.startB.setEnabled(false);
                    AudioCapture.this.startB.setBackground(null);
                    AudioCapture.this.startB.setForeground(Color.BLACK);
                    AudioCapture.this.doStartCapture = false;
                    AudioCapture.this.startB.setEnabled(true);
                    AudioCapture.this.selectB.setEnabled(true);
                    AudioCapture.this.stopB.setEnabled(false);
                    AudioCapture.this.pauseB.setEnabled(false);
                    AudioCapture.this.stopCapture();
                }
            });
            this.selectB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AudioCapture.this.select();
                }
            });
            this.pauseB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AudioCapture.this.doStartCapture = false;
                    AudioCapture.this.startB.setBackground(null);
                    AudioCapture.this.startB.setForeground(Color.BLACK);
                    if (AudioCapture.this.doCapture) {
                        AudioCapture.this.doCapture = false;
                        AudioCapture.this.pauseB.setBackground(Color.RED);
                    } else {
                        AudioCapture.this.doCapture = true;
                        AudioCapture.this.pauseB.setBackground(Color.GREEN);
                    }
                }
            });
            this.initialized = true;
        }
        this.gfx.display.setSize(400, 120);
        this.gfx.display.setPreferredSize(new Dimension(400, 120));
        this.add(this.gfx.display);
        this.add(this.selectB);
        this.add(this.startB);
        this.add(this.pauseB);
        this.add(this.stopB);
        this.pauseB.setBackground(Color.GREEN);
        this.setLayout(new FlowLayout(1, 15, 12));
        this.setTitle("AudioCapture");
        this.setSize(460, 220);
        this.setResizable(false);
        this.setVisible(true);
        CPC.showAudioCapture = false;
    }

    public void putLong(byte[] buffer, int offs, int data) {
        buffer[offs] = (byte)(data & 0xFF);
        buffer[offs + 1] = (byte)(data >> 8 & 0xFF);
        buffer[offs + 2] = (byte)(data >> 16 & 0xFF);
        buffer[offs + 3] = (byte)(data >> 24 & 0xFF);
    }
}

