/*
 * Decompiled with CFR 0.152.
 */
package jemu.core.device.tape;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;

public class Samp2CDT {
    byte[] pulseBuffer;
    final int ACTION_DEFAULT = 0;
    final int ACTION_SLDETECT = 1;
    final int LDR_UNKNOWN = 0;
    final int LDR_APPLEBY = 1;
    final int LDR_USGOLD = 2;
    final int LDR_SLOCKDATA = 3;
    final int LDR_SLOCKDATA2 = 4;
    final int LDR_SLOCKDATA3 = 5;
    final int LDR_SPEEDLOCKV0 = 6;
    final int LDR_SPEEDLOCKV1 = 7;
    final int LDR_SPEEDLOCKV2 = 8;
    final int LDR_SPEEDLOCKV3 = 9;
    final int LDR_SPEEDLOCKV4 = 10;
    final int LDR_SPECROM = 11;
    final int LDR_BLEEPV1 = 12;
    final int LDR_BLEEPV2 = 13;
    final int LDR_BLEEPV3 = 14;
    final int LDR_CODEMASTERS = 15;
    final int LDR_RICOCHET = 16;
    final int LDR_FIREMUS = 17;
    final int LDR_STANDARD = 18;
    final int LDR_CASSYS = 19;
    final int LDR_MICROKEY = 20;
    final int LDR_SPECVAR2 = 21;
    final int LDR_SPECVAR3 = 22;
    final int LDR_SPECVAR4 = 23;
    int sample_frequency;
    byte[] temp = new byte[131072];
    byte[] tstr = new byte[14];
    byte[] tzxbuf = new byte[]{90, 88, 84, 97, 112, 101, 33, 26, 1, 12};
    BufferedOutputStream ofh;
    boolean write_initial_pause = true;
    boolean display_initial_pause = true;
    final int WRITE_BLOCK_NONE = 0;
    final int WRITE_BLOCK_PURE_DATA = 1;
    final int WRITE_BLOCK_TURBO_LOADING = 2;
    final int WRITE_BLOCK_TONE = 3;
    final int WRITE_BLOCK_PULSES = 4;
    int write_block_type = 0;
    boolean write_group_end = false;
    int previous_write_block_type = 0;
    int ldrskip = -1;
    int ldrtype = -1;
    int ldrcur = 0;
    int ldrend = -1;
    int slblock = -1;
    int actioncur = 0;
    int slockmain = -1;
    int RICOCHET_SYNC1 = 693;
    int RICOCHET_SYNC2 = 924;
    int RICOCHET_HP_PILOT = 2295;
    int RICOCHET_BIT0 = 924;
    int RICOCHET_BIT1 = 1848;
    int CODEMASTERS_SYNC1 = 1103;
    int CODEMASTERS_SYNC2 = 630;
    int CODEMASTERS_HP_PILOT = 2276;
    int CODEMASTERS_BIT0 = 575;
    int CODEMASTERS_BIT1 = 1150;
    int FIREMUS_SYNC1 = 945;
    int FIREMUS_SYNC2 = 630;
    int FIREMUS_BIT0 = 860;
    int FIREMUS_BIT1 = 1720;
    int FIREMUS_HP_PILOT = 1720;
    int BLEEPV3_BIT0 = 800;
    int BLEEPV3_BIT1 = 1600;
    int BLEEPV1_HP_PILOT = 1600;
    int BLEEPV1_SYNC1 = 945;
    int BLEEPV1_SYNC2 = 630;
    int BLEEPV1_BIT0 = 800;
    int BLEEPV1_BIT1 = 1600;
    int SLOCKDATA_SYNC1 = 945;
    int SLOCKDATA_SYNC2 = 630;
    int SLOCKDATA_BIT0 = 580;
    int SLOCKDATA_BIT1 = 1161;
    int SLOCKDATA_HP_PILOT = 2200;
    int SLOCKDATA2_HP_PILOT = 2300;
    int SLOCKDATA2_SYNC1 = 788;
    int SLOCKDATA2_SYNC2 = 788;
    int SLOCKDATA2_BIT0 = 760;
    int SLOCKDATA2_BIT1 = 1520;
    int SLOCKDATA3_HP_PILOT = 2300;
    int SLOCKDATA3_SYNC1 = 788;
    int SLOCKDATA3_SYNC2 = 788;
    int SLOCKDATA3_BIT0 = 760;
    int SLOCKDATA3_BIT1 = 1520;
    int APPLEBY_SYNC1 = 945;
    int APPLEBY_SYNC2 = 630;
    int APPLEBY_BIT0 = 620;
    int APPLEBY_BIT1 = 1240;
    int APPLEBY_HP_PILOT = 2257;
    int APPLEBY_MIN_PILOT = 100;
    int USG_HP_PILOT = 2304;
    int USG_SYNC1 = 1001;
    int USG_SYNC2 = 539;
    int USG_BIT0 = 639;
    int USG_BIT1 = 1278;
    int SPECROM_HP_PILOT = 2168;
    int SPECROM_SYNC1 = 667;
    int SPECROM_SYNC2 = 735;
    int SPECROM_BIT0 = 855;
    int SPECROM_BIT1 = 1710;
    int SPECROM_PILOT_HEAD = 8064;
    int SPECROM_PILOT_DATA = 3220;
    int SPECVAR2_HP_PILOT = 2220;
    int SPECVAR2_SYNC1 = 667;
    int SPECVAR2_SYNC2 = 735;
    int SPECVAR2_BIT0 = 848;
    int SPECVAR2_BIT1 = 1695;
    int SPECVAR3_HP_PILOT = 2272;
    int SPECVAR3_SYNC1 = 667;
    int SPECVAR3_SYNC2 = 735;
    int SPECVAR3_BIT0 = 580;
    int SPECVAR3_BIT1 = 1160;
    int SPECVAR4_HP_PILOT = 2026;
    int SPECVAR4_SYNC1 = 667;
    int SPECVAR4_SYNC2 = 735;
    int SPECVAR4_BIT0 = 783;
    int SPECVAR4_BIT1 = 1565;
    int DUX_HP_PILOT = 2075;
    int DUX_SYNC1 = 945;
    int DUX_SYNC2 = 630;
    int DUX_BIT0 = 800;
    int DUX_Bit1 = 1600;
    int STD_TRES = 10;
    int TRES_FULL = 35;
    int TRES_01 = 40;
    int TRES_END = 60;
    int MIN_PILOT = 50;
    boolean ignore = false;
    int aprox = 1;
    int forcep;
    int alter = 0;
    int difend = 0;
    int middle = 0;
    int plen = 0;
    int lplen;
    int pilot;
    int num0;
    int num1;
    double total;
    double total0;
    double total1;
    double t_states_per_sample;
    double samples_per_t_state;
    int block = 0;
    int start;
    int endb;
    int sync1;
    int sync2;
    int hp0;
    int hp1;
    int hpt;
    int hp01;
    int apilot;
    int ahp0;
    int ahp1;
    int posbyte;
    int posbit;
    int currbit;
    float pausev;
    byte[] buf2 = new byte[256];
    int custom = 32;
    int lst_pilot;
    int dif;
    boolean PilotOK;
    int NoData;
    byte[] finp;
    byte[] fout;
    byte[] errstr = new byte[256];
    int n = 0;
    short[] slock12sync = new short[]{3150, 3150, 1130, 1130, 1130, 1130, 1130, 1130, 565, 565, 1130, 1130, 565, 565};
    short[] slock34sync = new short[]{667, 735, 714, 714, 1428, 1428, 2144, 2144, 2144, 2144, 2144, 2144, 1428, 1428, 714, 714, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    short[] slockmidsync = new short[42];
    int subblocknum = 1;
    int totallen;
    char totalcheck;
    int ClickLen;
    int[] ClickPulses = new int[10];
    int PilotPulse;
    int NumPilotParts;
    int[] PilotParts = new int[50];
    int bleepv3pilot;
    int bleepv3sync1;
    int bleepv3bits;
    int pulseOffset = 0;
    final int BLEEPV3_PILOT_BYTE = 15;

    int ToTStates(int Samples2) {
        return (int)((double)Samples2 / this.samples_per_t_state + 0.5);
    }

    int PauseToMilliseconds(double pause) {
        return (int)((pause + 5.0E-4) * 1000.0);
    }

    private static void write(BufferedOutputStream bos, byte[] data) {
        Samp2CDT.write(bos, data, data.length);
    }

    private static void write(BufferedOutputStream bos, byte[] data, int len) {
        try {
            for (int i = 0; i < len; ++i) {
                bos.write(data[i]);
            }
        }
        catch (Exception e) {
            Samp2CDT.Error("File error!");
        }
    }

    static void write_short(BufferedOutputStream fh, short data) {
        byte[] local_byte = new byte[]{(byte)(data & 0xFF), (byte)(data >> 8 & 0xFF)};
        Samp2CDT.write(fh, local_byte);
    }

    static void write_long(BufferedOutputStream fh, long data) {
        byte[] local_byte = new byte[]{(byte)(data & 0xFFL), (byte)(data >> 8 & 0xFFL), (byte)(data >> 16 & 0xFFL), (byte)(data >> 24 & 0xFFL)};
        Samp2CDT.write(fh, local_byte);
    }

    static long read_long(BufferedInputStream fh, long pData) {
        long local_long;
        byte[] data = new byte[4];
        pData = local_long = (long)(data[0] & 0xFF | (data[1] & 0xFF) << 8 | (data[2] & 0xFF) << 16 | (data[3] & 0xFF) << 24);
        return 4L;
    }

    static void Error(String errstr) {
        System.err.println("\n-- Error: " + errstr);
        System.exit(0);
    }

    int diff_abs(int x) {
        return x < 0 ? -x : x;
    }

    float diff_abs(float x) {
        return x < 0.0f ? -x : x;
    }

    int Diff(int a, int b) {
        if (a == b) {
            return 0;
        }
        int max = a;
        if (b > max) {
            max = b;
        }
        if (max == 0) {
            return 0;
        }
        int diff = b - a;
        diff = this.diff_abs(diff);
        return diff * 100 / max;
    }

    int Diff2(float a, float b) {
        if (a == b) {
            return 0;
        }
        float max = a;
        if (b > max) {
            max = b;
        }
        if (max == 0.0f) {
            return 0;
        }
        float diff = b - a;
        diff = this.diff_abs(diff);
        return (int)(diff * 100.0f / max);
    }

    String CassysCheckSum(int len) {
        return "? ";
    }

    String SpanishChecksum(int len) {
        char c = '\u0000';
        int n = 0;
        if (this.posbit != 8 && !this.ignore) {
            --len;
        }
        while (n < len) {
            c = (char)(c ^ this.temp[n]);
            ++n;
        }
        if (c != '\u0000') {
            return "X ";
        }
        return "O ";
    }

    String SpeedlockV1CheckSum(int len) {
        char c = '\u0000';
        int n = 0;
        if (this.posbit != 8 && !this.ignore) {
            --len;
        }
        while (n < len) {
            c = (char)(c ^ this.temp[n]);
            ++n;
        }
        if (c != '\u0000') {
            return "X ";
        }
        return "O ";
    }

    int GetBits(int bitoffset, int count) {
        int databyte = 0;
        int byteoffs = bitoffset >> 3;
        int bitinbyte = bitoffset & 7;
        for (int i = 0; i < count; ++i) {
            int data = this.temp[byteoffs] & 0xFF;
            data = data >> 7 - bitinbyte & 1;
            databyte <<= 1;
            databyte |= data;
            if (++bitinbyte != 8) continue;
            bitinbyte = 0;
            ++byteoffs;
        }
        return databyte;
    }

    void ShiftBits(byte[] pSrc, int len, int nbits) {
        int off = len - 1;
        int mask1 = 255 >> nbits;
        int mask2 = mask1 ^ 0xFF;
        for (int i = 0; i < len; ++i) {
            int data1 = pSrc[off] & 0xFF;
            int data2 = pSrc[--off] & 0xFF;
            int data = data1 >> nbits;
            data &= mask1;
            pSrc[++off] = (byte)(data |= data2 << 8 - nbits & mask2);
            --off;
        }
    }

    String BleepV1Checksum(int len) {
        int c = 0;
        for (int n = 0; n < len - 2; ++n) {
            int datab = this.temp[n + 1] & 0xFF;
            c = (char)(c ^ datab);
        }
        if (c != (this.temp[len - 1] & 0xFF)) {
            return "X ";
        }
        return "O ";
    }

    boolean BleepV3Check(int len) {
        int c = 0;
        for (int n = 0; n < len - this.pilot - 3; ++n) {
            int datab = this.temp[n + this.pilot + 3] & 0xFF;
            c = (char)(c ^ datab);
        }
        return c == (this.temp[len - 1] & 0xFF);
    }

    String BleepV3Checksum(int len) {
        if (this.BleepV3Check(len)) {
            return "O ";
        }
        if (this.bleepv3bits != 0) {
            this.ShiftBits(this.temp, len, 8 - this.bleepv3bits);
            if (this.BleepV3Check(len)) {
                return "O ";
            }
        }
        return "X ";
    }

    String FirebirdMusicChecksum(int len) {
        int c = 0;
        int n = 0;
        boolean musicdata = false;
        int databytecount = 0;
        int blockcount = 0;
        int bitoffset = 11;
        int datab = this.GetBits(bitoffset += 3, 8);
        bitoffset += 8;
        c = (char)(c ^ datab);
        datab = this.GetBits(bitoffset += 3, 8);
        bitoffset += 8;
        if (c != datab) {
            return "X ";
        }
        while (bitoffset < (this.posbyte << 3) + this.posbit) {
            int code = this.GetBits(bitoffset, 3);
            datab = this.GetBits(bitoffset += 3, 8);
            bitoffset += 8;
            if (musicdata) {
                if (datab == 255) {
                    musicdata = false;
                }
            } else if ((code & 3) == 0) {
                c = (char)(c ^ datab);
                if (++databytecount == 256) {
                    ++blockcount;
                    databytecount = 0;
                    datab = this.GetBits(bitoffset += 3, 8);
                    bitoffset += 8;
                    c = (char)(c ^ datab);
                    datab = this.GetBits(bitoffset += 3, 8);
                    bitoffset += 8;
                    c = (char)(c ^ datab);
                    datab = this.GetBits(bitoffset += 3, 8);
                    bitoffset += 8;
                    if (c != datab) {
                        return "X ";
                    }
                }
            } else {
                musicdata = true;
                if (datab == 255) {
                    musicdata = false;
                }
            }
            ++n;
        }
        if (blockcount != 0 && databytecount == 0) {
            return "O ";
        }
        return "X ";
    }

    String BleepV2Checksum(int len) {
        int c = 0;
        int bitoffset = 10;
        int lengthInBytes = ((this.posbyte << 3) + this.posbit) / 9;
        for (int n = 0; n < lengthInBytes - 2; ++n) {
            int datab = this.GetBits(bitoffset, 8);
            c = (char)(c ^ datab);
            bitoffset += 9;
        }
        if (((c ^ this.GetBits(bitoffset, 8)) & 0xFF) != 0) {
            return "X ";
        }
        return "O ";
    }

    String USG_CheckSum(int len, int init, int add1, int add2) {
        int n = 0;
        if (this.posbit != 8 && !this.ignore) {
            --len;
        }
        char c = '\u0000';
        while (n < len) {
            c = (char)(c + this.temp[n]);
            ++n;
        }
        int check_adj = init;
        check_adj += add1;
        check_adj += add1;
        for (int i = 0; i < len - 3; ++i) {
            int len2 = len - 3 - i;
            int d = len2 >> 8 & 0xFF;
            int e = len2 & 0xFF;
            if ((e & 0x10) != 0) {
                check_adj += add2;
                check_adj += e;
                check_adj -= d;
            }
            check_adj += add1;
        }
        int check = this.temp[len - 1];
        check ^= 1;
        check ^= check_adj;
        if ((this.temp[len - 1] + (check &= 0xFF) & 0xFF) == (c & 0xFF)) {
            return "O ";
        }
        return "X ";
    }

    String SpectrumCheckSum(int len) {
        char c = '\u0000';
        int n = 0;
        if (this.posbit != 8 && !this.ignore) {
            --len;
        }
        while (n < len - 1) {
            c = (char)(c ^ this.temp[n]);
            ++n;
        }
        if (c == this.temp[len - 1]) {
            return "O ";
        }
        return "X ";
    }

    String CheckSum2(int len) {
        int c = 0;
        for (int n = 0; n < len - 1; ++n) {
            c += this.temp[n + 1] & 0xFF;
        }
        if (c == (this.temp[0] & 0xFF)) {
            return "O ";
        }
        return "X ";
    }

    String SpeedlockDataCheckSum(int len) {
        int c = 0;
        for (int n = 0; n < len - 1; ++n) {
            c = (char)(c + (this.temp[n] & 0xFF));
        }
        if (c == (this.temp[len - 1] & 0xFF)) {
            return "O ";
        }
        return "X ";
    }

    String SpeedlockDataCheckSum2(int len) {
        int c = 0;
        for (int n = 0; n < len - 1; ++n) {
            c = (char)(c + (this.temp[n + 1] & 0xFF));
        }
        if (c == (this.temp[0] & 0xFF)) {
            return "O ";
        }
        return "X ";
    }

    byte[] Identify(int len) {
        if ((this.temp[0] & 0xFF) == 44) {
            for (int i = 0; i < 12; ++i) {
                this.tstr[i] = 32;
            }
            this.tstr[12] = 0;
            for (int n = 0; n < 12 && (this.temp[n + 1] & 0xFF) != 0; ++n) {
                this.tstr[n] = this.temp[n + 1];
            }
        } else {
            for (int i = 0; i < 12; ++i) {
                this.tstr[i] = 45;
            }
        }
        return this.tstr;
    }

    void SavePureData(byte[] data, int len) {
        int PauseInMilliseconds = this.PauseToMilliseconds(this.pausev);
        this.buf2[0] = 20;
        this.buf2[1] = (byte)(this.ahp0 & 0xFF);
        this.buf2[2] = (byte)(this.ahp0 >> 8);
        this.buf2[3] = (byte)(this.ahp1 & 0xFF);
        this.buf2[4] = (byte)(this.ahp1 >> 8);
        this.buf2[5] = (byte)this.posbit;
        this.buf2[6] = (byte)(PauseInMilliseconds & 0xFF);
        this.buf2[7] = (byte)(PauseInMilliseconds >> 8 & 0xFF);
        this.buf2[8] = (byte)(len & 0xFF);
        this.buf2[9] = (byte)(len >> 8 & 0xFF);
        this.buf2[10] = (byte)(len >> 8 >> 8);
        Samp2CDT.write(this.ofh, this.buf2, 11);
        Samp2CDT.write(this.ofh, data, len);
    }

    void SaveSpeedlockMidSync() {
        this.buf2[0] = 19;
        this.buf2[1] = 42;
        this.n = 0;
        while (this.n < 21) {
            if (this.n < 5 || this.n > 15) {
                this.slockmidsync[1 + this.n * 2] = 875;
                this.slockmidsync[this.n * 2] = 875;
            } else {
                this.slockmidsync[1 + this.n * 2] = 1750;
                this.slockmidsync[this.n * 2] = 1750;
            }
            ++this.n;
        }
        Samp2CDT.write(this.ofh, this.buf2, 2);
        this.n = 0;
        while (this.n < 42) {
            Samp2CDT.write_short(this.ofh, this.slockmidsync[this.n]);
            ++this.n;
        }
    }

    void SaveGroupEnd() {
        this.buf2[0] = 34;
        Samp2CDT.write(this.ofh, this.buf2, 1);
    }

    void SaveGroupStart(byte[] pGroupText) {
        int group_desc_length = pGroupText.length;
        this.buf2[0] = 33;
        this.buf2[1] = (byte)group_desc_length;
        Samp2CDT.write(this.ofh, this.buf2, 2);
        if (group_desc_length != 0) {
            Samp2CDT.write(this.ofh, pGroupText, group_desc_length);
        }
    }

    void SaveTurboLoadingDataBlock() {
        int PauseInMilliseconds = this.PauseToMilliseconds(this.pausev);
        this.buf2[0] = 17;
        this.buf2[1] = (byte)(this.apilot & 0xFF);
        this.buf2[2] = (byte)(this.apilot >> 8);
        this.buf2[3] = (byte)(this.sync1 & 0xFF);
        this.buf2[4] = (byte)(this.sync1 >> 8);
        this.buf2[5] = (byte)(this.sync2 & 0xFF);
        this.buf2[6] = (byte)(this.sync2 >> 8);
        this.buf2[7] = (byte)(this.ahp0 & 0xFF);
        this.buf2[8] = (byte)(this.ahp0 >> 8);
        this.buf2[9] = (byte)(this.ahp1 & 0xFF);
        this.buf2[10] = (byte)(this.ahp1 >> 8);
        this.buf2[11] = (byte)(this.lst_pilot & 0xFF);
        this.buf2[12] = (byte)(this.lst_pilot >> 8);
        this.buf2[13] = (byte)this.posbit;
        this.buf2[14] = (byte)(PauseInMilliseconds & 0xFF);
        this.buf2[15] = (byte)(PauseInMilliseconds >> 8 & 0xFF);
        this.buf2[16] = (byte)(this.posbyte & 0xFF);
        this.buf2[17] = (byte)(this.posbyte >> 8 & 0xFF);
        this.buf2[18] = (byte)(this.posbyte >> 8 >> 8);
        Samp2CDT.write(this.ofh, this.buf2, 19);
        if (this.posbyte != 0) {
            Samp2CDT.write(this.ofh, this.temp, this.posbyte);
        }
    }

    void SaveStandardSpeedDataBlock() {
        int PauseInMilliseconds = this.PauseToMilliseconds(this.pausev);
        this.buf2[0] = 16;
        this.buf2[1] = (byte)(PauseInMilliseconds & 0xFF);
        this.buf2[2] = (byte)(PauseInMilliseconds >> 8 & 0xFF);
        this.buf2[3] = (byte)(this.posbyte & 0xFF);
        this.buf2[4] = (byte)(this.posbyte >> 8);
        Samp2CDT.write(this.ofh, this.buf2, 5);
        if (this.posbyte != 0) {
            Samp2CDT.write(this.ofh, this.temp, this.posbyte);
        }
    }

    void SavePureTone(int PulseLen, int NumPulses) {
        this.buf2[0] = 18;
        this.buf2[1] = (byte)(PulseLen & 0xFF);
        this.buf2[2] = (byte)(PulseLen >> 8 & 0xFF);
        this.buf2[3] = (byte)(NumPulses & 0xFF);
        this.buf2[4] = (byte)(NumPulses >> 8 & 0xFF);
        Samp2CDT.write(this.ofh, this.buf2, 5);
    }

    void SaveDataAsPulses(byte[] data, int lenbytes, int lenbits) {
        int BitOffset = 0;
        this.buf2[0] = 19;
        this.buf2[1] = 1;
        this.buf2[2] = 0;
        this.buf2[3] = 4;
        Samp2CDT.write(this.ofh, this.buf2, 4);
        int PulseCount = lenbytes * 8 + lenbits;
        do {
            this.buf2[0] = 19;
            int NumPulses = PulseCount > 255 ? 255 : PulseCount;
            PulseCount -= NumPulses;
            this.buf2[1] = (byte)(NumPulses & 0xFF);
            Samp2CDT.write(this.ofh, this.buf2, 2);
            for (int i = 0; i < NumPulses; ++i) {
                int datab = data[BitOffset >> 3] & 1 << 7 - (BitOffset & 7);
                int PulseLen = datab != 0 ? this.ahp1 : this.ahp0;
                this.buf2[0] = (byte)(PulseLen & 0xFF);
                this.buf2[1] = (byte)(PulseLen >> 8 & 0xFF);
                Samp2CDT.write(this.ofh, this.buf2, 2);
                ++BitOffset;
            }
        } while (PulseCount != 0);
    }

    void SavePulses(int NumPulses, short[] PulseBuffer) {
        this.buf2[0] = 19;
        this.buf2[1] = (byte)NumPulses;
        Samp2CDT.write(this.ofh, this.buf2, 2);
        this.n = 0;
        while (this.n < NumPulses) {
            Samp2CDT.write_short(this.ofh, PulseBuffer[this.n]);
            ++this.n;
        }
    }

    boolean DetectStandardLoading(int hp0, int hp1, int hppilot, int numpilot) {
        return this.Diff(hp0, this.SPECROM_BIT0) <= this.STD_TRES && this.Diff(hp1, this.SPECROM_BIT1) <= this.STD_TRES && this.Diff(hppilot, this.SPECROM_HP_PILOT) <= this.STD_TRES && this.posbyte < 65536 && ((this.temp[0] & 0xFF) != 0 && this.Diff(numpilot, this.SPECROM_PILOT_DATA) <= this.STD_TRES || (this.temp[0] & 0xFF) == 0 && this.Diff(numpilot, this.SPECROM_PILOT_HEAD) <= this.STD_TRES);
    }

    void WritePause(double pause) {
        int PauseInMilliseconds = this.PauseToMilliseconds(pause);
        this.buf2[0] = 32;
        this.buf2[1] = (byte)(PauseInMilliseconds & 0xFF);
        this.buf2[2] = (byte)(PauseInMilliseconds >> 8 & 0xFF);
        Samp2CDT.write(this.ofh, this.buf2, 3);
    }

    void WriteInitialPause() {
        if (this.write_initial_pause) {
            this.write_initial_pause = false;
            double pause = this.start / this.sample_frequency;
            if (pause < 0.0) {
                pause = 0.0;
            }
            this.WritePause(pause);
        }
    }

    void WritePossiblePause() {
        if (this.previous_write_block_type == 3 || this.previous_write_block_type == 4) {
            double pause = (this.start - this.endb) / this.sample_frequency;
            if (pause < 0.0) {
                pause = 0.0;
            }
            this.WritePause(pause);
        }
    }

    void DisplayInitialPause() {
        if (this.display_initial_pause) {
            this.display_initial_pause = false;
            double initialPause = this.start / this.sample_frequency;
            if (initialPause < 0.0) {
                initialPause = 0.0;
            }
            System.out.println("initial P-" + initialPause);
        }
    }

    void SaveTZXBlock() {
        switch (this.write_block_type) {
            case 1: {
                this.SavePureData(this.temp, this.posbyte);
                break;
            }
            case 4: {
                this.SaveDataAsPulses(this.temp, this.posbyte, this.posbit);
                break;
            }
            case 3: {
                this.SavePureTone(this.apilot, this.lst_pilot);
                break;
            }
            case 2: {
                if (this.ldrcur == 11) {
                    if (this.DetectStandardLoading(this.ahp0, this.ahp1, this.apilot, this.lst_pilot)) {
                        this.SaveStandardSpeedDataBlock();
                        break;
                    }
                    this.SaveTurboLoadingDataBlock();
                    break;
                }
                this.SaveTurboLoadingDataBlock();
            }
        }
        if (this.write_group_end) {
            this.SaveGroupEnd();
        }
        this.write_group_end = false;
        this.previous_write_block_type = this.write_block_type;
        this.write_block_type = 0;
    }

    int PulseBuffer_GetPulse(byte[] buffer) {
        return 0;
    }

    boolean PulseBuffer_EOF(byte[] buffer) {
        return true;
    }

    int PulseBuffer_GetCurrentPosition(byte[] buffer) {
        return 0;
    }

    void GetStandardPilot2() {
        do {
            this.lplen = this.plen;
            this.plen = this.PulseBuffer_GetPulse(this.pulseBuffer);
        } while (this.Diff(this.plen, this.lplen) > this.TRES_FULL && !this.PulseBuffer_EOF(this.pulseBuffer));
        this.start = this.PulseBuffer_GetCurrentPosition(this.pulseBuffer) - this.plen + this.lplen;
        this.pilot = 0;
        this.total = 0.0;
        this.plen = (int)(((double)(this.plen + this.lplen) + 0.5) / 2.0);
        if (this.plen == 0) {
            this.PilotOK = false;
            return;
        }
        do {
            this.lplen = this.PulseBuffer_GetPulse(this.pulseBuffer);
            if (this.lplen == 0) continue;
            ++this.pilot;
            this.total += (double)this.lplen;
            float fraction = this.ToTStates(this.plen) / this.ToTStates(this.lplen);
            if (this.lplen < this.plen && (double)fraction >= 1.25 && (double)fraction <= 2.3 || this.lplen > this.plen && (double)fraction < 0.5 || this.lplen < this.plen && (double)fraction > 1.5) break;
        } while (!this.PulseBuffer_EOF(this.pulseBuffer));
        --this.pilot;
        this.total -= (double)this.plen;
        this.PilotOK = this.pilot >= this.MIN_PILOT;
    }

    void GetFixedPilot(int PilotPulseLenT, int PilotMinLen) {
        int PilotPulseLen = (int)((double)PilotPulseLenT * this.samples_per_t_state);
        this.start = this.PulseBuffer_GetCurrentPosition(this.pulseBuffer);
        this.pilot = 0;
        this.total = 0.0;
        do {
            this.lplen = this.PulseBuffer_GetPulse(this.pulseBuffer);
            ++this.pilot;
            this.total += (double)this.lplen;
        } while (this.Diff(PilotPulseLen, this.lplen) <= this.TRES_FULL && !this.PulseBuffer_EOF(this.pulseBuffer));
        --this.pilot;
        this.total -= (double)this.lplen;
        this.PilotOK = this.pilot >= PilotMinLen;
    }

    void GetStandardPilot() {
        do {
            this.lplen = this.plen;
            this.plen = this.PulseBuffer_GetPulse(this.pulseBuffer);
        } while (this.Diff(this.plen, this.lplen) > this.TRES_FULL && !this.PulseBuffer_EOF(this.pulseBuffer));
        this.start = this.PulseBuffer_GetCurrentPosition(this.pulseBuffer) - this.plen + this.lplen;
        this.pilot = 0;
        this.total = 0.0;
        this.plen = (int)(((double)(this.plen + this.lplen) + 0.5) / 2.0);
        do {
            this.lplen = this.PulseBuffer_GetPulse(this.pulseBuffer);
            ++this.pilot;
            this.total += (double)this.lplen;
        } while (this.Diff(this.plen, this.lplen) <= this.TRES_FULL && !this.PulseBuffer_EOF(this.pulseBuffer));
        --this.pilot;
        this.total -= (double)this.plen;
        this.PilotOK = this.pilot >= this.MIN_PILOT;
    }

    int BleepV3GetByte(int pPtr) {
        int i;
        int databyte = 0;
        this.hp0 = 10;
        this.hp1 = 20;
        this.hp01 = 15;
        for (i = 0; i < 8 && !this.PulseBuffer_EOF(this.pulseBuffer); ++i) {
            this.plen = this.PulseBuffer_GetPulse(this.pulseBuffer);
            if ((double)this.plen > 1.5 * (double)this.hp1) break;
            int db = this.plen <= this.hp01 ? 0 : 1;
            databyte <<= 1;
            databyte |= db;
        }
        pPtr = databyte;
        return i;
    }

    void GetBleepV3Sync() {
        int i;
        int bleepv3sync2 = 0;
        for (i = 0; i < 16384; ++i) {
            this.temp[i] = 0;
        }
        this.temp[0] = 0;
        this.num1 = 0;
        this.num0 = 0;
        this.posbit = 0;
        this.posbyte = 0;
        this.total1 = 0.0;
        this.total0 = 0.0;
        for (i = 0; i < this.pilot; ++i) {
            this.temp[this.posbyte++] = (byte)this.bleepv3pilot;
        }
        this.temp[this.posbyte++] = (byte)this.bleepv3sync1;
        int nbits = this.BleepV3GetByte(bleepv3sync2);
        this.temp[this.posbyte++] = (byte)bleepv3sync2;
    }

    void GetBleepV3Data() {
        int nbits;
        int datab = 0;
        int[] SyncString = new int[6];
        boolean NoData = true;
        this.bleepv3bits = 0;
        do {
            if ((nbits = this.BleepV3GetByte(datab)) == 8) {
                this.temp[this.posbyte] = (byte)datab;
                ++this.posbyte;
                NoData = false;
                continue;
            }
            this.bleepv3bits = nbits;
        } while (nbits == 8);
        if (NoData) {
            return;
        }
        NoData = false;
        this.ahp0 = (int)((double)this.hp0 / this.samples_per_t_state);
        this.ahp1 = (int)((double)this.hp1 / this.samples_per_t_state);
        this.endb = this.PulseBuffer_GetCurrentPosition(this.pulseBuffer);
        this.write_block_type = 4;
        ++this.block;
    }

    void GetBleepV3Pilot() {
        int nbits;
        int pilotbytea = 0;
        int pilotbyteb = 0;
        this.pilot = 0;
        this.PilotOK = false;
        do {
            nbits = this.BleepV3GetByte(pilotbytea);
        } while (!this.PulseBuffer_EOF(this.pulseBuffer) && nbits != 8);
        this.start = this.PulseBuffer_GetCurrentPosition(this.pulseBuffer);
        this.bleepv3pilot = pilotbytea;
        do {
            if ((nbits = this.BleepV3GetByte(pilotbyteb)) != 8 || pilotbytea != pilotbyteb) continue;
            ++this.pilot;
        } while (!this.PulseBuffer_EOF(this.pulseBuffer) && pilotbytea == pilotbyteb && nbits == 8);
        --this.pilot;
        if (nbits == 8 && this.pilot > 4) {
            this.bleepv3sync1 = pilotbyteb;
            this.PilotOK = true;
        }
    }
}

