/*
 * Decompiled with CFR 0.152.
 */
package jemu.system.cpc;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import jemu.core.device.Device;
import jemu.system.cpc.CPC;

public class Baslist {
    protected int charPos = 0;
    static String[] Keywords = new String[]{"AFTER", "AUTO", "BORDER", "CALL", "CAT", "CHAIN", "CLEAR", "CLG", "CLOSEIN", "CLOSEOUT", "CLS", "CONT", "DATA", "DEF", "DEFINT", "DEFREAL", "DEFSTR", "DEG", "DELETE", "DIM", "DRAW", "DRAWR", "EDIT", "ELSE", "END", "ENT", "ENV", "ERASE", "ERROR", "EVERY", "FOR", "GOSUB", "GOTO", "IF", "INK", "INPUT", "KEY", "LET", "LINE", "LIST", "LOAD", "LOCATE", "MEMORY", "MERGE", "MID$", "MODE", "MOVE", "MOVER", "NEXT", "NEW", "ON", "ON BREAK", "ON ERROR GOTO", "SQ", "OPENIN", "OPENOUT", "ORIGIN", "OUT", "PAPER", "PEN", "PLOT", "PLOTR", "POKE", "PRINT", "'", "RAD", "RANDOMIZE", "READ", "RELEASE", "REM", "RENUM", "RESTORE", "RESUME", "RETURN", "RUN", "SAVE", "SOUND", "SPEED", "STOP", "SYMBOL", "TAG", "TAGOFF", "TROFF", "TRON", "WAIT", "WEND", "WHILE", "WIDTH", "WINDOW", "WRITE", "ZONE", "DI", "EI", "FILL", "GRAPHICS", "MASK", "FRAME", "CURSOR", null, "ERL", "FN", "SPC", "STEP", "SWAP", null, null, "TAB", "THEN", "TO", "USING", ">", "=", ">=", "<", "<>", "<=", "+", "-", "*", "/", "^", "\\", "AND", "MOD", "OR", "XOR", "NOT", null};
    static String[] AdditionalKeywords = new String[]{"ABS", "ASC", "ATN", "CHR$", "CINT", "COS", "CREAL", "EXP", "FIX", "FRE", "INKEY", "INP", "INT", "JOY", "LEN", "LOG", "LOG10", "LOWER$", "PEEK", "REMAIN", "SGN", "SIN", "SPACE$", "SQ", "SQR", "STR$", "TAN", "UNT", "UPPER$", "VAL", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, "EOF", "ERR", "HIMEM", "INKEY$", "PI", "RND", "TIME", "XPOS", "YPOS", "DERR", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, "BIN$", "DEC$", "HEX$", "INSTR", "LEFT$", "MAX", "MIN", "POS", "RIGHT$", "ROUND", "STRING$", "TEST", "TESTR", "COPYCHR$", "VPOS", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null};
    String result = "";
    protected static final String HEX_CHARS = "0123456789ABCDEF";
    static String str;
    final String lineholder = "fejo23435rj2djejfuiuigheroifjioer";
    final String placeholder = "x666666666xZZyyT222T";
    public boolean reformat = false;
    public int[] addresses = new int[65537];
    public int[] lines = new int[65537];
    public String[] codes = new String[65537];
    int actlinenumber;

    protected String DisplayVariable(String pLinePtr) {
        char ch;
        do {
            ch = pLinePtr.charAt(this.charPos);
            ++this.charPos;
            this.result = this.result + (char)(ch & 0x7F);
        } while ((ch & 0x80) == 0);
        return pLinePtr;
    }

    public double Round(double r, int decimalPlace) {
        BigDecimal bd = new BigDecimal(r);
        bd = bd.setScale(decimalPlace, RoundingMode.HALF_EVEN);
        r = bd.doubleValue();
        return r;
    }

    protected void TranslateLine(String pLinePtr, long LineLength) {
        char Token2;
        String pLocalLinePtr = pLinePtr;
        this.charPos = 0;
        block19: do {
            Token2 = pLocalLinePtr.charAt(this.charPos);
            ++this.charPos;
            switch (Token2) {
                case '\u0000': {
                    break;
                }
                case '\u0001': {
                    if (pLocalLinePtr.charAt(this.charPos) == '\u0097' || pLocalLinePtr.charAt(this.charPos) == '\u00c0') continue block19;
                    this.result = this.result + ":";
                    break;
                }
                case '\u0002': {
                    this.charPos += 2;
                    pLocalLinePtr = this.DisplayVariable(pLocalLinePtr);
                    this.result = this.result + "%";
                    break;
                }
                case '\u0003': {
                    this.charPos += 2;
                    pLocalLinePtr = this.DisplayVariable(pLocalLinePtr);
                    this.result = this.result + "$";
                    break;
                }
                case '\u0004': {
                    this.charPos += 2;
                    pLocalLinePtr = this.DisplayVariable(pLocalLinePtr);
                    this.result = this.result + "!";
                    break;
                }
                case '\u0005': 
                case '\u0006': 
                case '\u0007': 
                case '\b': 
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': {
                    this.charPos += 2;
                    pLocalLinePtr = this.DisplayVariable(pLocalLinePtr);
                    break;
                }
                case '\u000e': 
                case '\u000f': 
                case '\u0010': 
                case '\u0011': 
                case '\u0012': 
                case '\u0013': 
                case '\u0014': 
                case '\u0015': 
                case '\u0016': 
                case '\u0017': 
                case '\u0018': {
                    int Num = Token2 - 14;
                    this.result = this.result + (Num & 0xFF);
                    break;
                }
                case '\u0019': {
                    short Number2 = (short)(pLocalLinePtr.charAt(this.charPos) & 0xFF);
                    this.result = this.result + (Number2 & 0xFF);
                    ++this.charPos;
                    break;
                }
                case '\u001a': {
                    short Number2 = (short)(pLocalLinePtr.charAt(this.charPos) & 0xFF | (pLocalLinePtr.charAt(this.charPos + 1) & 0xFF) << 8);
                    this.result = this.result + (Number2 & 0xFFFF);
                    this.charPos += 2;
                    break;
                }
                case '\u001b': {
                    boolean bIgnoreDigit = true;
                    short Number2 = (short)(pLocalLinePtr.charAt(this.charPos) & 0xFF | (pLocalLinePtr.charAt(this.charPos + 1) & 0xFF) << 8);
                    this.result = this.result + "&X";
                    for (int j = 0; j < 16; ++j) {
                        int bd = Number2 >> 15 - j & 1;
                        if (bd != 0) {
                            bIgnoreDigit = false;
                        }
                        if (bIgnoreDigit) continue;
                        this.result = this.result + (char)(48 + bd);
                    }
                    this.charPos += 2;
                    break;
                }
                case '\u001c': {
                    short Number2 = (short)(pLocalLinePtr.charAt(this.charPos) & 0xFF | (pLocalLinePtr.charAt(this.charPos + 1) & 0xFF) << 8);
                    String r = Baslist.hex((short)(Number2 & 0xFFFF));
                    while (r.startsWith("0")) {
                        r = r.substring(1);
                    }
                    this.result = this.result + "&" + r;
                    this.charPos += 2;
                    break;
                }
                case '\u001d': {
                    short Number2 = (short)(pLocalLinePtr.charAt(this.charPos) & 0xFF | (pLocalLinePtr.charAt(this.charPos + 1) & 0xFF) << 8);
                    this.actlinenumber = Number2 & 0xFFFF;
                    byte[] d = new byte[2];
                    d[0] = (byte)CPC.memory.readWriteByte(this.actlinenumber + 3);
                    d[1] = (byte)CPC.memory.readWriteByte(this.actlinenumber + 4);
                    this.result = this.result + Device.getWord(d, 0);
                    this.charPos += 2;
                    break;
                }
                case '\u001e': {
                    short Number2 = (short)(pLocalLinePtr.charAt(this.charPos) & 0xFF | (pLocalLinePtr.charAt(this.charPos + 1) & 0xFF) << 8);
                    this.result = this.result + (Number2 & 0xFFFF);
                    this.charPos += 2;
                    break;
                }
                case '\u001f': {
                    char[] bufFile = new char[]{pLocalLinePtr.charAt(this.charPos), pLocalLinePtr.charAt(this.charPos + 1), pLocalLinePtr.charAt(this.charPos + 2), pLocalLinePtr.charAt(this.charPos + 3), pLocalLinePtr.charAt(this.charPos + 4)};
                    double f = ((bufFile[3] & 0x7F) << 24) + (bufFile[2] << 16) + (bufFile[1] << 8) + bufFile[0];
                    f = 1.0 + f / Math.pow(2.0, 31.0);
                    if ((bufFile[3] & 0x80) != 0) {
                        f = -f;
                    }
                    double exp = (double)(bufFile[4] & 0xFF) - 129.0;
                    String e = "" + this.Round(f * Math.pow(2.0, exp), 9);
                    if (e.contains("E-")) {
                        String b = e;
                        while (!b.startsWith("E-")) {
                            b = b.substring(1);
                        }
                        b = b.replace("E-", "");
                        while (!e.endsWith("E")) {
                            e = e.substring(0, e.length() - 1);
                        }
                        e = e.replace("E", "");
                        e = e.replace(".", "");
                        int c = Integer.parseInt(b);
                        String t = "";
                        for (int i = 1; i < c; ++i) {
                            t = "0" + t;
                        }
                        t = t + e;
                        while (t.endsWith("0")) {
                            t = t.substring(0, t.length() - 1);
                        }
                        e = t = "0." + t;
                    }
                    this.result = this.result + e;
                    this.charPos += 5;
                    break;
                }
                case '\"': {
                    char ch = Token2;
                    this.result = this.result + ch;
                    do {
                        ch = pLocalLinePtr.charAt(this.charPos);
                        ++this.charPos;
                        if (ch == '\u0000') {
                            --this.charPos;
                            continue;
                        }
                        this.result = this.result + ch;
                    } while (ch != '\"' && ch != '\u0000');
                    break;
                }
                case '\u00ff': {
                    char Keyword = pLocalLinePtr.charAt(this.charPos);
                    ++this.charPos;
                    if (AdditionalKeywords[Keyword & 0xFF] == null) break;
                    this.result = this.result + AdditionalKeywords[Keyword & 0xFF];
                    break;
                }
                case '|': {
                    this.result = this.result + "|";
                    ++this.charPos;
                    pLocalLinePtr = this.DisplayVariable(pLocalLinePtr);
                    break;
                }
                default: {
                    if (Token2 >= '\u0080' && Token2 <= '\u00fe') {
                        char NextToken;
                        if (Keywords[Token2 - 128] != null) {
                            this.result = this.result + Keywords[Token2 - 128];
                        }
                        if (Token2 != '\u00bf' || (NextToken = pLocalLinePtr.charAt(this.charPos)) != '\u00ff' && (NextToken < '\u0080' || NextToken > '\u00fe') && (NextToken < '\u0002' || NextToken > '\r')) break;
                        this.result = this.result + " ";
                        break;
                    }
                    if (Token2 >= ' ' && Token2 <= '\u007f') {
                        this.result = this.result + Token2;
                        break;
                    }
                    if (Keywords[Token2 & 0x7F] == null) continue block19;
                    this.result = this.result + Keywords[Token2 & 0x7F];
                }
            }
            this.result = this.result + "x666666666xZZyyT222T";
        } while (Token2 != '\u0000');
    }

    protected String formattedString(String replace) {
        replace = replace.replace("x666666666xZZyyT222T", "");
        return replace;
    }

    protected String formatASCII(String input) {
        for (int i = 0; i < input.length(); ++i) {
            if (input.charAt(i) >= ' ' && input.charAt(i) <= '}' || !this.reformat) continue;
            input = input.replace("" + input.charAt(i), "\";CHR$(" + input.charAt(i) + ");\"");
        }
        input = "\"" + input + "\"";
        return input;
    }

    protected void format() {
        if (!this.result.contains("\"")) {
            this.result = this.formattedString(this.result);
        } else {
            int i;
            boolean string = false;
            String[] res = this.result.split("\"");
            for (i = 0; i < res.length; ++i) {
                res[i] = !string ? this.formattedString(res[i]) : this.formatASCII(res[i]);
                string = !string;
            }
            this.result = "";
            for (i = 0; i < res.length; ++i) {
                this.result = this.result + res[i];
            }
        }
    }

    public static int getWord(byte[] buffer, int offs) {
        return buffer[offs] & 0xFF | buffer[offs + 1] << 8 & 0xFF00;
    }

    public static int ChecksumAMSDOS(byte[] pHeader) {
        int Checksum2 = 0;
        for (int i = 0; i < 67; ++i) {
            int CheckSumByte = pHeader[i] & 0xFF;
            Checksum2 += CheckSumByte;
        }
        return Checksum2;
    }

    public static boolean CheckAMSDOS(byte[] pHeader) {
        try {
            int CalculatedChecksum = Baslist.ChecksumAMSDOS(pHeader);
            int ChecksumFromHeader = pHeader[67] & 0xFF | (pHeader[68] & 0xFF) << 8;
            return ChecksumFromHeader == CalculatedChecksum && ChecksumFromHeader != 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String LIST(String filename) {
        File test2 = new File(filename);
        if (!test2.exists()) {
            test2 = new File(filename + ".bas");
        }
        if (!test2.exists()) {
            return "";
        }
        String basresult = "";
        try {
            Baslist list = new Baslist();
            BufferedInputStream bin = new BufferedInputStream(new FileInputStream(test2));
            byte[] data = new byte[bin.available()];
            bin.read(data);
            bin.close();
            if (Baslist.CheckAMSDOS(data)) {
                int length = Baslist.getWord(data, 24);
                byte[] newdata = new byte[length];
                System.arraycopy(data, 128, newdata, 0, length);
                data = new byte[length];
                System.arraycopy(newdata, 0, data, 0, length);
            }
            int baspos = 0;
            while (baspos < data.length - 2) {
                int linelength = Baslist.getWord(data, baspos) - 4;
                if (linelength == 0) continue;
                int linenumber = Baslist.getWord(data, baspos + 2);
                String code = "";
                int pos = 0;
                for (int i = baspos += 4; i < baspos + linelength; ++i) {
                    code = code + (char)(data[i] & 0xFF);
                    ++pos;
                }
                list.result = "";
                try {
                    list.TranslateLine(code, linelength);
                    if (list.result.length() > 255) {
                        System.out.println("Line too long in line " + linenumber);
                    }
                    baspos += linelength;
                }
                catch (Exception e) {
                    return basresult.toString().replace("x666666666xZZyyT222T", "");
                }
                basresult = basresult + linenumber;
                basresult = basresult + list.result + "\r\n";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return basresult.toString().replace("x666666666xZZyyT222T", "");
    }

    public String LIST(byte[] data) {
        StringBuilder basresult = new StringBuilder();
        try {
            Baslist list = new Baslist();
            if (Baslist.CheckAMSDOS(data)) {
                int length = Baslist.getWord(data, 24);
                byte[] newdata = new byte[length];
                System.arraycopy(data, 128, newdata, 0, length);
                data = new byte[length];
                System.arraycopy(newdata, 0, data, 0, length);
            }
            int baspos = 0;
            int adrpos = 0;
            for (int i = 0; i < this.lines.length; ++i) {
                this.lines[i] = 0;
                this.addresses[i] = 0;
                this.codes[i] = null;
            }
            while (baspos < data.length - 2) {
                int linenumber;
                int linelength = Baslist.getWord(data, baspos) - 4;
                if (linelength == 0) continue;
                this.lines[adrpos] = linenumber = Baslist.getWord(data, baspos + 2);
                this.addresses[adrpos] = baspos + 2 + 368;
                String code = "";
                int pos = 0;
                for (int i = baspos += 4; i < baspos + linelength; ++i) {
                    try {
                        code = code + (char)(data[i] & 0xFF);
                    }
                    catch (Exception e) {
                        break;
                    }
                    ++pos;
                }
                list.result = "";
                try {
                    list.TranslateLine(code, linelength);
                    list.format();
                    if (list.result.length() > 255) {
                        System.out.println("Line too long in line " + linenumber);
                    }
                    baspos += linelength;
                }
                catch (Exception e) {
                    String d = basresult.toString().replace("x666666666xZZyyT222T", "");
                    if (d.endsWith("\r\n")) {
                        d = d.substring(0, d.length() - 2);
                    }
                    return d;
                }
                this.codes[adrpos] = linenumber + " " + list.result.replace("fejo23435rj2djejfuiuigheroifjioer", "" + linenumber);
                ++adrpos;
                basresult.append(linenumber + " ");
                basresult.append(list.result.replace("fejo23435rj2djejfuiuigheroifjioer", "" + linenumber) + "\r\n");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String d = basresult.toString().replace("x666666666xZZyyT222T", "");
        if (d.endsWith("\r\n")) {
            d = d.substring(0, d.length() - 2);
        }
        return d;
    }

    public static String hex(byte value) {
        str = "XY";
        str = str.replace('X', HEX_CHARS.charAt((value & 0xF0) >> 4));
        str = str.replace('Y', HEX_CHARS.charAt(value & 0xF));
        return str;
    }

    public static String hex(short value) {
        return Baslist.hex((byte)(value >> 8)) + Baslist.hex((byte)value);
    }

    public static String hex(int value) {
        return Baslist.hex((short)(value >> 16)) + Baslist.hex((short)value);
    }
}

