/*
 * Decompiled with CFR 0.152.
 */
package jemu.system.cpc;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import jemu.core.device.Device;
import jemu.core.device.floppy.DiscImage;
import jemu.core.device.floppy.UPD765A;
import jemu.system.cpc.CPCDiscImageSector;
import jemu.system.cpc.CPCDiscImageTrack;

public class CPCDiscImageForMerge
extends DiscImage {
    private static final String SAVED_DSK = "";
    private static final String WIN_APE_EYECATCHER = "Win APE 32 1.0";
    private static final String MV_CPC_EYECATCHER = "MV - CPC";
    private static final String EXTENDED_EYECATCHER = "EXTENDED";
    private static final String EXTENDED_DESCRIPTION = "EXTENDED CPC DSK File\r\nDisk-Info\r\n";
    private static final String CREATOR_DATA = "JCPC DOUBLEDSK";
    private static final String ENCODING = "UTF-8";
    private static final String TRACK_INFO = "Track-Info\r\n";
    private static final int SIDE_MASK = 1;
    private static final int MAX_TRACK = 79;
    private static final int BUFFER_SIZE = 8192;
    private static final int[] AMSDOS_SECTOR_IDS = new int[]{193, 195, 197, 199, 201, 194, 196, 198, 200};
    private final boolean newImage;
    private final String discId;
    private final String creator;
    private final int numberOfTracks;
    private final int numberOfSides;
    private final int sizeOfTrack;
    private final boolean extended;
    private final CPCDiscImageTrack[][] tracks;
    final JFileChooser fc = new JFileChooser();

    @Override
    public int getGap(int track) {
        return 0;
    }

    @Override
    public void notifyWriteSector(byte data, int cylinder, int head, int c, int h, int r, int n) {
    }

    @Override
    public void notifyReadSector(boolean beginOfSector, int cylinder, int head, int c, int h, int r, int n) {
    }

    @Override
    public void addSectorToTrack(int a, int b, int c, int d, int e, int f, int g) {
    }

    @Override
    public void removeAllSectorsFromTrack(int a, int b) {
    }

    public static CPCDiscImageForMerge create(String name, InputStream is) throws IOException {
        return new CPCDiscImageForMerge(name, CPCDiscImageForMerge.load(is));
    }

    @Override
    public int getNoOfTracks() {
        return this.numberOfTracks;
    }

    public CPCDiscImageForMerge(String name, int numberOfSides) {
        super(name);
        this.newImage = true;
        this.discId = EXTENDED_DESCRIPTION;
        this.creator = CREATOR_DATA;
        this.numberOfTracks = 40;
        this.numberOfSides = 1;
        this.sizeOfTrack = Math.max(1, Math.min(2, numberOfSides));
        this.extended = true;
        this.tracks = new CPCDiscImageTrack[this.numberOfTracks][this.numberOfSides];
        int sectorSize = UPD765A.getCommandSize(512);
        for (int track = 0; track < this.numberOfTracks; ++track) {
            for (int side = 0; side < this.numberOfSides; ++side) {
                this.tracks[track][side] = new CPCDiscImageTrack(track, side, 4608, 9);
                for (int sector = 0; sector < 9; ++sector) {
                    byte[] data = new byte[512];
                    for (int i = 0; i < data.length; ++i) {
                        data[i] = 0;
                    }
                    this.tracks[track][side].setSector(new CPCDiscImageSector(track, side, AMSDOS_SECTOR_IDS[sector], sectorSize, data, 0, 0), sector);
                }
            }
        }
    }

    public CPCDiscImageForMerge(String name, byte[] data) {
        super(name);
        this.newImage = false;
        this.discId = new String(data, 0, 34);
        this.creator = new String(data, 34, 14);
        this.numberOfTracks = data[48] & 0xFF;
        this.numberOfSides = data[49] & 0xFF;
        this.sizeOfTrack = Device.getWord(data, 50);
        this.extended = this.discId.toUpperCase().startsWith(EXTENDED_EYECATCHER);
        boolean isCpcDisc = this.extended || this.discId.toUpperCase().startsWith(MV_CPC_EYECATCHER);
        boolean winape = this.creator.equalsIgnoreCase(WIN_APE_EYECATCHER);
        this.tracks = new CPCDiscImageTrack[this.numberOfTracks][this.numberOfSides];
        if (isCpcDisc) {
            byte[] trackSizes = new byte[256];
            if (this.extended) {
                System.arraycopy(data, 52, trackSizes, 0, this.numberOfTracks * this.numberOfSides);
            }
            int offs = 256;
            for (int track = 0; track < this.numberOfTracks; ++track) {
                for (int side = 0; side < this.numberOfSides; ++side) {
                    int trackLength = this.sizeOfTrack;
                    if (this.extended) {
                        trackLength = (trackSizes[track * this.numberOfSides + side] & 0xFF) * 256;
                    }
                    if (trackLength == 0 || offs >= data.length) continue;
                    int sot = offs;
                    int numberOfSectors = data[offs + 21] & 0xFF;
                    int sectorInformationPos = offs + 24;
                    this.tracks[track][side] = new CPCDiscImageTrack(track, side, trackLength, numberOfSectors);
                    offs += 256;
                    for (int sect = 0; sect < numberOfSectors; ++sect) {
                        int sz;
                        int sectTrack = data[sectorInformationPos++] & 0xFF;
                        int sectSide = data[sectorInformationPos++] & 0xFF;
                        int sectId = data[sectorInformationPos++] & 0xFF;
                        int sectSize = data[sectorInformationPos++] & 0xFF;
                        int bytes = UPD765A.getSectorSize(sectSize);
                        if (this.extended && !winape && (sz = Device.getWord(data, sectorInformationPos += 2)) != 0) {
                            bytes = sz;
                            sectSize = UPD765A.getCommandSize(bytes);
                        }
                        sectorInformationPos += 2;
                        byte[] sectData = new byte[bytes];
                        System.arraycopy(data, offs, sectData, 0, bytes);
                        offs += bytes;
                        this.tracks[track][side].setSector(new CPCDiscImageSector(sectTrack, sectSide, sectId, sectSize, sectData, 0, 0), sect);
                    }
                    if (winape) continue;
                    offs = sot + trackLength;
                }
            }
        }
    }

    public CPCDiscImageForMerge(String newFileName, CPCDiscImageForMerge firstImage, CPCDiscImageForMerge secondImage) throws IOException {
        super(newFileName);
        int i;
        this.newImage = true;
        this.discId = firstImage.discId;
        this.creator = firstImage.creator;
        this.numberOfTracks = Math.max(firstImage.numberOfTracks, secondImage.numberOfTracks);
        this.numberOfSides = 2;
        this.sizeOfTrack = firstImage.sizeOfTrack;
        this.extended = firstImage.extended;
        if (!firstImage.extended || !secondImage.extended) {
            throw new IOException("only extended images can be merged!");
        }
        if (firstImage.numberOfSides != 1 || secondImage.numberOfSides != 1) {
            throw new IOException("only single sided extended images can be merged!");
        }
        this.tracks = new CPCDiscImageTrack[this.numberOfTracks][this.numberOfSides];
        for (i = 0; i < firstImage.numberOfTracks; ++i) {
            this.tracks[i][0] = firstImage.tracks[i][0];
        }
        for (i = 0; i < secondImage.numberOfTracks; ++i) {
            CPCDiscImageTrack track = secondImage.tracks[i][0];
            track.setSide(1);
            this.tracks[i][1] = track;
        }
    }

    @Override
    public byte[] readSector(int track, int side, int c, int h, int r, int n) {
        if (track <= 79) {
            return this.tracks[track][side & 1].getSectorData(c, h, r, n);
        }
        return null;
    }

    @Override
    public int[] getSectorID(int track, int side, int index) {
        return this.tracks[track][side & 1].getSectorIDs(index);
    }

    @Override
    public int getSectorCount(int track, int side) {
        return track > 79 ? 0 : this.tracks[track][side & 1].getSectorCount();
    }

    @Override
    public void writeSector(int track, int side, int c, int h, int r, int n, byte[] data) {
        CPCDiscImageTrack td = this.tracks[track][side & 1];
        td.setSectorData(c, h, r, n, data);
        this.saveImage();
    }

    public String getDiscId() {
        return this.discId;
    }

    public String getCreator() {
        return this.creator;
    }

    public int getNumberOfTracks() {
        return this.numberOfTracks;
    }

    public int getNumberOfSides() {
        return this.numberOfSides;
    }

    public int getSizeOfTrack() {
        return this.sizeOfTrack;
    }

    public boolean isExtended() {
        return this.extended;
    }

    public CPCDiscImageTrack[][] getTracks() {
        return this.tracks;
    }

    public void saveImage() {
        this.saveImage(new File(this.name));
    }

    @Override
    public synchronized byte[] getImage() {
        return null;
    }

    @Override
    public synchronized void saveImage(File discImage) {
        String saveFileName = discImage.getName();
        if (!this.newImage) {
            int dotPos = saveFileName.lastIndexOf(46);
            if (dotPos == -1) {
                if (!saveFileName.endsWith(SAVED_DSK)) {
                    saveFileName = saveFileName + SAVED_DSK;
                    saveFileName = this.checkNewSaveFile(discImage.getParent(), saveFileName, SAVED_DSK);
                }
            } else {
                String ext = saveFileName.substring(dotPos);
                if (!saveFileName.endsWith(SAVED_DSK + ext)) {
                    saveFileName = this.checkNewSaveFile(discImage.getParent(), saveFileName.substring(0, dotPos) + SAVED_DSK, ext);
                }
            }
        }
        File savedImage = new File(discImage.getParent(), saveFileName);
        if (System.getSecurityManager() != null) {
            try {
                System.getSecurityManager().checkWrite(savedImage.getAbsolutePath());
            }
            catch (SecurityException sex) {
                return;
            }
        }
        System.out.println("store dsk file to " + savedImage);
        JOptionPane.showMessageDialog(null, "Sucessfully saved " + savedImage);
        this.name = savedImage.getAbsolutePath();
        try {
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(savedImage));
            bos.write(EXTENDED_DESCRIPTION.getBytes(ENCODING));
            bos.write(CREATOR_DATA.getBytes(ENCODING));
            bos.write(this.numberOfTracks);
            bos.write(this.numberOfSides);
            bos.write(0);
            bos.write(0);
            for (int track = 0; track < this.numberOfTracks; ++track) {
                for (int side = 0; side < this.numberOfSides; ++side) {
                    int trackLength = this.tracks[track][side].getLength();
                    bos.write(trackLength / 256 & 0xFF);
                }
            }
            int unused = 204 - this.numberOfTracks * this.numberOfSides;
            for (int i = 0; i < unused; ++i) {
                bos.write(0);
            }
            for (int track = 0; track < this.numberOfTracks; ++track) {
                for (int side = 0; side < this.numberOfSides; ++side) {
                    int sector;
                    CPCDiscImageTrack td = this.tracks[track][side];
                    bos.write(TRACK_INFO.getBytes(ENCODING));
                    bos.write(0);
                    bos.write(0);
                    bos.write(0);
                    bos.write(0);
                    bos.write(td.getTrack());
                    bos.write(td.getSide());
                    bos.write(0);
                    bos.write(0);
                    bos.write(td.getSector(0).getSize());
                    int numberOfSectors = td.getSectorCount();
                    bos.write(numberOfSectors);
                    bos.write(78);
                    bos.write(229);
                    for (sector = 0; sector < numberOfSectors; ++sector) {
                        CPCDiscImageSector sd = td.getSector(sector);
                        bos.write(sd.getTrack());
                        bos.write(sd.getSide());
                        bos.write(sd.getId());
                        bos.write(sd.getSize());
                        bos.write(0);
                        bos.write(0);
                        int dataSize = sd.getData().length;
                        bos.write(dataSize & 0xFF);
                        bos.write(dataSize / 256 & 0xFF);
                    }
                    unused = 232 - 8 * numberOfSectors;
                    for (int i = 0; i < unused; ++i) {
                        bos.write(0);
                    }
                    for (sector = 0; sector < numberOfSectors; ++sector) {
                        bos.write(td.getSector(sector).getData());
                    }
                }
            }
            bos.close();
        }
        catch (IOException iox) {
            System.out.println("can't write to file " + savedImage + ": " + iox.getMessage());
        }
    }

    public synchronized void UserSave() {
        this.fc.setDialogTitle("Select destination dsk file...");
        int result = this.fc.showSaveDialog(null);
        String newFileName = this.fc.getSelectedFile().getAbsolutePath();
        File discImage = new File(newFileName);
        String saveFileName = discImage.getName();
        if (!this.newImage) {
            int dotPos = saveFileName.lastIndexOf(46);
            if (dotPos == -1) {
                if (!saveFileName.endsWith(SAVED_DSK)) {
                    saveFileName = saveFileName + SAVED_DSK;
                    saveFileName = this.checkNewSaveFile(discImage.getParent(), saveFileName, SAVED_DSK);
                }
            } else {
                String ext = saveFileName.substring(dotPos);
                if (!saveFileName.endsWith(SAVED_DSK + ext)) {
                    saveFileName = this.checkNewSaveFile(discImage.getParent(), saveFileName.substring(0, dotPos) + SAVED_DSK, ext);
                }
            }
        }
        File savedImage = new File(discImage.getParent(), saveFileName);
        if (System.getSecurityManager() != null) {
            try {
                System.getSecurityManager().checkWrite(savedImage.getAbsolutePath());
            }
            catch (SecurityException sex) {
                return;
            }
        }
        System.out.println("store dsk file to " + savedImage);
        this.name = savedImage.getAbsolutePath();
        try {
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(savedImage));
            bos.write(EXTENDED_DESCRIPTION.getBytes(ENCODING));
            bos.write(CREATOR_DATA.getBytes(ENCODING));
            bos.write(this.numberOfTracks);
            bos.write(this.numberOfSides);
            bos.write(0);
            bos.write(0);
            for (int track = 0; track < this.numberOfTracks; ++track) {
                for (int side = 0; side < this.numberOfSides; ++side) {
                    int trackLength = this.tracks[track][side].getLength();
                    bos.write(trackLength / 256 & 0xFF);
                }
            }
            int unused = 204 - this.numberOfTracks * this.numberOfSides;
            for (int i = 0; i < unused; ++i) {
                bos.write(0);
            }
            for (int track = 0; track < this.numberOfTracks; ++track) {
                for (int side = 0; side < this.numberOfSides; ++side) {
                    int sector;
                    CPCDiscImageTrack td = this.tracks[track][side];
                    bos.write(TRACK_INFO.getBytes(ENCODING));
                    bos.write(0);
                    bos.write(0);
                    bos.write(0);
                    bos.write(0);
                    bos.write(td.getTrack());
                    bos.write(td.getSide());
                    bos.write(0);
                    bos.write(0);
                    bos.write(td.getSector(0).getSize());
                    int numberOfSectors = td.getSectorCount();
                    bos.write(numberOfSectors);
                    bos.write(78);
                    bos.write(229);
                    for (sector = 0; sector < numberOfSectors; ++sector) {
                        CPCDiscImageSector sd = td.getSector(sector);
                        bos.write(sd.getTrack());
                        bos.write(sd.getSide());
                        bos.write(sd.getId());
                        bos.write(sd.getSize());
                        bos.write(0);
                        bos.write(0);
                        int dataSize = sd.getData().length;
                        bos.write(dataSize & 0xFF);
                        bos.write(dataSize / 256 & 0xFF);
                    }
                    unused = 232 - 8 * numberOfSectors;
                    for (int i = 0; i < unused; ++i) {
                        bos.write(0);
                    }
                    for (sector = 0; sector < numberOfSectors; ++sector) {
                        bos.write(td.getSector(sector).getData());
                    }
                }
            }
            bos.close();
        }
        catch (IOException iox) {
            System.out.println("can't write to file " + savedImage + ": " + iox.getMessage());
        }
    }

    private String checkNewSaveFile(String directory, String fileName, String ext) {
        String result = fileName + ext;
        File saveFile = new File(directory, result);
        int index = 1;
        int counter = 10000;
        while (saveFile.exists()) {
            result = fileName + Integer.toString(index++) + ext;
            saveFile = new File(directory, result);
            if (--counter >= 0) continue;
            break;
        }
        return result;
    }

    static byte[] load(InputStream is) throws IOException {
        int readLen;
        if (is == null) {
            return new byte[0];
        }
        int bufferSize = 8192;
        byte[] tmpData = new byte[8192];
        int offs = 0;
        int addOn = 16384;
        while ((readLen = is.read(tmpData, offs, tmpData.length - offs)) != -1) {
            if ((offs += readLen) != tmpData.length) continue;
            byte[] newres = new byte[tmpData.length + addOn];
            if (addOn < 0x100000) {
                addOn *= 2;
            }
            System.arraycopy(tmpData, 0, newres, 0, tmpData.length);
            tmpData = newres;
        }
        is.close();
        byte[] data = new byte[offs];
        System.arraycopy(tmpData, 0, data, 0, offs);
        return data;
    }

    public void addSector(int track, int side, int c, int h, int r, int n) {
    }

    public void clearTrack(int a, int b, byte n) {
    }

    public void addTrack(int a, byte n) {
    }

    public void removeSector(int track, int side, int c, int h) {
    }

    @Override
    public int getST1ForSector(int track, int side, int c, int h, int r, int n) {
        return this.tracks[track][side & 1].getST1(c, h, r, n);
    }

    @Override
    public int getST2ForSector(int track, int side, int c, int h, int r, int n) {
        return this.tracks[track][side & 1].getST2(c, h, r, n);
    }

    @Override
    public void setST1ForSector(int track, int side, int c, int h, int r, int n, int st1) {
        this.tracks[track][side & 1].setST1(c, h, r, n, st1);
    }

    @Override
    public void setST2ForSector(int track, int side, int c, int h, int r, int n, int st2) {
        this.tracks[track][side & 1].setST2(c, h, r, n, st2);
    }
}

