/*
 * Decompiled with CFR 0.152.
 */
package jemu.system.cpc;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import jemu.system.cpc.Mapper;
import jemu.ui.Display;
import jemu.ui.JEMU;

public class GameMapper
extends JFrame {
    Mapper mapper;
    BufferedImage largeMap;
    BufferedImage buffer;
    int mapposx = 0;
    int mapposy = 0;
    int mpx = 0;
    int mpy = 0;
    int lastx = 0;
    int lasty = 0;
    BufferedImage buff;
    BufferedImage grid;
    int div = 2;
    Thread put;
    BufferedImage result;
    FileDialog dialog;
    boolean ctrl;
    boolean shift;
    final int PUTIMG = -1;
    final int ERASE = -2;
    final int NORTH = 0;
    final int SOUTH = 1;
    final int EAST = 2;
    final int WEST = 3;
    final int MNORTH = 4;
    final int MSOUTH = 5;
    final int MEAST = 6;
    final int MWEST = 7;
    private JCheckBox fromScreen;
    private JCheckBox halfSize;
    private JButton jButton1;
    private JButton jButton10;
    private JButton jButton11;
    private JButton jButton13;
    private JButton jButton2;
    private JButton jButton3;
    private JButton jButton4;
    private JButton jButton5;
    private JButton jButton6;
    private JButton jButton7;
    private JButton jButton8;
    private JButton jButton9;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JToggleButton setScreen;

    public void newMap() {
        this.mapposx = 0;
        this.mapposy = 0;
        this.mpx = 0;
        this.mpy = 0;
        this.lastx = 0;
        this.lasty = 0;
        this.largeMap = null;
        this.buff = null;
        this.buffer = null;
        this.addPanel(-1);
    }

    public GameMapper(Mapper mapper) {
        this.initComponents();
        this.mapper = mapper;
    }

    public GameMapper(JEMU jemu) {
        this.initComponents();
        this.fromScreen.setSelected(true);
        this.fromScreen.setEnabled(false);
        this.setScreen.setEnabled(true);
        this.setLocation(JEMU.frame.getLocation().x + JEMU.frame.getWidth() + 4, JEMU.frame.getLocation().y);
    }

    public BufferedImage getScreenMap() {
        try {
            if (this.buffer == null || Display.capH / this.div != this.buffer.getHeight() || Display.capW / this.div != this.buffer.getWidth()) {
                this.buffer = new BufferedImage(Display.capW / this.div, Display.capH / this.div, 1);
                this.grid = null;
                this.largeMap = null;
            }
            this.buffer.createGraphics().drawImage(Display.image, 0 - Display.capX / this.div, 0 - Display.capY / this.div, Display.image.getWidth() / this.div, Display.image.getHeight() / this.div, null);
            System.out.println(this.buffer.getWidth() + "," + this.buffer.getHeight());
            return this.buffer;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void addPanel(final int dir) {
        if (this.put != null) {
            while (this.put.isAlive()) {
                try {
                    Thread.sleep(1L);
                }
                catch (Exception exception) {}
            }
        }
        this.put = new Thread(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void run() {
                Graphics2D g;
                if (!GameMapper.this.fromScreen.isSelected()) {
                    if (GameMapper.this.mapper == null) {
                        GameMapper.this.fromScreen.setSelected(true);
                        GameMapper.this.fromScreen.setEnabled(false);
                        GameMapper.this.setScreen.setEnabled(true);
                        return;
                    }
                    GameMapper.this.mapper.drawMap();
                    GameMapper.this.buffer = GameMapper.this.mapper.getMap();
                } else {
                    GameMapper.this.buffer = GameMapper.this.getScreenMap();
                }
                if (GameMapper.this.grid == null || GameMapper.this.grid.getWidth() != GameMapper.this.buffer.getWidth() || GameMapper.this.grid.getHeight() != GameMapper.this.buffer.getHeight()) {
                    GameMapper.this.grid = new BufferedImage(GameMapper.this.buffer.getWidth(), GameMapper.this.buffer.getHeight(), 2);
                    g = GameMapper.this.grid.createGraphics();
                    g.setColor(new Color(255, 255, 255, 128));
                    for (int y = 0; y < GameMapper.this.grid.getHeight(); ++y) {
                        for (int x = 0; x < GameMapper.this.grid.getWidth(); ++x) {
                            if (x % 2 == 1 && y % 2 == 1) {
                                g.fillRect(x, y, 1, 1);
                                continue;
                            }
                            if (x % 2 != 0 || y % 2 != 0) continue;
                            g.fillRect(x, y, 1, 1);
                        }
                    }
                }
                if (GameMapper.this.largeMap == null) {
                    GameMapper.this.largeMap = new BufferedImage(GameMapper.this.buffer.getWidth(), GameMapper.this.buffer.getHeight(), 1);
                    GameMapper.this.largeMap.createGraphics().drawImage((Image)GameMapper.this.buffer, 0, 0, null);
                } else {
                    switch (dir) {
                        case -1: {
                            GameMapper.this.buff = new BufferedImage(GameMapper.this.largeMap.getWidth(), GameMapper.this.largeMap.getHeight(), 1);
                            GameMapper.this.buff.createGraphics().drawImage((Image)GameMapper.this.largeMap, 0, 0, null);
                            GameMapper.this.buff.createGraphics().drawImage((Image)GameMapper.this.buffer, GameMapper.this.mapposx, GameMapper.this.mapposy, null);
                            break;
                        }
                        case -2: {
                            GameMapper.this.buff = new BufferedImage(GameMapper.this.largeMap.getWidth(), GameMapper.this.largeMap.getHeight(), 1);
                            Graphics2D d = GameMapper.this.buff.createGraphics();
                            d.setColor(Color.BLACK);
                            d.drawImage((Image)GameMapper.this.largeMap, 0, 0, null);
                            d.fillRect(GameMapper.this.mapposx, GameMapper.this.mapposy, GameMapper.this.buffer.getWidth(), GameMapper.this.buffer.getHeight());
                            break;
                        }
                        case 4: {
                            if (GameMapper.this.mapposy <= 0) break;
                            GameMapper.this.mapposy -= GameMapper.this.buffer.getHeight();
                            --GameMapper.this.mpy;
                            break;
                        }
                        case 0: {
                            GameMapper.this.mapposy -= GameMapper.this.buffer.getHeight();
                            --GameMapper.this.mpy;
                            if (GameMapper.this.mapposy < 0) {
                                GameMapper.this.buff = new BufferedImage(GameMapper.this.largeMap.getWidth(), GameMapper.this.largeMap.getHeight() + GameMapper.this.buffer.getHeight(), 1);
                                GameMapper.this.buff.createGraphics().drawImage((Image)GameMapper.this.largeMap, 0, GameMapper.this.buffer.getHeight(), null);
                                GameMapper.this.buff.createGraphics().drawImage((Image)GameMapper.this.buffer, GameMapper.this.mapposx, 0, null);
                                GameMapper.this.mapposy = 0;
                                break;
                            }
                            if (GameMapper.this.mapposy < 0) break;
                            GameMapper.this.buff.createGraphics().drawImage((Image)GameMapper.this.largeMap, 0, 0, null);
                            GameMapper.this.buff.createGraphics().drawImage((Image)GameMapper.this.buffer, GameMapper.this.mapposx, GameMapper.this.mapposy, null);
                            break;
                        }
                        case 5: {
                            if (GameMapper.this.mapposy + GameMapper.this.buffer.getHeight() >= GameMapper.this.largeMap.getHeight()) break;
                            GameMapper.this.mapposy += GameMapper.this.buffer.getHeight();
                            ++GameMapper.this.mpy;
                            break;
                        }
                        case 1: {
                            GameMapper.this.mapposy += GameMapper.this.buffer.getHeight();
                            ++GameMapper.this.mpy;
                            if (GameMapper.this.mapposy < 0) break;
                            if (GameMapper.this.mpy > GameMapper.this.lasty) {
                                GameMapper.this.buff = new BufferedImage(GameMapper.this.largeMap.getWidth(), GameMapper.this.largeMap.getHeight() + GameMapper.this.buffer.getHeight(), 1);
                                GameMapper.this.lasty = GameMapper.this.mpy;
                            }
                            GameMapper.this.buff.createGraphics().drawImage((Image)GameMapper.this.largeMap, 0, 0, null);
                            GameMapper.this.buff.createGraphics().drawImage((Image)GameMapper.this.buffer, GameMapper.this.mapposx, GameMapper.this.mapposy, null);
                            break;
                        }
                        case 6: {
                            if (GameMapper.this.mapposx + GameMapper.this.buffer.getWidth() >= GameMapper.this.largeMap.getWidth()) break;
                            ++GameMapper.this.mpx;
                            GameMapper.this.mapposx += GameMapper.this.buffer.getWidth();
                            break;
                        }
                        case 2: {
                            ++GameMapper.this.mpx;
                            GameMapper.this.mapposx += GameMapper.this.buffer.getWidth();
                            if (GameMapper.this.mapposx < 0) break;
                            if (GameMapper.this.mpx > GameMapper.this.lastx) {
                                GameMapper.this.buff = new BufferedImage(GameMapper.this.largeMap.getWidth() + GameMapper.this.buffer.getWidth(), GameMapper.this.largeMap.getHeight(), 1);
                                GameMapper.this.lastx = GameMapper.this.mpx;
                            }
                            GameMapper.this.buff.createGraphics().drawImage((Image)GameMapper.this.largeMap, 0, 0, null);
                            GameMapper.this.buff.createGraphics().drawImage((Image)GameMapper.this.buffer, GameMapper.this.mapposx, GameMapper.this.mapposy, null);
                            break;
                        }
                        case 7: {
                            if (GameMapper.this.mapposx <= 0) break;
                            GameMapper.this.mapposx -= GameMapper.this.buffer.getWidth();
                            --GameMapper.this.mpx;
                            break;
                        }
                        case 3: {
                            GameMapper.this.mapposx -= GameMapper.this.buffer.getWidth();
                            --GameMapper.this.mpx;
                            if (GameMapper.this.mapposx < 0) {
                                GameMapper.this.buff = new BufferedImage(GameMapper.this.largeMap.getWidth() + GameMapper.this.buffer.getWidth(), GameMapper.this.largeMap.getHeight(), 1);
                                GameMapper.this.buff.createGraphics().drawImage((Image)GameMapper.this.largeMap, GameMapper.this.buffer.getWidth(), 0, null);
                                GameMapper.this.buff.createGraphics().drawImage((Image)GameMapper.this.buffer, 0, GameMapper.this.mapposy, null);
                                GameMapper.this.mapposx = 0;
                                break;
                            }
                            if (GameMapper.this.mapposx < 0) break;
                            GameMapper.this.buff.createGraphics().drawImage((Image)GameMapper.this.largeMap, 0, 0, null);
                            GameMapper.this.buff.createGraphics().drawImage((Image)GameMapper.this.buffer, GameMapper.this.mapposx, GameMapper.this.mapposy, null);
                            break;
                        }
                    }
                    if (GameMapper.this.buff != null) {
                        GameMapper.this.largeMap = new BufferedImage(GameMapper.this.buff.getWidth(), GameMapper.this.buff.getHeight(), 1);
                        GameMapper.this.largeMap.createGraphics().drawImage((Image)GameMapper.this.buff, 0, 0, null);
                    }
                    GameMapper.this.jLabel2.setText("" + GameMapper.this.mpx);
                    GameMapper.this.jLabel3.setText("" + GameMapper.this.mpy);
                }
                GameMapper.this.jLabel1.setPreferredSize(new Dimension(GameMapper.this.largeMap.getWidth(), GameMapper.this.largeMap.getHeight()));
                GameMapper.this.result = new BufferedImage(GameMapper.this.largeMap.getWidth(), GameMapper.this.largeMap.getHeight(), 1);
                g = GameMapper.this.result.createGraphics();
                g.drawImage((Image)GameMapper.this.largeMap, 0, 0, null);
                g.setColor(Color.white);
                g.drawImage((Image)GameMapper.this.grid, GameMapper.this.mapposx, GameMapper.this.mapposy, null);
                g.drawRect(GameMapper.this.mapposx, GameMapper.this.mapposy, GameMapper.this.buffer.getWidth(), GameMapper.this.buffer.getHeight());
                GameMapper.this.jLabel1.setIcon(new ImageIcon(GameMapper.this.result));
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        GameMapper.this.jScrollPane1.getVerticalScrollBar().setValue(GameMapper.this.mapposy + GameMapper.this.buffer.getHeight() - GameMapper.this.jScrollPane1.getHeight());
                        GameMapper.this.jScrollPane1.getHorizontalScrollBar().setValue(GameMapper.this.mapposx + GameMapper.this.buffer.getWidth() - GameMapper.this.jScrollPane1.getWidth());
                    }
                });
            }
        };
        this.put.start();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jLabel1 = new JLabel();
        this.jPanel1 = new JPanel();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jButton3 = new JButton();
        this.jButton4 = new JButton();
        this.jButton5 = new JButton();
        this.jButton6 = new JButton();
        this.jButton7 = new JButton();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jButton8 = new JButton();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jButton9 = new JButton();
        this.jButton10 = new JButton();
        this.jButton11 = new JButton();
        this.jButton13 = new JButton();
        this.fromScreen = new JCheckBox();
        this.setScreen = new JToggleButton();
        this.halfSize = new JCheckBox();
        this.setTitle("JavaCPC GameMapper");
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                GameMapper.this.formFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                GameMapper.this.formFocusLost(evt);
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                GameMapper.this.formKeyPressed(evt);
            }

            @Override
            public void keyReleased(KeyEvent evt) {
                GameMapper.this.formKeyReleased(evt);
            }
        });
        this.jScrollPane1.setPreferredSize(new Dimension(640, 594));
        this.jLabel1.setFocusable(false);
        this.jScrollPane1.setViewportView(this.jLabel1);
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel1.setFocusable(false);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jButton1.setText("\u25bc");
        this.jButton1.setFocusPainted(false);
        this.jButton1.setFocusable(false);
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GameMapper.this.jButton1ActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        this.jPanel1.add((Component)this.jButton1, gridBagConstraints);
        this.jButton2.setText("\u25b2");
        this.jButton2.setFocusPainted(false);
        this.jButton2.setFocusable(false);
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GameMapper.this.jButton2ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        this.jPanel1.add((Component)this.jButton2, gridBagConstraints);
        this.jButton3.setText("\u25ba");
        this.jButton3.setFocusPainted(false);
        this.jButton3.setFocusable(false);
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GameMapper.this.jButton3ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        this.jPanel1.add((Component)this.jButton3, gridBagConstraints);
        this.jButton4.setText("\u25c4");
        this.jButton4.setFocusPainted(false);
        this.jButton4.setFocusable(false);
        this.jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GameMapper.this.jButton4ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        this.jPanel1.add((Component)this.jButton4, gridBagConstraints);
        this.jButton5.setText("\u25cf");
        this.jButton5.setFocusPainted(false);
        this.jButton5.setFocusable(false);
        this.jButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GameMapper.this.jButton5ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        this.jPanel1.add((Component)this.jButton5, gridBagConstraints);
        this.jButton6.setText("Export");
        this.jButton6.setFocusPainted(false);
        this.jButton6.setFocusable(false);
        this.jButton6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GameMapper.this.jButton6ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        this.jPanel1.add((Component)this.jButton6, gridBagConstraints);
        this.jButton7.setText("\u25cb");
        this.jButton7.setFocusPainted(false);
        this.jButton7.setFocusable(false);
        this.jButton7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GameMapper.this.jButton7ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        this.jPanel1.add((Component)this.jButton7, gridBagConstraints);
        this.jLabel2.setText("0");
        this.jLabel2.setPreferredSize(new Dimension(40, 14));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        this.jPanel1.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel3.setText("0");
        this.jLabel3.setPreferredSize(new Dimension(40, 14));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 7;
        this.jPanel1.add((Component)this.jLabel3, gridBagConstraints);
        this.jButton8.setText("New");
        this.jButton8.setFocusPainted(false);
        this.jButton8.setFocusable(false);
        this.jButton8.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GameMapper.this.jButton8ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        this.jPanel1.add((Component)this.jButton8, gridBagConstraints);
        this.jLabel4.setText("Cell:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        this.jPanel1.add((Component)this.jLabel4, gridBagConstraints);
        this.jLabel5.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        this.jPanel1.add((Component)this.jLabel5, gridBagConstraints);
        this.jLabel6.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        this.jPanel1.add((Component)this.jLabel6, gridBagConstraints);
        this.jButton9.setText("\u25b2");
        this.jButton9.setFocusPainted(false);
        this.jButton9.setFocusable(false);
        this.jButton9.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GameMapper.this.jButton9ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        this.jPanel1.add((Component)this.jButton9, gridBagConstraints);
        this.jButton10.setText("\u25c4");
        this.jButton10.setFocusPainted(false);
        this.jButton10.setFocusable(false);
        this.jButton10.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GameMapper.this.jButton10ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        this.jPanel1.add((Component)this.jButton10, gridBagConstraints);
        this.jButton11.setText("\u25ba");
        this.jButton11.setFocusPainted(false);
        this.jButton11.setFocusable(false);
        this.jButton11.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GameMapper.this.jButton11ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 9;
        this.jPanel1.add((Component)this.jButton11, gridBagConstraints);
        this.jButton13.setText("\u25bc");
        this.jButton13.setFocusPainted(false);
        this.jButton13.setFocusable(false);
        this.jButton13.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GameMapper.this.jButton13ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 10;
        this.jPanel1.add((Component)this.jButton13, gridBagConstraints);
        this.fromScreen.setText("From Screen");
        this.fromScreen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GameMapper.this.fromScreenActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 3;
        this.jPanel1.add((Component)this.fromScreen, gridBagConstraints);
        this.setScreen.setText("Set");
        this.setScreen.setEnabled(false);
        this.setScreen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GameMapper.this.setScreenActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 11;
        this.jPanel1.add((Component)this.setScreen, gridBagConstraints);
        this.halfSize.setSelected(true);
        this.halfSize.setText("Half size");
        this.halfSize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GameMapper.this.halfSizeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridwidth = 3;
        this.jPanel1.add((Component)this.halfSize, gridBagConstraints);
        this.getContentPane().add((Component)this.jPanel1, "East");
        this.pack();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.addPanel(0);
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.addPanel(1);
    }

    private void jButton4ActionPerformed(ActionEvent evt) {
        this.addPanel(3);
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        this.addPanel(2);
    }

    private void jButton5ActionPerformed(ActionEvent evt) {
        this.addPanel(-1);
    }

    private void jButton6ActionPerformed(ActionEvent evt) {
        try {
            if (this.dialog == null) {
                this.dialog = new FileDialog((Frame)this, "Export GameMap", 1);
            }
            this.dialog.setFile("*.png");
            this.dialog.setVisible(true);
            String file = this.dialog.getDirectory();
            if (file != null) {
                file = this.dialog.getDirectory() + this.dialog.getFile();
                if (!file.toLowerCase().endsWith(".png")) {
                    file = file + ".png";
                }
                ImageIO.write((RenderedImage)this.largeMap, "PNG", new File(file));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void jButton7ActionPerformed(ActionEvent evt) {
        this.addPanel(-2);
    }

    private void jButton8ActionPerformed(ActionEvent evt) {
        this.newMap();
    }

    private void jButton9ActionPerformed(ActionEvent evt) {
        this.addPanel(4);
    }

    private void jButton10ActionPerformed(ActionEvent evt) {
        this.addPanel(7);
    }

    private void jButton11ActionPerformed(ActionEvent evt) {
        this.addPanel(6);
    }

    private void jButton13ActionPerformed(ActionEvent evt) {
        this.addPanel(5);
    }

    public GameMapper getMapper() {
        return this;
    }

    public void keyPress(int code) {
        if (code == 17) {
            this.ctrl = true;
        }
        if (code == 16) {
            this.shift = true;
        }
    }

    public void keyRelease(int code) {
        if (code == 38) {
            if (this.ctrl) {
                this.addPanel(0);
            } else {
                this.addPanel(4);
            }
        } else if (code == 40) {
            if (this.ctrl) {
                this.addPanel(1);
            } else {
                this.addPanel(5);
            }
        } else if (code == 37) {
            if (this.ctrl) {
                this.addPanel(3);
            } else {
                this.addPanel(7);
            }
        } else if (code == 39) {
            if (this.ctrl) {
                this.addPanel(2);
            } else {
                this.addPanel(6);
            }
        } else if (code == 127) {
            this.addPanel(-2);
        } else if (code == 32) {
            this.addPanel(-1);
        }
        if (code == 17) {
            this.ctrl = false;
        }
        if (code == 16) {
            this.shift = false;
        }
    }

    private void formKeyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 38) {
            if (this.ctrl) {
                this.addPanel(0);
            } else {
                this.addPanel(4);
            }
        } else if (evt.getKeyCode() == 40) {
            if (this.ctrl) {
                this.addPanel(1);
            } else {
                this.addPanel(5);
            }
        } else if (evt.getKeyCode() == 37) {
            if (this.ctrl) {
                this.addPanel(3);
            } else {
                this.addPanel(7);
            }
        } else if (evt.getKeyCode() == 39) {
            if (this.ctrl) {
                this.addPanel(2);
            } else {
                this.addPanel(6);
            }
        } else if (evt.getKeyCode() == 127) {
            this.addPanel(-2);
        } else if (evt.getKeyCode() == 32) {
            this.addPanel(-1);
        }
        if (evt.getKeyCode() == 17) {
            this.ctrl = false;
        }
        if (evt.getKeyCode() == 16) {
            this.shift = false;
        }
    }

    private void formKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 17) {
            this.ctrl = true;
        }
        if (evt.getKeyCode() == 16) {
            this.shift = true;
        }
    }

    private void formFocusGained(FocusEvent evt) {
        System.out.println("Panel has focus.");
    }

    private void formFocusLost(FocusEvent evt) {
        System.out.println("Panel lost focus.");
    }

    private void setScreenActionPerformed(ActionEvent evt) {
        Display.initcap = this.setScreen.isSelected();
    }

    private void fromScreenActionPerformed(ActionEvent evt) {
        this.setScreen.setEnabled(this.fromScreen.isSelected());
        Display.initcap = false;
    }

    private void halfSizeActionPerformed(ActionEvent evt) {
        this.div = this.halfSize.isSelected() ? 2 : 1;
        this.newMap();
    }
}

