/*
 * Decompiled with CFR 0.152.
 */
package jemu.system.cpc;

import JCPC.core.device.Device;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import jemu.core.device.Computer;
import jemu.core.device.floppy.DiscImage;
import jemu.system.cpc.CPC;
import jemu.ui.cpcgamescd.CPCFileSystem;

public class MagicCPCDiscImage
extends DiscImage {
    CPCFileSystem system;
    String path;
    int[][][][] ids;
    byte[][][][] sectors;
    int lastCylinder = 79;
    int headMask = 1;
    public static final int SECTS = 9;
    public static final int CYLS = 40;
    public static final int HEADS = 1;
    HashMap<String, File> dirContent = new HashMap();
    List<String> dirContentKeys = new ArrayList<String>();
    boolean isData = false;
    boolean isBank = true;
    List<String> scanNames = new ArrayList<String>();
    List<Byte> buffer = new ArrayList<Byte>();
    int cursorWrite = 0;
    Integer cylinderBank = null;
    Integer headBank = null;
    Integer indexBank = null;

    @Override
    public int getGap(int track) {
        return 0;
    }

    @Override
    public byte[] getImage() {
        return null;
    }

    @Override
    public void saveImage(File file) {
    }

    @Override
    public void writeSector(int a, int b, int c, int d, int e, int f, byte[] g) {
    }

    @Override
    public void addSectorToTrack(int a, int b, int c, int d, int e, int f, int g) {
    }

    @Override
    public int getNoOfTracks() {
        return this.lastCylinder;
    }

    @Override
    public void removeAllSectorsFromTrack(int a, int b) {
    }

    @Override
    public void setST1ForSector(int a, int b, int c, int d, int e, int f, int g) {
    }

    @Override
    public void setST2ForSector(int a, int b, int c, int d, int e, int f, int g) {
    }

    @Override
    public int getST1ForSector(int a, int b, int c, int d, int e, int f) {
        return 0;
    }

    @Override
    public int getST2ForSector(int a, int b, int c, int d, int e, int f) {
        return 0;
    }

    public MagicCPCDiscImage(String dir) {
        super("MagicCPCDiscImage");
        this.system = new CPCFileSystem();
        this.init(dir);
    }

    public void init(String path) {
        this.path = path;
        this.createSectorStructure();
        this.listDir();
    }

    private void createSectorStructure() {
        this.ids = new int[2][80][0][];
        this.sectors = new byte[2][80][][];
        for (int cyl = 0; cyl < 40; ++cyl) {
            for (int head = 0; head < 1; ++head) {
                this.ids[head][cyl] = new int[9][4];
                this.sectors[head][cyl] = new byte[9][];
                for (int sect = 0; sect < 9; ++sect) {
                    int[] sectId = this.ids[head][cyl][sect];
                    sectId[0] = cyl;
                    sectId[1] = 0;
                    sectId[2] = 193 + sect;
                    sectId[3] = 2;
                    int size = MagicCPCDiscImage.sectorSize(sectId[3]);
                    byte[] byArray = new byte[size];
                    this.sectors[head][cyl][sect] = byArray;
                    byte[] sectData = byArray;
                    for (int i = 0; i < size; ++i) {
                        sectData[i] = -27;
                    }
                }
            }
        }
    }

    private void resetSectorContent() {
        byte[] empty = new byte[512];
        for (int j = 0; j < 512; ++j) {
            empty[j] = -27;
        }
        System.arraycopy(empty, 0, this.sectors[0][0][0], 0, 512);
        System.arraycopy(empty, 0, this.sectors[0][0][1], 0, 512);
        System.arraycopy(empty, 0, this.sectors[0][0][2], 0, 512);
        System.arraycopy(empty, 0, this.sectors[0][0][3], 0, 512);
    }

    public void copyAsDSK() {
        this.system.get(this.path + "/MAGIC_OUTPUT.DSK");
        try {
            File folder = new File(this.path);
            if (folder.isDirectory()) {
                for (File sf : folder.listFiles()) {
                    if (sf.isDirectory() || sf.length() > 65535L || sf.length() < 1L) continue;
                    String cpcname = sf.getName().toUpperCase();
                    String realname = sf.getName().toUpperCase();
                    if (cpcname.contains(".")) {
                        int point = cpcname.indexOf(".");
                        String filename = cpcname.substring(0, point);
                        filename = filename + "        ";
                        filename = filename.substring(0, 8);
                        String extension = cpcname.substring(point + 1, cpcname.length());
                        extension = extension + "   ";
                        extension = extension.substring(0, 3);
                        cpcname = filename + extension;
                    } else {
                        cpcname = cpcname + "           ";
                        cpcname = cpcname.substring(0, 11);
                    }
                    this.system.DIR();
                    this.system.copyToDSK(this.path + "/", realname, this.path + "/MAGIC_OUTPUT.DSK");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void listDir() {
        this.dirContent.clear();
        this.dirContentKeys.clear();
        int ii = 0;
        int noSect = 0;
        try {
            File folder = new File(this.path);
            if (folder.isDirectory()) {
                for (File sf : folder.listFiles()) {
                    if (sf.isDirectory() || sf.length() > 131199L || sf.length() < 1L) continue;
                    String cpcname = sf.getName().toUpperCase();
                    String realname = sf.getName().toUpperCase();
                    if (cpcname.contains(".")) {
                        int point = cpcname.indexOf(".");
                        String filename = cpcname.substring(0, point);
                        filename = filename + "        ";
                        filename = filename.substring(0, 8);
                        String extension = cpcname.substring(point + 1, cpcname.length());
                        extension = extension + "   ";
                        extension = extension.substring(0, 3);
                        cpcname = filename + extension;
                    } else {
                        cpcname = cpcname + "           ";
                        cpcname = cpcname.substring(0, 11);
                    }
                    File fSuperAmstradName = new File(this.path + "/" + realname);
                    this.dirContent.put(cpcname, fSuperAmstradName);
                    this.dirContentKeys.add(cpcname);
                }
            }
            this.resetSectorContent();
            byte[] line = new byte[32];
            for (int j = 0; j < 32; ++j) {
                line[j] = 0;
            }
            byte[] empty = new byte[512];
            for (int j = 0; j < 512; ++j) {
                empty[j] = -27;
            }
            int i = 0;
            int writeNoSect = 2;
            int writeH = 0;
            int writeC = 0;
            int writeR = 4;
            boolean teaForTwo = false;
            for (String name : this.dirContentKeys) {
                noSect = i / 16;
                if (noSect >= 4) {
                    System.out.println("FILE_STRUCTDIR_TOO_BIG");
                    break;
                }
                ii = i % 16;
                byte[] sectData = this.sectors[0][0][noSect];
                File f = this.dirContent.get(name);
                long fileLength = f.length();
                System.out.println("DIR : " + name);
                try {
                    byte[] selectedFileContent = new byte[512];
                    FileInputStream fis = new FileInputStream(f);
                    while (fis.read(selectedFileContent) > 0) {
                        System.arraycopy(selectedFileContent, 0, this.sectors[writeH][writeC][writeR], 0, 512);
                        boolean bl = teaForTwo = !teaForTwo;
                        if (++writeR >= 9) {
                            writeR = 0;
                            if (++writeC >= 40) break;
                        }
                        System.arraycopy(empty, 0, selectedFileContent, 0, 512);
                    }
                    if (teaForTwo) {
                        boolean bl = teaForTwo = !teaForTwo;
                        if (++writeR >= 9) {
                            writeR = 0;
                            if (++writeC >= 40) break;
                        }
                    }
                    fis.close();
                }
                catch (Exception e) {
                    break;
                }
                long m = fileLength / 16384L;
                long mm = fileLength % 16384L;
                if (mm > 0L) {
                    ++m;
                }
                int n = 0;
                while ((long)n < m) {
                    noSect = (i + n) / 16;
                    if (noSect >= 4) {
                        System.out.println("FILE_STRUCTDIR_TOO_BIG");
                        break;
                    }
                    ii = (i + n) % 16;
                    sectData = this.sectors[0][0][noSect];
                    System.arraycopy(line, 0, sectData, ii * 32, 32);
                    System.arraycopy(name.getBytes(), 0, sectData, ii * 32 + 1, 11);
                    if ((long)n == m - 1L && mm > 0L) {
                        long mmm = mm / 128L;
                        long mmmm = mm % 128L;
                        if (mmmm > 0L) {
                            ++mmm;
                        }
                        sectData[ii * 32 + 1 + 8 + 3 + 3] = (byte)mmm;
                        long nnn = mm / 1024L;
                        long nnnn = mm % 1024L;
                        if (nnnn > 0L) {
                            ++nnn;
                        }
                        int k = 0;
                        while ((long)k < nnn) {
                            sectData[ii * 32 + 16 + k] = writeNoSect;
                            writeNoSect = (byte)(writeNoSect + 1);
                            ++k;
                        }
                    } else {
                        sectData[ii * 32 + 1 + 8 + 3 + 3] = -128;
                        for (int k = 16; k < 32; ++k) {
                            sectData[ii * 32 + k] = writeNoSect;
                            writeNoSect = (byte)(writeNoSect + 1);
                        }
                    }
                    sectData[ii * 32 + 1 + 8 + 3] = (byte)n;
                    ++n;
                }
                i = (int)((long)i + m);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.scanNames = this.doScanAllNamesFromSectors();
    }

    protected static int sectorSize(int n) {
        return n > 5 ? 6144 : 128 << n;
    }

    protected int getSectorIndex(int[][] ids, int c, int h, int r, int n) {
        for (int i = 0; i < ids.length; ++i) {
            int[] id = ids[i];
            if (id[0] != c || id[1] != h || id[2] != r || id[3] != n) continue;
            return i;
        }
        return -1;
    }

    @Override
    public byte[] readSector(int cylinder, int head, int c, int h, int r, int n) {
        int index;
        byte[] result = null;
        if (cylinder <= this.lastCylinder && (index = this.getSectorIndex(this.ids[head &= this.headMask][cylinder], c, h, r, n)) != -1) {
            result = this.sectors[head][cylinder][index];
        }
        return result;
    }

    @Override
    public int[] getSectorID(int cylinder, int head, int index) {
        return this.ids[head & this.headMask][cylinder][index];
    }

    @Override
    public int getSectorCount(int cylinder, int head) {
        return cylinder > this.lastCylinder ? 0 : this.ids[head & this.headMask][cylinder].length;
    }

    @Override
    public void notifyWriteSector(byte data, int cylinder, int head, int c, int h, int r, int n) {
        int index;
        if (cylinder <= this.lastCylinder && (index = this.getSectorIndex(this.ids[head &= this.headMask][cylinder], c, h, r, n)) != -1) {
            if (head == 0 && cylinder == 0 && index < 4) {
                if (this.isData) {
                    this.cursorWrite = 0;
                    this.isData = false;
                }
                if (this.cursorWrite == 511) {
                    this.doScanNames(true, head, cylinder, index);
                }
            } else {
                if (!this.isData) {
                    this.cursorWrite = 0;
                    this.isData = true;
                }
                if (this.cursorWrite == 0) {
                    if (this.cylinderBank == null) {
                        this.cylinderBank = cylinder;
                        this.headBank = head;
                        this.indexBank = index;
                        this.isBank = true;
                    } else if (this.cylinderBank == cylinder && this.headBank == head && this.indexBank == index) {
                        this.isBank = false;
                    }
                }
                if (this.isBank) {
                    this.buffer.add(data);
                } else if (this.buffer.size() > 0) {
                    this.buffer.add(this.cursorWrite, data);
                    if (this.cursorWrite == 511) {
                        for (int i = 0; i < 512; ++i) {
                            this.buffer.remove(512);
                        }
                    }
                    this.cylinderBank = null;
                } else {
                    this.cylinderBank = null;
                }
            }
        }
        ++this.cursorWrite;
        if (this.cursorWrite == 512) {
            this.cursorWrite = 0;
        }
    }

    private List<String> doScanAllNamesFromSectors() {
        ArrayList<String> flatScanNames = new ArrayList<String>();
        for (int index = 0; index < 4; ++index) {
            byte[] result = this.sectors[0][0][index];
            for (int i = 0; i < result.length / 32; ++i) {
                byte[] filename = new byte[11];
                System.arraycopy(result, i * 32 + 1, filename, 0, 11);
                if (result[i * 32] == -27 || filename[10] == -27 || filename[10] == 36) continue;
                String s = "";
                for (int j = 0; j < 11; ++j) {
                    s = s + (char)filename[j];
                }
                flatScanNames.add(s);
            }
        }
        return flatScanNames;
    }

    private void doScanNames(boolean isWrite, int head, int cylinder, int index) {
        List<String> newScanNames = this.doScanAllNamesFromSectors();
        try {
            String filename = this.checkNewFile(this.scanNames, newScanNames);
            if (filename != null) {
                String first = filename;
                String ext = filename;
                while (first.length() > 8) {
                    first = first.substring(0, first.length() - 1);
                }
                while (ext.length() > 3) {
                    ext = ext.substring(1);
                }
                first = first.replace(" ", "");
                ext = ext.replace(" ", "");
                filename = first + "." + ext;
                System.out.println("FILE ADDED (isWrite=" + isWrite + ") : " + filename);
                File f = new File(this.path + "/" + filename);
                try {
                    byte[] buff = new byte[512];
                    FileOutputStream fos = new FileOutputStream(f, true);
                    for (int b = 0; b < this.buffer.size(); ++b) {
                        buff[b % 512] = this.buffer.get(b);
                        if (b % 512 == 511) {
                            fos.write(buff);
                            CPC.protect = true;
                            continue;
                        }
                        if (b != this.buffer.size() - 1) continue;
                        fos.write(buff, 0, b % 512 + 1);
                        CPC.protect = true;
                    }
                    fos.flush();
                    fos.close();
                    this.buffer.clear();
                    this.checkFile(f);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.scanNames = newScanNames;
            return;
        }
        catch (BadScanNameMomentException e) {
            System.out.println("Something but a new file by here");
            try {
                List<String> filenames = this.checkRenameFile(this.scanNames, newScanNames);
                if (filenames != null) {
                    System.out.println("Renaming file " + filenames.get(0) + " into " + filenames.get(1));
                    File f = new File(this.path + "/" + filenames.get(0));
                    File f2 = new File(this.path + "/" + filenames.get(1));
                    f.renameTo(f2);
                    CPC.protect = true;
                }
                this.scanNames = newScanNames;
                return;
            }
            catch (BadScanNameMomentException e2) {
                System.out.println("Something but a new file/a rename file by here");
                try {
                    String filename = this.checkEraseFile(this.scanNames, newScanNames);
                    if (filename != null) {
                        System.out.println("Erasing file " + filename);
                        File f = new File(this.path + "/" + filename);
                        f.delete();
                        String first = filename;
                        String ext = filename;
                        while (first.length() > 8) {
                            first = first.substring(0, first.length() - 1);
                        }
                        while (ext.length() > 3) {
                            ext = ext.substring(1);
                        }
                        first = first.replace(" ", "");
                        ext = ext.replace(" ", "");
                        filename = first + "." + ext;
                        f = new File(this.path + "/" + filename);
                        if (f.exists()) {
                            f.delete();
                        }
                        CPC.protect = true;
                    }
                    this.scanNames = newScanNames;
                    return;
                }
                catch (BadScanNameMomentException e3) {
                    System.out.println("Something but a new file/a rename file/an erase file by here : DIRStruct is not yet aligned, do just continue.");
                    return;
                }
            }
        }
    }

    protected void checkFile(File f) {
        try {
            int k = (int)f.length();
            byte[] buffer = new byte[k];
            BufferedInputStream bin = new BufferedInputStream(new FileInputStream(f));
            bin.read(buffer);
            bin.close();
            if (Computer.CheckAMSDOS(buffer)) {
                int size = Device.getWord(buffer, 24) + 128;
                byte[] result = new byte[size];
                System.arraycopy(buffer, 0, result, 0, size);
                BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(f));
                bos.write(result);
                bos.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String checkEraseFile(List<String> scanNames, List<String> newScanNames) throws BadScanNameMomentException {
        int n;
        HashMap<String, Integer> fileEntryCounts = new HashMap<String, Integer>();
        for (String name : scanNames) {
            if (fileEntryCounts.containsKey(name)) {
                n = (Integer)fileEntryCounts.get(name) - 1;
                fileEntryCounts.put(name, n);
                continue;
            }
            fileEntryCounts.put(name, -1);
        }
        for (String name : newScanNames) {
            if (fileEntryCounts.containsKey(name)) {
                n = (Integer)fileEntryCounts.get(name) + 1;
                fileEntryCounts.put(name, n);
                continue;
            }
            fileEntryCounts.put(name, 1);
        }
        String candidate = null;
        boolean candidateHasProblem = false;
        for (String name : fileEntryCounts.keySet()) {
            if ((Integer)fileEntryCounts.get(name) < 0) {
                if (!candidateHasProblem) {
                    candidate = name;
                    candidateHasProblem = true;
                    continue;
                }
                throw new BadScanNameMomentException();
            }
            if ((Integer)fileEntryCounts.get(name) <= 0) continue;
            throw new BadScanNameMomentException();
        }
        return candidate;
    }

    private List<String> checkRenameFile(List<String> scanNames, List<String> newScanNames) throws BadScanNameMomentException {
        int n;
        HashMap<String, Integer> fileEntryCounts = new HashMap<String, Integer>();
        for (String name : scanNames) {
            if (fileEntryCounts.containsKey(name)) {
                n = (Integer)fileEntryCounts.get(name) - 1;
                fileEntryCounts.put(name, n);
                continue;
            }
            fileEntryCounts.put(name, -1);
        }
        for (String name : newScanNames) {
            if (fileEntryCounts.containsKey(name)) {
                n = (Integer)fileEntryCounts.get(name) + 1;
                fileEntryCounts.put(name, n);
                continue;
            }
            fileEntryCounts.put(name, 1);
        }
        String candidateFrom = null;
        String candidateTo = null;
        boolean candidateFromHasProblem = false;
        boolean candidateToHasProblem = false;
        for (String name : fileEntryCounts.keySet()) {
            if ((Integer)fileEntryCounts.get(name) > 0) {
                if (!candidateToHasProblem) {
                    candidateTo = name;
                    candidateToHasProblem = true;
                    continue;
                }
                throw new BadScanNameMomentException();
            }
            if ((Integer)fileEntryCounts.get(name) >= 0) continue;
            if (!candidateFromHasProblem) {
                candidateFrom = name;
                candidateFromHasProblem = true;
                continue;
            }
            throw new BadScanNameMomentException();
        }
        if (candidateFromHasProblem != candidateToHasProblem) {
            throw new BadScanNameMomentException();
        }
        if (candidateFrom == null && candidateTo == null) {
            return null;
        }
        ArrayList<String> candidates = new ArrayList<String>();
        candidates.add(candidateFrom);
        candidates.add(candidateTo);
        return candidates;
    }

    private String checkNewFile(List<String> scanNames, List<String> newScanNames) throws BadScanNameMomentException {
        int n;
        HashMap<String, Integer> fileEntryCounts = new HashMap<String, Integer>();
        for (String name : scanNames) {
            if (fileEntryCounts.containsKey(name)) {
                n = (Integer)fileEntryCounts.get(name) - 1;
                fileEntryCounts.put(name, n);
                continue;
            }
            fileEntryCounts.put(name, -1);
        }
        for (String name : newScanNames) {
            if (fileEntryCounts.containsKey(name)) {
                n = (Integer)fileEntryCounts.get(name) + 1;
                fileEntryCounts.put(name, n);
                continue;
            }
            fileEntryCounts.put(name, 1);
        }
        String candidate = null;
        boolean candidateHasProblem = false;
        for (String name : fileEntryCounts.keySet()) {
            if ((Integer)fileEntryCounts.get(name) > 0) {
                if (!candidateHasProblem) {
                    candidate = name;
                    candidateHasProblem = true;
                    continue;
                }
                throw new BadScanNameMomentException();
            }
            if ((Integer)fileEntryCounts.get(name) >= 0) continue;
            throw new BadScanNameMomentException();
        }
        return candidate;
    }

    @Override
    public void notifyReadSector(boolean beginOfSector, int cylinder, int head, int c, int h, int r, int n) {
        int index;
        if (cylinder <= this.lastCylinder && (index = this.getSectorIndex(this.ids[head &= this.headMask][cylinder], c, h, r, n)) != -1 && head == 0 && cylinder == 0 && beginOfSector && index < 4) {
            this.doScanNames(true, head, cylinder, index);
        }
    }

    public class MagicCPCDiscImageException
    extends Exception {
        public static final String FILE_STRUCTDIR_TOO_BIG = "FILE_STRUCTDIR_TOO_BIG";

        public MagicCPCDiscImageException(String message) {
            super(message);
        }
    }

    public class BadScanNameMomentException
    extends Exception {
    }
}

