/*
 * Decompiled with CFR 0.152.
 */
package jemu.ui;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import jemu.core.Util;
import jemu.core.device.Device;
import jemu.system.cpc.CPC;
import jemu.system.cpc.GateArray;
import jemu.ui.Display;
import jemu.ui.Switches;

public class CPCOCR
extends JComponent {
    int ydistance = 0;
    BufferedImage Screen;
    protected int[] mode0 = new int[]{0, 192, 12, 204, 48, 240, 60, 252, 3, 195, 15, 207, 51, 243, 63, 255};
    protected int[] mode1 = new int[]{0, 240, 15, 255};
    protected int[] mode2 = new int[]{0, 255};
    int pen;
    int paper;
    protected String[] CPCASCII = new String[]{"\u25a1", " ", " ", " ", "\u0482", "\u04ff", "\u221a", "\u01b1", "\u2190", "\u2192", "\u2193", "\u2191", "\u21a8", " ", "\u00d8", "\u0298", "\u019f", "\u00d3", "\u01a0", "\u01ea", "\u00d2", " ", " ", " ", " ", " ", "\u00bf", " ", " ", " ", " ", " ", " ", "!", "\"", "#", "$", "%", "&", "'", "(", ")", "*", "+", ",", "-", ".", "/", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", ":", ";", "<", "=", ">", "?", "@", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "[", "\\", "]", "^", "_", "`", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "{", "|", "}", "~", "\u2593", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", "\u2588", "\u00b7", " ", " ", "\u2514", " ", "\u2502", "\u250c", "\u251c", " ", "\u2518", "\u2015", "\u2534", "\u2510", "\u2524", "\u252c", " ", "^", "\u00b4", "\u00a8", "\u00a3", "\u00a9", "\u00b6", "\u00a7", "`", "\u00bc", "\u00bd", "\u00be", "\u00b1", " ", "\u00ac", "\u00bf", "\u00a1", "\u03b1", "\u03b2", "\u03b3", "\u03b4", "\u03b5", "\u03b8", "\u03bb", "\u03bc", "\u03c0", "\u03c3", " ", " ", "\u03c7", "\u03c9", "\u03a3", "\u03a9", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", "\u2592", "\u2591", "\u00af", "\u25a1", "\u25a1", "\u25a1", "\u25a1", "\u25a1", "\u25a1", "\u25a1", "\u25a1", "\u25a1", "\u25a1", "\u25a1", "\u25a1", "\u25a1", "\u25a1", "\u25a1", "\u263a", "\u263b", "\u2663", "\u2666", "\u2665", "\u2660", "\u25cb", "\u25cf", "\u25a1", "\u25a0", "\u2642", "\u2640", "\u266a", "\u266b", "\u263c", "\u25a1", "\u2191", "\u2193", "\u2190", "\u2192", "\u25b2", "\u25bc", "\u25ba", "\u25c4", "\u25a1", "\u25a1", "\u25a1", "\u25a1", "\u25a1", "\u25a1", "\u2195", "\u2194"};
    BufferedImage[] chars;
    BufferedImage[] ichars;
    boolean initialised = false;
    final URL cpcchars = this.getClass().getResource("allinone.png");
    final URL cpccharsi = this.getClass().getResource("allinonei.png");
    int oldmode = -1;
    BufferedImage bufferchar;
    int oldd;
    StringBuilder result;
    BufferedImage FullColor;
    int back = 0;
    int fore = 0;
    public JComboBox fontsize = new JComboBox();
    String[] sizes = new String[]{"9", "10", "11", "12", "13", "16", "18", "24"};
    int width;
    int height;
    int mode;
    int[] crtc;
    String textresult;
    boolean recheck = false;
    int repos = 0;
    public boolean showreverse = true;
    public boolean showdouble = true;
    public boolean showallchars = true;

    public int getpen() {
        return GateArray.getInkRGB(this.pen);
    }

    public int getpaper() {
        return GateArray.getInkRGB(this.paper);
    }

    protected void init() {
        this.chars = new BufferedImage[this.CPCASCII.length];
        this.ichars = new BufferedImage[this.CPCASCII.length];
        try {
            BufferedImage cpcascii = ImageIO.read(this.cpcchars);
            BufferedImage cpcasciii = ImageIO.read(this.cpccharsi);
            int xpos = 0;
            int ypos = 0;
            for (int i = 0; i < this.chars.length; ++i) {
                this.chars[i] = new BufferedImage(8, 8, 1);
                this.ichars[i] = new BufferedImage(8, 8, 1);
                for (int x = 0; x < 8; ++x) {
                    for (int y = 0; y < 8; ++y) {
                        this.chars[i].setRGB(x, y, cpcascii.getRGB(x + xpos, y + ypos));
                        this.ichars[i].setRGB(x, y, cpcasciii.getRGB(x + xpos, y + ypos));
                    }
                }
                if ((xpos += 8) <= 632) continue;
                xpos = 0;
                ypos += 8;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        this.initialised = true;
    }

    public String getScreen() {
        if (!this.initialised) {
            this.init();
        }
        if (!this.initialised) {
            return "";
        }
        this.defineFont();
        this.mode = GateArray.getSMode();
        if (this.Screen == null || this.oldmode != this.mode) {
            switch (this.mode) {
                case 0: {
                    this.Screen = new BufferedImage(Display.image.getWidth() / 4, Display.image.getHeight() / 2, 1);
                    break;
                }
                case 1: {
                    this.Screen = new BufferedImage(Display.image.getWidth() / 2, Display.image.getHeight() / 2, 1);
                    break;
                }
                case 2: {
                    this.Screen = new BufferedImage(Display.image.getWidth(), Display.image.getHeight() / 2, 1);
                }
            }
        }
        switch (this.mode) {
            case 0: {
                this.Screen.createGraphics().drawImage(Display.image, 0, 0, Display.image.getWidth() / 4, Display.image.getHeight() / 2, null);
                break;
            }
            case 1: {
                this.Screen.createGraphics().drawImage(Display.image, 0, 0, Display.image.getWidth() / 2, Display.image.getHeight() / 2, null);
                break;
            }
            case 2: {
                this.Screen.createGraphics().drawImage(Display.image, 1, 0, Display.image.getWidth(), Display.image.getHeight() / 2, null);
            }
        }
        if (this.Screen == null) {
            return "";
        }
        boolean is6128 = Switches.ROM.equals("CPC6128");
        this.pen = CPC.PEEK(is6128 ? 46895 : 45711);
        this.paper = CPC.PEEK(is6128 ? 46896 : 45712);
        boolean penset = false;
        boolean paperset = false;
        block21: for (int i = 0; i < (this.mode == 0 ? 16 : (this.mode == 1 ? 4 : 2)); ++i) {
            switch (this.mode) {
                case 0: {
                    if (this.pen == this.mode0[i]) {
                        penset = true;
                        this.pen = i;
                    }
                    if (this.paper != this.mode0[i]) continue block21;
                    paperset = true;
                    this.paper = i;
                    continue block21;
                }
                case 1: {
                    if (this.pen == this.mode1[i]) {
                        penset = true;
                        this.pen = i;
                    }
                    if (this.paper != this.mode1[i]) continue block21;
                    paperset = true;
                    this.paper = i;
                    continue block21;
                }
                case 2: {
                    if (this.pen == this.mode2[i]) {
                        penset = true;
                        this.pen = i;
                    }
                    if (this.paper != this.mode2[i]) continue block21;
                    paperset = true;
                    this.paper = i;
                }
            }
        }
        if (!penset || !paperset) {
            this.pen = 0;
            this.paper = 0;
        }
        if (this.pen == this.paper) {
            this.paper = 0;
            this.pen = 1;
        }
        int background = GateArray.getInkRGB(this.paper);
        System.out.println("PEN = " + this.pen + " - PAPER = " + this.paper);
        for (int x = 0; x < this.Screen.getWidth(); ++x) {
            for (int y = 0; y < this.Screen.getHeight(); ++y) {
                if ((this.Screen.getRGB(x, y) & 0xFFFFFF) == background) {
                    this.Screen.setRGB(x, y, 0xFFFFFF);
                    continue;
                }
                this.Screen.setRGB(x, y, 0);
            }
        }
        try {
            ImageIO.write((RenderedImage)this.Screen, "PNG", new File("SCR.PNG"));
        }
        catch (Exception x) {
            // empty catch block
        }
        int[] borders = GateArray.cpc.getGateArray().getField();
        int xoff = borders[0];
        int yoff = borders[2];
        int firstpix = xoff;
        if (this.mode == 2 && GateArray.GAType == 40008) {
            ++firstpix;
        }
        if (this.mode == 0) {
            firstpix >>= 2;
        }
        if (this.mode == 1) {
            firstpix >>= 1;
        }
        int xpos = firstpix;
        int ypos = (yoff >> 1) + this.ydistance;
        int dd = GateArray.cpc.getGateArray().crtc.getReg(9) + 1;
        if (this.bufferchar == null || dd != this.oldd) {
            this.bufferchar = new BufferedImage(8, dd, 1);
        }
        this.oldd = dd;
        this.result = new StringBuilder();
        this.width = GateArray.cpc.getGateArray().crtc.getReg(1);
        this.height = GateArray.cpc.getGateArray().crtc.getReg(6);
        if (this.mode == 2) {
            this.width <<= 1;
        }
        if (this.mode == 0) {
            this.width >>= 1;
        }
        int off = 0;
        try {
            for (int j = 0; j < this.width; ++j) {
                for (int y = 0; y < this.height; ++y) {
                    int ya;
                    int xa;
                    for (xa = 0; xa < 8; ++xa) {
                        for (ya = 0; ya < dd; ++ya) {
                            this.bufferchar.setRGB(xa, ya, this.Screen.getRGB(xpos + xa, ypos + ya));
                        }
                    }
                    this.result.append(this.compare(this.bufferchar));
                    if (this.recheck) {
                        try {
                            this.bufferchar = new BufferedImage(8, dd, 1);
                            for (xa = 0; xa < 8; ++xa) {
                                for (ya = 0; ya < dd; ++ya) {
                                    this.bufferchar.setRGB(xa, ya, this.Screen.getRGB(xpos + xa, ypos + ya * 2));
                                }
                            }
                        }
                        catch (Exception r) {
                            r.printStackTrace();
                        }
                        this.result.append(this.compareAgain(this.bufferchar, this.repos));
                    }
                    xpos += 8;
                    if (++off < this.width) continue;
                    off = 0;
                    xpos = firstpix;
                    ypos += 8;
                    String line = this.result.toString();
                    while (line.endsWith(" ")) {
                        line = line.substring(0, line.length() - 1);
                    }
                    line = line + "\r\n";
                    this.result = new StringBuilder();
                    this.result.append(line);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.textresult = this.result.toString();
        while (this.textresult.endsWith("\r\n")) {
            this.textresult = this.textresult.substring(0, this.textresult.length() - 2);
        }
        return this.textresult;
    }

    public void initCombo() {
        this.fontsize.setModel(new DefaultComboBoxModel<String>(this.sizes));
        this.fontsize.setSelectedIndex(2);
    }

    public String getStyle() {
        return "font-family:Courier new;font-size:" + this.sizes[this.fontsize.getSelectedIndex()] + "px;background-color:#" + Util.hex(GateArray.getInkRGB(16)).substring(2);
    }

    public String getScreenHTML() {
        if (!this.initialised) {
            this.init();
        }
        if (!this.initialised) {
            return "";
        }
        this.defineFont();
        this.mode = GateArray.getSMode();
        if (this.Screen == null || this.oldmode != this.mode) {
            this.oldmode = this.mode;
            switch (this.mode) {
                case 1: {
                    this.Screen = new BufferedImage(Display.image.getWidth() / 2, Display.image.getHeight() / 2, 1);
                    this.FullColor = new BufferedImage(Display.image.getWidth() / 2, Display.image.getHeight() / 2, 1);
                    break;
                }
                case 2: {
                    this.Screen = new BufferedImage(Display.image.getWidth(), Display.image.getHeight() / 2, 1);
                    this.FullColor = new BufferedImage(Display.image.getWidth(), Display.image.getHeight() / 2, 1);
                    break;
                }
                default: {
                    this.Screen = new BufferedImage(Display.image.getWidth() / 4, Display.image.getHeight() / 2, 1);
                    this.FullColor = new BufferedImage(Display.image.getWidth() / 4, Display.image.getHeight() / 2, 1);
                }
            }
        }
        switch (this.mode) {
            case 1: {
                this.Screen.createGraphics().drawImage(Display.image, 0, 0, Display.image.getWidth() / 2, Display.image.getHeight() / 2, null);
                this.FullColor.createGraphics().drawImage(Display.image, 0, 0, Display.image.getWidth() / 2, Display.image.getHeight() / 2, null);
                break;
            }
            case 2: {
                this.Screen.createGraphics().drawImage(Display.image, 1, 0, Display.image.getWidth(), Display.image.getHeight() / 2, null);
                this.FullColor.createGraphics().drawImage(Display.image, 1, 0, Display.image.getWidth(), Display.image.getHeight() / 2, null);
                break;
            }
            default: {
                this.Screen.createGraphics().drawImage(Display.image, 0, 0, Display.image.getWidth() / 4, Display.image.getHeight() / 2, null);
                this.FullColor.createGraphics().drawImage(Display.image, 0, 0, Display.image.getWidth() / 4, Display.image.getHeight() / 2, null);
            }
        }
        if (this.Screen == null) {
            return "";
        }
        boolean is6128 = Switches.ROM.equals("CPC6128");
        this.pen = CPC.PEEK(is6128 ? 46895 : 45711);
        this.paper = CPC.PEEK(is6128 ? 46896 : 45712);
        boolean penset = false;
        boolean paperset = false;
        block17: for (int i = 0; i < (this.mode == 0 ? 16 : (this.mode == 1 ? 4 : 2)); ++i) {
            switch (this.mode) {
                case 0: {
                    if (this.pen == this.mode0[i]) {
                        penset = true;
                        this.pen = i;
                    }
                    if (this.paper != this.mode0[i]) continue block17;
                    paperset = true;
                    this.paper = i;
                    continue block17;
                }
                case 1: {
                    if (this.pen == this.mode1[i]) {
                        penset = true;
                        this.pen = i;
                    }
                    if (this.paper != this.mode1[i]) continue block17;
                    paperset = true;
                    this.paper = i;
                    continue block17;
                }
                case 2: {
                    if (this.pen == this.mode2[i]) {
                        penset = true;
                        this.pen = i;
                    }
                    if (this.paper != this.mode2[i]) continue block17;
                    paperset = true;
                    this.paper = i;
                }
            }
        }
        if (!penset || !paperset) {
            this.pen = 0;
            this.paper = 0;
        }
        if (this.pen == this.paper) {
            this.paper = 0;
            this.pen = 1;
        }
        int background = GateArray.getInkRGB(this.paper);
        for (int x = 0; x < this.Screen.getWidth(); ++x) {
            for (int y = 0; y < this.Screen.getHeight(); ++y) {
                if ((this.Screen.getRGB(x, y) & 0xFFFFFF) == background) {
                    this.Screen.setRGB(x, y, 0xFFFFFF);
                    continue;
                }
                this.Screen.setRGB(x, y, 0);
            }
        }
        int[] borders = GateArray.cpc.getGateArray().getField();
        int xoff = borders[0];
        int yoff = borders[2];
        int firstpix = xoff;
        if (this.mode == 2 && GateArray.GAType == 40008) {
            ++firstpix;
        }
        if (this.mode == 0) {
            firstpix >>= 2;
        }
        if (this.mode == 1) {
            firstpix >>= 1;
        }
        int xpos = firstpix;
        int ypos = (yoff >> 1) + this.ydistance;
        int dd = GateArray.cpc.getGateArray().crtc.getReg(9) + 1;
        if (this.bufferchar == null || dd != this.oldd) {
            this.bufferchar = new BufferedImage(8, dd, 1);
        }
        this.oldd = dd;
        this.result = new StringBuilder();
        this.result.append("<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body style=\"font-family:Courier new;font-size:" + this.sizes[this.fontsize.getSelectedIndex()] + "px;background-color:#ffffff\">\r\n");
        this.result.append("<table border=\"0\" bgcolor=\"#" + Util.hex(GateArray.getInkRGB(16)).substring(2) + "\" style=\"border-collapse: collapse\">\r\n<tr>\r\n<td>\r\n");
        for (int j = 0; j < yoff / 16; ++j) {
            this.result.append("<br>  <!-- Upper Border -->\r\n");
        }
        this.width = GateArray.cpc.getGateArray().crtc.getReg(1);
        this.height = GateArray.cpc.getGateArray().crtc.getReg(6);
        if (this.mode == 2) {
            this.width <<= 1;
        }
        if (this.mode == 0) {
            this.width >>= 1;
        }
        int off = 0;
        try {
            for (int y = 0; y < this.height; ++y) {
                for (int m = 0; m < this.width; ++m) {
                    int ya;
                    int xa;
                    for (xa = 0; xa < 8; ++xa) {
                        for (ya = 0; ya < dd; ++ya) {
                            this.bufferchar.setRGB(xa, ya, this.Screen.getRGB(xpos + xa, ypos + ya));
                            if ((this.bufferchar.getRGB(xa, ya) & 0xFFFFFF) == 0) {
                                this.fore = this.FullColor.getRGB(xpos + xa, ypos + ya) & 0xFFFFFF;
                                continue;
                            }
                            if ((this.bufferchar.getRGB(xa, ya) & 0xFFFFFF) == 0) continue;
                            this.back = this.FullColor.getRGB(xpos + xa, ypos + ya) & 0xFFFFFF;
                        }
                    }
                    if (m == 0) {
                        for (int n = 0; n < firstpix >> 3; ++n) {
                            this.result.append("&nbsp;");
                        }
                    }
                    this.result.append(this.compareHTML(this.bufferchar, this.fore, this.back));
                    if (this.recheck) {
                        try {
                            this.bufferchar = new BufferedImage(8, dd, 1);
                            for (xa = 0; xa < 8; ++xa) {
                                for (ya = 0; ya < dd; ++ya) {
                                    this.bufferchar.setRGB(xa, ya, this.Screen.getRGB(xpos + xa, ypos + ya * 2));
                                }
                            }
                        }
                        catch (Exception r) {
                            r.printStackTrace();
                        }
                        this.result.append(this.compareAgainHTML(this.bufferchar, this.repos, this.fore, this.back));
                    }
                    xpos += 8;
                    if (++off < this.width) continue;
                    off = 0;
                    xpos = firstpix;
                    ypos += 8;
                    String line = this.result.toString();
                    for (int n = 0; n < firstpix >> 3; ++n) {
                        line = line + "&nbsp;";
                    }
                    line = line + "<br>\r\n";
                    this.result = new StringBuilder();
                    this.result.append(line);
                }
            }
        }
        catch (Exception y) {
            // empty catch block
        }
        this.textresult = this.result.toString();
        for (int k = 0; k < yoff / 16; ++k) {
            this.textresult = this.textresult + "<br>  <!-- Lower Border -->\r\n";
        }
        this.textresult = this.textresult + "</td>\r\n</tr>\r\n</table>\r\n</body></html>";
        return this.textresult;
    }

    public int getW() {
        int mode = GateArray.getSMode();
        int width = GateArray.cpc.getGateArray().crtc.getReg(1) + 2;
        if (mode == 2) {
            width <<= 1;
        }
        if (mode == 0) {
            width >>= 1;
        }
        return width;
    }

    public int getH() {
        return GateArray.cpc.getGateArray().crtc.getReg(6) + 3;
    }

    public String getScreen(int lin) {
        if (--lin < 0) {
            return "";
        }
        if (!this.initialised) {
            this.init();
        }
        if (!this.initialised) {
            return "";
        }
        this.mode = GateArray.getSMode();
        this.Screen = null;
        switch (this.mode) {
            case 0: {
                this.Screen = new BufferedImage(Display.image.getWidth() / 4, Display.image.getHeight() / 2, 1);
                this.Screen.createGraphics().drawImage(Display.image, 0, 0, Display.image.getWidth() / 4, Display.image.getHeight() / 2, null);
                break;
            }
            case 1: {
                this.Screen = new BufferedImage(Display.image.getWidth() / 2, Display.image.getHeight() / 2, 1);
                this.Screen.createGraphics().drawImage(Display.image, 0, 0, Display.image.getWidth() / 2, Display.image.getHeight() / 2, null);
                break;
            }
            case 2: {
                this.Screen = new BufferedImage(Display.image.getWidth(), Display.image.getHeight() / 2, 1);
                this.Screen.createGraphics().drawImage(Display.image, 1, 0, Display.image.getWidth(), Display.image.getHeight() / 2, null);
            }
        }
        if (this.Screen == null) {
            return "";
        }
        boolean is6128 = Switches.ROM.equals("CPC6128");
        this.pen = CPC.PEEK(is6128 ? 46895 : 45711);
        this.paper = CPC.PEEK(is6128 ? 46896 : 45712);
        block12: for (int i = 0; i < (this.mode == 0 ? 16 : (this.mode == 1 ? 4 : 2)); ++i) {
            switch (this.mode) {
                case 0: {
                    if (this.pen == this.mode0[i]) {
                        this.pen = i;
                    }
                    if (this.paper != this.mode0[i]) continue block12;
                    this.paper = i;
                    continue block12;
                }
                case 1: {
                    if (this.pen == this.mode1[i]) {
                        this.pen = i;
                    }
                    if (this.paper != this.mode1[i]) continue block12;
                    this.paper = i;
                    continue block12;
                }
                case 2: {
                    if (this.pen == this.mode2[i]) {
                        this.pen = i;
                    }
                    if (this.paper != this.mode2[i]) continue block12;
                    this.paper = i;
                }
            }
        }
        if (this.pen == this.paper) {
            this.paper = 0;
            this.pen = 1;
        }
        int background = GateArray.getInkRGB(this.paper);
        for (int x = 0; x < this.Screen.getWidth(); ++x) {
            for (int y = 0; y < this.Screen.getHeight(); ++y) {
                if ((this.Screen.getRGB(x, y) & 0xFFFFFF) == background) {
                    this.Screen.setRGB(x, y, 0xFFFFFF);
                    continue;
                }
                this.Screen.setRGB(x, y, 0);
            }
        }
        int firstpix = 32;
        if (this.mode == 0) {
            firstpix = 16;
        }
        if (this.mode == 2) {
            firstpix = 64;
        }
        int xpos = firstpix;
        int ypos = 41;
        ypos += lin * 8;
        BufferedImage buffer = new BufferedImage(8, 8, 1);
        StringBuilder result = new StringBuilder();
        this.width = GateArray.cpc.getGateArray().crtc.getReg(1);
        if (this.mode == 2) {
            this.width <<= 1;
        }
        if (this.mode == 0) {
            this.width >>= 1;
        }
        int off = 0;
        for (int j = 0; j < this.width; ++j) {
            try {
                for (int xa = 0; xa < 8; ++xa) {
                    for (int ya = 0; ya < 8; ++ya) {
                        buffer.setRGB(xa, ya, this.Screen.getRGB(xpos + xa, ypos + ya));
                    }
                }
            }
            catch (Exception xa) {
                // empty catch block
            }
            result.append(this.compare(buffer));
            xpos += 8;
            if (++off < this.width) continue;
            off = 0;
            xpos = firstpix;
            ypos += 8;
            String line = result.toString();
            while (line.endsWith(" ")) {
                line = line.substring(0, line.length() - 1);
            }
            line = line + "\r\n";
            result = new StringBuilder();
            result.append(line);
        }
        this.textresult = result.toString();
        while (this.textresult.endsWith("\r\n")) {
            this.textresult = this.textresult.substring(0, this.textresult.length() - 2);
        }
        return this.textresult;
    }

    protected String compareAgain(BufferedImage input, int pos) {
        this.recheck = false;
        for (int i = this.showallchars ? 0 : 32; i < (this.showallchars ? this.chars.length : 170); ++i) {
            boolean match = true;
            for (int x = 0; x < 8; ++x) {
                for (int y = 0; y < 8; ++y) {
                    if (input.getRGB(x, y) == this.chars[i].getRGB(x, y)) continue;
                    match = false;
                }
            }
            if (!match) continue;
            return this.CPCASCII[i];
        }
        return "";
    }

    protected String compareAgainHTML(BufferedImage input, int pos, int fore, int back) {
        this.recheck = false;
        for (int i = this.showallchars ? 0 : 32; i < (this.showallchars ? this.chars.length : 170); ++i) {
            boolean match = true;
            for (int x = 0; x < 8; ++x) {
                for (int y = 0; y < 8; ++y) {
                    if (input.getRGB(x, y) == this.chars[i].getRGB(x, y)) continue;
                    match = false;
                }
            }
            if (!match) continue;
            return "<span style=\"color: #" + Util.hex(fore & 0xFFFFFF).substring(2) + ";background-color: #" + Util.hex(back & 0xFFFFFF).substring(2) + "\">" + this.CPCASCII[i].replace(" ", "&nbsp;") + "</span>";
        }
        return "";
    }

    protected String compare(BufferedImage input) {
        int y;
        int x;
        boolean match;
        int i;
        this.recheck = false;
        for (i = this.showallchars ? 0 : 32; i < (this.showallchars ? this.chars.length : 170); ++i) {
            match = true;
            for (x = 0; x < 8; ++x) {
                for (y = 0; y < 8; ++y) {
                    if (input.getRGB(x, y) == this.chars[i].getRGB(x, y)) continue;
                    match = false;
                }
            }
            if (!match) continue;
            return this.CPCASCII[i];
        }
        if (this.showreverse) {
            for (i = this.showallchars ? 0 : 32; i < (this.showallchars ? this.chars.length : 170); ++i) {
                match = true;
                for (x = 0; x < 8; ++x) {
                    for (y = 0; y < 8; ++y) {
                        if (input.getRGB(x, y) == this.ichars[i].getRGB(x, y)) continue;
                        match = false;
                    }
                }
                if (!match) continue;
                return this.CPCASCII[i];
            }
        }
        if (this.showdouble) {
            for (i = this.showallchars ? 0 : 32; i < (this.showallchars ? this.chars.length : 170); ++i) {
                match = true;
                BufferedImage gg = new BufferedImage(8, 16, 1);
                gg.createGraphics().drawImage(this.chars[i], 0, 0, 8, 16, this);
                for (int x2 = 0; x2 < 8; ++x2) {
                    for (int y2 = 0; y2 < 8; ++y2) {
                        if (input.getRGB(x2, y2) == gg.getRGB(x2, y2)) continue;
                        match = false;
                    }
                }
                if (!match) continue;
                this.repos = i;
                this.recheck = true;
                return "";
            }
        }
        return "";
    }

    protected String compareHTML(BufferedImage input, int fore, int back) {
        int y;
        int x;
        boolean match;
        int i;
        this.recheck = false;
        for (i = this.showallchars ? 0 : 32; i < (this.showallchars ? this.chars.length : 170); ++i) {
            match = true;
            for (x = 0; x < 8; ++x) {
                for (y = 0; y < 8; ++y) {
                    if (input.getRGB(x, y) == this.chars[i].getRGB(x, y)) continue;
                    match = false;
                }
            }
            if (!match) continue;
            return "<span style=\"color: #" + Util.hex(fore & 0xFFFFFF).substring(2) + ";background-color: #" + Util.hex(back & 0xFFFFFF).substring(2) + "\">" + this.CPCASCII[i].replace(" ", "&nbsp;") + "</span>";
        }
        if (this.showreverse) {
            for (i = this.showallchars ? 0 : 32; i < (this.showallchars ? this.chars.length : 170); ++i) {
                match = true;
                for (x = 0; x < 8; ++x) {
                    for (y = 0; y < 8; ++y) {
                        if (input.getRGB(x, y) == this.ichars[i].getRGB(x, y)) continue;
                        match = false;
                    }
                }
                if (!match) continue;
                return "<span style=\"color: #" + Util.hex(back & 0xFFFFFF).substring(2) + ";background-color: #" + Util.hex(fore & 0xFFFFFF).substring(2) + "\">" + this.CPCASCII[i].replace(" ", "&nbsp;") + "</span>";
            }
        }
        if (this.showdouble) {
            for (i = this.showallchars ? 0 : 32; i < (this.showallchars ? this.chars.length : 170); ++i) {
                match = true;
                BufferedImage gg = new BufferedImage(8, 16, 1);
                gg.createGraphics().drawImage(this.chars[i], 0, 0, 8, 16, this);
                for (int x2 = 0; x2 < 8; ++x2) {
                    for (int y2 = 0; y2 < 8; ++y2) {
                        if (input.getRGB(x2, y2) == gg.getRGB(x2, y2)) continue;
                        match = false;
                    }
                }
                if (!match) continue;
                this.repos = i;
                this.recheck = true;
                return "";
            }
        }
        return "";
    }

    public void defineFont() {
        byte check;
        boolean is6128 = Switches.ROM.equals("CPC6128");
        int pos = 0;
        byte[] half = CPC.memory.getLowerFONT();
        int addr = 45716;
        if (is6128) {
            addr = 46900;
        }
        if (((check = (byte)CPC.PEEK(addr)) & 0xFF) != 0 && CPC.PEEK(addr + 1) == 255) {
            int first = check & 0xFF;
            int bytepos = first * 8;
            byte[] newa = new byte[]{(byte)CPC.PEEK(addr + 2), (byte)CPC.PEEK(addr + 3)};
            addr = Device.getWord(newa, 0);
            pos = 0;
            for (int j = first; j < 255; ++j) {
                for (int k = 0; k < 8; ++k) {
                    half[bytepos++] = (byte)CPC.PEEK(addr + pos++);
                }
            }
        }
        pos = 0;
        int offs = 0;
        for (int i = 0; i < half.length; i += 8) {
            BufferedImage pox = new BufferedImage(8, 8, 1);
            BufferedImage pox2 = new BufferedImage(8, 8, 1);
            int y = 0;
            int l = 0;
            for (int d = 0; d < 8; ++d) {
                int val = half[offs++] & 0xFF;
                String g = Integer.toBinaryString(val);
                while (g.length() < 8) {
                    g = "0" + g;
                }
                l = 0;
                for (int k = 0; k < 8; ++k) {
                    String v = "" + g.charAt(k);
                    pox.setRGB(l, y, v.equals("1") ? 0 : 0xFFFFFF);
                    pox2.setRGB(l++, y, v.equals("0") ? 0 : 0xFFFFFF);
                }
                ++y;
            }
            this.chars[pos] = pox;
            this.ichars[pos++] = pox2;
        }
    }
}

