/*
 * Decompiled with CFR 0.152.
 */
package jemu.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.border.SoftBevelBorder;
import jemu.core.Util;
import jemu.core.device.Computer;
import jemu.core.device.Device;
import jemu.system.cpc.CPC;
import jemu.system.cpc.GateArray;
import jemu.ui.Switches;

public class CharViewer
extends JPanel
implements MouseListener {
    boolean saved = true;
    int diff = 0;
    final int ink1off = 4178;
    final int ink2off = 4195;
    final int modeoff = 2835;
    int modediff = 0;
    int ink = 0;
    int cink1;
    int cink2;
    int pink1;
    int pink2;
    int bootmode;
    int minindex = 255;
    FileDialog filedia;
    byte[] rombuffer;
    JFrame zoomview;
    JFrame editview;
    JLabel zoom;
    BufferedImage Zoom;
    BufferedImage Edit;
    BufferedImage REdit;
    BufferedImage source;
    int charpos;
    int charindex = -1;
    int sssx;
    int sssy;
    int ssx;
    int ssy;
    BufferedImage Res;
    BufferedImage[] chars = new BufferedImage[256];
    protected int startaddress;
    protected int startchar;
    boolean mouseisin;
    JFrame fram;
    private JTextField basfield;
    private JTextField charfield;
    private JLabel edit;
    private JPanel editpan;
    private Panel ink1;
    private Panel ink2;
    private JButton jButton1;
    private JButton jButton10;
    private JButton jButton11;
    private JButton jButton12;
    private JButton jButton13;
    private JButton jButton14;
    private JButton jButton15;
    private JButton jButton16;
    private JButton jButton2;
    private JButton jButton3;
    private JButton jButton4;
    private JButton jButton5;
    private JButton jButton6;
    private JButton jButton7;
    private JButton jButton8;
    private JButton jButton9;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JComboBox mode;
    private JLabel pen1;
    private JLabel pen2;
    private JLabel view;

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int x = e.getX() / 16;
        int y = e.getY() / 16;
        if (x > 7 || y > 7) {
            return;
        }
        int xx = x * 16 + 1;
        int yy = y * 16 + 1;
        int val = this.Edit.getRGB(xx + 3, yy + 3) & 0xFFFFFF;
        Color col = val == 0xFFFFFF ? Color.blue : Color.white;
        Graphics2D d = this.Edit.createGraphics();
        d.setColor(col);
        d.fillRect(xx, yy, 15, 15);
        this.saved = false;
        this.edit.setIcon(new ImageIcon(this.Edit));
    }

    public void Clear() {
        Graphics2D g = this.Edit.createGraphics();
        g.setColor(Color.white);
        g.fillRect(0, 0, 130, 130);
        g.setColor(Color.gray);
        for (int i = 0; i < 130; i += 16) {
            g.drawLine(i, 0, i, 130);
            g.drawLine(0, i, 130, i);
        }
        g.setColor(Color.black);
        g.drawRect(0, 0, 128, 128);
        this.edit.setIcon(new ImageIcon(this.Edit));
    }

    public void writeFromGA() {
        this.rombuffer = CPC.memory.getLowerROM();
        this.diff = 0;
        this.modediff = 0;
        if (Switches.ROM.equals("CPC464")) {
            this.diff = 5;
            this.modediff = 32;
        } else if (Switches.ROM.equals("CPC664")) {
            this.diff = 4;
            this.modediff = 4;
        }
        for (int ink = 0; ink < 17; ++ink) {
            int ga = GateArray.CPCInksb[ink] & 0x1F;
            int off = ink == 16 ? 0 : ink + 1;
            this.rombuffer[4178 + off - this.diff] = (byte)(ga & 0x1F);
            this.rombuffer[4195 + off - this.diff] = (byte)(ga & 0x1F);
        }
        this.bootmode = this.mode.getSelectedIndex();
        CPC.memory.setLowerROM(this.rombuffer);
        GateArray.cpc.reset();
        this.mode.setSelectedIndex(this.bootmode);
    }

    public void writeColor() {
        this.rombuffer = CPC.memory.getLowerROM();
        this.diff = 0;
        this.modediff = 0;
        if (Switches.ROM.equals("CPC464")) {
            this.diff = 5;
            this.modediff = 32;
        } else if (Switches.ROM.equals("CPC664")) {
            this.diff = 4;
            this.modediff = 4;
        }
        this.rombuffer[4178 + this.ink - this.diff] = (byte)(this.cink1 & 0x1F);
        this.rombuffer[4195 + this.ink - this.diff] = (byte)(this.cink2 & 0x1F);
        this.rombuffer[2835 - this.modediff] = (byte)(this.mode.getSelectedIndex() & 3);
        this.bootmode = this.mode.getSelectedIndex();
        CPC.memory.setLowerROM(this.rombuffer);
        GateArray.cpc.reset();
        this.mode.setSelectedIndex(this.bootmode);
    }

    public void updatePanels() {
        this.rombuffer = CPC.memory.getLowerROM();
        int col1 = GateArray.inkTranslateColor[this.cink1];
        int col2 = GateArray.inkTranslateColor[this.cink2];
        Color c1 = new Color(col1);
        Color c2 = new Color(col2);
        this.ink1.setBackground(c1);
        this.ink2.setBackground(c2);
        this.pen1.setText(Util.hex((byte)this.cink1));
        this.pen2.setText(Util.hex((byte)this.cink2));
    }

    public void updateColors() {
        this.diff = 0;
        this.modediff = 0;
        if (Switches.ROM.equals("CPC464")) {
            this.diff = 5;
            this.modediff = 32;
        } else if (Switches.ROM.equals("CPC664")) {
            this.diff = 4;
            this.modediff = 4;
        }
        this.rombuffer = CPC.memory.getLowerROM();
        this.bootmode = this.rombuffer[2835 - this.modediff] & 3;
        this.mode.setSelectedIndex(this.bootmode);
        this.pink1 = this.rombuffer[4178 + this.ink - this.diff] & 0x1F;
        this.pink2 = this.rombuffer[4195 + this.ink - this.diff] & 0x1F;
        int col1 = GateArray.inkTranslateColor[this.pink1];
        int col2 = GateArray.inkTranslateColor[this.pink2];
        Color c1 = new Color(col1);
        Color c2 = new Color(col2);
        this.ink1.setBackground(c1);
        this.ink2.setBackground(c2);
        this.pen1.setText(Util.hex((byte)this.cink1));
        this.pen2.setText(Util.hex((byte)this.cink2));
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    public CharViewer() {
        this.initComponents();
        this.edit.addMouseListener(this);
        this.Edit = new BufferedImage(129, 129, 1);
        Graphics2D g = this.Edit.createGraphics();
        g.setColor(Color.white);
        g.fillRect(0, 0, 130, 130);
        g.setColor(Color.gray);
        for (int i = 0; i < 130; i += 16) {
            g.drawLine(i, 0, i, 130);
            g.drawLine(0, i, 130, i);
        }
        g.setColor(Color.black);
        g.drawRect(0, 0, 128, 128);
        this.edit.setIcon(new ImageIcon(this.Edit));
    }

    protected void Save() {
        if (this.charindex < 0) {
            return;
        }
        String[] result = new String[8];
        int[] vals = new int[8];
        for (int i = 0; i < 8; ++i) {
            result[i] = "";
        }
        int pos = 0;
        for (int y = 0; y < 128; y += 16) {
            for (int x = 0; x < 128; x += 16) {
                int n = pos;
                result[n] = result[n] + ((this.Edit.getRGB(x + 4, y + 4) & 0xFFFFFF) == 0xFFFFFF ? "0" : "1");
            }
            ++pos;
        }
        String bas = "SYMBOL " + this.charindex + ",";
        for (int i = 0; i < 8; ++i) {
            vals[i] = this.getBinary(result[i]);
            bas = bas + vals[i];
            if (i >= 7) continue;
            bas = bas + ",";
        }
        this.basfield.setText(bas);
        byte[] half = CPC.memory.getLowerFONT();
        int start = this.charindex * 8;
        for (int i = 0; i < vals.length; ++i) {
            half[start + i] = (byte)vals[i];
        }
        CPC.memory.writeLowerFONT(half);
        System.out.println(this.startchar + "," + this.charindex);
        if (this.charindex >= this.startchar) {
            System.out.println("Fixing RAM font");
            boolean is6128 = Switches.ROM.equals("CPC6128");
            pos = 0;
            int addr = 45716;
            if (is6128) {
                addr = 46900;
            }
            int bytepos = (this.charindex - this.startchar) * 8;
            byte[] newa = new byte[]{(byte)CPC.PEEK(addr + 2), (byte)CPC.PEEK(addr + 3)};
            this.startaddress = addr = Device.getWord(newa, 0);
            pos = 0;
            for (int i = 0; i < vals.length; ++i) {
                CPC.POKE(addr + bytepos + pos++, vals[i]);
            }
        }
    }

    protected void Export(boolean rom) {
        byte[] data;
        this.update();
        if (rom) {
            data = CPC.memory.getLowerROM();
        } else {
            data = CPC.memory.getLowerFONT();
            this.minindex = 0;
            if (this.minindex > 0) {
                int start = this.minindex * 8;
                byte[] buf = new byte[2048 - start];
                System.arraycopy(data, start, buf, 0, buf.length);
                data = new byte[buf.length];
                System.arraycopy(buf, 0, data, 0, buf.length);
            }
        }
        this.filedia = new FileDialog((Frame)new JFrame(), "Export " + (rom ? "ROM" : "FONT"), 1);
        this.filedia.setFile(rom ? "*.rom" : "*.bin");
        this.filedia.setVisible(true);
        String file = this.filedia.getFile();
        if (file == null) {
            return;
        }
        file = this.filedia.getDirectory() + this.filedia.getFile();
        if (!file.toLowerCase().endsWith(rom ? ".rom" : ".bin")) {
            file = file + (rom ? ".rom" : ".bin");
        }
        File a = new File(file);
        try {
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(a));
            bos.write(data);
            bos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void Import() {
        this.filedia = new FileDialog((Frame)new JFrame(), "Import ", 0);
        this.filedia.setFile("*.rom;*.bin;*.fnt");
        this.filedia.setVisible(true);
        String file = this.filedia.getFile();
        if (file == null) {
            return;
        }
        boolean fnt = false;
        file = this.filedia.getDirectory() + this.filedia.getFile();
        if (file.toLowerCase().endsWith(".fnt")) {
            fnt = true;
        }
        File a = new File(file);
        byte[] data = new byte[(int)a.length()];
        try {
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(a));
            bis.read(data);
            bis.close();
            if (Computer.CheckAMSDOS(data)) {
                byte[] buffer = new byte[data.length - 128];
                System.arraycopy(data, 128, buffer, 0, buffer.length);
                data = new byte[buffer.length];
                System.arraycopy(buffer, 0, data, 0, data.length);
            }
            System.out.println("font size:" + data.length / 8);
            if (data.length > 2048) {
                if (data.length > 16384) {
                    return;
                }
                CPC.memory.setLowerROM(data);
                GateArray.cpc.reset();
            } else {
                if (data.length < 2048) {
                    byte[] fa = CPC.memory.getLowerFONT();
                    if (fnt) {
                        System.arraycopy(data, 0, fa, 256, data.length);
                    } else {
                        System.arraycopy(data, 0, fa, 2048 - data.length, data.length);
                    }
                    data = new byte[2048];
                    System.arraycopy(fa, 0, data, 0, 2048);
                }
                CPC.memory.writeLowerFONT(data);
                GateArray.cpc.reset();
            }
            this.update();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.minindex = 255;
    }

    protected int getBinary(String integ) {
        try {
            return Integer.parseInt(integ, 2);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    protected void EditChar() {
        if (this.charpos < 0 || this.charpos > 255) {
            return;
        }
        System.out.println("Editing " + this.charpos);
        this.EditChar(this.charpos);
    }

    protected void EditChar(int index) {
        this.sssx = this.ssx;
        this.sssy = this.ssy;
        this.charindex = index;
        if (this.charindex - 1 < this.minindex) {
            this.minindex = this.charindex - 1;
        }
        System.out.println("Selected char is " + this.charindex);
        this.charfield.setText("" + Integer.toHexString(index).toUpperCase());
        this.Edit = new BufferedImage(129, 129, 1);
        this.REdit = new BufferedImage(129, 129, 1);
        this.Edit.createGraphics().drawImage((Image)this.Zoom, 0, 0, null);
        this.REdit.createGraphics().drawImage((Image)this.Zoom, 0, 0, null);
        this.edit.setIcon(new ImageIcon(this.Edit));
    }

    protected void handleMouse(int x, int y, int sx, int sy) {
        x += 16;
        y += 16;
        sx = sx / 20 * 20 + 1;
        sy = sy / 32 * 32 + 1;
        this.charpos = sx / 20 + 29 * (sy / 32);
        if (this.charpos > 255) {
            this.view.setIcon(new ImageIcon(this.getChars()));
            if (this.zoomview != null) {
                this.zoomview.setVisible(false);
            }
            return;
        }
        if (this.zoomview == null) {
            this.zoomview = new JFrame();
            this.zoomview.setUndecorated(true);
            this.zoomview.setAlwaysOnTop(true);
            this.zoomview.setFocusable(false);
            this.zoom = new JLabel();
            this.Zoom = new BufferedImage(129, 129, 1);
            this.zoomview.setLayout(new BorderLayout());
            this.zoomview.add((Component)this.zoom, "Center");
            this.zoom.setPreferredSize(new Dimension(129, 129));
            this.zoomview.pack();
        }
        if (this.zoomview.isVisible() != this.mouseisin) {
            this.zoomview.setVisible(this.mouseisin);
        }
        this.zoomview.setLocation(x, y);
        Graphics2D g = this.Zoom.createGraphics();
        g.setColor(Color.gray);
        g.fillRect(0, 0, 130, 130);
        g.drawImage(this.source, 1, 1, 129, 129, sx, sy, sx + 16, sy + 16, null);
        if (this.saved) {
            this.ssx = sx;
            this.ssy = sy;
        }
        for (int i = 0; i < 130; i += 16) {
            g.drawLine(i, 0, i, 130);
            g.drawLine(0, i, 130, i);
        }
        g.setColor(Color.black);
        g.drawRect(0, 0, 128, 128);
        this.Res = this.getChars();
        Graphics2D d = this.Res.createGraphics();
        d.setColor(new Color(255, 255, 0, 128));
        d.fillRect(sx, sy, 16, 16);
        this.view.setIcon(new ImageIcon(this.Res));
        this.zoom.setIcon(new ImageIcon(this.Zoom));
    }

    public void resetZoom() {
        this.Edit.createGraphics().drawImage((Image)this.REdit, 0, 0, null);
    }

    public BufferedImage defineFont() {
        int pos;
        byte check;
        boolean is6128 = Switches.ROM.equals("CPC6128");
        byte[] half = CPC.memory.getLowerFONT();
        int addr = 45716;
        if (is6128) {
            addr = 46900;
        }
        if (((check = (byte)CPC.PEEK(addr)) & 0xFF) != 0 && CPC.PEEK(addr + 1) == 255) {
            int first;
            this.startchar = first = check & 0xFF;
            int bytepos = first * 8;
            byte[] newa = new byte[]{(byte)CPC.PEEK(addr + 2), (byte)CPC.PEEK(addr + 3)};
            this.startaddress = addr = Device.getWord(newa, 0);
            pos = 0;
            for (int i = first; i < 256; ++i) {
                for (int k = 0; k < 8; ++k) {
                    half[bytepos++] = (byte)CPC.PEEK(addr + pos++);
                }
            }
        }
        CPC.memory.writeLowerFONT(half);
        pos = 0;
        int offs = 0;
        for (int i = 0; i < half.length; i += 8) {
            BufferedImage pox = new BufferedImage(8, 8, 1);
            BufferedImage pox2 = new BufferedImage(8, 8, 1);
            int y = 0;
            for (int d = 0; d < 8; ++d) {
                int val = half[offs++] & 0xFF;
                String g = Integer.toBinaryString(val);
                while (g.length() < 8) {
                    g = "0" + g;
                }
                int l = 0;
                for (int k = 0; k < 8; ++k) {
                    String v = "" + g.charAt(k);
                    pox.setRGB(l, y, v.equals("1") ? 0 : 0xFFFFFF);
                    pox2.setRGB(l++, y, v.equals("0") ? 0 : 0xFFFFFF);
                }
                ++y;
            }
            this.chars[pos] = pox;
            ++pos;
        }
        BufferedImage result = new BufferedImage(578, 288, 1);
        int x = 0;
        int y = 0;
        Graphics2D g = result.createGraphics();
        g.setColor(Color.white);
        g.fillRect(0, 0, 800, 600);
        for (int i = 0; i < this.chars.length; ++i) {
            g.setColor(Color.blue);
            g.drawRect(x, y, 17, 17);
            g.drawImage(this.chars[i], ++x, ++y, 16, 16, null);
            ((Graphics)g).drawString("" + Util.hex((byte)i), x, y += 28);
            y -= 29;
            if ((x += 19) < 576) continue;
            x = 0;
            y += 32;
        }
        this.source = result;
        return result;
    }

    public BufferedImage getChars() {
        BufferedImage result = new BufferedImage(578, 288, 1);
        int x = 0;
        int y = 0;
        Graphics2D g = result.createGraphics();
        g.setColor(Color.white);
        g.fillRect(0, 0, 800, 600);
        for (int i = 0; i < this.chars.length; ++i) {
            g.setColor(Color.blue);
            g.drawRect(x, y, 17, 17);
            g.drawImage(this.chars[i], ++x, ++y, 16, 16, null);
            ((Graphics)g).drawString("" + Util.hex((byte)i), x, y += 28);
            y -= 29;
            if ((x += 19) < 576) continue;
            x = 0;
            y += 32;
        }
        return result;
    }

    public void update() {
        this.view.setIcon(new ImageIcon(this.defineFont()));
    }

    private void initComponents() {
        this.jPanel7 = new JPanel();
        this.ink1 = new Panel();
        this.ink2 = new Panel();
        this.jButton9 = new JButton();
        this.jButton10 = new JButton();
        this.jLabel2 = new JLabel();
        this.jButton11 = new JButton();
        this.jButton12 = new JButton();
        this.pen1 = new JLabel();
        this.jButton13 = new JButton();
        this.pen2 = new JLabel();
        this.jButton14 = new JButton();
        this.jButton15 = new JButton();
        this.mode = new JComboBox();
        this.jButton16 = new JButton();
        this.jPanel2 = new JPanel();
        this.view = new JLabel();
        this.editpan = new JPanel();
        this.jPanel3 = new JPanel();
        this.edit = new JLabel();
        this.jPanel4 = new JPanel();
        this.jButton1 = new JButton();
        this.jButton4 = new JButton();
        this.jPanel5 = new JPanel();
        this.jPanel1 = new JPanel();
        this.jButton2 = new JButton();
        this.charfield = new JTextField();
        this.jLabel1 = new JLabel();
        this.basfield = new JTextField();
        this.jButton3 = new JButton();
        this.jButton8 = new JButton();
        this.jPanel6 = new JPanel();
        this.jButton5 = new JButton();
        this.jButton6 = new JButton();
        this.jButton7 = new JButton();
        this.ink1.setMaximumSize(new Dimension(58, 58));
        this.ink1.setMinimumSize(new Dimension(58, 58));
        this.ink1.setPreferredSize(new Dimension(58, 58));
        this.ink2.setMaximumSize(new Dimension(58, 58));
        this.ink2.setMinimumSize(new Dimension(58, 58));
        this.ink2.setPreferredSize(new Dimension(58, 58));
        this.jButton9.setText("<");
        this.jButton9.setBorder(new SoftBevelBorder(0));
        this.jButton9.setFocusable(false);
        this.jButton9.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CharViewer.this.jButton9ActionPerformed(evt);
            }
        });
        this.jButton10.setText("<");
        this.jButton10.setFocusable(false);
        this.jButton10.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CharViewer.this.jButton10ActionPerformed(evt);
            }
        });
        this.jLabel2.setHorizontalAlignment(0);
        this.jLabel2.setText("BORDER");
        this.jButton11.setText(">");
        this.jButton11.setFocusable(false);
        this.jButton11.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CharViewer.this.jButton11ActionPerformed(evt);
            }
        });
        this.jButton12.setText(">");
        this.jButton12.setBorder(new SoftBevelBorder(0));
        this.jButton12.setFocusable(false);
        this.jButton12.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CharViewer.this.jButton12ActionPerformed(evt);
            }
        });
        this.pen1.setHorizontalAlignment(0);
        this.pen1.setText("01");
        this.jButton13.setText(">");
        this.jButton13.setBorder(new SoftBevelBorder(0));
        this.jButton13.setFocusable(false);
        this.jButton13.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CharViewer.this.jButton13ActionPerformed(evt);
            }
        });
        this.pen2.setHorizontalAlignment(0);
        this.pen2.setText("01");
        this.jButton14.setText("<");
        this.jButton14.setBorder(new SoftBevelBorder(0));
        this.jButton14.setFocusable(false);
        this.jButton14.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CharViewer.this.jButton14ActionPerformed(evt);
            }
        });
        this.jButton15.setText("Set");
        this.jButton15.setFocusable(false);
        this.jButton15.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CharViewer.this.jButton15ActionPerformed(evt);
            }
        });
        this.mode.setModel(new DefaultComboBoxModel<String>(new String[]{"MODE 0", "MODE 1", "MODE 2"}));
        this.mode.setFocusable(false);
        this.jButton16.setText("GA");
        this.jButton16.setFocusable(false);
        this.jButton16.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CharViewer.this.jButton16ActionPerformed(evt);
            }
        });
        GroupLayout jPanel7Layout = new GroupLayout(this.jPanel7);
        this.jPanel7.setLayout(jPanel7Layout);
        jPanel7Layout.setHorizontalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addContainerGap().addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(jPanel7Layout.createSequentialGroup().addComponent(this.jButton9).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pen1, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton12)).addComponent(this.ink1, -2, 58, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(jPanel7Layout.createSequentialGroup().addComponent(this.jButton14).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pen2, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton13)).addComponent(this.ink2, -2, 58, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(jPanel7Layout.createSequentialGroup().addComponent(this.jButton10).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2, -2, 85, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton11)).addGroup(jPanel7Layout.createSequentialGroup().addComponent(this.mode, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton16, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton15))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel7Layout.setVerticalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addContainerGap().addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jLabel2, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.ink1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.ink2, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jButton10, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jButton11, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton9, -2, 35, -2).addComponent(this.jButton12, -2, 35, -2)).addComponent(this.pen1, -2, 35, -2).addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton14, -2, 35, -2).addComponent(this.jButton13, -2, 35, -2).addComponent(this.pen2, -2, 35, -2).addComponent(this.jButton15).addComponent(this.mode, -2, -1, -2).addComponent(this.jButton16))).addContainerGap(-1, Short.MAX_VALUE)));
        this.setLayout(new BorderLayout());
        this.jPanel2.setLayout(new BorderLayout());
        this.view.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                CharViewer.this.viewMouseMoved(evt);
            }
        });
        this.view.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                CharViewer.this.viewMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                CharViewer.this.viewMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                CharViewer.this.viewMouseExited(evt);
            }
        });
        this.jPanel2.add((Component)this.view, "Center");
        this.editpan.setLayout(new BorderLayout());
        this.edit.setMaximumSize(new Dimension(129, 129));
        this.edit.setMinimumSize(new Dimension(129, 129));
        this.edit.setPreferredSize(new Dimension(129, 129));
        this.jPanel3.add(this.edit);
        this.editpan.add((Component)this.jPanel3, "First");
        this.jButton1.setText("Save");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CharViewer.this.jButton1ActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.jButton1);
        this.jButton4.setText("Cancel");
        this.jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CharViewer.this.jButton4ActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.jButton4);
        this.editpan.add((Component)this.jPanel4, "Center");
        this.jPanel2.add((Component)this.editpan, "After");
        this.jPanel5.setLayout(new BorderLayout());
        this.jPanel1.setMaximumSize(null);
        this.jButton2.setText("Update");
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CharViewer.this.jButton2ActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButton2);
        this.charfield.setColumns(2);
        this.charfield.setText("0");
        this.jPanel1.add(this.charfield);
        this.jLabel1.setText("BASIC:");
        this.jPanel1.add(this.jLabel1);
        this.basfield.setColumns(40);
        this.basfield.setFont(new Font("Monospaced", 1, 12));
        this.jPanel1.add(this.basfield);
        this.jButton3.setText("Clear");
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CharViewer.this.jButton3ActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButton3);
        this.jButton8.setText("Edit ROM Colors");
        this.jButton8.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CharViewer.this.jButton8ActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButton8);
        this.jPanel5.add((Component)this.jPanel1, "North");
        this.jButton5.setText("Export ROM");
        this.jButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CharViewer.this.jButton5ActionPerformed(evt);
            }
        });
        this.jPanel6.add(this.jButton5);
        this.jButton6.setText("Export Font");
        this.jButton6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CharViewer.this.jButton6ActionPerformed(evt);
            }
        });
        this.jPanel6.add(this.jButton6);
        this.jButton7.setText("Import Font");
        this.jButton7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CharViewer.this.jButton7ActionPerformed(evt);
            }
        });
        this.jPanel6.add(this.jButton7);
        this.jPanel5.add((Component)this.jPanel6, "South");
        this.jPanel2.add((Component)this.jPanel5, "Last");
        this.add((Component)this.jPanel2, "Center");
    }

    private void viewMouseEntered(MouseEvent evt) {
        this.mouseisin = true;
        if (this.zoomview != null) {
            this.zoomview.setVisible(true);
        }
    }

    private void viewMouseExited(MouseEvent evt) {
        this.mouseisin = false;
        if (this.zoomview != null) {
            this.zoomview.setVisible(false);
        }
    }

    private void viewMouseMoved(MouseEvent evt) {
        this.handleMouse(evt.getXOnScreen(), evt.getYOnScreen(), evt.getX(), evt.getY());
    }

    private void viewMouseClicked(MouseEvent evt) {
        if (this.saved) {
            this.EditChar();
        }
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.update();
    }

    private void jButton4ActionPerformed(ActionEvent evt) {
        if (this.saved) {
            return;
        }
        if (this.charindex > -1) {
            this.resetZoom();
            this.edit.setIcon(new ImageIcon(this.Edit));
        }
        this.saved = true;
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.Save();
        if (this.saved) {
            return;
        }
        this.update();
        if (this.charindex > -1) {
            this.edit.setIcon(new ImageIcon(this.Edit));
        }
        this.saved = true;
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        this.Clear();
    }

    private void jButton5ActionPerformed(ActionEvent evt) {
        this.Export(true);
    }

    private void jButton6ActionPerformed(ActionEvent evt) {
        this.Export(false);
    }

    private void jButton7ActionPerformed(ActionEvent evt) {
        this.Import();
    }

    private void jButton9ActionPerformed(ActionEvent evt) {
        this.cink1 = this.cink1 > 0 ? --this.cink1 : 31;
        this.cink2 = this.cink1;
        this.updatePanels();
    }

    private void jButton10ActionPerformed(ActionEvent evt) {
        this.ink = this.ink > 0 ? --this.ink : 16;
        this.jLabel2.setText("" + (this.ink == 0 ? "BORDER" : "PEN " + (this.ink - 1)));
        this.updateColors();
        this.cink1 = this.pink1;
        this.cink2 = this.pink2;
        this.updateColors();
    }

    private void jButton11ActionPerformed(ActionEvent evt) {
        this.ink = this.ink < 16 ? ++this.ink : 0;
        this.jLabel2.setText("" + (this.ink == 0 ? "BORDER" : "PEN " + (this.ink - 1)));
        this.updateColors();
        this.cink1 = this.pink1;
        this.cink2 = this.pink2;
        this.updateColors();
    }

    private void jButton12ActionPerformed(ActionEvent evt) {
        this.cink1 = this.cink1 < 31 ? ++this.cink1 : 0;
        this.cink2 = this.cink1;
        this.updatePanels();
    }

    private void jButton13ActionPerformed(ActionEvent evt) {
        this.cink2 = this.cink2 < 31 ? ++this.cink2 : 0;
        this.updatePanels();
    }

    private void jButton14ActionPerformed(ActionEvent evt) {
        this.cink2 = this.cink2 > 0 ? --this.cink2 : 31;
        this.updatePanels();
    }

    private void jButton8ActionPerformed(ActionEvent evt) {
        if (this.fram == null) {
            this.fram = new JFrame("Color chooser");
            this.fram.setLayout(new BorderLayout());
            this.fram.add((Component)this.jPanel7, "Center");
            this.fram.setDefaultCloseOperation(1);
            this.fram.pack();
            this.fram.setResizable(false);
        }
        this.fram.setVisible(true);
        this.updateColors();
        this.cink1 = this.pink1;
        this.cink2 = this.pink2;
        this.updatePanels();
    }

    private void jButton15ActionPerformed(ActionEvent evt) {
        this.writeColor();
    }

    private void jButton16ActionPerformed(ActionEvent evt) {
        this.writeFromGA();
    }
}

