/*
 * Decompiled with CFR 0.152.
 */
package jemu.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JDesktopPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import jemu.core.samples.Samples;
import jemu.settings.FavSettings;
import jemu.settings.Settings;
import jemu.system.cpc.GateArray;
import jemu.ui.Display;
import jemu.ui.Switches;

public class Favourites
extends JPanel
implements MouseListener,
MouseMotionListener {
    final URL bk = this.getClass().getResource("fav/favback.jpg");
    final Image wallpaper = this.getToolkit().getImage(this.bk);
    boolean stretch = false;
    private ArrayList<DropTarget> dropTargetList;
    JLabel[] dskLabel = new JLabel[1000];
    JLabel[] dskText = new JLabel[1000];
    JLabel[] dskShadow = new JLabel[1000];
    String[] names = new String[1000];
    ImageIcon[] ico = new ImageIcon[1000];
    int[] dskwidth = new int[1000];
    boolean[] icons = new boolean[1000];
    int maxiconwidth = 150;
    ImageIcon pressed = new ImageIcon(this.getClass().getResource("/jemu/ui/icons/icborder.png"));
    int choosenlabel = -10;
    final JFileChooser fc = new JFileChooser();
    int mx;
    int my;
    boolean running = false;
    private JMenuItem Load;
    private JMenuItem Load1;
    private JMenuItem Loadit;
    private JMenuItem addIconFromFile;
    private JDesktopPane desktop;
    private JPopupMenu diskMenu;
    private JMenuItem dskAdd;
    private JMenuItem dskAdd1;
    private JMenuItem dskAddU;
    private JPopupMenu dskMenu;
    private JMenuItem dskRemove;
    private JMenuItem dskRename;
    private JMenu dskmen;
    private JMenuItem jMenuItem1;
    private JMenuItem jMenuItem2;
    private JMenuItem jMenuItem3;
    private JScrollPane jScrollPane1;
    private JPopupMenu.Separator jSeparator1;
    private JPopupMenu.Separator jSeparator2;
    private JPopupMenu.Separator jSeparator3;
    private JPopupMenu.Separator jSeparator4;
    private JMenuItem makeIcon;
    private JProgressBar progress;
    private JMenuItem remIcon;

    public Favourites() {
        int i;
        this.initComponents();
        this.dropTargetList = new ArrayList();
        DropListener myListener = new DropListener();
        Favourites.registerDropListener(this.dropTargetList, this.desktop, myListener);
        for (i = 0; i < 1000; ++i) {
            this.dskText[i] = new JLabel();
            this.dskShadow[i] = new JLabel();
        }
        for (i = 0; i < 1000; ++i) {
            this.dskText[i].setText(null);
            this.dskShadow[i].setText(null);
        }
        this.desktop.addMouseListener(this);
        for (i = 0; i < 1000; ++i) {
            this.getIcon(i, true);
        }
    }

    public int getWidth(JLabel input) {
        try {
            FontMetrics fm = this.getFontMetrics(input.getFont());
            int width = fm.stringWidth(input.getText());
            if (width + 4 < this.maxiconwidth) {
                return width + 4;
            }
            return this.maxiconwidth;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public void setIconPos(int icon, int x, int y) {
        this.dskLabel[icon].setLocation(x, y);
        int width = this.getWidth(this.dskText[icon]);
        this.dskText[icon].setBounds(x, y, width, 14);
        this.dskText[icon].setLocation(x - width / 2 + 34, y + 52);
        this.dskShadow[icon].setBounds(x, y, width, 14);
        this.dskShadow[icon].setLocation(x - width / 2 + 36, y + 54);
        this.expand();
    }

    public void putIconPos(int icon, int x, int y) {
        this.dskLabel[icon].setLocation(x, y);
        int width = this.getWidth(this.dskText[icon]);
        this.dskText[icon].setBounds(x, y, width, 14);
        this.dskText[icon].setLocation(x - width / 2 + 34, y + 52);
        this.dskShadow[icon].setBounds(x, y, width, 14);
        this.dskShadow[icon].setLocation(x - width / 2 + 36, y + 54);
    }

    public void expand() {
        int sx = 0;
        int sy = 0;
        for (int i = 0; i < 1000; ++i) {
            if (this.dskText[i].getText() == null) continue;
            int xx = this.dskText[i].getX() + this.getWidth(this.dskText[i]) + 30;
            int yy = this.dskText[i].getY() + 30;
            if (sx < xx) {
                sx = xx;
            }
            if (sy >= yy) continue;
            sy = yy;
        }
        this.desktop.setPreferredSize(new Dimension(sx, sy));
    }

    public void saveIcon(int pos) {
        try {
            BufferedImage ima = new BufferedImage(64, 48, 2);
            Graphics2D g = ima.createGraphics();
            g.setColor(new Color(0, 0, 0, 32));
            g.fillRect(8, 8, 53, 40);
            g.setColor(new Color(0, 0, 0, 96));
            g.fillRect(7, 7, 53, 40);
            g.setColor(new Color(0, 0, 0, 160));
            g.fillRect(6, 6, 53, 40);
            g.setColor(new Color(0, 0, 0, 240));
            g.fillRect(5, 5, 53, 40);
            BufferedImage buf = new BufferedImage(640, 400, 1);
            Graphics2D v = buf.createGraphics();
            int sw = 40;
            int sh = 240;
            if (Display.doublesize) {
                sw = 80;
                sh = 480;
            } else {
                sw = 40;
                sh = 240;
            }
            Graphics2D g2 = v;
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            v = g2;
            v.drawImage(Display.image, 0, 0, 640, 400, 64, sw, 704, sh, this);
            g2 = g;
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g = g2;
            g.drawImage(buf, 4, 4, 53, 40, this);
            String filename = System.getProperty("user.home") + "/JavaCPC/FavIcons/";
            File file = new File(filename);
            if (!file.exists()) {
                file.mkdir();
            }
            file = new File(filename + "icon_" + Integer.toString(pos) + ".png");
            this.dskLabel[this.choosenlabel].setIcon(new ImageIcon(ima));
            FavSettings.setBoolean("icon_image_" + Integer.toString(pos), true);
            ImageIO.write((RenderedImage)ima, "png", file);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void importIcon() {
        int returnVal = this.fc.showOpenDialog(this);
        String name = null;
        if (returnVal == 0) {
            try {
                name = this.fc.getSelectedFile().getCanonicalPath();
            }
            catch (Exception e) {
                name = null;
            }
        }
        if (name == null) {
            return;
        }
        if (name.equals("empty")) {
            return;
        }
        this.saveIcon(this.choosenlabel, name);
    }

    public void saveIcon(int pos, String name) {
        try {
            BufferedImage ima = new BufferedImage(64, 48, 2);
            Graphics2D g = ima.createGraphics();
            g.setColor(new Color(0, 0, 0, 32));
            g.fillRect(8, 8, 40, 40);
            g.setColor(new Color(0, 0, 0, 96));
            g.fillRect(7, 7, 40, 40);
            g.setColor(new Color(0, 0, 0, 160));
            g.fillRect(6, 6, 40, 40);
            g.setColor(new Color(0, 0, 0, 240));
            g.fillRect(5, 5, 40, 40);
            Graphics2D g2 = g;
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g = g2;
            g.drawImage(this.pickIcon(name), 4, 4, 40, 40, this);
            String filename = System.getProperty("user.home") + "/JavaCPC/FavIcons/";
            File file = new File(filename);
            if (!file.exists()) {
                file.mkdir();
            }
            file = new File(filename + "icon_" + Integer.toString(pos) + ".png");
            this.dskLabel[this.choosenlabel].setIcon(new ImageIcon(ima));
            FavSettings.setBoolean("icon_image_" + Integer.toString(pos), true);
            ImageIO.write((RenderedImage)ima, "png", file);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void remIcon(int pos) {
        String filename = System.getProperty("user.home") + "/JavaCPC/FavIcons/icon_" + Integer.toString(pos) + ".png";
        File file = new File(filename);
        file.delete();
        this.dskLabel[pos].setIcon(this.ico[pos]);
        FavSettings.setBoolean("icon_image_" + Integer.toString(pos), false);
    }

    @Override
    public void mouseMoved(MouseEvent m) {
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        this.choosenlabel = -10;
        for (int i = 0; i < 1000; ++i) {
            if (me.getSource() != this.dskLabel[i]) continue;
            this.choosenlabel = i;
            if (this.dskLabel[i].getBorder() != null) break;
            this.dskLabel[i].setBorder(BorderFactory.createMatteBorder(0, 0, 0, 100, this.pressed));
            break;
        }
        if (this.choosenlabel < 0) {
            return;
        }
        try {
            int x = this.desktop.getMousePosition().x - 24;
            int y = this.desktop.getMousePosition().y - 24;
            int icon = this.choosenlabel;
            this.setIconPos(icon, x, y);
            this.mx = this.desktop.getMousePosition().x;
            this.my = this.desktop.getMousePosition().y;
            FavSettings.set("icon_pos_x_" + Integer.toString(this.choosenlabel), "" + this.mx);
            FavSettings.set("icon_pos_y_" + Integer.toString(this.choosenlabel), "" + this.my);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addIcon(int drive) {
        for (int i = 0; i < 1000; ++i) {
            String name;
            if (this.dskText[i] != null && this.dskText[i].getText() != null) continue;
            if (this.dskText[i] == null) {
                this.dskText[i] = new JLabel();
                this.dskShadow[i] = new JLabel();
            }
            if ((name = Settings.get("file.drive" + Integer.toString(drive), "empty")).equals("empty")) {
                return;
            }
            for (int ig = 0; ig < 1000; ++ig) {
                if (this.names[ig] == null || !this.names[ig].equals(name)) continue;
                return;
            }
            this.names[i] = name;
            while (name.contains("\\")) {
                name = name.substring(1);
            }
            this.setIcon(i, this.names[i], name);
            this.getIcon(i, true);
            break;
        }
    }

    public void addIcon() {
        for (int i = 0; i < 1000; ++i) {
            if (this.dskText[i] != null && this.dskText[i].getText() != null) continue;
            if (this.dskText[i] == null) {
                this.dskText[i] = new JLabel();
                this.dskShadow[i] = new JLabel();
            }
            int returnVal = this.fc.showOpenDialog(this);
            String name = null;
            if (returnVal == 0) {
                try {
                    name = this.fc.getSelectedFile().getCanonicalPath();
                }
                catch (Exception e) {
                    name = null;
                }
            }
            if (name == null) {
                return;
            }
            if (name.equals("empty")) {
                return;
            }
            File check = new File(name);
            if (check.isDirectory()) {
                return;
            }
            for (int ig = 0; ig < 1000; ++ig) {
                if (this.names[ig] == null || !this.names[ig].equals(name)) continue;
                return;
            }
            this.names[i] = name;
            while (name.contains("\\")) {
                name = name.substring(1);
            }
            this.setIcon(i, this.names[i], name);
            this.getIcon(i, true);
            break;
        }
    }

    public void addIcon(String name) {
        for (int i = 0; i < 1000; ++i) {
            if (this.dskText[i] != null && this.dskText[i].getText() != null) continue;
            if (this.dskText[i] == null) {
                this.dskText[i] = new JLabel();
                this.dskShadow[i] = new JLabel();
            }
            if (name == null) {
                return;
            }
            if (name.equals("empty")) {
                return;
            }
            File check = new File(name);
            if (check.isDirectory()) {
                return;
            }
            for (int ig = 0; ig < 1000; ++ig) {
                if (this.names[ig] == null || !this.names[ig].equals(name)) continue;
                return;
            }
            this.names[i] = name;
            while (name.contains("\\")) {
                name = name.substring(1);
            }
            this.setIcon(i, this.names[i], name);
            this.getIcon(i, false);
            break;
        }
    }

    public void setIcon(int index, String name, String label) {
        FavSettings.set("icon_label_" + Integer.toString(index), label);
        FavSettings.set("icon_text_" + Integer.toString(index), name);
        this.names[index] = name;
        this.dskText[index].setText(label);
        this.dskShadow[index].setText(label);
    }

    @Override
    public void removeAll() {
        if (this.running) {
            return;
        }
        this.running = true;
        Object[] options = new String[]{"Yes", "No"};
        int n = JOptionPane.showOptionDialog(null, "Are you sure to remove all entries?", "Please confirm", 0, 3, null, options, options[1]);
        if (n != 0) {
            this.running = false;
            return;
        }
        Thread runner = new Thread(){

            @Override
            public void run() {
                Favourites.this.progress.setMaximum(1000);
                for (int i = 0; i < 1000; ++i) {
                    Favourites.this.progress.setValue(i);
                    try {
                        Favourites.this.removeEntry(i);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                Favourites.this.progress.setValue(0);
                Favourites.this.running = false;
            }
        };
        runner.start();
    }

    public void checkFavs() {
        for (int i = 0; i < 1000; ++i) {
            try {
                File check;
                if (this.names[i] == null || (check = new File(this.names[i])).exists()) continue;
                this.removeEntry(i);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.cleanUp();
    }

    public void removeEntry(int index) {
        if (this.dskLabel[index] != null) {
            FavSettings.set("icon_label_" + Integer.toString(index), "notdefined");
            FavSettings.set("icon_text_" + Integer.toString(index), "notdefined");
            FavSettings.set("icon_pos_x_" + Integer.toString(index), "null");
            FavSettings.set("icon_pos_y_" + Integer.toString(index), "null");
            FavSettings.setBoolean("icon_image_" + Integer.toString(index), false);
            this.names[index] = null;
            this.dskText[index].setText(null);
            this.dskShadow[index].setText(null);
            this.desktop.remove(this.dskLabel[index]);
            this.desktop.remove(this.dskText[index]);
            this.desktop.remove(this.dskShadow[index]);
            this.desktop.repaint();
            if (this.icons[index]) {
                this.remIcon(index);
            }
            this.icons[index] = false;
        }
    }

    public void getIcon(int index, boolean reorder) {
        String label = FavSettings.get("icon_label_" + Integer.toString(index), "notdefined");
        String name = null;
        if (label == null || label.equals("notdefined")) {
            label = null;
            this.names[index] = null;
            if (this.dskText[index].getText() != null) {
                this.desktop.remove(this.dskText[index]);
                this.desktop.remove(this.dskLabel[index]);
                this.desktop.remove(this.dskShadow[index]);
            }
            this.dskText[index].setText(null);
            this.dskShadow[index].setText(null);
        } else {
            this.dskText[index].setText(label);
            this.dskShadow[index].setText(label);
            this.names[index] = name = FavSettings.get("icon_text_" + Integer.toString(index), "notdefined");
            this.ico[index] = this.names[index].toLowerCase().endsWith(".dsk") ? new ImageIcon(this.getClass().getResource("/jemu/ui/fav/diskicon.png")) : (this.names[index].toLowerCase().endsWith(".sna") ? new ImageIcon(this.getClass().getResource("/jemu/ui/fav/snaicon.png")) : (this.names[index].toLowerCase().endsWith(".cdt") || this.names[index].toLowerCase().endsWith(".tzx") || this.names[index].toLowerCase().endsWith(".csw") || this.names[index].toLowerCase().endsWith(".wav") || this.names[index].toLowerCase().endsWith(".mp3") ? new ImageIcon(this.getClass().getResource("/jemu/ui/fav/tapeicon.png")) : (this.names[index].toLowerCase().endsWith(".zip") || this.names[index].toLowerCase().endsWith(".anz") ? new ImageIcon(this.getClass().getResource("/jemu/ui/fav/packedicon.png")) : new ImageIcon(this.getClass().getResource("/jemu/ui/fav/fileicon.png")))));
            this.dskLabel[index] = new JLabel();
            this.icons[index] = FavSettings.getBoolean("icon_image_" + Integer.toString(index), false);
            if (this.icons[index]) {
                this.dskLabel[index].setIcon(new ImageIcon(this.pickIcon(index)));
            } else {
                this.dskLabel[index].setIcon(this.ico[index]);
            }
            this.desktop.add(this.dskLabel[index]);
            this.desktop.add(this.dskText[index]);
            this.desktop.add(this.dskShadow[index]);
            this.dskLabel[index].setBounds(20, 20, 64, 48);
            this.dskLabel[index].setVisible(true);
            this.dskText[index].setVisible(true);
            this.dskText[index].setToolTipText(this.names[index]);
            this.dskText[index].setFont(new Font("", 1, 10));
            this.dskText[index].setForeground(Color.white);
            this.dskShadow[index].setVisible(true);
            this.dskShadow[index].setToolTipText(this.names[index]);
            this.dskShadow[index].setFont(new Font("", 1, 10));
            this.dskShadow[index].setForeground(new Color(0, 0, 0, 160));
            this.dskLabel[index].setToolTipText(this.dskText[index].getText());
            this.dskLabel[index].setFocusable(true);
            this.dskLabel[index].addMouseListener(this);
            this.dskLabel[index].addMouseMotionListener(this);
            String xp = FavSettings.get("icon_pos_x_" + Integer.toString(index), "null");
            String yp = FavSettings.get("icon_pos_y_" + Integer.toString(index), "null");
            if (!xp.contains("null")) {
                this.mx = Integer.parseInt(xp);
                this.my = Integer.parseInt(yp);
            }
            if (reorder) {
                this.setIconPos(index, this.mx, this.my);
            } else {
                this.putIconPos(index, this.mx, this.my);
            }
            FavSettings.set("icon_pos_x_" + Integer.toString(index), "" + this.mx);
            FavSettings.set("icon_pos_y_" + Integer.toString(index), "" + this.my);
        }
    }

    public BufferedImage pickIcon(int pos) {
        BufferedImage img = null;
        try {
            String filename = System.getProperty("user.home") + "/JavaCPC/FavIcons/icon_" + pos + ".png";
            img = ImageIO.read(new File(filename));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return img;
    }

    public BufferedImage pickIcon(String name) {
        BufferedImage img = null;
        try {
            img = ImageIO.read(new File(name));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return img;
    }

    @Override
    public void mousePressed(MouseEvent me) {
        if (me.getButton() != 1) {
            this.mx = this.desktop.getMousePosition().x;
            this.my = this.desktop.getMousePosition().y;
            this.displayPopup((Component)me.getSource(), me.getX(), me.getY(), me);
        } else if (me.getSource() != this.desktop && me.getClickCount() == 2) {
            this.loadFile(this.choosenlabel);
        }
    }

    public void cleanUp() {
        if (this.running) {
            return;
        }
        Thread runner = new Thread(){

            @Override
            public void run() {
                int i;
                int x = 0;
                int y = 0;
                int maxy = Favourites.this.getHeight() - 200;
                int mp = 0;
                for (i = 0; i < 1000; ++i) {
                    if (Favourites.this.dskText[i].getText() == null) continue;
                    ++mp;
                    Favourites.this.putIconPos(i, 0, 0);
                }
                Favourites.this.progress.setMaximum(mp);
                Favourites.this.progress.setValue(0);
                mp = 0;
                for (i = 0; i < 1000; ++i) {
                    if (Favourites.this.dskText[i].getText() == null) continue;
                    Favourites.this.progress.setValue(++mp);
                    FavSettings.set("icon_pos_x_" + Integer.toString(i), "null");
                    FavSettings.set("icon_pos_y_" + Integer.toString(i), "null");
                    int xp = x + Favourites.this.maxiconwidth / 2;
                    int yp = y + 10;
                    Favourites.this.putIconPos(i, xp, yp);
                    FavSettings.set("icon_pos_x_" + Integer.toString(i), "" + xp);
                    FavSettings.set("icon_pos_y_" + Integer.toString(i), "" + yp);
                    if (y < maxy) {
                        y += 80;
                        continue;
                    }
                    y = 0;
                    x += 180;
                }
                Favourites.this.expand();
                Favourites.this.repaint();
                int sx = 0;
                int sy = 0;
                Favourites.this.progress.setValue(0);
                mp = 0;
                for (int i2 = 0; i2 < 1000; ++i2) {
                    if (Favourites.this.dskText[i2].getText() == null) continue;
                    Favourites.this.progress.setValue(++mp);
                    int xx = Favourites.this.dskText[i2].getX() + Favourites.this.getWidth(Favourites.this.dskText[i2]) + 30;
                    int yy = Favourites.this.dskText[i2].getY() + 30;
                    if (sx < xx) {
                        sx = xx;
                    }
                    if (sy >= yy) continue;
                    sy = yy;
                }
                Favourites.this.desktop.setPreferredSize(new Dimension(sx, sy));
                Favourites.this.updateUI();
                Favourites.this.running = false;
                Favourites.this.progress.setValue(0);
                mp = 0;
            }
        };
        this.running = true;
        runner.start();
    }

    public void loadFile(int index) {
        if (index < 0) {
            return;
        }
        System.out.println("Loading " + this.names[index]);
        String name = this.names[index];
        try {
            if (name.toLowerCase().endsWith(".dsk")) {
                Settings.set("file.drive" + Integer.toString(0), name);
                Settings.setBoolean("loaddrive" + Integer.toString(0), true);
            }
            GateArray.cpc.loadFile(0, name);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void loadFile(int index, int drive) {
        if (index < 0) {
            return;
        }
        System.out.println("Loading " + this.names[index] + " to drive DF" + drive);
        String name = this.names[index];
        try {
            if (Switches.FloppySound) {
                Samples.INSERT.play();
            }
            int d = GateArray.cpc.getCurrentDrive();
            GateArray.cpc.setCurrentDrive(drive);
            GateArray.cpc.loadFile(0, name);
            GateArray.cpc.setCurrentDrive(d);
            Settings.set("file.drive" + Integer.toString(drive), name);
            Settings.setBoolean("loaddrive" + Integer.toString(drive), true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void mouseExited(MouseEvent me) {
    }

    @Override
    public void mouseEntered(MouseEvent me) {
    }

    public void rename(JLabel input) {
        String old = input.getText();
        String inputWord = JOptionPane.showInputDialog("Enter the new name", (Object)old);
        if (inputWord != null) {
            input.setText(inputWord);
            this.setIconPos(this.choosenlabel, this.dskLabel[this.choosenlabel].getX(), this.dskLabel[this.choosenlabel].getY());
            FavSettings.set("icon_label_" + Integer.toString(this.choosenlabel), inputWord);
        }
    }

    @Override
    public void mouseClicked(MouseEvent me) {
        if (me.getSource() == this.desktop) {
            return;
        }
        try {
            int x = this.desktop.getMousePosition().x - 24;
            int y = this.desktop.getMousePosition().y - 24;
            this.choosenlabel = -10;
            for (int i = 0; i < 1000; ++i) {
                if (this.dskLabel[i] == null || this.dskLabel[i].getX() >= x + 24 || this.dskLabel[i].getX() <= x - 24 || this.dskLabel[i].getY() >= y + 24 || this.dskLabel[i].getY() <= y - 24) continue;
                this.choosenlabel = i;
                this.dskLabel[i].setBorder(BorderFactory.createMatteBorder(0, 0, 0, 100, this.pressed));
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        for (int i = 0; i < 1000; ++i) {
            if (this.dskLabel[i] == null) continue;
            this.dskLabel[i].setBorder(null);
        }
    }

    void displayPopup(Component invoker, int x, int y, MouseEvent me) {
        for (int i = 0; i < 1000; ++i) {
            if (me.getSource() != this.dskLabel[i]) continue;
            if (this.names[i].toLowerCase().endsWith(".dsk")) {
                this.Loadit.setVisible(false);
                this.Load.setVisible(true);
                this.Load1.setVisible(true);
            } else {
                this.Loadit.setVisible(true);
                this.Load.setVisible(false);
                this.Load1.setVisible(false);
            }
            this.dskmen.setText(this.dskText[i].getText());
            this.choosenlabel = i;
            this.diskMenu.show(invoker, x, y);
            return;
        }
        if (me.getSource() == this.desktop) {
            this.dskMenu.show(invoker, x, y);
        }
    }

    public static void main(String[] args) {
        Favourites test2 = new Favourites();
        test2.setPreferredSize(new Dimension(500, 400));
        JFrame tframe = new JFrame("Test application");
        tframe.setDefaultCloseOperation(3);
        tframe.setLayout(new BorderLayout());
        tframe.add((Component)test2, "Center");
        tframe.pack();
        tframe.setVisible(true);
    }

    private void initComponents() {
        this.dskMenu = new JPopupMenu();
        this.dskAdd = new JMenuItem();
        this.dskAdd1 = new JMenuItem();
        this.dskAddU = new JMenuItem();
        this.jSeparator2 = new JPopupMenu.Separator();
        this.jMenuItem2 = new JMenuItem();
        this.jSeparator3 = new JPopupMenu.Separator();
        this.jMenuItem1 = new JMenuItem();
        this.jMenuItem3 = new JMenuItem();
        this.diskMenu = new JPopupMenu();
        this.dskmen = new JMenu();
        this.Loadit = new JMenuItem();
        this.Load = new JMenuItem();
        this.Load1 = new JMenuItem();
        this.jSeparator1 = new JPopupMenu.Separator();
        this.dskRename = new JMenuItem();
        this.dskRemove = new JMenuItem();
        this.jSeparator4 = new JPopupMenu.Separator();
        this.makeIcon = new JMenuItem();
        this.addIconFromFile = new JMenuItem();
        this.remIcon = new JMenuItem();
        this.jScrollPane1 = new JScrollPane();
        this.desktop = new JDesktopPane(){

            @Override
            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                Graphics2D g2 = (Graphics2D)g;
                g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                g = g2;
                if (Favourites.this.wallpaper != null) {
                    if (Favourites.this.stretch) {
                        g.drawImage(Favourites.this.wallpaper, 0, 0, Favourites.this.desktop.getWidth(), Favourites.this.desktop.getHeight(), this);
                    } else {
                        for (int x = 0; x < 4000; x += Favourites.this.wallpaper.getWidth(this)) {
                            for (int y = 0; y < 3000; y += Favourites.this.wallpaper.getHeight(this)) {
                                if (x >= Favourites.this.desktop.getWidth() || y >= Favourites.this.desktop.getHeight()) continue;
                                g.drawImage(Favourites.this.wallpaper, x, y, this);
                            }
                        }
                    }
                }
            }
        };
        this.progress = new JProgressBar();
        this.dskAdd.setText("Add DSK in DF0 to favourites");
        this.dskAdd.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                Favourites.this.dskAddMouseReleased(evt);
            }
        });
        this.dskAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Favourites.this.dskAddActionPerformed(evt);
            }
        });
        this.dskMenu.add(this.dskAdd);
        this.dskAdd1.setText("Add DSK in DF1 to favourites");
        this.dskAdd1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                Favourites.this.dskAdd1MouseReleased(evt);
            }
        });
        this.dskAdd1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Favourites.this.dskAdd1ActionPerformed(evt);
            }
        });
        this.dskMenu.add(this.dskAdd1);
        this.dskAddU.setText("Add file to favourites");
        this.dskAddU.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                Favourites.this.dskAddUMouseReleased(evt);
            }
        });
        this.dskAddU.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Favourites.this.dskAddUActionPerformed(evt);
            }
        });
        this.dskMenu.add(this.dskAddU);
        this.dskMenu.add(this.jSeparator2);
        this.jMenuItem2.setText("Clean up window");
        this.jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Favourites.this.jMenuItem2ActionPerformed(evt);
            }
        });
        this.dskMenu.add(this.jMenuItem2);
        this.dskMenu.add(this.jSeparator3);
        this.jMenuItem1.setText("Remove all icons");
        this.jMenuItem1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                Favourites.this.jMenuItem1MouseReleased(evt);
            }
        });
        this.jMenuItem1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Favourites.this.jMenuItem1ActionPerformed(evt);
            }
        });
        this.dskMenu.add(this.jMenuItem1);
        this.jMenuItem3.setText("Remove unused Entries");
        this.jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Favourites.this.jMenuItem3ActionPerformed(evt);
            }
        });
        this.dskMenu.add(this.jMenuItem3);
        this.dskmen.setText(null);
        this.Loadit.setText("Load file into JavaCPC");
        this.Loadit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Favourites.this.LoaditActionPerformed(evt);
            }
        });
        this.dskmen.add(this.Loadit);
        this.Load.setText("Load Disk into DF0");
        this.Load.setActionCommand("Load DSK to drive DF0");
        this.Load.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Favourites.this.LoadActionPerformed(evt);
            }
        });
        this.dskmen.add(this.Load);
        this.Load1.setText("Load Disk into DF1");
        this.Load1.setActionCommand("Load DSK to drive DF1");
        this.Load1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Favourites.this.Load1ActionPerformed(evt);
            }
        });
        this.dskmen.add(this.Load1);
        this.dskmen.add(this.jSeparator1);
        this.dskRename.setText("Rename Label");
        this.dskRename.setActionCommand("Rename icon-label");
        this.dskRename.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                Favourites.this.dskRenameMouseReleased(evt);
            }
        });
        this.dskRename.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Favourites.this.dskRenameActionPerformed(evt);
            }
        });
        this.dskmen.add(this.dskRename);
        this.dskRemove.setText("Remove file from favourites");
        this.dskRemove.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                Favourites.this.dskRemoveMouseReleased(evt);
            }
        });
        this.dskRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Favourites.this.dskRemoveActionPerformed(evt);
            }
        });
        this.dskmen.add(this.dskRemove);
        this.dskmen.add(this.jSeparator4);
        this.makeIcon.setText("Create icon from screen");
        this.makeIcon.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Favourites.this.makeIconActionPerformed(evt);
            }
        });
        this.dskmen.add(this.makeIcon);
        this.addIconFromFile.setText("Add icon from image file");
        this.addIconFromFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Favourites.this.addIconFromFileActionPerformed(evt);
            }
        });
        this.dskmen.add(this.addIconFromFile);
        this.remIcon.setText("Remove userdefined icon");
        this.remIcon.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Favourites.this.remIconActionPerformed(evt);
            }
        });
        this.dskmen.add(this.remIcon);
        this.diskMenu.add(this.dskmen);
        this.setLayout(new BorderLayout());
        this.desktop.setBackground(new Color(0, 102, 153));
        this.jScrollPane1.setViewportView(this.desktop);
        this.add((Component)this.jScrollPane1, "Center");
        this.progress.setPreferredSize(new Dimension(146, 20));
        this.add((Component)this.progress, "Last");
    }

    private void dskRenameMouseReleased(MouseEvent evt) {
    }

    private void dskAddMouseReleased(MouseEvent evt) {
    }

    private void dskAdd1MouseReleased(MouseEvent evt) {
    }

    private void dskRemoveMouseReleased(MouseEvent evt) {
    }

    private void dskAddUMouseReleased(MouseEvent evt) {
    }

    private void jMenuItem1MouseReleased(MouseEvent evt) {
    }

    private void jMenuItem2ActionPerformed(ActionEvent evt) {
        this.cleanUp();
    }

    private void dskRenameActionPerformed(ActionEvent evt) {
        this.rename(this.dskText[this.choosenlabel]);
    }

    private void dskRemoveActionPerformed(ActionEvent evt) {
        Object[] options = new String[]{"Yes", "No"};
        int n = JOptionPane.showOptionDialog(null, "Are you sure to remove this entry?\r\n" + this.dskText[this.choosenlabel].getText(), "Please confirm", 0, 3, null, options, options[1]);
        if (n != 0) {
            this.running = false;
            return;
        }
        this.removeEntry(this.choosenlabel);
    }

    private void dskAddActionPerformed(ActionEvent evt) {
        this.addIcon(0);
    }

    private void dskAdd1ActionPerformed(ActionEvent evt) {
        this.addIcon(1);
    }

    private void dskAddUActionPerformed(ActionEvent evt) {
        this.addIcon();
    }

    private void jMenuItem1ActionPerformed(ActionEvent evt) {
        this.removeAll();
    }

    private void LoaditActionPerformed(ActionEvent evt) {
        this.loadFile(this.choosenlabel);
    }

    private void LoadActionPerformed(ActionEvent evt) {
        this.loadFile(this.choosenlabel, 0);
    }

    private void Load1ActionPerformed(ActionEvent evt) {
        this.loadFile(this.choosenlabel, 1);
    }

    private void makeIconActionPerformed(ActionEvent evt) {
        this.saveIcon(this.choosenlabel);
    }

    private void remIconActionPerformed(ActionEvent evt) {
        this.remIcon(this.choosenlabel);
    }

    private void addIconFromFileActionPerformed(ActionEvent evt) {
        this.importIcon();
    }

    private void jMenuItem3ActionPerformed(ActionEvent evt) {
        this.checkFavs();
    }

    private static void registerDropListener(ArrayList<DropTarget> list, Container basePanel, DropListener myListener) {
        list.add(new DropTarget(basePanel, myListener));
        Component[] components = basePanel.getComponents();
        for (int i = 0; i < components.length; ++i) {
            Component component = components[i];
            if (component instanceof Container) {
                Favourites.registerDropListener(list, (Container)component, myListener);
                continue;
            }
            list.add(new DropTarget(component, myListener));
        }
    }

    private class DropListener
    extends DropTargetAdapter {
        private DropListener() {
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            try {
                Transferable t = dtde.getTransferable();
                if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    dtde.acceptDrop(3);
                    final Object userObject = t.getTransferData(DataFlavor.javaFileListFlavor);
                    if (userObject instanceof List) {
                        final int size = ((List)userObject).size();
                        Favourites.this.progress.setMaximum(size);
                        Thread open = new Thread(){

                            @Override
                            public void run() {
                                for (int i = 0; i < size; ++i) {
                                    Favourites.this.progress.setValue(i);
                                    String fileName = ((List)userObject).get(i).toString();
                                    Favourites.this.addIcon(fileName);
                                }
                                Favourites.this.cleanUp();
                                Favourites.this.progress.setValue(0);
                            }
                        };
                        open.start();
                    }
                    dtde.dropComplete(true);
                }
            }
            catch (Exception ex) {
                System.out.println("[MainForm::DropListener]" + ex);
            }
        }
    }
}

