/*
 * Decompiled with CFR 0.152.
 */
package jemu.ui;

import com.jcraft.jogg.Packet;
import com.jcraft.jogg.Page;
import com.jcraft.jogg.StreamState;
import com.jcraft.jogg.SyncState;
import com.jcraft.jorbis.Block;
import com.jcraft.jorbis.Comment;
import com.jcraft.jorbis.DspState;
import com.jcraft.jorbis.Info;
import java.applet.AppletContext;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.util.Vector;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class JOrbisPlayer
extends JApplet
implements ActionListener,
Runnable {
    private static final long serialVersionUID = 1L;
    boolean running_as_applet = true;
    Thread player = null;
    InputStream bitStream = null;
    int udp_port = -1;
    String udp_baddress = null;
    static AppletContext acontext = null;
    static final int BUFSIZE = 8192;
    static int convsize = 16384;
    static byte[] convbuffer = new byte[convsize];
    private int RETRY;
    int retry = this.RETRY = 3;
    String playlistfile = "playlist";
    boolean icestats = false;
    SyncState oy;
    StreamState os;
    Page og;
    Packet op;
    Info vi;
    Comment vc;
    DspState vd;
    Block vb;
    byte[] buffer = null;
    int bytes = 0;
    int format;
    int rate = 0;
    int channels = 0;
    int left_vol_scale = 100;
    int right_vol_scale = 100;
    SourceDataLine outputLine = null;
    String current_source = null;
    int frameSizeInBytes;
    int bufferLengthInBytes;
    boolean playonstartup = false;
    boolean leftc;
    int value = 0;
    int left = -128;
    int right = -128;
    int highestleft = 128;
    int highestright = 128;
    protected boolean isplaying = false;
    Vector playlist = new Vector();
    boolean album = true;
    int h = 0;
    JPanel panel;
    JComboBox cb;
    JButton start_button;
    JButton stats_button;

    @Override
    public void init() {
        this.running_as_applet = true;
        acontext = this.getAppletContext();
        String s = this.getParameter("jorbis.player.playlist");
        if (s == null) {
            s = "http://streaming.rolandradio.net/rolandradio.64.stereo";
        }
        this.playlistfile = s;
        s = this.getParameter("jorbis.player.icestats");
        if (s != null && s.equals("yes")) {
            this.icestats = true;
        }
        this.loadPlaylist();
        this.initUI();
        if (this.playlist.size() > 0 && (s = this.getParameter("jorbis.player.playonstartup")) != null && s.equals("yes")) {
            this.playonstartup = true;
        }
        this.setBackground(Color.lightGray);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add(this.panel);
    }

    @Override
    public void start() {
        super.start();
        this.isplaying = true;
        if (this.playonstartup) {
            this.play_sound();
        }
    }

    void init_jorbis() {
        this.oy = new SyncState();
        this.os = new StreamState();
        this.og = new Page();
        this.op = new Packet();
        this.vi = new Info();
        this.vc = new Comment();
        this.vd = new DspState();
        this.vb = new Block(this.vd);
        this.buffer = null;
        this.bytes = 0;
        this.oy.init();
    }

    SourceDataLine getOutputLine(int channels, int rate) {
        if (this.outputLine == null || this.rate != rate || this.channels != channels) {
            if (this.outputLine != null) {
                this.outputLine.drain();
                this.outputLine.stop();
                this.outputLine.close();
            }
            this.init_audio(channels, rate);
            this.outputLine.start();
        }
        return this.outputLine;
    }

    void init_audio(int channels, int rate) {
        try {
            AudioFormat audioFormat = new AudioFormat(rate, 16, channels, true, false);
            DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat, -1);
            if (!AudioSystem.isLineSupported(info)) {
                return;
            }
            try {
                this.outputLine = (SourceDataLine)AudioSystem.getLine(info);
                this.outputLine.open(audioFormat);
            }
            catch (LineUnavailableException ex) {
                System.out.println("Unable to open the sourceDataLine: " + ex);
                return;
            }
            catch (IllegalArgumentException ex) {
                System.out.println("Illegal Argument: " + ex);
                return;
            }
            this.frameSizeInBytes = audioFormat.getFrameSize();
            int bufferLengthInFrames = this.outputLine.getBufferSize() / this.frameSizeInBytes / 2;
            this.bufferLengthInBytes = bufferLengthInFrames * this.frameSizeInBytes;
            this.rate = rate;
            this.channels = channels;
        }
        catch (Exception ee) {
            System.out.println(ee);
        }
    }

    private int item2index(String item) {
        if (item == null) {
            return -1;
        }
        for (int i = 0; i < this.cb.getItemCount(); ++i) {
            String foo = (String)this.cb.getItemAt(i);
            if (!item.equals(foo)) continue;
            return i;
        }
        this.cb.addItem(item);
        return this.cb.getItemCount() - 1;
    }

    @Override
    public void run() {
        Thread me = Thread.currentThread();
        String item = (String)this.cb.getSelectedItem();
        int current_index = this.item2index(item);
        do {
            item = (String)this.cb.getItemAt(current_index);
            this.cb.setSelectedIndex(current_index);
            this.bitStream = this.selectSource(item);
            if (this.bitStream != null) {
                if (this.udp_port != -1) {
                    this.play_udp_stream(me);
                } else {
                    this.play_stream(me);
                }
            } else if (this.cb.getItemCount() == 1) break;
            if (this.player != me) break;
            this.bitStream = null;
            if (++current_index < this.cb.getItemCount()) continue;
            current_index = 0;
        } while (this.cb.getItemCount() > 0);
        this.player = null;
        this.start_button.setText("Play");
    }

    private void play_stream(Thread me) {
        boolean chained = false;
        this.init_jorbis();
        this.retry = this.RETRY;
        block14: while (true) {
            boolean eos = false;
            int index = this.oy.buffer(8192);
            this.buffer = this.oy.data;
            try {
                this.bytes = this.bitStream.read(this.buffer, index, 8192);
            }
            catch (Exception e) {
                System.err.println(e);
                return;
            }
            this.oy.wrote(this.bytes);
            if (chained) {
                chained = false;
            } else if (this.oy.pageout(this.og) != 1) {
                if (this.bytes < 8192) break;
                System.err.println("Input does not appear to be an Ogg bitstream.");
                return;
            }
            this.os.init(this.og.serialno());
            this.os.reset();
            this.vi.init();
            this.vc.init();
            if (this.os.pagein(this.og) < 0) {
                System.err.println("Error reading first page of Ogg bitstream data.");
                return;
            }
            this.retry = this.RETRY;
            if (this.os.packetout(this.op) != 1) {
                System.err.println("Error reading initial header packet.");
                break;
            }
            if (this.vi.synthesis_headerin(this.vc, this.op) < 0) {
                System.err.println("This Ogg bitstream does not contain Vorbis audio data.");
                return;
            }
            int i = 0;
            while (i < 2) {
                int result;
                while (i < 2 && (result = this.oy.pageout(this.og)) != 0) {
                    if (result != 1) continue;
                    this.os.pagein(this.og);
                    while (i < 2 && (result = this.os.packetout(this.op)) != 0) {
                        if (result == -1) {
                            System.err.println("Corrupt secondary header.  Exiting.");
                            break block14;
                        }
                        this.vi.synthesis_headerin(this.vc, this.op);
                        ++i;
                    }
                }
                index = this.oy.buffer(8192);
                this.buffer = this.oy.data;
                try {
                    this.bytes = this.bitStream.read(this.buffer, index, 8192);
                }
                catch (Exception e) {
                    System.err.println(e);
                    return;
                }
                if (this.bytes == 0 && i < 2) {
                    System.err.println("End of file before finding all Vorbis headers!");
                    return;
                }
                this.oy.wrote(this.bytes);
            }
            byte[][] ptr = this.vc.user_comments;
            StringBuffer sb = null;
            if (acontext != null) {
                sb = new StringBuffer();
            }
            for (int j = 0; j < ptr.length && ptr[j] != null; ++j) {
                System.out.println("Comment: " + new String(ptr[j], 0, ptr[j].length - 1));
                if (sb == null) continue;
                sb.append(" " + new String(ptr[j], 0, ptr[j].length - 1));
            }
            System.out.println("Bitstream is " + this.vi.channels + " channel, " + this.vi.rate + "Hz");
            System.out.println("Encoded by: " + new String(this.vc.vendor, 0, this.vc.vendor.length - 1) + "\n");
            if (sb != null) {
                acontext.showStatus(sb.toString());
            }
            convsize = 8192 / this.vi.channels;
            this.vd.synthesis_init(this.vi);
            this.vb.init(this.vd);
            float[][][] _pcmf = new float[1][][];
            int[] _index = new int[this.vi.channels];
            this.getOutputLine(this.vi.channels, this.vi.rate);
            while (!eos) {
                while (!eos) {
                    if (this.player != me) {
                        try {
                            this.bitStream.close();
                            this.outputLine.drain();
                            this.outputLine.stop();
                            this.outputLine.close();
                            this.outputLine = null;
                        }
                        catch (Exception j) {
                            // empty catch block
                        }
                        return;
                    }
                    int result = this.oy.pageout(this.og);
                    if (result == 0) break;
                    if (result == -1) continue;
                    this.os.pagein(this.og);
                    if (this.og.granulepos() == 0L) {
                        chained = true;
                        eos = true;
                        break;
                    }
                    while ((result = this.os.packetout(this.op)) != 0) {
                        int samples;
                        if (result == -1) continue;
                        if (this.vb.synthesis(this.op) == 0) {
                            this.vd.synthesis_blockin(this.vb);
                        }
                        while ((samples = this.vd.synthesis_pcmout(_pcmf, _index)) > 0) {
                            float[][] pcmf = _pcmf[0];
                            int bout = samples < convsize ? samples : convsize;
                            block23: for (i = 0; i < this.vi.channels; ++i) {
                                int ptr2 = i * 2;
                                int mono = _index[i];
                                for (int j = 0; j < bout; ++j) {
                                    int val = (int)((double)pcmf[i][mono + j] * 32767.0);
                                    if (val > Short.MAX_VALUE) {
                                        val = Short.MAX_VALUE;
                                    }
                                    if (val < Short.MIN_VALUE) {
                                        val = Short.MIN_VALUE;
                                    }
                                    if (val < 0) {
                                        val |= 0x8000;
                                    }
                                    JOrbisPlayer.convbuffer[ptr2] = (byte)val;
                                    JOrbisPlayer.convbuffer[ptr2 + 1] = (byte)(val >>> 8);
                                    this.value = convbuffer[ptr2];
                                    ptr2 += 2 * this.vi.channels;
                                }
                                switch (i) {
                                    case 0: {
                                        this.left = (byte)(this.value ^ 0x80);
                                        continue block23;
                                    }
                                    case 1: {
                                        this.right = (byte)(this.value ^ 0x80);
                                    }
                                }
                            }
                            this.outputLine.write(convbuffer, 0, 2 * this.vi.channels * bout);
                            this.vd.synthesis_read(bout);
                        }
                    }
                    if (this.og.eos() == 0) continue;
                    eos = true;
                }
                if (eos) continue;
                index = this.oy.buffer(8192);
                this.buffer = this.oy.data;
                try {
                    this.bytes = this.bitStream.read(this.buffer, index, 8192);
                }
                catch (Exception e) {
                    System.err.println(e);
                    return;
                }
                if (this.bytes == -1) break;
                this.oy.wrote(this.bytes);
                if (this.bytes != 0) continue;
                eos = true;
            }
            this.os.clear();
            this.vb.clear();
            this.vd.clear();
            this.vi.clear();
        }
        this.oy.clear();
        try {
            if (this.bitStream != null) {
                this.bitStream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getLeft() {
        this.highestleft -= 2;
        if (this.highestleft < this.left) {
            this.highestleft = this.left;
        }
        if (this.highestleft < -126) {
            this.highestleft = -126;
        }
        return this.highestleft * 2;
    }

    public int getRight() {
        this.highestright -= 2;
        if (this.highestright < this.right) {
            this.highestright = this.right;
        }
        if (this.highestright < -126) {
            this.highestright = -126;
        }
        return this.highestright * 2;
    }

    private void play_udp_stream(Thread me) {
        block19: {
            this.init_jorbis();
            try {
                int index = this.oy.buffer(8192);
                this.buffer = this.oy.data;
                try {
                    this.bytes = this.bitStream.read(this.buffer, index, 8192);
                }
                catch (Exception e) {
                    System.err.println(e);
                    return;
                }
                this.oy.wrote(this.bytes);
                if (this.oy.pageout(this.og) != 1) {
                    System.err.println("Input does not appear to be an Ogg bitstream.");
                    return;
                }
                this.os.init(this.og.serialno());
                this.os.reset();
                this.vi.init();
                this.vc.init();
                if (this.os.pagein(this.og) < 0) {
                    System.err.println("Error reading first page of Ogg bitstream data.");
                    return;
                }
                if (this.os.packetout(this.op) != 1) {
                    System.err.println("Error reading initial header packet.");
                    return;
                }
                if (this.vi.synthesis_headerin(this.vc, this.op) < 0) {
                    System.err.println("This Ogg bitstream does not contain Vorbis audio data.");
                    return;
                }
                int i = 0;
                while (i < 2) {
                    int result;
                    while (i < 2 && (result = this.oy.pageout(this.og)) != 0) {
                        if (result != 1) continue;
                        this.os.pagein(this.og);
                        while (i < 2 && (result = this.os.packetout(this.op)) != 0) {
                            if (result == -1) {
                                System.err.println("Corrupt secondary header.  Exiting.");
                                break block19;
                            }
                            this.vi.synthesis_headerin(this.vc, this.op);
                            ++i;
                        }
                    }
                    if (i == 2) break;
                    index = this.oy.buffer(8192);
                    this.buffer = this.oy.data;
                    try {
                        this.bytes = this.bitStream.read(this.buffer, index, 8192);
                    }
                    catch (Exception e) {
                        System.err.println(e);
                        return;
                    }
                    if (this.bytes == 0 && i < 2) {
                        System.err.println("End of file before finding all Vorbis headers!");
                        return;
                    }
                    this.oy.wrote(this.bytes);
                }
            }
            catch (Exception index) {
                // empty catch block
            }
        }
        try {
            this.bitStream.close();
        }
        catch (Exception index) {
            // empty catch block
        }
        UDPIO io = null;
        try {
            io = new UDPIO(this.udp_port);
        }
        catch (Exception e) {
            return;
        }
        this.bitStream = io;
        this.play_stream(me);
    }

    @Override
    public void stop() {
        if (this.player == null) {
            try {
                this.isplaying = false;
                this.outputLine.drain();
                this.outputLine.stop();
                this.outputLine.close();
                this.outputLine = null;
                if (this.bitStream != null) {
                    this.bitStream.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.player = null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.stats_button) {
            String item = (String)this.cb.getSelectedItem();
            if (!item.startsWith("http://")) {
                return;
            }
            if (item.endsWith(".pls") ? (item = this.fetch_pls(item)) == null : item.endsWith(".m3u") && (item = this.fetch_m3u(item)) == null) {
                return;
            }
            byte[] foo = item.getBytes();
            for (int i = foo.length - 1; i >= 0; --i) {
                if (foo[i] != 47) continue;
                item = item.substring(0, i + 1) + "stats.xml";
                break;
            }
            System.out.println(item);
            try {
                String bar;
                URL url = null;
                url = this.running_as_applet ? new URL(this.getCodeBase(), item) : new URL(item);
                BufferedReader stats = new BufferedReader(new InputStreamReader(url.openConnection().getInputStream()));
                while ((bar = stats.readLine()) != null) {
                    System.out.println(bar);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        String command = ((JButton)e.getSource()).getText();
        if (command.equals("Play") && this.player == null) {
            this.play_sound();
        } else if (this.player != null) {
            this.stop_sound();
        }
    }

    public String getTitle() {
        return (String)this.cb.getSelectedItem();
    }

    public boolean isPlaying() {
        return this.isplaying;
    }

    public String getInfo() {
        try {
            ++this.h;
            byte[][] ptr = this.vc.user_comments;
            if (this.h < 10) {
                String i = new String(ptr[1], 0, ptr[1].length - 1);
                i = i.replace("album=", "");
                return i;
            }
            if (this.h > 20) {
                this.h = 0;
            }
            String i = new String(ptr[0], 0, ptr[0].length - 1);
            i = i.replace("title=", "");
            boolean dots = false;
            while (i.length() > 50) {
                i = i.substring(0, i.length() - 1);
                dots = true;
            }
            if (dots) {
                i = i + "...";
            }
            return i;
        }
        catch (Exception exception) {
            return "   Not playing...";
        }
    }

    public void play_sound() {
        if (this.player != null) {
            return;
        }
        this.player = new Thread(this);
        this.start_button.setText("Stop");
        this.player.start();
    }

    public void stop_sound() {
        if (this.player == null) {
            return;
        }
        this.vc = null;
        this.player = null;
        this.start_button.setText("Play");
    }

    InputStream selectSource(String item) {
        if (item == null) {
            item = "http://streaming.rolandradio.net/rolandradio";
        }
        System.out.println(item);
        if (item.endsWith(".pls") ? (item = this.fetch_pls(item)) == null : item.endsWith(".m3u") && (item = this.fetch_m3u(item)) == null) {
            return null;
        }
        InputStream is = null;
        URLConnection urlc = null;
        try {
            URL url = null;
            url = this.running_as_applet ? new URL(this.getCodeBase(), item) : new URL(item);
            urlc = url.openConnection();
            is = urlc.getInputStream();
            this.current_source = url.getProtocol() + "://" + url.getHost() + ":" + url.getPort() + url.getFile();
        }
        catch (Exception ee) {
            System.err.println(ee);
        }
        if (is == null && !this.running_as_applet) {
            try {
                is = new FileInputStream(System.getProperty("user.dir") + System.getProperty("file.separator") + item);
                this.current_source = null;
            }
            catch (Exception ee) {
                System.err.println(ee);
            }
        }
        if (is == null) {
            return null;
        }
        System.out.println("Select: " + item);
        boolean find = false;
        for (int i = 0; i < this.cb.getItemCount(); ++i) {
            String foo = (String)this.cb.getItemAt(i);
            if (!item.equals(foo)) continue;
            find = true;
            break;
        }
        if (!find) {
            this.cb.addItem(item);
        }
        int i = 0;
        String s = null;
        String t = null;
        this.udp_port = -1;
        this.udp_baddress = null;
        while (urlc != null) {
            s = urlc.getHeaderField(i);
            t = urlc.getHeaderFieldKey(i);
            if (s == null) break;
            ++i;
            if (t != null && t.equals("udp-port")) {
                try {
                    this.udp_port = Integer.parseInt(s);
                }
                catch (Exception ee) {
                    System.err.println(ee);
                }
                continue;
            }
            if (t == null || !t.equals("udp-broadcast-address")) continue;
            this.udp_baddress = s;
        }
        return is;
    }

    String fetch_pls(String pls) {
        block10: {
            int i;
            InputStream pstream = null;
            if (pls.startsWith("http://")) {
                try {
                    URL url = null;
                    url = this.running_as_applet ? new URL(this.getCodeBase(), pls) : new URL(pls);
                    URLConnection urlc = url.openConnection();
                    pstream = urlc.getInputStream();
                }
                catch (Exception ee) {
                    System.err.println(ee);
                    return null;
                }
            }
            if (pstream == null && !this.running_as_applet) {
                try {
                    pstream = new FileInputStream(System.getProperty("user.dir") + System.getProperty("file.separator") + pls);
                }
                catch (Exception ee) {
                    System.err.println(ee);
                    return null;
                }
            }
            String line = null;
            do {
                try {
                    line = this.readline(pstream);
                }
                catch (Exception urlc) {
                    // empty catch block
                }
                if (line == null) break block10;
            } while (!line.startsWith("File1="));
            byte[] foo = line.getBytes();
            for (i = 6; i < foo.length && foo[i] != 13; ++i) {
            }
            return line.substring(6, i);
        }
        return null;
    }

    String fetch_m3u(String m3u) {
        InputStream pstream = null;
        if (m3u.startsWith("http://")) {
            try {
                URL url = null;
                url = this.running_as_applet ? new URL(this.getCodeBase(), m3u) : new URL(m3u);
                URLConnection urlc = url.openConnection();
                pstream = urlc.getInputStream();
            }
            catch (Exception ee) {
                System.err.println(ee);
                return null;
            }
        }
        if (pstream == null && !this.running_as_applet) {
            try {
                pstream = new FileInputStream(System.getProperty("user.dir") + System.getProperty("file.separator") + m3u);
            }
            catch (Exception ee) {
                System.err.println(ee);
                return null;
            }
        }
        String line = null;
        try {
            line = this.readline(pstream);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (line != null) {
            return line;
        }
        return null;
    }

    void loadPlaylist() {
        if (this.running_as_applet) {
            String s = null;
            for (int i = 0; i < 10 && (s = this.getParameter("jorbis.player.play." + i)) != null; ++i) {
                this.playlist.addElement(s);
            }
        }
        if (this.playlistfile == null) {
            return;
        }
        try {
            String line;
            InputStream is = null;
            try {
                URL url = null;
                url = this.running_as_applet ? new URL(this.getCodeBase(), this.playlistfile) : new URL(this.playlistfile);
                URLConnection urlc = url.openConnection();
                is = urlc.getInputStream();
            }
            catch (Exception url) {
                // empty catch block
            }
            if (is == null && !this.running_as_applet) {
                try {
                    is = new FileInputStream(System.getProperty("user.dir") + System.getProperty("file.separator") + this.playlistfile);
                }
                catch (Exception url) {
                    // empty catch block
                }
            }
            if (is == null) {
                return;
            }
            while ((line = this.readline(is)) != null) {
                byte[] foo = line.getBytes();
                for (int i = 0; i < foo.length; ++i) {
                    if (foo[i] != 13) continue;
                    line = new String(foo, 0, i);
                    break;
                }
                this.playlist.addElement(line);
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    private String readline(InputStream is) {
        int temp;
        StringBuffer rtn = new StringBuffer();
        do {
            try {
                temp = is.read();
            }
            catch (Exception e) {
                return null;
            }
            if (temp == -1) {
                String str = rtn.toString();
                if (str.length() == 0) {
                    return null;
                }
                return str;
            }
            if (temp == 0 || temp == 10 || temp == 13) continue;
            rtn.append((char)temp);
        } while (temp != 10 && temp != 13);
        return rtn.toString();
    }

    void initUI() {
        this.panel = new JPanel();
        this.cb = new JComboBox(this.playlist);
        this.cb.setEditable(true);
        this.panel.add(this.cb);
        this.start_button = new JButton("Play");
        this.start_button.addActionListener(this);
        this.start_button.setFocusPainted(false);
        this.start_button.setFocusable(false);
        this.start_button.setFont(new Font("", 1, 8));
        this.panel.add(this.start_button);
        if (this.icestats) {
            this.stats_button = new JButton("IceStats");
            this.stats_button.addActionListener(this);
            this.panel.add(this.stats_button);
        }
    }

    public static void main(String[] arg) {
        JFrame frame = new JFrame("JOrbisPlayer");
        frame.setBackground(Color.lightGray);
        frame.setBackground(Color.white);
        frame.getContentPane().setLayout(new BorderLayout());
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        JOrbisPlayer player = new JOrbisPlayer();
        player.running_as_applet = false;
        if (arg.length > 0) {
            for (int i = 0; i < arg.length; ++i) {
                player.playlist.addElement(arg[i]);
            }
        }
        player.loadPlaylist();
        player.initUI();
        frame.getContentPane().add(player.panel);
        frame.pack();
        frame.setVisible(true);
    }

    class UDPIO
    extends InputStream {
        InetAddress address;
        DatagramSocket socket = null;
        DatagramPacket sndpacket;
        DatagramPacket recpacket;
        byte[] buf = new byte[1024];
        int port;
        byte[] inbuffer = new byte[2048];
        byte[] outbuffer = new byte[1024];
        int instart = 0;
        int inend = 0;
        int outindex = 0;

        UDPIO(int port) {
            this.port = port;
            try {
                this.socket = new DatagramSocket(port);
            }
            catch (Exception e) {
                System.err.println(e);
            }
            this.recpacket = new DatagramPacket(this.buf, 1024);
        }

        void setTimeout(int i) {
            try {
                this.socket.setSoTimeout(i);
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }

        int getByte() throws IOException {
            if (this.inend - this.instart < 1) {
                this.read(1);
            }
            return this.inbuffer[this.instart++] & 0xFF;
        }

        int getByte(byte[] array) throws IOException {
            return this.getByte(array, 0, array.length);
        }

        int getByte(byte[] array, int begin, int length) throws IOException {
            int i = 0;
            int foo = begin;
            while ((i = this.inend - this.instart) < length) {
                if (i != 0) {
                    System.arraycopy(this.inbuffer, this.instart, array, begin, i);
                    begin += i;
                    length -= i;
                    this.instart += i;
                }
                this.read(length);
            }
            System.arraycopy(this.inbuffer, this.instart, array, begin, length);
            this.instart += length;
            return begin + length - foo;
        }

        int getShort() throws IOException {
            if (this.inend - this.instart < 2) {
                this.read(2);
            }
            int s = 0;
            s = this.inbuffer[this.instart++] & 0xFF;
            s = s << 8 & 0xFFFF | this.inbuffer[this.instart++] & 0xFF;
            return s;
        }

        int getInt() throws IOException {
            if (this.inend - this.instart < 4) {
                this.read(4);
            }
            int i = 0;
            i = this.inbuffer[this.instart++] & 0xFF;
            i = i << 8 & 0xFFFF | this.inbuffer[this.instart++] & 0xFF;
            i = i << 8 & 0xFFFFFF | this.inbuffer[this.instart++] & 0xFF;
            i = i << 8 | this.inbuffer[this.instart++] & 0xFF;
            return i;
        }

        void getPad(int n) throws IOException {
            while (n > 0) {
                int i = this.inend - this.instart;
                if (i < n) {
                    this.instart += i;
                    this.read(n -= i);
                    continue;
                }
                this.instart += n;
                break;
            }
        }

        void read(int n) throws IOException {
            if (n > this.inbuffer.length) {
                n = this.inbuffer.length;
            }
            this.inend = 0;
            this.instart = 0;
            this.recpacket.setData(this.buf, 0, 1024);
            this.socket.receive(this.recpacket);
            int i = this.recpacket.getLength();
            System.arraycopy(this.recpacket.getData(), 0, this.inbuffer, this.inend, i);
            if (i == -1) {
                throw new IOException();
            }
            this.inend += i;
        }

        @Override
        public void close() throws IOException {
            this.socket.close();
        }

        @Override
        public int read() throws IOException {
            return 0;
        }

        @Override
        public int read(byte[] array, int begin, int length) throws IOException {
            return this.getByte(array, begin, length);
        }
    }
}

