/*
 * Decompiled with CFR 0.152.
 */
package jemu.ui;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;

public class Notepad
extends JInternalFrame {
    FileDialog dialog;
    FileDialog savedialog;
    private JMenu jMenu1;
    private JMenuBar jMenuBar1;
    private JMenuItem jMenuItem1;
    private JMenuItem jMenuItem2;
    private JScrollPane jScrollPane1;
    public JTextArea text;

    public Notepad() {
        this.initComponents();
    }

    protected void open() throws Exception {
        if (this.dialog == null) {
            this.dialog = new FileDialog((Frame)new JFrame(), "Open file", 0);
        }
        this.dialog.setVisible(true);
        String file = this.dialog.getFile();
        if (file == null) {
            return;
        }
        file = this.dialog.getDirectory() + this.dialog.getFile();
        File a = new File(file);
        String textcontent = new String(Files.readAllBytes(Paths.get(file, new String[0])));
        this.text.setText(textcontent);
    }

    protected void save() throws Exception {
        if (this.savedialog == null) {
            this.savedialog = new FileDialog((Frame)new JFrame(), "Save file", 1);
        }
        this.savedialog.setVisible(true);
        String file = this.savedialog.getFile();
        if (file == null) {
            return;
        }
        file = this.savedialog.getDirectory() + this.savedialog.getFile();
        if (!file.toLowerCase().endsWith(".txt")) {
            file = file + ".txt";
        }
        File a = new File(file);
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(a));
        bos.write(this.text.getText().getBytes("UTF-8"));
        bos.close();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.text = new JTextArea();
        this.jMenuBar1 = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.jMenuItem1 = new JMenuItem();
        this.jMenuItem2 = new JMenuItem();
        this.setTitle("JavaCPC Notepad");
        this.text.setBackground(new Color(255, 255, 254));
        this.text.setColumns(20);
        this.text.setFont(new Font("Monospaced", 1, 14));
        this.text.setForeground(new Color(0, 0, 1));
        this.text.setRows(5);
        this.jScrollPane1.setViewportView(this.text);
        this.jMenu1.setText("File");
        this.jMenuItem1.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.jMenuItem1.setIcon(new ImageIcon(this.getClass().getResource("/jemu/ui/ico/floppy.png")));
        this.jMenuItem1.setText("Open");
        this.jMenuItem1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Notepad.this.jMenuItem1ActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem1);
        this.jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.jMenuItem2.setIcon(new ImageIcon(this.getClass().getResource("/jemu/ui/ico/breakpoint.gif")));
        this.jMenuItem2.setText("Save");
        this.jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Notepad.this.jMenuItem2ActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem2);
        this.jMenuBar1.add(this.jMenu1);
        this.setJMenuBar(this.jMenuBar1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 275, Short.MAX_VALUE));
        this.pack();
    }

    private void jMenuItem1ActionPerformed(ActionEvent evt) {
        try {
            this.open();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void jMenuItem2ActionPerformed(ActionEvent evt) {
        try {
            this.save();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Notepad note = new Notepad();
                note.setDefaultCloseOperation(3);
                note.setVisible(true);
            }
        });
    }
}

