/*
 * Decompiled with CFR 0.152.
 */
package jemu.ui;

import java.security.MessageDigest;
import java.util.Map;
import java.util.TreeMap;

public class SynLicense {
    public static String generateLicense(String owner, String number, String product) throws Exception {
        String[] licenseInformation = new String[]{"Licensee=" + owner, "LicenseRegistrationNumber=" + number, "Product=" + product, "LicenseType=Non Commercial", "ExpireDate=--.--.----", "MaxVersion=2.999.999"};
        TreeMap<String, String> licenseTreeMap = new TreeMap<String, String>();
        for (String licenceEntry : licenseInformation) {
            String[] licenceEntryValues = licenceEntry.split("=");
            licenseTreeMap.put(licenceEntryValues[0], licenceEntryValues[1]);
        }
        return SynLicense.GenerateKey(licenseTreeMap);
    }

    private static String GenerateKey(TreeMap<String, String> licenseTreeMap) throws Exception {
        StringBuilder licenseInformationString = new StringBuilder();
        for (Map.Entry<String, String> licenseEntry : licenseTreeMap.entrySet()) {
            licenseInformationString.append(licenseEntry).append("\n");
        }
        MessageDigest cryptor = MessageDigest.getInstance("SHA-1");
        cryptor.reset();
        cryptor.update(licenseInformationString.toString().getBytes("UTF-8"));
        byte[] encryptedBytes = cryptor.digest();
        StringBuilder keyString = new StringBuilder(encryptedBytes.length * 2);
        for (int i = 0; i < encryptedBytes.length; ++i) {
            int j = encryptedBytes[i] & 0xFF;
            if (j < 16) {
                keyString.append('0');
            }
            keyString.append(Integer.toHexString(j));
            if (i % 4 != 3 || i >= encryptedBytes.length - 1) continue;
            keyString.append("-");
        }
        return keyString.toString().toUpperCase();
    }
}

