/*
 * Decompiled with CFR 0.152.
 */
package jemu.ui.dskFile;

import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.border.EtchedBorder;
import jemu.system.cpc.GateArray;
import jemu.ui.Switches;
import jemu.ui.dskFile.DPanel;

public class DSKPreview
extends DPanel
implements PropertyChangeListener {
    File file = null;
    public static int[] user;

    public DSKPreview(JFileChooser fc) {
        this.setPreferredSize(new Dimension(200, 100));
        this.setBorder(new EtchedBorder());
        fc.addPropertyChangeListener(this);
    }

    public void checkDSK(String filename) {
        int drive = GateArray.cpc.getDrive();
        GateArray.cpc.setDrive(3);
        boolean flopsound = Switches.FloppySound;
        Switches.FloppySound = false;
        try {
            GateArray.cpc.loadFile(1, filename);
            String[] files = GateArray.cpc.getDir();
            user = GateArray.cpc.getUser();
            for (int i = 0; i < files.length; ++i) {
                while (files[i].length() > 12) {
                    files[i] = files[i].substring(0, files[i].length() - 1);
                }
                int n = i;
                files[n] = files[n] + " | USR:" + user[i];
            }
            this.setList(files);
            this.setList2(GateArray.cpc.getDir());
        }
        catch (Exception exception) {
            // empty catch block
        }
        GateArray.cpc.setDrive(drive);
        Switches.FloppySound = flopsound;
    }

    public void loadImage() {
        block6: {
            try {
                if (this.file == null) {
                    this.setList(null);
                    return;
                }
                try {
                    if (this.file.getPath().toLowerCase().endsWith(".dsk")) {
                        this.checkDSK(this.file.getPath());
                        break block6;
                    }
                    this.setList(null);
                }
                catch (Exception e) {
                    this.setList(null);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        boolean update = false;
        String prop = e.getPropertyName();
        if ("directoryChanged".equals(prop)) {
            this.file = null;
            update = true;
        } else if ("SelectedFileChangedProperty".equals(prop)) {
            this.file = (File)e.getNewValue();
            update = true;
        }
        if (update && this.isShowing()) {
            this.loadImage();
            this.repaint();
        }
    }
}

