/*
 * Decompiled with CFR 0.152.
 */
package jemu.ui.dskutil;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jemu.core.Util;
import jemu.core.device.Device;
import jemu.core.device.filesystem.CPCFileSystem;
import jemu.settings.Settings;
import jemu.system.cpc.CPC;
import jemu.ui.dskutil.JHexEditor;

public final class DSKUtil
extends JFrame
implements KeyListener {
    CPCFileSystem filesystem = new CPCFileSystem();
    protected byte[][] diskTracks;
    protected int selectedDrive;
    protected String[] DSKImages;
    protected String selected = "Selected Format: ";
    protected int index = 9;
    public int seldrive;
    protected final String[] drive = new String[]{"a:", "b:", "c:", "d:", "e:", "f:", "g:", "h:", "i:", "j:", "k:", "l:", "m:", "n:", "o:", "p:", "q:", "r:", "s:", "t:", "u:", "v:", "w:", "x:", "y:", "z:"};
    protected final String[] track = new String[]{"", " -c40", " -c43", " -c80"};
    protected final String[] heads = new String[]{"", "-h0", "-h1"};
    int prog = 0;
    protected boolean DEBUG = false;
    private ArrayList<DropTarget> dropTargetList;
    protected String name0;
    protected String name1;
    protected String name2;
    protected String name3;
    protected String actualdsk;
    protected String[] names = new String[100];
    protected String[] sizes = new String[100];
    protected String[] users = new String[100];
    protected String[] ronly = new String[100];
    protected String[] prot = new String[100];
    protected int[] direntries = new int[100];
    protected String folder = null;
    protected byte[] dumpdisk;
    protected byte[] redumpdisk;
    protected JHexEditor edit;
    public static boolean isPresent = false;
    protected int[] DSKSizes;
    byte[] trackinfo = new byte[256];
    byte[] tracksizes;
    protected String temp0 = "empty";
    protected String temp1 = "empty";
    protected String t0 = System.getProperty("user.home") + "/javacpc/temp0.dsk";
    protected String t1 = System.getProperty("user.home") + "/javacpc/temp1.dsk";
    int drives = 0;
    String free;
    int freesize;
    Object[] items;
    Object[] sizel;
    Object[] userl;
    Object[] rdonly;
    Object[] hidden;
    String manualdisk = "empty";
    String[] sectors;
    String[] sectorsSorted;
    JPanel hexeditor = new JPanel();
    Process process;
    protected int[] selectedFiles;
    final JFileChooser fc = new JFileChooser();
    String com = "";
    JButton infclose;
    protected static final String HEX_CHARS = "0123456789ABCDEF";
    private JLabel DSKStructure;
    private JLabel DSKStructure1;
    private JCheckBox also;
    private JCheckBox ascii;
    private JCheckBox bboth;
    private JCheckBox bfdi;
    private JCheckBox bhead0;
    private JCheckBox bhead1;
    private JCheckBox brescan;
    private JButton bstart;
    private JCheckBox bstep;
    private JButton bstop;
    private ButtonGroup buttonGroup1;
    private ButtonGroup buttonGroup2;
    private ButtonGroup buttonGroup3;
    private ButtonGroup buttonGroup4;
    private JComboBox cdrive;
    private JList console;
    private JList console1;
    private JComboBox ctracks;
    public JPanel disktools;
    private JPanel dropper;
    private JLabel dsk;
    public JLabel exec;
    public JLabel filename;
    public JLabel filesize;
    public JLabel filetype;
    private JLabel flop;
    private JCheckBox gaps;
    private JPanel hex;
    private JPanel hexi;
    private JButton jButton1;
    private JButton jButton10;
    private JButton jButton11;
    private JButton jButton2;
    private JButton jButton3;
    private JButton jButton4;
    private JButton jButton5;
    private JButton jButton6;
    private JButton jButton7;
    private JButton jButton8;
    private JButton jButton9;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JMenuItem jMenuItem1;
    private JMenuItem jMenuItem2;
    private JMenuItem jMenuItem3;
    private JMenuItem jMenuItem4;
    private JPanel jPanel1;
    private JPanel jPanel10;
    private JPanel jPanel11;
    private JPanel jPanel13;
    private JPanel jPanel14;
    private JPanel jPanel15;
    private JPanel jPanel16;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JPanel jPanel9;
    private JPopupMenu jPopupMenu1;
    private JRadioButton jRadioButton1;
    private JRadioButton jRadioButton10;
    private JRadioButton jRadioButton11;
    private JRadioButton jRadioButton12;
    private JRadioButton jRadioButton13;
    private JRadioButton jRadioButton14;
    private JRadioButton jRadioButton15;
    private JRadioButton jRadioButton16;
    private JRadioButton jRadioButton17;
    private JRadioButton jRadioButton18;
    private JRadioButton jRadioButton19;
    private JRadioButton jRadioButton2;
    private JRadioButton jRadioButton20;
    private JRadioButton jRadioButton21;
    private JRadioButton jRadioButton22;
    private JRadioButton jRadioButton23;
    private JRadioButton jRadioButton3;
    private JRadioButton jRadioButton4;
    private JRadioButton jRadioButton5;
    private JRadioButton jRadioButton6;
    private JRadioButton jRadioButton7;
    private JRadioButton jRadioButton8;
    private JRadioButton jRadioButton9;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JScrollPane jScrollPane5;
    private JScrollPane jScrollPane6;
    private JScrollPane jScrollPane7;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;
    private JSeparator jSeparator5;
    private JTabbedPane jTabbedPane1;
    private JToggleButton jToggleButton1;
    private JToggleButton jToggleButton2;
    private JToggleButton jToggleButton3;
    private JToggleButton jToggleButton4;
    private JButton load;
    private JTextArea output;
    private JTextArea output1;
    private JProgressBar progress;
    private JList protec;
    public JLabel realname;
    private JTextField renamefield;
    private JComboBox<String> sectorBox;
    private JButton seldsk;
    private JLabel selform;
    private JLabel sideb;
    private JList sizelist;
    private JLabel space;
    public JLabel start;
    private JList system;
    private JTextArea text;
    private JComboBox<String> trackBox;
    private JCheckBox txtinfo;
    private JComboBox user;
    private JComboBox user1;
    private JList userlist;

    public DSKUtil() {
        this.DSKImages = new String[]{"parados80.dsk", "parados41.dsk", "parados40D.dsk", "romdosD1.dsk", "romdosD2.dsk", "romdosD10.dsk", "romdosD20.dsk", "romdosD40.dsk", "s-dos(romdosD80).dsk", "dataSS40.dsk", "dataDS40.dsk", "dataSS80.dsk", "dataDS80.dsk", "systemSS40.dsk", "systemDS40.dsk", "systemSS80.dsk", "systemDS80.dsk", "ibmSS40.dsk", "ibmDS40.dsk", "ibmSS80.dsk", "ibmDS80.dsk", "ultraform.dsk", "vortex704k.dsk"};
        this.DSKSizes = new int[]{430336, 220672, 430336, 778496, 778496, 860416, 860416, 860416, 860416, 194816, 389376, 389376, 778496, 194816, 389376, 389376, 778496, 174336, 348416, 348416, 696576, 220672, 778496};
        this.initComponents();
        this.txtinfo.setVisible(false);
        this.output.setText("DiskUtil 1.3 (November 17 2021), by Markus Hohmann -- http://cpc-live.com/\r\n");
        this.dsk.setVisible(this.DEBUG);
        this.text.setText("DiskUtil 1.3 (November 17 2021), by Markus Hohmann -- http://cpc-live.com/\r\n");
        this.text.append("SAMdisk 3.4 (Aug 14 2012), (c) 2012 Simon Owen -- http://simonowen.com/samdisk/\r\n");
        this.text.select(2000000, 2000000);
        this.dumpdisk = new byte[1];
        this.edit = new JHexEditor(new byte[1]);
        this.hexi.add((Component)this.edit, "Center");
        this.setNames();
        if (!this.name0.equals("empty") && this.name0.length() > 3) {
            this.jToggleButton2.setSelected(true);
            this.selectedDrive = 0;
            this.drives = 0;
            this.DIR(0);
        } else if (!this.name1.equals("empty") && this.name1.length() > 3) {
            this.jToggleButton1.setSelected(true);
            this.drives = 1;
            this.selectedDrive = 1;
            this.DIR(1);
        }
        this.console.addKeyListener(this);
        this.userlist.addKeyListener(this);
        this.sizelist.addKeyListener(this);
        this.system.addKeyListener(this);
        this.protec.addKeyListener(this);
        this.output.addKeyListener(this);
        this.addKeyListener(this);
        this.folder = Settings.get("dsktool_path", "");
        this.dropTargetList = new ArrayList();
        DropListener myListener = new DropListener();
        DSKUtil.registerDropListener(this.dropTargetList, this.console, myListener);
        DSKUtil.registerDropListener(this.dropTargetList, this.userlist, myListener);
        DSKUtil.registerDropListener(this.dropTargetList, this.sizelist, myListener);
        DSKUtil.registerDropListener(this.dropTargetList, this.output, myListener);
        DSKUtil.registerDropListener(this.dropTargetList, this.system, myListener);
        DSKUtil.registerDropListener(this.dropTargetList, this.protec, myListener);
        DSKUtil.registerDropListener(this.dropTargetList, this, myListener);
        isPresent = true;
    }

    public void formatDisk(int format) {
        String discimage = this.DSKImages[format];
        int discsize = this.DSKSizes[format];
        byte[] bufferdsk = this.copyResource("file/" + discimage, discsize);
        System.out.println("Formatting image in drive DF" + this.drives);
        System.out.println(this.actualdsk);
        if (this.actualdsk != null && this.actualdsk.length() > 0 && !this.actualdsk.equals("empty")) {
            String writeAs = this.actualdsk;
            int ok = JOptionPane.showConfirmDialog(new Frame(), "Are you sure to format your DSK\n\"" + writeAs + "\"?\nAll data will be erased!", "Confirm format", 0);
            if (ok == 0) {
                try {
                    BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(writeAs));
                    bos.write(bufferdsk);
                    bos.close();
                    Settings.set("file.drive" + Integer.toString(this.drives), writeAs);
                    this.DIR(this.drives);
                    if (this.also.isSelected() && this.also.isVisible()) {
                        this.jTabbedPane1.setSelectedIndex(2);
                        this.jToggleButton4.setSelected(true);
                        if (this.process == null) {
                            Thread runner = new Thread(){

                                @Override
                                public void run() {
                                    try {
                                        DSKUtil.this.Launch(DSKUtil.this.jToggleButton3.isSelected());
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                }
                            };
                            runner.start();
                        }
                    }
                }
                catch (Exception bos) {}
            }
        } else {
            try {
                FileDialog filedia = new FileDialog(new Frame(), "Create DSK file", 1);
                filedia.setFile("*.dsk");
                filedia.setVisible(true);
                String filename = filedia.getFile();
                if (filename != null) {
                    if (!filename.toLowerCase().endsWith(".dsk")) {
                        filename = filename + ".dsk";
                    }
                    BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(filename));
                    bos.write(bufferdsk);
                    bos.close();
                    Settings.set("file.drive" + Integer.toString(this.drives), filename);
                    this.DIR(this.drives);
                    if (this.also.isSelected() && this.also.isVisible()) {
                        this.jTabbedPane1.setSelectedIndex(2);
                        this.jToggleButton4.setSelected(true);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void getStructure() {
        block22: {
            this.sideb.setVisible(false);
            this.DSKStructure1.setVisible(false);
            int blockwidth = 310;
            BufferedImage struct = new BufferedImage(blockwidth, 420, 1);
            BufferedImage struct2 = new BufferedImage(blockwidth, 420, 1);
            Graphics s1 = struct.getGraphics();
            Graphics s2 = struct2.getGraphics();
            s1.setColor(Color.white);
            s1.fillRect(0, 0, blockwidth, 420);
            s2.setColor(Color.white);
            s2.fillRect(0, 0, blockwidth, 420);
            String disk = Settings.get("file.drive" + Integer.toString(this.drives), "empty");
            if (disk == null || disk.equals("empty")) {
                s1.setColor(Color.black);
                s1.drawString("No Disc!", 100, 160);
                s1.drawString("No Disc!", 101, 160);
                this.DSKStructure.setIcon(new ImageIcon(struct));
                this.DSKStructure1.setIcon(new ImageIcon(struct2));
                return;
            }
            try {
                int g;
                int k;
                int yd;
                int xd;
                int diff;
                int pixel;
                int fillerbyte;
                byte[] track;
                int tracksize2;
                int i;
                File a = new File(disk);
                byte[] data = new byte[(int)a.length()];
                FileInputStream bin = new FileInputStream(a);
                bin.read(data);
                bin.close();
                int tracks = data[48] & 0xFF;
                int sides = data[49] & 0xFF;
                String[] trackbox = new String[tracks * sides];
                for (int i2 = 0; i2 < trackbox.length; ++i2) {
                    trackbox[i2] = "" + i2;
                    while (trackbox[i2].length() < 3) {
                        trackbox[i2] = " " + trackbox[i2];
                    }
                }
                this.trackBox.setModel(new DefaultComboBoxModel<String>(trackbox));
                this.tracksizes = new byte[tracks * sides];
                int x = 5;
                int y = 4;
                int blocksize = 36;
                Graphics gr = struct.getGraphics();
                System.arraycopy(data, 52, this.tracksizes, 0, this.tracksizes.length);
                int startoff = 256;
                int trackno = 1;
                this.diskTracks = new byte[tracks * sides][];
                for (i = 0; i < this.tracksizes.length / sides; ++i) {
                    try {
                        block21: {
                            System.arraycopy(data, startoff, this.trackinfo, 0, 256);
                            tracksize2 = (this.trackinfo[20] & 0xFF) * (this.trackinfo[21] & 0xFF) * 256;
                            startoff += 256;
                            try {
                                track = new byte[tracksize2];
                                this.diskTracks[i] = new byte[tracksize2];
                                System.arraycopy(data, startoff, track, 0, track.length);
                                System.arraycopy(data, startoff, this.diskTracks[i], 0, this.diskTracks[i].length);
                                startoff += tracksize2;
                                fillerbyte = this.trackinfo[23] & 0xFF;
                                pixel = tracksize2 / ((blocksize - 4) * (blocksize - 4));
                                diff = 0;
                                xd = 0;
                                yd = 0;
                                k = 0;
                                for (g = 0; g < track.length; ++g) {
                                    diff += track[g] & 0xFF;
                                    if (++k < pixel) continue;
                                    if ((diff /= pixel) == fillerbyte) {
                                        gr.setColor(Color.gray);
                                    } else {
                                        gr.setColor(Color.blue);
                                    }
                                    gr.fillRect(x + xd++, y + yd, 1, 1);
                                    if (xd >= blocksize - 4) {
                                        xd = 0;
                                        ++yd;
                                    }
                                    diff = 0;
                                    k = 0;
                                }
                                gr.setColor(Color.WHITE);
                                gr.drawString("" + trackno++, x + 2, y + 13);
                                if ((x += blocksize) + blocksize <= blockwidth) break block21;
                                x = 5;
                                y += blocksize + 5;
                            }
                            catch (Exception ex) {
                                break;
                            }
                        }
                        this.DSKStructure.setIcon(new ImageIcon(struct));
                        continue;
                    }
                    catch (Exception tracksize2) {
                        // empty catch block
                    }
                }
                if (sides <= 1) break block22;
                x = 5;
                y = 4;
                gr = struct2.getGraphics();
                trackno = 1;
                for (i = this.tracksizes.length / sides; i < this.tracksizes.length; ++i) {
                    block23: {
                        System.arraycopy(data, startoff, this.trackinfo, 0, 256);
                        tracksize2 = (this.trackinfo[20] & 0xFF) * (this.trackinfo[21] & 0xFF) * 256;
                        startoff += 256;
                        try {
                            track = new byte[tracksize2];
                            this.diskTracks[i] = new byte[tracksize2];
                            System.arraycopy(data, startoff, track, 0, track.length);
                            System.arraycopy(data, startoff, this.diskTracks[i], 0, this.diskTracks[i].length);
                            System.arraycopy(data, startoff, track, 0, track.length);
                            startoff += tracksize2;
                            fillerbyte = this.trackinfo[23] & 0xFF;
                            pixel = tracksize2 / ((blocksize - 4) * (blocksize - 4));
                            diff = 0;
                            xd = 0;
                            yd = 0;
                            diff = 0;
                            k = 0;
                            for (g = 0; g < track.length; ++g) {
                                diff += track[g] & 0xFF;
                                if (++k < pixel) continue;
                                if ((diff /= pixel) == fillerbyte) {
                                    gr.setColor(Color.gray);
                                } else {
                                    gr.setColor(Color.blue);
                                }
                                gr.fillRect(x + xd++, y + yd, 1, 1);
                                if (xd >= blocksize - 4) {
                                    xd = 0;
                                    ++yd;
                                }
                                diff = 0;
                                k = 0;
                            }
                            gr.setColor(Color.WHITE);
                            gr.drawString("" + trackno++, x + 2, y + 13);
                            if ((x += blocksize) + blocksize <= blockwidth) break block23;
                            x = 5;
                            y += blocksize + 5;
                        }
                        catch (Exception ex) {
                            break;
                        }
                    }
                    this.sideb.setVisible(true);
                    this.DSKStructure1.setVisible(true);
                    this.DSKStructure1.setIcon(new ImageIcon(struct2));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 127) {
            this.Delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] copyResource(String name, int size) {
        byte[] buffer = new byte[size];
        int offs = 0;
        try (InputStream stream = null;){
            InputStream is;
            stream = is = this.getClass().getResourceAsStream(name);
            while (size > 0) {
                int read = stream.read(buffer, offs, size);
                if (read == -1) {
                    break;
                }
                offs += read;
                size -= read;
            }
        }
        catch (Exception e) {
            System.err.println("File not found...");
        }
        return buffer;
    }

    public void Launch(boolean direction) throws InterruptedException, IOException {
        String line;
        String file = this.actualdsk;
        if (file == null || file.length() < 1 || file.equals("empty")) {
            return;
        }
        this.text.setText("DiskUtil 1.3 (November 17 2021), by Markus Hohmann -- http://cpc-live.com/\r\n");
        this.text.append("SAMdisk 3.4 (Aug 14 2012), (c) 2012 Simon Owen -- http://simonowen.com/samdisk/\r\n");
        String ending = "";
        if (this.bfdi.isSelected() || this.bhead0.isSelected()) {
            ending = "-h0";
        }
        if (this.bhead1.isSelected()) {
            ending = "-h1";
        }
        String drv = this.drive[this.cdrive.getSelectedIndex()];
        String command = "";
        if (this.gaps.isSelected()) {
            ending = ending + " --gaps";
        }
        command = direction ? drv + " \"" + file + "\" " + ending : "\"" + file + "\" " + drv + " " + ending;
        command = command + this.track[this.ctracks.getSelectedIndex()];
        if (this.bstep.isSelected()) {
            command = command + " -d";
        }
        if (this.brescan.isSelected()) {
            command = command + " -R";
        }
        this.process = Runtime.getRuntime().exec(System.getProperty("user.home") + "/JavaCPC/tools/SamDisk.exe " + command);
        this.text.append("SamDisk.exe " + command + "\r\n");
        this.text.select(20000000, 20000000);
        InputStream is = this.process.getInputStream();
        InputStreamReader isr = new InputStreamReader(is);
        BufferedReader br = new BufferedReader(isr);
        this.bstart.setEnabled(false);
        this.bstop.setEnabled(true);
        this.progress.setIndeterminate(true);
        this.jTabbedPane1.setEnabled(false);
        this.jToggleButton1.setEnabled(false);
        this.jToggleButton2.setEnabled(false);
        this.load.setEnabled(false);
        this.jButton1.setEnabled(false);
        this.seldsk.setEnabled(false);
        while ((line = br.readLine()) != null) {
            this.text.append(line + "\r\n");
            this.text.select(20000000, 20000000);
        }
        br.close();
        this.text.append("Done...\r\n");
        this.jTabbedPane1.setSelectedIndex(0);
        this.text.select(20000000, 20000000);
        this.progress.setIndeterminate(false);
        this.bstart.setEnabled(true);
        this.bstop.setEnabled(false);
        this.jTabbedPane1.setEnabled(true);
        this.jToggleButton1.setEnabled(true);
        this.jToggleButton2.setEnabled(true);
        this.load.setEnabled(true);
        this.jButton1.setEnabled(true);
        this.seldsk.setEnabled(true);
        this.prog = 0;
        this.process = null;
        this.DIR(this.drives);
    }

    protected String BufferDisk() {
        if (this.drives == 0) {
            this.temp0 = Settings.get("file.drive" + Integer.toString(0), "empty");
            if (this.temp0.contains(" ")) {
                try {
                    BufferedInputStream stream = new BufferedInputStream(new FileInputStream(this.temp0));
                    byte[] t = new byte[stream.available()];
                    stream.read(t);
                    stream.close();
                    BufferedOutputStream streamo = new BufferedOutputStream(new FileOutputStream(new File(this.t0)));
                    streamo.write(t);
                    streamo.close();
                }
                catch (IOException re) {
                    re.printStackTrace();
                }
                return this.t0;
            }
            return this.temp0;
        }
        if (this.drives == 1) {
            this.temp1 = Settings.get("file.drive" + Integer.toString(1), "empty");
            if (this.temp1.contains(" ")) {
                try {
                    BufferedInputStream stream = new BufferedInputStream(new FileInputStream(this.temp1));
                    byte[] t = new byte[stream.available()];
                    stream.read(t);
                    stream.close();
                    BufferedOutputStream streamo = new BufferedOutputStream(new FileOutputStream(new File(this.t1)));
                    streamo.write(t);
                }
                catch (IOException re) {
                    re.printStackTrace();
                }
                return this.t1;
            }
            return this.temp1;
        }
        return "empty";
    }

    protected String eraseTemp() {
        if (this.drives == 0) {
            File file = new File(this.t0);
            try {
                BufferedInputStream stream = new BufferedInputStream(new FileInputStream(file));
                byte[] t = new byte[stream.available()];
                stream.read(t);
                stream.close();
                BufferedOutputStream streamo = new BufferedOutputStream(new FileOutputStream(new File(this.temp0)));
                streamo.write(t);
                streamo.close();
                file.delete();
            }
            catch (Exception stream) {
                // empty catch block
            }
            return this.temp0;
        }
        if (this.drives == 1) {
            File file = new File(this.t1);
            try {
                BufferedInputStream stream = new BufferedInputStream(new FileInputStream(file));
                byte[] t = new byte[stream.available()];
                stream.read(t);
                stream.close();
                BufferedOutputStream streamo = new BufferedOutputStream(new FileOutputStream(new File(this.temp1)));
                streamo.write(t);
                streamo.close();
                file.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this.temp1;
        }
        return "empty";
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    private static void registerDropListener(ArrayList<DropTarget> list, Container basePanel, DropListener myListener) {
        list.add(new DropTarget(basePanel, myListener));
        Component[] components = basePanel.getComponents();
        for (int i = 0; i < components.length; ++i) {
            Component component = components[i];
            if (component instanceof Container) {
                DSKUtil.registerDropListener(list, (Container)component, myListener);
                continue;
            }
            list.add(new DropTarget(component, myListener));
        }
    }

    public void loadDSK(String name) {
        Settings.set("file.drive" + Integer.toString(this.drives), name);
        this.DIR(this.drives);
    }

    public void eject(int drive) {
        Settings.set("file.drive" + Integer.toString(drive), "empty");
        this.DIR(drive);
    }

    public void setNames() {
        this.name0 = Settings.get("file.drive" + Integer.toString(0), "empty");
        this.name1 = Settings.get("file.drive" + Integer.toString(1), "empty");
    }

    public void clear() {
        this.items = new Object[1];
        this.sizel = new Object[1];
        this.userl = new Object[1];
        this.rdonly = new Object[1];
        this.hidden = new Object[1];
        this.console.setListData(this.items);
        this.sizelist.setListData(this.sizel);
        this.userlist.setListData(this.userl);
        this.protec.setListData(this.rdonly);
        this.system.setListData(this.hidden);
    }

    public void DIR(int drive) {
        if (this.edit != null) {
            this.edit.changed = false;
        }
        if (drive != this.selectedDrive) {
            this.clear();
            this.getStructure();
            return;
        }
        this.output.setText("DiskUtil 1.3 (November 17 2021), by Markus Hohmann -- http://cpc-live.com/\r\n\r\n");
        this.drives = drive;
        String disk = Settings.get("file.drive" + Integer.toString(this.drives), "empty");
        if (disk == null || disk.equals("empty") || disk.length() < 3) {
            this.space.setText("Drive is empty");
            this.getStructure();
            this.clear();
            return;
        }
        this.filesystem.loadDisk(disk);
        this.sectors = new String[this.filesystem.getSectorIDs().length];
        this.sectorsSorted = new String[this.filesystem.getSectorIDs().length];
        for (int i = 0; i < this.sectors.length; ++i) {
            this.sectors[i] = jemu.ui.wavtocpc.Util.hex((byte)this.filesystem.getSectorIDs()[i]);
            this.sectorsSorted[i] = jemu.ui.wavtocpc.Util.hex((byte)this.filesystem.getSectorIDs()[i]);
        }
        Arrays.sort(this.sectorsSorted);
        this.sectorBox.setModel(new DefaultComboBoxModel<String>(this.sectorsSorted));
        this.output.append("DIR:\r\n");
        this.drives = drive;
        this.actualdsk = Settings.get("file.drive" + Integer.toString(this.drives), "empty");
        if (this.actualdsk.equals("empty") || this.actualdsk.length() < 3) {
            this.output.append("DIR: No Disk!\r\n");
            this.space.setText("Drive is empty");
            this.output.select(200000, 200000);
            this.getStructure();
            this.clear();
            return;
        }
        String path = this.actualdsk;
        this.space.setText("Drive is empty or unknown format");
        this.actualdsk = this.BufferDisk();
        try {
            File dump = new File(this.actualdsk);
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(dump));
            this.dumpdisk = new byte[bis.available()];
            bis.read(this.dumpdisk);
            bis.close();
            this.redumpdisk = new byte[this.dumpdisk.length];
            for (int i = 0; i < this.redumpdisk.length; ++i) {
                this.redumpdisk[i] = this.dumpdisk[i];
            }
        }
        catch (Exception dump) {
            // empty catch block
        }
        String h = Settings.get("file.drive" + Integer.toString(this.drives), "empty");
        System.out.println("Reading " + this.actualdsk);
        try {
            int i;
            int i2;
            String dir = this.filesystem.DIRECTORY();
            this.output.append(dir);
            String[] entries = dir.split("\n");
            this.names = new String[400];
            this.sizes = new String[400];
            this.users = new String[400];
            this.ronly = new String[400];
            this.prot = new String[400];
            this.direntries = new int[400];
            int pos = 0;
            this.free = "";
            int begin = 0;
            for (i2 = 0; i2 < entries.length; ++i2) {
                if (entries[i2].startsWith("-")) {
                    begin = i2 + 1;
                }
                if (!entries[i2].startsWith("(") || !entries[i2].contains("Bytes free")) continue;
                String r = entries[i2];
                entries[i2] = entries[i2].substring(1);
                while (!entries[i2].startsWith(" ")) {
                    this.free = this.free + entries[i2].charAt(0);
                    entries[i2] = entries[i2].substring(1);
                }
                String inf = path;
                while (inf.contains("\\")) {
                    inf = inf.substring(1);
                }
                while (inf.contains("/")) {
                    inf = inf.substring(1);
                }
                this.freesize = Integer.parseInt(this.free);
                this.space.setText(this.free + " bytes (" + (int)Math.ceil((double)this.freesize / 1024.0) + "KB) in " + inf);
                entries[i2] = r;
                break;
            }
            for (i2 = begin; i2 < entries.length; ++i2) {
                int p;
                if (!entries[i2].startsWith(" ")) continue;
                entries[i2] = entries[i2].substring(1);
                this.users[pos] = "Usr ";
                String use = "";
                while (!entries[i2].startsWith(" ")) {
                    use = use + entries[i2].charAt(0);
                    entries[i2] = entries[i2].substring(1);
                }
                use = "" + jemu.ui.wavtocpc.Util.hexValue(use);
                if (use.length() < 2) {
                    use = " " + use;
                }
                int n = pos;
                this.users[n] = this.users[n] + use;
                entries[i2] = entries[i2].substring(1);
                String syscheck = entries[i2];
                if (syscheck.length() > 50) {
                    syscheck = syscheck.substring(0, syscheck.length() / 2);
                }
                this.ronly[pos] = syscheck.contains("R/O") ? "R/O" : " ";
                this.prot[pos] = syscheck.contains(" + ") ? "SYS" : " ";
                String entr = "";
                String entri = "";
                try {
                    entr = entries[i2].substring(29);
                    entri = "";
                    for (int j = 0; j < 6; ++j) {
                        entri = entri + entr.charAt(j);
                    }
                    entri = entri.replace(" ", "");
                    entri = entri.replace("+", "");
                    this.direntries[pos] = Integer.parseInt(entri);
                }
                catch (Exception j) {
                    // empty catch block
                }
                this.names[pos] = "";
                this.sizes[pos] = "";
                for (p = 0; p < 12; ++p) {
                    int n2 = pos;
                    this.names[n2] = this.names[n2] + "" + entries[i2].charAt(p);
                }
                entries[i2] = entries[i2].substring(13);
                for (p = 0; p < 7; ++p) {
                    if (entries[i2].charAt(p) == ' ') continue;
                    int n3 = pos;
                    this.sizes[n3] = this.sizes[n3] + "" + entries[i2].charAt(p);
                }
                this.names[++pos] = "";
                this.sizes[pos] = "";
                try {
                    entries[i2] = entries[i2].substring(25);
                    System.out.println(entries[i2]);
                    this.users[pos] = "Usr ";
                    use = "";
                    while (!entries[i2].startsWith(" ")) {
                        use = use + entries[i2].charAt(0);
                        entries[i2] = entries[i2].substring(1);
                    }
                    use = "" + jemu.ui.wavtocpc.Util.hexValue(use);
                    if (use.length() < 2) {
                        use = " " + use;
                    }
                    int n4 = pos;
                    this.users[n4] = this.users[n4] + use;
                    entries[i2] = entries[i2].substring(1);
                    this.ronly[pos] = entries[i2].contains("R/O") ? "R/O" : " ";
                    this.prot[pos] = entries[i2].contains(" + ") ? "SYS" : " ";
                    for (p = 0; p < 12; ++p) {
                        int n5 = pos;
                        this.names[n5] = this.names[n5] + "" + entries[i2].charAt(p);
                    }
                    try {
                        entri = entries[i2].substring(26);
                        entri = entri.replace(" ", "");
                        entri = entri.replace("+", "");
                        this.direntries[pos] = Integer.parseInt(entri);
                    }
                    catch (Exception p2) {
                        // empty catch block
                    }
                    entries[i2] = entries[i2].substring(13);
                    for (int p3 = 0; p3 < 7; ++p3) {
                        if (entries[i2].charAt(p3) == ' ') continue;
                        int n6 = pos;
                        this.sizes[n6] = this.sizes[n6] + "" + entries[i2].charAt(p3);
                    }
                    ++pos;
                    continue;
                }
                catch (Exception p3) {
                    // empty catch block
                }
            }
            int length = 0;
            for (i = 0; i < this.names.length; ++i) {
                if (this.names[i] == null) continue;
                this.names[i] = this.names[i].replace(".", "~");
                String[] rebuild = this.names[i].split("~");
                if (rebuild.length > 1) {
                    String a = rebuild[0];
                    String b = rebuild[1];
                    while (a.length() < 8) {
                        a = a + " ";
                    }
                    this.names[i] = a + "." + b;
                }
                this.names[i] = this.names[i].replace("~", ".");
                if (this.names[i].length() <= 1) continue;
                ++length;
            }
            this.items = new Object[length];
            this.sizel = new Object[length];
            this.userl = new Object[length];
            this.rdonly = new Object[length];
            this.hidden = new Object[length];
            for (i = 0; i < length; ++i) {
                if (this.names[i] == null) continue;
                this.items[i] = this.names[i];
                int siz = (int)Math.ceil((double)Integer.parseInt(this.sizes[i]) / 1024.0);
                this.sizes[i] = siz + "K";
                while (this.sizes[i].length() < 6) {
                    this.sizes[i] = " " + this.sizes[i];
                }
                this.sizel[i] = this.sizes[i];
                this.userl[i] = this.users[i];
                this.rdonly[i] = this.ronly[i];
                this.hidden[i] = this.prot[i];
            }
            if (this.txtinfo.isSelected()) {
                try {
                    int i3;
                    String txtfile;
                    String diskname = txtfile = Settings.get("file.drive" + Integer.toString(this.drives), "empty");
                    while (diskname.contains("/") || diskname.contains("\\")) {
                        diskname = diskname.substring(1);
                    }
                    String inf = "Directory of " + diskname + ":";
                    int len = inf.length();
                    txtfile = txtfile + ".txt";
                    File txt = new File(txtfile);
                    BufferedOutputStream outt = new BufferedOutputStream(new FileOutputStream(txt));
                    outt.write(inf.getBytes("UTF-8"));
                    outt.write(new byte[]{13, 10});
                    outt.write(new byte[]{13, 10});
                    outt.write("-------------------------------------------".getBytes("UTF-8"));
                    outt.write(new byte[]{13, 10});
                    Object[] dirr = new String[length];
                    for (i3 = 0; i3 < length; ++i3) {
                        String name = this.names[i3];
                        while (name.endsWith(" ")) {
                            name = name.substring(0, name.length() - 1);
                        }
                        while (name.length() < 12) {
                            name = name + " ";
                        }
                        String size = this.sizes[i3].replace(" ", "");
                        while (size.length() < 8) {
                            size = " " + size;
                        }
                        String rdonly = this.ronly[i3];
                        String hidden = this.prot[i3];
                        if (rdonly.length() < 3) {
                            rdonly = "   ";
                        }
                        if (hidden.length() < 3) {
                            hidden = "   ";
                        }
                        String out = name + " -" + size + " - " + rdonly + "|" + hidden + " - " + this.users[i3].replace("Usr", "User:");
                        dirr[i3] = out + "\r\n";
                    }
                    Arrays.sort(dirr);
                    for (i3 = 0; i3 < length; ++i3) {
                        outt.write(((String)dirr[i3]).getBytes("UTF-8"));
                    }
                    outt.write(new byte[]{13, 10});
                    outt.write("-------------------------------------------".getBytes("UTF-8"));
                    outt.write(new byte[]{13, 10});
                    outt.write(new byte[]{13, 10});
                    String frees = (int)Math.ceil((double)this.freesize / 1024.0) + "K free";
                    outt.write(frees.getBytes("UTF-8"));
                    outt.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            this.console.setListData(this.items);
            this.sizelist.setListData(this.sizel);
            this.userlist.setListData(this.userl);
            this.protec.setListData(this.rdonly);
            this.system.setListData(this.hidden);
        }
        catch (Exception e) {
            if (this.actualdsk.contains(System.getProperty("user.home") + "/javacpc/temp")) {
                this.actualdsk = this.eraseTemp();
            }
            this.output.append(this.actualdsk + ": Disk not directoryable / readable\r\n");
            this.clear();
            this.output.select(200000, 200000);
        }
        if (this.actualdsk.contains(System.getProperty("user.home") + "/javacpc/temp")) {
            this.actualdsk = this.eraseTemp();
        }
        this.output.append("DSK EyeCatcher:" + this.getEyeCatcher() + "\r\n");
        this.output.select(200000, 200000);
        if (drive == 0) {
            CPC.up0 = true;
        }
        if (drive == 1) {
            CPC.up1 = true;
        }
        this.getStructure();
        if (!h.startsWith("empty")) {
            this.edit.buff = new byte[this.dumpdisk.length];
            System.arraycopy(this.dumpdisk, 0, this.edit.buff, 0, this.edit.buff.length);
            this.edit.setIndex(32);
            this.edit.update(this.edit.getGraphics());
        }
    }

    protected void writeEyeCatcher() {
        try {
            String eyecatcher = "JAVACPC EXTDSK";
            int pos = 34;
            byte[] catcher = eyecatcher.getBytes("UTF-8");
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(new File(this.actualdsk)));
            byte[] go = new byte[bis.available()];
            bis.read(go);
            bis.close();
            for (int i = 0; i < catcher.length; ++i) {
                go[i + pos] = catcher[i];
            }
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(new File(this.actualdsk)));
            bos.write(go);
            bos.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected String getEyeCatcher() {
        String eyecatcher = "";
        try {
            int pos = 34;
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(new File(this.actualdsk)));
            byte[] go = new byte[bis.available()];
            bis.read(go);
            bis.close();
            for (int i = 0; i < 14; ++i) {
                eyecatcher = eyecatcher + (char)go[i + pos];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return eyecatcher;
    }

    protected void checkDump() {
        if (this.redumpdisk == null) {
            return;
        }
        for (int i = 0; i < this.redumpdisk.length; ++i) {
            if (this.redumpdisk[i] == this.dumpdisk[i]) continue;
            this.overWriteDSK();
            break;
        }
    }

    protected void overWriteDSK() {
        int n = JOptionPane.showConfirmDialog(this, "Your DSK has been changed. Do you want to save it?", "Confirm change", 0, 2);
        if (n != 0) {
            this.DIR(this.drives);
            return;
        }
        try {
            this.actualdsk = this.BufferDisk();
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(new File(this.actualdsk)));
            bos.write(this.dumpdisk);
            bos.close();
            this.writeEyeCatcher();
            if (this.actualdsk.contains(System.getProperty("user.home") + "/javacpc/temp")) {
                this.actualdsk = this.eraseTemp();
            }
            this.DIR(this.drives);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setFolder() {
        this.fc.setCurrentDirectory(new File(Settings.get("dsktool_path", "")));
        this.fc.setFileHidingEnabled(true);
        this.fc.setFileSelectionMode(1);
        this.fc.setDialogType(0);
        int returnVal = this.fc.showSaveDialog(this);
        if (returnVal == 0) {
            File file = this.fc.getSelectedFile();
            Settings.set("dsktool_path", file.getPath() + "\\");
            this.folder = file.getPath();
        } else {
            this.folder = null;
        }
    }

    public void loadDSK() {
        this.fc.setCurrentDirectory(new File(Settings.get("dsktool_path", "")));
        this.fc.setFileHidingEnabled(false);
        this.fc.setFileSelectionMode(2);
        this.fc.setDialogType(0);
        int returnVal = this.fc.showSaveDialog(this);
        if (returnVal == 0) {
            File file = this.fc.getSelectedFile();
            this.loadDSK(file.getPath());
            Settings.set("dsktool_path", file.getPath() + "\\");
            this.DIR(this.drives);
        }
    }

    public void chooseDsk() {
        File file;
        this.fc.setSelectedFile(new File(Settings.get("dsktool_path", "")));
        this.fc.setDialogType(0);
        this.manualdisk = "empty";
        this.fc.setFileSelectionMode(2);
        int returnVal = this.fc.showSaveDialog(this);
        this.manualdisk = returnVal == 0 ? ((file = this.fc.getSelectedFile()) != null ? file.getAbsolutePath() : "empty") : "empty";
        if (!this.manualdisk.equals("empty")) {
            this.DIR(2);
        }
    }

    public void getFromDSK() {
        if (this.selectedFiles == null || this.folder == null) {
            return;
        }
        String fold = this.folder;
        String disk = Settings.get("file.drive" + Integer.toString(this.drives), "empty");
        if (disk == null) {
            return;
        }
        this.filesystem.loadDisk(disk);
        this.com = "";
        for (int i = 0; i < this.selectedFiles.length; ++i) {
            this.folder = this.actualdsk;
            while (!this.folder.endsWith("\\")) {
                this.folder = this.folder.substring(0, this.folder.length() - 1);
            }
            fold = this.folder;
            this.actualdsk = this.BufferDisk();
            try {
                String get = this.items[this.selectedFiles[i]].toString();
                get = get.replace(" ", "");
                String temp = this.folder = this.folder + "\\" + get;
                boolean erasetemp = false;
                if (this.folder.contains(" ")) {
                    this.folder = System.getProperty("user.home") + "/javacpc/" + get;
                    erasetemp = true;
                }
                this.folder = this.folder.replace("\\\\", "\\");
                get = this.items[this.selectedFiles[i]].toString();
                String prot = this.rdonly[this.selectedFiles[i]].toString();
                String hidd = this.hidden[this.selectedFiles[i]].toString();
                boolean isprotected = prot.length() > 2;
                boolean ishidden = hidd.length() > 2;
                String diskFile = this.getRealName(get, isprotected, ishidden);
                byte[] data = this.filesystem.readFile(disk, diskFile);
                if (!this.CheckAMSDOS(data)) {
                    int posremove = 0;
                    for (int t = 0; t < data.length; ++t) {
                        int check1 = data[t] & 0xFF;
                        if (check1 != 26) continue;
                        posremove = t;
                        break;
                    }
                    if (posremove > 0) {
                        byte[] bufferdata = new byte[posremove];
                        System.arraycopy(data, 0, bufferdata, 0, bufferdata.length);
                        data = new byte[bufferdata.length];
                        System.arraycopy(bufferdata, 0, data, 0, data.length);
                    }
                }
                File d = new File(this.folder);
                BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(d));
                bos.write(data);
                bos.close();
                if (erasetemp) {
                    File te = new File(System.getProperty("user.home") + "/javacpc/" + get);
                    BufferedInputStream in = new BufferedInputStream(new FileInputStream(te));
                    byte[] g = new byte[in.available()];
                    in.read(g);
                    in.close();
                    te.delete();
                    BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(new File(temp)));
                    out.write(g);
                    out.close();
                }
                this.folder = fold;
                this.DIR(this.drives);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!this.actualdsk.contains(System.getProperty("user.home") + "/javacpc/temp")) continue;
            this.actualdsk = this.eraseTemp();
        }
        this.folder = fold;
    }

    public void rename(String torename) {
        if (this.selectedFiles == null || this.folder == null) {
            return;
        }
        if (torename.length() < 1) {
            return;
        }
        torename = this.filesystem.getAmsdosString(torename);
        System.out.println(torename);
        this.actualdsk = this.BufferDisk();
        for (int i = 0; i < this.selectedFiles.length; ++i) {
            try {
                String get = this.items[this.selectedFiles[i]].toString();
                String use = this.users[this.selectedFiles[i]];
                String prt = this.ronly[this.selectedFiles[i]];
                String sys = this.prot[this.selectedFiles[i]];
                int entrienumber = this.direntries[this.selectedFiles[i]];
                use = use.substring(4);
                File in = new File(this.actualdsk);
                BufferedInputStream bis = new BufferedInputStream(new FileInputStream(in));
                byte[] tempdisk = new byte[bis.available()];
                bis.read(tempdisk);
                bis.close();
                get = get.replace(".", "");
                torename = torename.replace(".", "");
                byte[] check = get.getBytes("UTF-8");
                byte[] replace = get.getBytes("UTF-8");
                if (prt.contains("R/O")) {
                    check[8] = (byte)(check[8] | 0x80);
                }
                if (sys.contains("SYS")) {
                    check[9] = (byte)(check[9] | 0x80);
                }
                for (int g = 0; g < 11; ++g) {
                    replace[g] = (byte)torename.charAt(g);
                }
                use = use.replace(" ", "");
                byte us = (byte)Integer.parseInt(use);
                int len = tempdisk.length;
                boolean cut = false;
                int checkentry = 0;
                for (int g = 0; g < len - 11; ++g) {
                    byte u;
                    byte[] got = new byte[11];
                    for (int k = 0; k < 11; ++k) {
                        got[k] = tempdisk[k + g];
                    }
                    if (got[0] != check[0] || got[1] != check[1] || got[2] != check[2] || got[3] != check[3] || got[4] != check[4] || got[5] != check[5] || got[6] != check[6] || got[7] != check[7] || got[8] != check[8] || got[9] != check[9] || got[10] != check[10]) continue;
                    byte[] checkHeader = new byte[70];
                    System.arraycopy(tempdisk, g - 1, checkHeader, 0, 70);
                    if (!this.CheckAMSDOS(checkHeader) && (u = tempdisk[g - 1]) == us) {
                        ++checkentry;
                        if (!cut) {
                            len = g + 255;
                        }
                        cut = true;
                        for (int t = 0; t < 11; ++t) {
                            tempdisk[g + t] = replace[t];
                        }
                    }
                    if (checkentry < entrienumber) continue;
                    System.out.println("End of entries for " + this.actualdsk + ": " + entrienumber);
                    break;
                }
                File out = new File(this.actualdsk);
                BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(out));
                bos.write(tempdisk);
                bos.close();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.actualdsk.contains(System.getProperty("user.home") + "/javacpc/temp")) {
            this.actualdsk = this.eraseTemp();
        }
        this.DIR(this.drives);
        this.updateRenName();
        this.console.setSelectedIndices(this.selectedFiles);
        this.sizelist.setSelectedIndices(this.console.getSelectedIndices());
        this.userlist.setSelectedIndices(this.console.getSelectedIndices());
        this.system.setSelectedIndices(this.console.getSelectedIndices());
        this.protec.setSelectedIndices(this.console.getSelectedIndices());
    }

    public void defineUser(String torename) {
        if (this.selectedFiles == null || this.folder == null) {
            return;
        }
        if (torename.length() < 1) {
            return;
        }
        int us = this.user.getSelectedIndex();
        torename = this.filesystem.getAmsdosString(torename);
        System.out.println(torename);
        this.actualdsk = this.BufferDisk();
        for (int i = 0; i < this.selectedFiles.length; ++i) {
            try {
                String get = this.items[this.selectedFiles[i]].toString();
                String prt = this.ronly[this.selectedFiles[i]];
                String sys = this.prot[this.selectedFiles[i]];
                int entrienumber = this.direntries[this.selectedFiles[i]];
                File in = new File(this.actualdsk);
                BufferedInputStream bis = new BufferedInputStream(new FileInputStream(in));
                byte[] tempdisk = new byte[bis.available()];
                bis.read(tempdisk);
                bis.close();
                get = get.replace(".", "");
                torename = torename.replace(".", "");
                byte[] check = get.getBytes("UTF-8");
                if (prt.contains("R/O")) {
                    check[8] = (byte)(check[8] | 0x80);
                }
                if (sys.contains("SYS")) {
                    check[9] = (byte)(check[9] | 0x80);
                }
                int len = tempdisk.length;
                int checkentry = 0;
                for (int g = 0; g < len - 11; ++g) {
                    byte[] got = new byte[11];
                    for (int k = 0; k < 11; ++k) {
                        got[k] = tempdisk[k + g];
                    }
                    if (got[0] != check[0] || got[1] != check[1] || got[2] != check[2] || got[3] != check[3] || got[4] != check[4] || got[5] != check[5] || got[6] != check[6] || got[7] != check[7] || got[8] != check[8] || got[9] != check[9] || got[10] != check[10]) continue;
                    byte[] checkHeader = new byte[70];
                    System.arraycopy(tempdisk, g - 1, checkHeader, 0, 70);
                    if (!this.CheckAMSDOS(checkHeader)) {
                        tempdisk[g - 1] = (byte)us;
                    }
                    if (checkentry < entrienumber) continue;
                    System.out.println("End of entries for " + this.actualdsk + ": " + entrienumber);
                    break;
                }
                File out = new File(this.actualdsk);
                BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(out));
                bos.write(tempdisk);
                bos.close();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.actualdsk.contains(System.getProperty("user.home") + "/javacpc/temp")) {
            this.actualdsk = this.eraseTemp();
        }
        this.DIR(this.drives);
        this.updateRenName();
        this.console.setSelectedIndices(this.selectedFiles);
        this.sizelist.setSelectedIndices(this.console.getSelectedIndices());
        this.userlist.setSelectedIndices(this.console.getSelectedIndices());
        this.system.setSelectedIndices(this.console.getSelectedIndices());
        this.protec.setSelectedIndices(this.console.getSelectedIndices());
    }

    public void defineUserTo(String torename) {
        if (this.selectedFiles == null || this.folder == null) {
            return;
        }
        if (torename.length() < 1) {
            return;
        }
        int us = this.user1.getSelectedIndex();
        torename = this.filesystem.getAmsdosString(torename);
        System.out.println(torename);
        this.actualdsk = this.BufferDisk();
        try {
            File in = new File(this.actualdsk);
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(in));
            byte[] tempdisk = new byte[bis.available()];
            bis.read(tempdisk);
            bis.close();
            block4: for (int i = 0; i < this.selectedFiles.length; ++i) {
                try {
                    String get = this.items[this.selectedFiles[i]].toString();
                    String prt = this.ronly[this.selectedFiles[i]];
                    String sys = this.prot[this.selectedFiles[i]];
                    int entrienumber = this.direntries[this.selectedFiles[i]];
                    get = get.replace(".", "");
                    torename = torename.replace(".", "");
                    byte[] check = get.getBytes("UTF-8");
                    if (prt.contains("R/O")) {
                        check[8] = (byte)(check[8] | 0x80);
                    }
                    if (sys.contains("SYS")) {
                        check[9] = (byte)(check[9] | 0x80);
                    }
                    int len = tempdisk.length;
                    int checkentry = 0;
                    for (int g = 0; g < len - 11; ++g) {
                        byte[] got = new byte[11];
                        for (int k = 0; k < 11; ++k) {
                            got[k] = tempdisk[k + g];
                        }
                        if (got[0] != check[0] || got[1] != check[1] || got[2] != check[2] || got[3] != check[3] || got[4] != check[4] || got[5] != check[5] || got[6] != check[6] || got[7] != check[7] || got[8] != check[8] || got[9] != check[9] || got[10] != check[10]) continue;
                        byte[] checkHeader = new byte[70];
                        System.arraycopy(tempdisk, g - 1, checkHeader, 0, 70);
                        if (!this.CheckAMSDOS(checkHeader)) {
                            tempdisk[g - 1] = (byte)us;
                        }
                        if (checkentry < entrienumber) continue;
                        System.out.println("End of entries for " + this.actualdsk + ": " + entrienumber);
                        continue block4;
                    }
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            File out = new File(this.actualdsk);
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(out));
            bos.write(tempdisk);
            bos.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.actualdsk.contains(System.getProperty("user.home") + "/javacpc/temp")) {
            this.actualdsk = this.eraseTemp();
        }
    }

    public void protect() {
        if (this.selectedFiles == null || this.folder == null) {
            return;
        }
        this.actualdsk = this.BufferDisk();
        for (int i = 0; i < this.selectedFiles.length; ++i) {
            try {
                String get = this.items[this.selectedFiles[i]].toString();
                String use = this.users[this.selectedFiles[i]];
                String prt = this.ronly[this.selectedFiles[i]];
                String sys = this.prot[this.selectedFiles[i]];
                int entrienumber = this.direntries[this.selectedFiles[i]];
                use = use.substring(4);
                File in = new File(this.actualdsk);
                BufferedInputStream bis = new BufferedInputStream(new FileInputStream(in));
                byte[] tempdisk = new byte[bis.available()];
                bis.read(tempdisk);
                bis.close();
                get = get.replace(".", "");
                byte[] check = get.getBytes("UTF-8");
                byte[] replace = get.getBytes("UTF-8");
                if (prt.contains("R/O")) {
                    check[8] = (byte)(check[8] | 0x80);
                } else {
                    replace[8] = (byte)(replace[8] | 0x80);
                }
                if (sys.contains("SYS")) {
                    check[9] = (byte)(check[9] | 0x80);
                    replace[9] = (byte)(replace[9] | 0x80);
                }
                use = use.replace(" ", "");
                byte us = (byte)Integer.parseInt(use);
                int len = tempdisk.length;
                boolean cut = false;
                int checkentry = 0;
                for (int g = 0; g < len - 11; ++g) {
                    byte u;
                    byte[] got = new byte[11];
                    for (int k = 0; k < 11; ++k) {
                        got[k] = tempdisk[k + g];
                    }
                    if (got[0] != check[0] || got[1] != check[1] || got[2] != check[2] || got[3] != check[3] || got[4] != check[4] || got[5] != check[5] || got[6] != check[6] || got[7] != check[7] || got[8] != check[8] || got[9] != check[9] || got[10] != check[10]) continue;
                    byte[] checkHeader = new byte[70];
                    System.arraycopy(tempdisk, g - 1, checkHeader, 0, 70);
                    if (!this.CheckAMSDOS(checkHeader) && (u = tempdisk[g - 1]) == us) {
                        ++checkentry;
                        if (!cut) {
                            len = g + 255;
                        }
                        cut = true;
                        for (int t = 0; t < 11; ++t) {
                            tempdisk[g + t] = replace[t];
                        }
                    }
                    if (checkentry < entrienumber) continue;
                    System.out.println("End of entries for " + this.actualdsk + ": " + entrienumber);
                    break;
                }
                File out = new File(this.actualdsk);
                BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(out));
                bos.write(tempdisk);
                bos.close();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.actualdsk.contains(System.getProperty("user.home") + "/javacpc/temp")) {
            this.actualdsk = this.eraseTemp();
        }
        this.DIR(this.drives);
        this.console.setSelectedIndices(this.selectedFiles);
        this.sizelist.setSelectedIndices(this.console.getSelectedIndices());
        this.userlist.setSelectedIndices(this.console.getSelectedIndices());
        this.system.setSelectedIndices(this.console.getSelectedIndices());
        this.protec.setSelectedIndices(this.console.getSelectedIndices());
    }

    public void changeUser() {
        if (this.selectedFiles == null || this.folder == null) {
            return;
        }
        this.actualdsk = this.BufferDisk();
        for (int i = 0; i < this.selectedFiles.length; ++i) {
            try {
                String get = this.items[this.selectedFiles[i]].toString();
                this.defineUserTo(get);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.actualdsk.contains(System.getProperty("user.home") + "/javacpc/temp")) {
            this.actualdsk = this.eraseTemp();
        }
        this.DIR(this.drives);
    }

    @Override
    public void hide() {
        if (this.selectedFiles == null || this.folder == null) {
            return;
        }
        this.actualdsk = this.BufferDisk();
        for (int i = 0; i < this.selectedFiles.length; ++i) {
            try {
                String get = this.items[this.selectedFiles[i]].toString();
                String use = this.users[this.selectedFiles[i]];
                String prt = this.ronly[this.selectedFiles[i]];
                String sys = this.prot[this.selectedFiles[i]];
                int entrienumber = this.direntries[this.selectedFiles[i]];
                use = use.substring(4);
                File in = new File(this.actualdsk);
                BufferedInputStream bis = new BufferedInputStream(new FileInputStream(in));
                byte[] tempdisk = new byte[bis.available()];
                bis.read(tempdisk);
                bis.close();
                get = get.replace(".", "");
                byte[] check = get.getBytes("UTF-8");
                byte[] replace = get.getBytes("UTF-8");
                if (sys.contains("SYS")) {
                    check[9] = (byte)(check[9] | 0x80);
                } else {
                    replace[9] = (byte)(replace[9] | 0x80);
                }
                if (prt.contains("R/O")) {
                    check[8] = (byte)(check[8] | 0x80);
                    replace[8] = (byte)(replace[8] | 0x80);
                }
                use = use.replace(" ", "");
                byte us = (byte)Integer.parseInt(use);
                int checkentry = 0;
                for (int g = 0; g < tempdisk.length - 11; ++g) {
                    byte u;
                    byte[] got = new byte[11];
                    for (int k = 0; k < 11; ++k) {
                        got[k] = tempdisk[k + g];
                    }
                    if (got[0] != check[0] || got[1] != check[1] || got[2] != check[2] || got[3] != check[3] || got[4] != check[4] || got[5] != check[5] || got[6] != check[6] || got[7] != check[7] || got[8] != check[8] || got[9] != check[9] || got[10] != check[10]) continue;
                    byte[] checkHeader = new byte[70];
                    System.arraycopy(tempdisk, g - 1, checkHeader, 0, 70);
                    if (!this.CheckAMSDOS(checkHeader) && (u = tempdisk[g - 1]) == us) {
                        ++checkentry;
                        for (int t = 0; t < 11; ++t) {
                            tempdisk[g + t] = replace[t];
                        }
                    }
                    if (checkentry < entrienumber) continue;
                    System.out.println("End of entries for " + this.actualdsk + ": " + entrienumber);
                    break;
                }
                File out = new File(this.actualdsk);
                BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(out));
                bos.write(tempdisk);
                bos.close();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.actualdsk.contains(System.getProperty("user.home") + "/javacpc/temp")) {
            this.actualdsk = this.eraseTemp();
        }
        this.DIR(this.drives);
        this.console.setSelectedIndices(this.selectedFiles);
        this.sizelist.setSelectedIndices(this.console.getSelectedIndices());
        this.userlist.setSelectedIndices(this.console.getSelectedIndices());
        this.system.setSelectedIndices(this.console.getSelectedIndices());
        this.protec.setSelectedIndices(this.console.getSelectedIndices());
    }

    public void Delete() {
        if (this.selectedFiles == null || this.folder == null) {
            return;
        }
        String disk = Settings.get("file.drive" + Integer.toString(this.drives), "empty");
        if (disk == null) {
            return;
        }
        this.filesystem.loadDisk(disk);
        String info = "";
        for (int i = 0; i < this.selectedFiles.length; ++i) {
            try {
                info = info + this.items[this.selectedFiles[i]].toString() + "\r\n";
                continue;
            }
            catch (Exception e) {
                return;
            }
        }
        if (info.length() < 1) {
            return;
        }
        int n = JOptionPane.showConfirmDialog(this, "Are you sure, you want to delete the following files?\r\n" + info, "Confirm deleting", 0, 2);
        if (n != 0) {
            return;
        }
        this.actualdsk = this.BufferDisk();
        for (int i = 0; i < this.selectedFiles.length; ++i) {
            try {
                String get = this.items[this.selectedFiles[i]].toString();
                String prot = this.rdonly[this.selectedFiles[i]].toString();
                String hidd = this.hidden[this.selectedFiles[i]].toString();
                boolean isprotected = prot.length() > 2;
                boolean ishidden = hidd.length() > 2;
                String diskFile = this.getRealName(get, isprotected, ishidden);
                this.filesystem.deleteFile(diskFile, disk);
                this.output.append("Deleting file " + get);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.actualdsk.contains(System.getProperty("user.home") + "/javacpc/temp")) {
            this.actualdsk = this.eraseTemp();
        }
        this.DIR(this.drives);
    }

    public void writeFileTo() {
        FileDialog filedia = new FileDialog(new Frame(), "Import file to DSK", 0);
        filedia.setVisible(true);
        String filename = filedia.getFile();
        if (filename != null) {
            this.writeToDsk(filedia.getDirectory() + "/" + filedia.getFile());
        }
    }

    public void writeToDsk(String file) {
        File checkfile = new File(file);
        String dofile = file;
        if (this.output.getText().contains("DIR: empty")) {
            this.output.append("\r\nNo DSK loaded. Please load a DSK first...");
            return;
        }
        String disk = Settings.get("file.drive" + Integer.toString(this.drives), "empty");
        if (disk == null) {
            return;
        }
        this.filesystem.loadDisk(disk);
        boolean deletetemp = false;
        int hassize = 0;
        try {
            BufferedInputStream stream = new BufferedInputStream(new FileInputStream(checkfile));
            hassize = stream.available();
            byte[] temp = new byte[hassize];
            stream.read(temp);
            stream.close();
            if (this.CheckAMSDOS(temp)) {
                hassize -= 128;
            }
            if (hassize > this.freesize) {
                this.output.append("File is too large! Free: " + this.freesize + " File size:" + hassize + "\r\n");
                return;
            }
        }
        catch (IOException re) {
            re.printStackTrace();
        }
        if (this.actualdsk == null) {
            return;
        }
        this.actualdsk = this.BufferDisk();
        while (file.contains("\\")) {
            file = file.substring(1);
        }
        while (file.contains("/")) {
            file = file.substring(1);
        }
        try {
            this.filesystem.writeFile(dofile, disk);
            if (deletetemp) {
                File del = new File(System.getProperty("user.home") + "/javacpc/temp.tmp");
                del.delete();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.writeEyeCatcher();
        if (this.actualdsk.contains(System.getProperty("user.home") + "/javacpc/temp")) {
            this.actualdsk = this.eraseTemp();
        }
        this.DIR(this.drives);
        if (this.user.getSelectedIndex() != 0) {
            file = this.filesystem.getAmsdosString(file);
            this.defineUser(file);
        }
        if (this.ascii.isSelected()) {
            this.output.append("ASCII transferred");
        } else {
            this.output.append("BINARY transferred");
        }
    }

    public String Launch(String command) throws InterruptedException, IOException {
        String line;
        String result = "";
        this.process = Runtime.getRuntime().exec(command);
        InputStream is = this.process.getInputStream();
        InputStreamReader isr = new InputStreamReader(is);
        BufferedReader br = new BufferedReader(isr);
        BufferedReader br2 = new BufferedReader(isr);
        System.out.println("Executing external command: " + command);
        while ((line = br.readLine()) != null) {
            String err;
            if (!line.contains("Label file")) {
                result = result + line + "\r";
                this.output.append(line + "\r\n");
            }
            if ((err = br2.readLine()) == null) continue;
            this.output.append(err + "\r\n");
        }
        br.close();
        this.process = null;
        return result;
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.buttonGroup2 = new ButtonGroup();
        this.buttonGroup3 = new ButtonGroup();
        this.buttonGroup4 = new ButtonGroup();
        this.jPopupMenu1 = new JPopupMenu();
        this.jMenuItem1 = new JMenuItem();
        this.jMenuItem2 = new JMenuItem();
        this.jMenuItem3 = new JMenuItem();
        this.jSeparator2 = new JSeparator();
        this.jMenuItem4 = new JMenuItem();
        this.disktools = new JPanel();
        this.jLabel1 = new JLabel();
        this.space = new JLabel();
        this.seldsk = new JButton();
        this.user = new JComboBox();
        this.jLabel3 = new JLabel();
        this.jToggleButton1 = new JToggleButton();
        this.jToggleButton2 = new JToggleButton();
        this.jButton1 = new JButton();
        this.load = new JButton();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel3 = new JPanel();
        this.dropper = new JPanel();
        this.jButton2 = new JButton();
        this.jButton5 = new JButton();
        this.jButton4 = new JButton();
        this.jButton9 = new JButton();
        this.user1 = new JComboBox();
        this.renamefield = new JTextField();
        this.jButton7 = new JButton();
        this.jPanel2 = new JPanel();
        this.jButton3 = new JButton();
        this.jButton8 = new JButton();
        this.jPanel11 = new JPanel();
        this.jScrollPane4 = new JScrollPane();
        this.userlist = new JList();
        this.jScrollPane2 = new JScrollPane();
        this.sizelist = new JList();
        this.jScrollPane5 = new JScrollPane();
        this.system = new JList();
        this.jScrollPane1 = new JScrollPane();
        this.console = new JList();
        this.jScrollPane6 = new JScrollPane();
        this.protec = new JList();
        this.jScrollPane3 = new JScrollPane();
        this.output = new JTextArea();
        this.jPanel13 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.filename = new JLabel();
        this.realname = new JLabel();
        this.filesize = new JLabel();
        this.filetype = new JLabel();
        this.start = new JLabel();
        this.exec = new JLabel();
        this.jSeparator3 = new JSeparator();
        this.jSeparator4 = new JSeparator();
        this.jSeparator5 = new JSeparator();
        this.jPanel4 = new JPanel();
        this.jPanel15 = new JPanel();
        this.DSKStructure = new JLabel();
        this.DSKStructure1 = new JLabel();
        this.jLabel11 = new JLabel();
        this.sideb = new JLabel();
        this.jPanel1 = new JPanel();
        this.jScrollPane7 = new JScrollPane();
        this.text = new JTextArea();
        this.jPanel6 = new JPanel();
        this.jToggleButton3 = new JToggleButton();
        this.jToggleButton4 = new JToggleButton();
        this.bstart = new JButton();
        this.jSeparator1 = new JSeparator();
        this.bstop = new JButton();
        this.progress = new JProgressBar();
        this.jPanel7 = new JPanel();
        this.jLabel4 = new JLabel();
        this.ctracks = new JComboBox();
        this.gaps = new JCheckBox();
        this.bstep = new JCheckBox();
        this.brescan = new JCheckBox();
        this.jPanel8 = new JPanel();
        this.jLabel5 = new JLabel();
        this.cdrive = new JComboBox();
        this.bboth = new JCheckBox();
        this.bhead0 = new JCheckBox();
        this.bhead1 = new JCheckBox();
        this.bfdi = new JCheckBox();
        this.jPanel9 = new JPanel();
        this.flop = new JLabel();
        this.jPanel5 = new JPanel();
        this.jPanel10 = new JPanel();
        this.jRadioButton2 = new JRadioButton();
        this.jRadioButton8 = new JRadioButton();
        this.jRadioButton9 = new JRadioButton();
        this.jRadioButton1 = new JRadioButton();
        this.jRadioButton7 = new JRadioButton();
        this.jRadioButton11 = new JRadioButton();
        this.jRadioButton12 = new JRadioButton();
        this.jRadioButton3 = new JRadioButton();
        this.jRadioButton6 = new JRadioButton();
        this.jRadioButton4 = new JRadioButton();
        this.jRadioButton5 = new JRadioButton();
        this.jRadioButton10 = new JRadioButton();
        this.jRadioButton13 = new JRadioButton();
        this.jRadioButton14 = new JRadioButton();
        this.jRadioButton15 = new JRadioButton();
        this.jRadioButton16 = new JRadioButton();
        this.jRadioButton18 = new JRadioButton();
        this.jRadioButton17 = new JRadioButton();
        this.jRadioButton22 = new JRadioButton();
        this.jRadioButton21 = new JRadioButton();
        this.jRadioButton19 = new JRadioButton();
        this.jRadioButton23 = new JRadioButton();
        this.jRadioButton20 = new JRadioButton();
        this.jButton6 = new JButton();
        this.selform = new JLabel();
        this.dsk = new JLabel();
        this.also = new JCheckBox();
        this.jPanel14 = new JPanel();
        this.hex = new JPanel();
        this.jPanel16 = new JPanel();
        this.jLabel12 = new JLabel();
        this.trackBox = new JComboBox();
        this.jLabel13 = new JLabel();
        this.sectorBox = new JComboBox();
        this.jButton11 = new JButton();
        this.hexi = new JPanel();
        this.ascii = new JCheckBox();
        this.txtinfo = new JCheckBox();
        this.jButton10 = new JButton();
        this.output1 = new JTextArea();
        this.console1 = new JList();
        this.jMenuItem1.setText("Get file(s)");
        this.jMenuItem1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DSKUtil.this.jMenuItem1ActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.jMenuItem1);
        this.jMenuItem2.setText("Protect / Unprotect");
        this.jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DSKUtil.this.jMenuItem2ActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.jMenuItem2);
        this.jMenuItem3.setText("System / Show");
        this.jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DSKUtil.this.jMenuItem3ActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.jMenuItem3);
        this.jPopupMenu1.add(this.jSeparator2);
        this.jMenuItem4.setText("Delete");
        this.jMenuItem4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DSKUtil.this.jMenuItem4ActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.jMenuItem4);
        this.disktools.setBorder(BorderFactory.createEtchedBorder());
        this.disktools.setMaximumSize(new Dimension(672, 654));
        this.disktools.setMinimumSize(new Dimension(672, 654));
        this.jLabel1.setFont(new Font("Tahoma", 1, 11));
        this.jLabel1.setText("Free:");
        this.space.setFont(new Font("Tahoma", 1, 11));
        this.space.setText("empty");
        this.seldsk.setText("Delete file(s)");
        this.seldsk.setFocusPainted(false);
        this.seldsk.setFocusable(false);
        this.seldsk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DSKUtil.this.seldskActionPerformed(evt);
            }
        });
        this.user.setModel(new DefaultComboBoxModel<String>(new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15"}));
        this.user.setFocusable(false);
        this.jLabel3.setFont(new Font("Tahoma", 1, 11));
        this.jLabel3.setText("Import to user:");
        this.buttonGroup1.add(this.jToggleButton1);
        this.jToggleButton1.setText("DF1");
        this.jToggleButton1.setFocusPainted(false);
        this.jToggleButton1.setFocusable(false);
        this.jToggleButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DSKUtil.this.jToggleButton1ActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.jToggleButton2);
        this.jToggleButton2.setText("DF0");
        this.jToggleButton2.setFocusPainted(false);
        this.jToggleButton2.setFocusable(false);
        this.jToggleButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DSKUtil.this.jToggleButton2ActionPerformed(evt);
            }
        });
        this.jButton1.setText("Eject");
        this.jButton1.setFocusPainted(false);
        this.jButton1.setFocusable(false);
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DSKUtil.this.jButton1ActionPerformed(evt);
            }
        });
        this.load.setText("Load");
        this.load.setFocusPainted(false);
        this.load.setFocusable(false);
        this.load.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DSKUtil.this.loadActionPerformed(evt);
            }
        });
        this.jTabbedPane1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                DSKUtil.this.jTabbedPane1StateChanged(evt);
            }
        });
        this.jTabbedPane1.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                DSKUtil.this.jTabbedPane1MousePressed(evt);
            }
        });
        this.dropper.setBorder(BorderFactory.createTitledBorder("Handle file(s)"));
        this.jButton2.setText("Protect");
        this.jButton2.setFocusPainted(false);
        this.jButton2.setFocusable(false);
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DSKUtil.this.jButton2ActionPerformed(evt);
            }
        });
        this.jButton5.setText("System");
        this.jButton5.setFocusPainted(false);
        this.jButton5.setFocusable(false);
        this.jButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DSKUtil.this.jButton5ActionPerformed(evt);
            }
        });
        this.jButton4.setText("Fix EyeCatcher");
        this.jButton4.setFocusPainted(false);
        this.jButton4.setFocusable(false);
        this.jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DSKUtil.this.jButton4ActionPerformed(evt);
            }
        });
        this.jButton9.setText("Set USER");
        this.jButton9.setFocusPainted(false);
        this.jButton9.setFocusable(false);
        this.jButton9.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DSKUtil.this.jButton9ActionPerformed(evt);
            }
        });
        this.user1.setModel(new DefaultComboBoxModel<String>(new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15"}));
        this.user1.setFocusable(false);
        this.renamefield.setColumns(12);
        this.renamefield.setFont(new Font("Monospaced", 0, 11));
        this.jButton7.setText("Rename");
        this.jButton7.setFocusPainted(false);
        this.jButton7.setFocusable(false);
        this.jButton7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DSKUtil.this.jButton7ActionPerformed(evt);
            }
        });
        GroupLayout dropperLayout = new GroupLayout(this.dropper);
        this.dropper.setLayout(dropperLayout);
        dropperLayout.setHorizontalGroup(dropperLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(dropperLayout.createSequentialGroup().addContainerGap().addGroup(dropperLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(dropperLayout.createSequentialGroup().addComponent(this.jButton4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton9).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.user1, -2, -1, -2)).addGroup(dropperLayout.createSequentialGroup().addComponent(this.jButton2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton5)).addGroup(dropperLayout.createSequentialGroup().addComponent(this.renamefield, -2, 150, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton7))).addContainerGap(-1, Short.MAX_VALUE)));
        dropperLayout.setVerticalGroup(dropperLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(dropperLayout.createSequentialGroup().addGroup(dropperLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton2).addComponent(this.jButton5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(dropperLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton4).addComponent(this.jButton9).addComponent(this.user1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(dropperLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.renamefield, -2, -1, -2).addComponent(this.jButton7)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Filetransfer"));
        this.jButton3.setText("Get file(s) from DSK");
        this.jButton3.setFocusPainted(false);
        this.jButton3.setFocusable(false);
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DSKUtil.this.jButton3ActionPerformed(evt);
            }
        });
        this.jButton8.setText("Write file to DSK");
        this.jButton8.setFocusPainted(false);
        this.jButton8.setFocusable(false);
        this.jButton8.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DSKUtil.this.jButton8ActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jButton8).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton3).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton3, -1, -1, Short.MAX_VALUE).addComponent(this.jButton8)).addContainerGap()));
        this.jScrollPane4.setBorder(BorderFactory.createEtchedBorder());
        this.jScrollPane4.setHorizontalScrollBarPolicy(31);
        this.jScrollPane4.setVerticalScrollBarPolicy(21);
        this.userlist.setFont(new Font("Monospaced", 0, 12));
        this.userlist.setComponentPopupMenu(this.jPopupMenu1);
        this.userlist.setFocusable(false);
        this.userlist.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DSKUtil.this.userlistMouseClicked(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                DSKUtil.this.userlistMousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                DSKUtil.this.userlistMouseReleased(evt);
            }
        });
        this.userlist.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                DSKUtil.this.userlistMouseDragged(evt);
            }
        });
        this.jScrollPane4.setViewportView(this.userlist);
        this.jScrollPane2.setBorder(BorderFactory.createEtchedBorder());
        this.jScrollPane2.setHorizontalScrollBarPolicy(31);
        this.jScrollPane2.setVerticalScrollBarPolicy(21);
        this.sizelist.setFont(new Font("Monospaced", 0, 12));
        this.sizelist.setComponentPopupMenu(this.jPopupMenu1);
        this.sizelist.setFocusable(false);
        this.sizelist.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DSKUtil.this.sizelistMouseClicked(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                DSKUtil.this.sizelistMousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                DSKUtil.this.sizelistMouseReleased(evt);
            }
        });
        this.sizelist.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                DSKUtil.this.sizelistMouseDragged(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.sizelist);
        this.jScrollPane5.setBorder(BorderFactory.createEtchedBorder());
        this.jScrollPane5.setHorizontalScrollBarPolicy(31);
        this.jScrollPane5.setVerticalScrollBarPolicy(21);
        this.system.setFont(new Font("Monospaced", 0, 12));
        this.system.setForeground(new Color(0, 0, 255));
        this.system.setComponentPopupMenu(this.jPopupMenu1);
        this.system.setFocusable(false);
        this.system.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DSKUtil.this.systemMouseClicked(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                DSKUtil.this.systemMousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                DSKUtil.this.systemMouseReleased(evt);
            }
        });
        this.system.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                DSKUtil.this.systemMouseDragged(evt);
            }
        });
        this.jScrollPane5.setViewportView(this.system);
        this.jScrollPane1.setBorder(BorderFactory.createEtchedBorder());
        this.jScrollPane1.setHorizontalScrollBarPolicy(31);
        this.jScrollPane1.setHorizontalScrollBar(null);
        this.jScrollPane1.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                DSKUtil.this.jScrollPane1PropertyChange(evt);
            }
        });
        this.console.setFont(new Font("Monospaced", 1, 12));
        this.console.setComponentPopupMenu(this.jPopupMenu1);
        this.console.setValueIsAdjusting(true);
        this.console.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                DSKUtil.this.consoleMouseDragged(evt);
            }
        });
        this.console.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DSKUtil.this.consoleMouseClicked(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                DSKUtil.this.consoleMousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                DSKUtil.this.consoleMouseReleased(evt);
            }
        });
        this.console.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent evt) {
                DSKUtil.this.consoleComponentMoved(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.console);
        this.jScrollPane6.setBorder(BorderFactory.createEtchedBorder());
        this.jScrollPane6.setHorizontalScrollBarPolicy(31);
        this.jScrollPane6.setVerticalScrollBarPolicy(21);
        this.protec.setFont(new Font("Monospaced", 0, 12));
        this.protec.setForeground(new Color(255, 0, 51));
        this.protec.setComponentPopupMenu(this.jPopupMenu1);
        this.protec.setFocusable(false);
        this.protec.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DSKUtil.this.protecMouseClicked(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                DSKUtil.this.protecMousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                DSKUtil.this.protecMouseReleased(evt);
            }
        });
        this.protec.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                DSKUtil.this.protecMouseDragged(evt);
            }
        });
        this.jScrollPane6.setViewportView(this.protec);
        GroupLayout jPanel11Layout = new GroupLayout(this.jPanel11);
        this.jPanel11.setLayout(jPanel11Layout);
        jPanel11Layout.setHorizontalGroup(jPanel11Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel11Layout.createSequentialGroup().addComponent(this.jScrollPane4, -2, 55, -2).addGap(2, 2, 2).addComponent(this.jScrollPane2, -2, 76, -2).addGap(2, 2, 2).addComponent(this.jScrollPane6, -2, 37, -2).addGap(2, 2, 2).addComponent(this.jScrollPane5, -2, 37, -2).addGap(2, 2, 2).addComponent(this.jScrollPane1, -2, 150, -2)));
        jPanel11Layout.setVerticalGroup(jPanel11Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane4).addComponent(this.jScrollPane2).addComponent(this.jScrollPane6).addComponent(this.jScrollPane5).addComponent(this.jScrollPane1));
        this.output.setEditable(false);
        this.output.setColumns(20);
        this.output.setFont(new Font("Monospaced", 1, 11));
        this.output.setRows(5);
        this.jScrollPane3.setViewportView(this.output);
        this.jLabel2.setText("Filename:");
        this.jLabel6.setText("Internal name:");
        this.jLabel7.setText("Filesize:");
        this.jLabel8.setText("Filetype:");
        this.jLabel9.setText("Start address:");
        this.jLabel10.setText("Exec. address:");
        this.filename.setText("empty");
        this.realname.setText("empty");
        this.filesize.setText("empty");
        this.filetype.setText("empty");
        this.start.setText("empty");
        this.exec.setText("empty");
        GroupLayout jPanel13Layout = new GroupLayout(this.jPanel13);
        this.jPanel13.setLayout(jPanel13Layout);
        jPanel13Layout.setHorizontalGroup(jPanel13Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel13Layout.createSequentialGroup().addContainerGap().addGroup(jPanel13Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator5).addGroup(jPanel13Layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.filename, -2, 121, -2)).addGroup(jPanel13Layout.createSequentialGroup().addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.realname, -2, 121, -2)).addComponent(this.jSeparator4).addComponent(this.jSeparator3).addGroup(jPanel13Layout.createSequentialGroup().addComponent(this.jLabel8).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(jPanel13Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.filetype, -2, 121, -2).addComponent(this.filesize, -2, 121, -2))).addComponent(this.jLabel7).addGroup(jPanel13Layout.createSequentialGroup().addComponent(this.jLabel9).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.start, -2, 121, -2)).addGroup(jPanel13Layout.createSequentialGroup().addComponent(this.jLabel10).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.exec, -2, 121, -2))).addContainerGap()));
        jPanel13Layout.setVerticalGroup(jPanel13Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel13Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(jPanel13Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.filename)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel13Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.realname)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator5, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel13Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel13Layout.createSequentialGroup().addGroup(jPanel13Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel13Layout.createSequentialGroup().addComponent(this.jLabel8).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel7)).addGroup(jPanel13Layout.createSequentialGroup().addComponent(this.filetype).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.filesize))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator3, -2, 10, -2)).addGroup(jPanel13Layout.createSequentialGroup().addGap(56, 56, 56).addGroup(jPanel13Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel9).addComponent(this.start)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel13Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel10).addComponent(this.exec)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator4, -2, 10, -2)));
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jPanel11, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addComponent(this.dropper, -1, -1, Short.MAX_VALUE).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jPanel13, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)))).addComponent(this.jScrollPane3)).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.dropper, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel13, -2, -1, -2).addGap(0, 13, Short.MAX_VALUE)).addComponent(this.jPanel11, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane3, -2, 160, -2).addContainerGap()));
        this.jTabbedPane1.addTab("Directory", this.jPanel3);
        this.jPanel15.setBorder(BorderFactory.createTitledBorder("DSK Structure"));
        this.DSKStructure.setMaximumSize(new Dimension(310, 420));
        this.DSKStructure.setMinimumSize(new Dimension(310, 420));
        this.DSKStructure.setPreferredSize(new Dimension(310, 420));
        this.DSKStructure1.setMaximumSize(new Dimension(310, 420));
        this.DSKStructure1.setMinimumSize(new Dimension(310, 420));
        this.DSKStructure1.setPreferredSize(new Dimension(310, 420));
        this.jLabel11.setText("Side A");
        this.sideb.setText("Side B");
        GroupLayout jPanel15Layout = new GroupLayout(this.jPanel15);
        this.jPanel15.setLayout(jPanel15Layout);
        jPanel15Layout.setHorizontalGroup(jPanel15Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel15Layout.createSequentialGroup().addGroup(jPanel15Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.DSKStructure, -2, -1, -2).addComponent(this.jLabel11)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel15Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.sideb).addComponent(this.DSKStructure1, -2, -1, -2)).addGap(0, 0, Short.MAX_VALUE)));
        jPanel15Layout.setVerticalGroup(jPanel15Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel15Layout.createSequentialGroup().addGroup(jPanel15Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel11).addComponent(this.sideb)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel15Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.DSKStructure, -2, -1, -2).addComponent(this.DSKStructure1, -2, -1, -2)).addGap(0, 0, Short.MAX_VALUE)));
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel15, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel15, -2, -1, -2).addContainerGap(80, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("Structure", this.jPanel4);
        this.text.setEditable(false);
        this.text.setColumns(20);
        this.text.setFont(new Font("Monospaced", 1, 11));
        this.text.setRows(5);
        this.jScrollPane7.setViewportView(this.text);
        this.jPanel6.setBorder(BorderFactory.createTitledBorder("Read / Write"));
        this.buttonGroup2.add(this.jToggleButton3);
        this.jToggleButton3.setSelected(true);
        this.jToggleButton3.setText("Read floppy to DSK");
        this.jToggleButton3.setFocusPainted(false);
        this.jToggleButton3.setFocusable(false);
        this.buttonGroup2.add(this.jToggleButton4);
        this.jToggleButton4.setText("Write DSK to floppy");
        this.jToggleButton4.setFocusPainted(false);
        this.jToggleButton4.setFocusable(false);
        this.bstart.setText("Start transfer");
        this.bstart.setFocusPainted(false);
        this.bstart.setFocusable(false);
        this.bstart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DSKUtil.this.bstartActionPerformed(evt);
            }
        });
        this.bstop.setText("Abort transfer");
        this.bstop.setEnabled(false);
        this.bstop.setFocusPainted(false);
        this.bstop.setFocusable(false);
        this.bstop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DSKUtil.this.bstopActionPerformed(evt);
            }
        });
        GroupLayout jPanel6Layout = new GroupLayout(this.jPanel6);
        this.jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addContainerGap().addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jToggleButton4, -1, -1, Short.MAX_VALUE).addComponent(this.jToggleButton3, -1, -1, Short.MAX_VALUE).addComponent(this.jSeparator1, GroupLayout.Alignment.TRAILING).addComponent(this.bstart, -1, -1, Short.MAX_VALUE).addComponent(this.bstop, -1, -1, Short.MAX_VALUE).addComponent(this.progress, -1, 154, Short.MAX_VALUE)).addContainerGap()));
        jPanel6Layout.setVerticalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addComponent(this.jToggleButton3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jToggleButton4).addGap(7, 7, 7).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bstart).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bstop).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.progress, -2, -1, -2).addContainerGap(22, Short.MAX_VALUE)));
        this.jPanel7.setBorder(BorderFactory.createTitledBorder("Options"));
        this.jLabel4.setText("Tracks");
        this.ctracks.setModel(new DefaultComboBoxModel<String>(new String[]{"Default", "40 Tracks", "43 Tracks", "80 Tracks"}));
        this.ctracks.setFocusable(false);
        this.gaps.setText("GAPs");
        this.gaps.setFocusPainted(false);
        this.gaps.setFocusable(false);
        this.bstep.setText("Double step");
        this.bstep.setFocusPainted(false);
        this.bstep.setFocusable(false);
        this.brescan.setText("Rescan");
        this.brescan.setFocusPainted(false);
        this.brescan.setFocusable(false);
        GroupLayout jPanel7Layout = new GroupLayout(this.jPanel7);
        this.jPanel7.setLayout(jPanel7Layout);
        jPanel7Layout.setHorizontalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addContainerGap().addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.brescan).addComponent(this.bstep).addComponent(this.gaps).addComponent(this.jLabel4).addComponent(this.ctracks, -2, -1, -2)).addContainerGap(52, Short.MAX_VALUE)));
        jPanel7Layout.setVerticalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ctracks, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.gaps).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.bstep).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.brescan).addContainerGap(46, Short.MAX_VALUE)));
        this.jPanel8.setBorder(BorderFactory.createTitledBorder("Drive settings"));
        this.jLabel5.setText("Transfer drive:");
        this.cdrive.setModel(new DefaultComboBoxModel<String>(new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"}));
        this.cdrive.setFocusable(false);
        this.cdrive.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DSKUtil.this.cdriveActionPerformed(evt);
            }
        });
        this.buttonGroup3.add(this.bboth);
        this.bboth.setText("Both heads");
        this.bboth.setFocusPainted(false);
        this.bboth.setFocusable(false);
        this.bboth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DSKUtil.this.bbothActionPerformed(evt);
            }
        });
        this.buttonGroup3.add(this.bhead0);
        this.bhead0.setText("Head 0");
        this.bhead0.setFocusPainted(false);
        this.bhead0.setFocusable(false);
        this.bhead0.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DSKUtil.this.bhead0ActionPerformed(evt);
            }
        });
        this.buttonGroup3.add(this.bhead1);
        this.bhead1.setText("Head 1");
        this.bhead1.setFocusPainted(false);
        this.bhead1.setFocusable(false);
        this.bhead1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DSKUtil.this.bhead1ActionPerformed(evt);
            }
        });
        this.buttonGroup3.add(this.bfdi);
        this.bfdi.setSelected(true);
        this.bfdi.setText("3\" drive");
        this.bfdi.setFocusPainted(false);
        this.bfdi.setFocusable(false);
        this.bfdi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DSKUtil.this.bfdiActionPerformed(evt);
            }
        });
        this.jPanel9.setBorder(BorderFactory.createEtchedBorder());
        this.flop.setIcon(new ImageIcon(this.getClass().getResource("/jemu/ui/dskutil/3inch.gif")));
        GroupLayout jPanel9Layout = new GroupLayout(this.jPanel9);
        this.jPanel9.setLayout(jPanel9Layout);
        jPanel9Layout.setHorizontalGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.flop, -1, -1, Short.MAX_VALUE));
        jPanel9Layout.setVerticalGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.flop));
        GroupLayout jPanel8Layout = new GroupLayout(this.jPanel8);
        this.jPanel8.setLayout(jPanel8Layout);
        jPanel8Layout.setHorizontalGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel8Layout.createSequentialGroup().addContainerGap().addGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5).addGroup(jPanel8Layout.createSequentialGroup().addGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.bhead0).addComponent(this.bhead1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 81, Short.MAX_VALUE).addComponent(this.jPanel9, -2, -1, -2)).addComponent(this.bboth).addComponent(this.bfdi).addComponent(this.cdrive, -2, -1, -2)).addContainerGap()));
        jPanel8Layout.setVerticalGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel8Layout.createSequentialGroup().addGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel9, -2, -1, -2).addGroup(jPanel8Layout.createSequentialGroup().addComponent(this.jLabel5).addGap(5, 5, 5).addComponent(this.cdrive, -2, -1, -2).addGap(18, 18, 18).addComponent(this.bfdi).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.bboth).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.bhead0).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.bhead1))).addContainerGap()));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane7).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jPanel6, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel7, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel8, -2, -1, -2))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jPanel6, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel7, -1, -1, Short.MAX_VALUE)).addComponent(this.jPanel8, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane7, -1, 337, Short.MAX_VALUE).addContainerGap()));
        this.jTabbedPane1.addTab("Transfer", this.jPanel1);
        this.jPanel10.setBorder(BorderFactory.createTitledBorder("Select format"));
        this.buttonGroup4.add(this.jRadioButton2);
        this.jRadioButton2.setText("PARADOS 80");
        this.jRadioButton2.setFocusPainted(false);
        this.jRadioButton2.setFocusable(false);
        this.jRadioButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DSKUtil.this.jRadioButton2ActionPerformed(evt);
            }
        });
        this.buttonGroup4.add(this.jRadioButton8);
        this.jRadioButton8.setText("PARADOS 41");
        this.jRadioButton8.setFocusPainted(false);
        this.jRadioButton8.setFocusable(false);
        this.jRadioButton8.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DSKUtil.this.jRadioButton8ActionPerformed(evt);
            }
        });
        this.buttonGroup4.add(this.jRadioButton9);
        this.jRadioButton9.setText("PARADOS D40");
        this.jRadioButton9.setFocusPainted(false);
        this.jRadioButton9.setFocusable(false);
        this.jRadioButton9.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DSKUtil.this.jRadioButton9ActionPerformed(evt);
            }
        });
        this.buttonGroup4.add(this.jRadioButton1);
        this.jRadioButton1.setText("ROMDOS D1");
        this.jRadioButton1.setFocusPainted(false);
        this.jRadioButton1.setFocusable(false);
        this.jRadioButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DSKUtil.this.jRadioButton1ActionPerformed(evt);
            }
        });
        this.buttonGroup4.add(this.jRadioButton7);
        this.jRadioButton7.setText("ROMDOS D2");
        this.jRadioButton7.setFocusPainted(false);
        this.jRadioButton7.setFocusable(false);
        this.jRadioButton7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DSKUtil.this.jRadioButton7ActionPerformed(evt);
            }
        });
        this.buttonGroup4.add(this.jRadioButton11);
        this.jRadioButton11.setText("S-DOS (RDOS D80)");
        this.jRadioButton11.setFocusPainted(false);
        this.jRadioButton11.setFocusable(false);
        this.jRadioButton11.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DSKUtil.this.jRadioButton11ActionPerformed(evt);
            }
        });
        this.buttonGroup4.add(this.jRadioButton12);
        this.jRadioButton12.setText("ROMDOS D10");
        this.jRadioButton12.setFocusPainted(false);
        this.jRadioButton12.setFocusable(false);
        this.jRadioButton12.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DSKUtil.this.jRadioButton12ActionPerformed(evt);
            }
        });
        this.buttonGroup4.add(this.jRadioButton3);
        this.jRadioButton3.setText("ROMDOS D20");
        this.jRadioButton3.setFocusPainted(false);
        this.jRadioButton3.setFocusable(false);
        this.jRadioButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DSKUtil.this.jRadioButton3ActionPerformed(evt);
            }
        });
        this.buttonGroup4.add(this.jRadioButton6);
        this.jRadioButton6.setText("ROMDOS D40");
        this.jRadioButton6.setFocusPainted(false);
        this.jRadioButton6.setFocusable(false);
        this.jRadioButton6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DSKUtil.this.jRadioButton6ActionPerformed(evt);
            }
        });
        this.buttonGroup4.add(this.jRadioButton4);
        this.jRadioButton4.setSelected(true);
        this.jRadioButton4.setText("DATA (SS 40)");
        this.jRadioButton4.setFocusPainted(false);
        this.jRadioButton4.setFocusable(false);
        this.jRadioButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DSKUtil.this.jRadioButton4ActionPerformed(evt);
            }
        });
        this.buttonGroup4.add(this.jRadioButton5);
        this.jRadioButton5.setText("DATA (DS 40)");
        this.jRadioButton5.setFocusPainted(false);
        this.jRadioButton5.setFocusable(false);
        this.jRadioButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DSKUtil.this.jRadioButton5ActionPerformed(evt);
            }
        });
        this.buttonGroup4.add(this.jRadioButton10);
        this.jRadioButton10.setText("DATA (SS 80)");
        this.jRadioButton10.setFocusPainted(false);
        this.jRadioButton10.setFocusable(false);
        this.jRadioButton10.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DSKUtil.this.jRadioButton10ActionPerformed(evt);
            }
        });
        this.buttonGroup4.add(this.jRadioButton13);
        this.jRadioButton13.setText("DATA (DS 80)");
        this.jRadioButton13.setFocusPainted(false);
        this.jRadioButton13.setFocusable(false);
        this.jRadioButton13.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DSKUtil.this.jRadioButton13ActionPerformed(evt);
            }
        });
        this.buttonGroup4.add(this.jRadioButton14);
        this.jRadioButton14.setText("SYSTEM (SS 40)");
        this.jRadioButton14.setFocusPainted(false);
        this.jRadioButton14.setFocusable(false);
        this.jRadioButton14.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DSKUtil.this.jRadioButton14ActionPerformed(evt);
            }
        });
        this.buttonGroup4.add(this.jRadioButton15);
        this.jRadioButton15.setText("SYSTEM (DS 40)");
        this.jRadioButton15.setFocusPainted(false);
        this.jRadioButton15.setFocusable(false);
        this.jRadioButton15.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DSKUtil.this.jRadioButton15ActionPerformed(evt);
            }
        });
        this.buttonGroup4.add(this.jRadioButton16);
        this.jRadioButton16.setText("SYSTEM (SS 80)");
        this.jRadioButton16.setFocusPainted(false);
        this.jRadioButton16.setFocusable(false);
        this.jRadioButton16.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DSKUtil.this.jRadioButton16ActionPerformed(evt);
            }
        });
        this.buttonGroup4.add(this.jRadioButton18);
        this.jRadioButton18.setText("SYSTEM (DS 80)");
        this.jRadioButton18.setFocusPainted(false);
        this.jRadioButton18.setFocusable(false);
        this.jRadioButton18.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DSKUtil.this.jRadioButton18ActionPerformed(evt);
            }
        });
        this.buttonGroup4.add(this.jRadioButton17);
        this.jRadioButton17.setText("IBM (SS 40)");
        this.jRadioButton17.setFocusPainted(false);
        this.jRadioButton17.setFocusable(false);
        this.jRadioButton17.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DSKUtil.this.jRadioButton17ActionPerformed(evt);
            }
        });
        this.buttonGroup4.add(this.jRadioButton22);
        this.jRadioButton22.setText("IBM (DS 40)");
        this.jRadioButton22.setFocusPainted(false);
        this.jRadioButton22.setFocusable(false);
        this.jRadioButton22.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DSKUtil.this.jRadioButton22ActionPerformed(evt);
            }
        });
        this.buttonGroup4.add(this.jRadioButton21);
        this.jRadioButton21.setText("IBM (SS 80)");
        this.jRadioButton21.setFocusPainted(false);
        this.jRadioButton21.setFocusable(false);
        this.jRadioButton21.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DSKUtil.this.jRadioButton21ActionPerformed(evt);
            }
        });
        this.buttonGroup4.add(this.jRadioButton19);
        this.jRadioButton19.setText("IBM (DS 80)");
        this.jRadioButton19.setFocusPainted(false);
        this.jRadioButton19.setFocusable(false);
        this.jRadioButton19.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DSKUtil.this.jRadioButton19ActionPerformed(evt);
            }
        });
        this.buttonGroup4.add(this.jRadioButton23);
        this.jRadioButton23.setText("VORTEX (DS 80)");
        this.jRadioButton23.setFocusPainted(false);
        this.jRadioButton23.setFocusable(false);
        this.jRadioButton23.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DSKUtil.this.jRadioButton23ActionPerformed(evt);
            }
        });
        this.buttonGroup4.add(this.jRadioButton20);
        this.jRadioButton20.setText("ULTRAFORM");
        this.jRadioButton20.setFocusPainted(false);
        this.jRadioButton20.setFocusable(false);
        this.jRadioButton20.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DSKUtil.this.jRadioButton20ActionPerformed(evt);
            }
        });
        this.jButton6.setText("Format");
        this.jButton6.setFocusPainted(false);
        this.jButton6.setFocusable(false);
        this.jButton6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DSKUtil.this.jButton6ActionPerformed(evt);
            }
        });
        this.selform.setFont(new Font("Tahoma", 1, 11));
        this.selform.setForeground(new Color(255, 0, 0));
        this.selform.setText("Selected Format: DATA (SS 40)");
        this.also.setText("Also format drive A:");
        this.also.setFocusPainted(false);
        this.also.setFocusable(false);
        GroupLayout jPanel10Layout = new GroupLayout(this.jPanel10);
        this.jPanel10.setLayout(jPanel10Layout);
        jPanel10Layout.setHorizontalGroup(jPanel10Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel10Layout.createSequentialGroup().addContainerGap().addGroup(jPanel10Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel10Layout.createSequentialGroup().addGroup(jPanel10Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, jPanel10Layout.createSequentialGroup().addComponent(this.jRadioButton10).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 88, Short.MAX_VALUE).addComponent(this.jRadioButton13)).addGroup(jPanel10Layout.createSequentialGroup().addComponent(this.jRadioButton12).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 87, Short.MAX_VALUE).addGroup(jPanel10Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel10Layout.createSequentialGroup().addGroup(jPanel10Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButton8).addComponent(this.jRadioButton7)).addGap(3, 3, 3)).addComponent(this.jRadioButton3))).addComponent(this.jRadioButton5)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel10Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButton6).addComponent(this.jRadioButton11).addComponent(this.jRadioButton9).addGroup(jPanel10Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(jPanel10Layout.createSequentialGroup().addComponent(this.jRadioButton14).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jRadioButton15)).addGroup(GroupLayout.Alignment.LEADING, jPanel10Layout.createSequentialGroup().addComponent(this.jRadioButton16).addGap(29, 29, 29).addComponent(this.jRadioButton18)))).addGap(122, 122, 122)).addGroup(jPanel10Layout.createSequentialGroup().addGroup(jPanel10Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButton4).addComponent(this.jRadioButton2).addComponent(this.jRadioButton1)).addContainerGap(-1, Short.MAX_VALUE)))).addGroup(jPanel10Layout.createSequentialGroup().addGap(10, 10, 10).addGroup(jPanel10Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel10Layout.createSequentialGroup().addComponent(this.jRadioButton17).addGap(18, 18, 18).addComponent(this.jRadioButton22).addGap(18, 18, 18).addComponent(this.jRadioButton23)).addGroup(jPanel10Layout.createSequentialGroup().addComponent(this.jRadioButton21).addGap(18, 18, 18).addComponent(this.jRadioButton19).addGap(18, 18, 18).addComponent(this.jRadioButton20))).addContainerGap(319, Short.MAX_VALUE)).addGroup(jPanel10Layout.createSequentialGroup().addContainerGap().addGroup(jPanel10Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.selform).addGroup(jPanel10Layout.createSequentialGroup().addComponent(this.jButton6).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.also))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dsk, -1, 306, Short.MAX_VALUE).addGap(122, 122, 122)));
        jPanel10Layout.setVerticalGroup(jPanel10Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel10Layout.createSequentialGroup().addGroup(jPanel10Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButton2).addComponent(this.jRadioButton9).addComponent(this.jRadioButton8)).addGap(18, 18, 18).addGroup(jPanel10Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButton1).addComponent(this.jRadioButton11).addComponent(this.jRadioButton7)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel10Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButton12).addComponent(this.jRadioButton3).addComponent(this.jRadioButton6)).addGap(8, 8, 8).addGroup(jPanel10Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButton4).addGroup(jPanel10Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButton5).addComponent(this.jRadioButton14).addComponent(this.jRadioButton15))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel10Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel10Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButton13).addComponent(this.jRadioButton16)).addComponent(this.jRadioButton18).addComponent(this.jRadioButton10)).addGap(18, 18, 18).addGroup(jPanel10Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButton17).addGroup(jPanel10Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButton22).addComponent(this.jRadioButton23))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel10Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButton21).addGroup(jPanel10Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButton19).addComponent(this.jRadioButton20))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel10Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel10Layout.createSequentialGroup().addComponent(this.selform).addGap(3, 3, 3).addGroup(jPanel10Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton6).addComponent(this.also))).addComponent(this.dsk, -2, 20, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel10, -1, -1, Short.MAX_VALUE).addContainerGap()));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel10, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.jTabbedPane1.addTab("Format / Create DSK", this.jPanel5);
        this.jPanel14.setLayout(new BorderLayout());
        this.hex.setMaximumSize(new Dimension(Integer.MAX_VALUE, 600));
        this.jLabel12.setText("Track:");
        this.trackBox.setFont(new Font("Monospaced", 0, 12));
        this.trackBox.setFocusable(false);
        this.trackBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                DSKUtil.this.trackBoxItemStateChanged(evt);
            }
        });
        this.jLabel13.setText("Sector:");
        this.sectorBox.setFont(new Font("Monospaced", 0, 12));
        this.sectorBox.setFocusable(false);
        this.sectorBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                DSKUtil.this.sectorBoxItemStateChanged(evt);
            }
        });
        this.jButton11.setText("Save");
        this.jButton11.setFocusable(false);
        this.jButton11.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DSKUtil.this.jButton11ActionPerformed(evt);
            }
        });
        GroupLayout jPanel16Layout = new GroupLayout(this.jPanel16);
        this.jPanel16.setLayout(jPanel16Layout);
        jPanel16Layout.setHorizontalGroup(jPanel16Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel16Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel12).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.trackBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel13).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sectorBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButton11).addContainerGap()));
        jPanel16Layout.setVerticalGroup(jPanel16Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel16Layout.createSequentialGroup().addContainerGap().addGroup(jPanel16Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel12).addComponent(this.trackBox, -2, -1, -2).addComponent(this.jLabel13).addComponent(this.sectorBox, -2, -1, -2).addComponent(this.jButton11)).addContainerGap(-1, Short.MAX_VALUE)));
        this.hexi.setLayout(new BorderLayout());
        GroupLayout hexLayout = new GroupLayout(this.hex);
        this.hex.setLayout(hexLayout);
        hexLayout.setHorizontalGroup(hexLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel16, -1, -1, Short.MAX_VALUE).addGroup(hexLayout.createSequentialGroup().addContainerGap().addComponent(this.hexi, -2, 604, -2).addContainerGap(49, Short.MAX_VALUE)));
        hexLayout.setVerticalGroup(hexLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(hexLayout.createSequentialGroup().addComponent(this.jPanel16, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.hexi, -2, 480, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel14.add((Component)this.hex, "Center");
        this.jTabbedPane1.addTab("Hex Editor", this.jPanel14);
        this.ascii.setText("ASCII");
        this.ascii.setFocusPainted(false);
        this.ascii.setFocusable(false);
        this.txtinfo.setText("Create txt info");
        this.txtinfo.setFocusPainted(false);
        this.txtinfo.setFocusable(false);
        this.jButton10.setText("Write Textinfo");
        this.jButton10.setFocusPainted(false);
        this.jButton10.setFocusable(false);
        this.jButton10.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DSKUtil.this.jButton10ActionPerformed(evt);
            }
        });
        GroupLayout disktoolsLayout = new GroupLayout(this.disktools);
        this.disktools.setLayout(disktoolsLayout);
        disktoolsLayout.setHorizontalGroup(disktoolsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTabbedPane1).addGroup(disktoolsLayout.createSequentialGroup().addContainerGap().addGroup(disktoolsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(disktoolsLayout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.space).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.txtinfo).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButton10)).addGroup(disktoolsLayout.createSequentialGroup().addComponent(this.jToggleButton2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jToggleButton1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.load).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.seldsk).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3).addGap(4, 4, 4).addComponent(this.user, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.ascii).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        disktoolsLayout.setVerticalGroup(disktoolsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(disktoolsLayout.createSequentialGroup().addContainerGap().addGroup(disktoolsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jToggleButton2).addComponent(this.jToggleButton1).addComponent(this.load).addComponent(this.jButton1).addComponent(this.seldsk).addComponent(this.jLabel3).addComponent(this.user, -2, -1, -2).addComponent(this.ascii)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTabbedPane1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(disktoolsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.space).addComponent(this.txtinfo).addComponent(this.jButton10, -2, 23, -2))));
        this.output1.setEditable(false);
        this.output1.setColumns(20);
        this.output1.setFont(new Font("Monospaced", 1, 11));
        this.output1.setRows(5);
        this.console1.setFont(new Font("Monospaced", 1, 12));
        this.console1.setComponentPopupMenu(this.jPopupMenu1);
        this.console1.setValueIsAdjusting(true);
        this.console1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DSKUtil.this.consoleMouseClicked(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                DSKUtil.this.consoleMousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                DSKUtil.this.consoleMouseReleased(evt);
            }
        });
        this.console1.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent evt) {
                DSKUtil.this.consoleComponentMoved(evt);
            }
        });
        this.console1.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                DSKUtil.this.consoleMouseDragged(evt);
            }
        });
        this.setDefaultCloseOperation(3);
        this.setTitle("JavaCPC - DSKUtil");
        this.setResizable(false);
        this.pack();
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        this.checkDump();
        this.getFromDSK();
    }

    private void seldskActionPerformed(ActionEvent evt) {
        this.checkDump();
        this.Delete();
    }

    private void jToggleButton2ActionPerformed(ActionEvent evt) {
        if (this.jToggleButton2.isSelected()) {
            this.selectedDrive = 0;
            this.checkDump();
            this.DIR(0);
        }
    }

    private void jToggleButton1ActionPerformed(ActionEvent evt) {
        if (this.jToggleButton1.isSelected()) {
            this.selectedDrive = 1;
            this.checkDump();
            this.DIR(1);
        }
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.checkDump();
        this.eject(this.drives);
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.checkDump();
        this.protect();
    }

    private void jButton5ActionPerformed(ActionEvent evt) {
        this.checkDump();
        this.hide();
    }

    private void loadActionPerformed(ActionEvent evt) {
        this.checkDump();
        this.loadDSK();
    }

    private void jTabbedPane1MousePressed(MouseEvent evt) {
        this.checkDump();
    }

    private void bfdiActionPerformed(ActionEvent evt) {
        if (this.bfdi.isSelected()) {
            this.flop.setIcon(new ImageIcon(this.getClass().getResource("/jemu/ui/dskutil/3inch.gif")));
        } else {
            this.flop.setIcon(new ImageIcon(this.getClass().getResource("/jemu/ui/dskutil/35inch.gif")));
        }
    }

    private void bbothActionPerformed(ActionEvent evt) {
        if (this.bfdi.isSelected()) {
            this.flop.setIcon(new ImageIcon(this.getClass().getResource("/jemu/ui/dskutil/3inch.gif")));
        } else {
            this.flop.setIcon(new ImageIcon(this.getClass().getResource("/jemu/ui/dskutil/35inch.gif")));
        }
    }

    private void bhead0ActionPerformed(ActionEvent evt) {
        if (this.bfdi.isSelected()) {
            this.flop.setIcon(new ImageIcon(this.getClass().getResource("/jemu/ui/dskutil/3inch.gif")));
        } else {
            this.flop.setIcon(new ImageIcon(this.getClass().getResource("/jemu/ui/dskutil/35inch.gif")));
        }
    }

    private void bhead1ActionPerformed(ActionEvent evt) {
        if (this.bfdi.isSelected()) {
            this.flop.setIcon(new ImageIcon(this.getClass().getResource("/jemu/ui/dskutil/3inch.gif")));
        } else {
            this.flop.setIcon(new ImageIcon(this.getClass().getResource("/jemu/ui/dskutil/35inch.gif")));
        }
    }

    private void bstartActionPerformed(ActionEvent evt) {
        int ok;
        if (this.jToggleButton3.isSelected() ? (ok = JOptionPane.showConfirmDialog(new Frame(), "Your DSK " + this.actualdsk + "\r\nwill be overwitten!\r\nAre you sure to proceed?", "Confirm transfer", 0)) != 0 : (ok = JOptionPane.showConfirmDialog(new Frame(), "Your Disk in drive " + this.drive[this.cdrive.getSelectedIndex()].toUpperCase() + "\r\nwill be overwitten!\r\nAre you sure to proceed?", "Confirm transfer", 0)) != 0) {
            return;
        }
        if (this.process == null) {
            Thread runner = new Thread(){

                @Override
                public void run() {
                    try {
                        DSKUtil.this.Launch(DSKUtil.this.jToggleButton3.isSelected());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
            runner.start();
        }
    }

    private void bstopActionPerformed(ActionEvent evt) {
        if (this.process != null) {
            int ok;
            if (this.jToggleButton3.isSelected() ? (ok = JOptionPane.showConfirmDialog(new Frame(), "Your DSK " + this.actualdsk + "\r\nhas not been changed yet!\r\nAre you sure to abort?", "Confirm abort transfer", 0)) != 0 : (ok = JOptionPane.showConfirmDialog(new Frame(), "Your Disk in drive " + this.drive[this.cdrive.getSelectedIndex()] + "\r\nis probably damaged.\r\nAre you sure to abort?", "Confirm abort transfer", 0)) != 0) {
                return;
            }
            this.process.destroy();
            this.text.append("Progress aborted...\r\n");
            this.progress.setIndeterminate(false);
            this.bstart.setEnabled(true);
            this.bstop.setEnabled(false);
            this.jTabbedPane1.setEnabled(true);
            this.jToggleButton1.setEnabled(true);
            this.jToggleButton2.setEnabled(true);
            this.load.setEnabled(true);
            this.jButton1.setEnabled(true);
            this.seldsk.setEnabled(true);
            this.prog = 0;
        }
    }

    private void jRadioButton2ActionPerformed(ActionEvent evt) {
        this.index = 0;
        this.also.setVisible(false);
        this.selform.setText(this.selected + "PARADOS 80");
        this.dsk.setText(this.DSKImages[this.index]);
    }

    private void jRadioButton8ActionPerformed(ActionEvent evt) {
        this.index = 1;
        this.also.setVisible(false);
        this.selform.setText(this.selected + "PARADOS 41");
        this.dsk.setText(this.DSKImages[this.index]);
    }

    private void jRadioButton9ActionPerformed(ActionEvent evt) {
        this.index = 2;
        this.also.setVisible(false);
        this.selform.setText(this.selected + "PARADOS 40D");
        this.dsk.setText(this.DSKImages[this.index]);
    }

    private void jRadioButton1ActionPerformed(ActionEvent evt) {
        this.index = 3;
        this.also.setVisible(false);
        this.selform.setText(this.selected + "ROMDOS D1");
        this.dsk.setText(this.DSKImages[this.index]);
    }

    private void jRadioButton7ActionPerformed(ActionEvent evt) {
        this.index = 4;
        this.also.setVisible(false);
        this.selform.setText(this.selected + "ROMDOS D2");
        this.dsk.setText(this.DSKImages[this.index]);
    }

    private void jRadioButton11ActionPerformed(ActionEvent evt) {
        this.index = 8;
        this.also.setVisible(false);
        this.selform.setText(this.selected + "S-DOS (ROMDOS D80)");
        this.dsk.setText(this.DSKImages[this.index]);
    }

    private void jRadioButton12ActionPerformed(ActionEvent evt) {
        this.index = 5;
        this.also.setVisible(false);
        this.selform.setText(this.selected + "ROMDOS D10");
        this.dsk.setText(this.DSKImages[this.index]);
    }

    private void jRadioButton3ActionPerformed(ActionEvent evt) {
        this.index = 6;
        this.also.setVisible(false);
        this.selform.setText(this.selected + "ROMDOS D20");
        this.dsk.setText(this.DSKImages[this.index]);
    }

    private void jRadioButton6ActionPerformed(ActionEvent evt) {
        this.index = 7;
        this.also.setVisible(false);
        this.selform.setText(this.selected + "ROMDOS D40");
        this.dsk.setText(this.DSKImages[this.index]);
    }

    private void jRadioButton4ActionPerformed(ActionEvent evt) {
        this.index = 9;
        this.also.setVisible(false);
        this.also.setVisible(true);
        this.selform.setText(this.selected + "DATA (SS 40)");
        this.dsk.setText(this.DSKImages[this.index]);
    }

    private void jRadioButton5ActionPerformed(ActionEvent evt) {
        this.index = 10;
        this.also.setVisible(false);
        this.selform.setText(this.selected + "DATA (DS 40)");
        this.dsk.setText(this.DSKImages[this.index]);
    }

    private void jRadioButton10ActionPerformed(ActionEvent evt) {
        this.index = 11;
        this.also.setVisible(false);
        this.selform.setText(this.selected + "DATA (SS 80)");
        this.dsk.setText(this.DSKImages[this.index]);
    }

    private void jRadioButton13ActionPerformed(ActionEvent evt) {
        this.index = 12;
        this.also.setVisible(false);
        this.selform.setText(this.selected + "DATA (DS 80)");
        this.dsk.setText(this.DSKImages[this.index]);
    }

    private void jRadioButton14ActionPerformed(ActionEvent evt) {
        this.index = 13;
        this.also.setVisible(true);
        this.selform.setText(this.selected + "SYSTEM (SS 40)");
        this.dsk.setText(this.DSKImages[this.index]);
    }

    private void jRadioButton15ActionPerformed(ActionEvent evt) {
        this.index = 14;
        this.also.setVisible(false);
        this.selform.setText(this.selected + "SYSTEM (DS 40)");
        this.dsk.setText(this.DSKImages[this.index]);
    }

    private void jRadioButton16ActionPerformed(ActionEvent evt) {
        this.index = 15;
        this.also.setVisible(false);
        this.selform.setText(this.selected + "SYSTEM (SS 80)");
        this.dsk.setText(this.DSKImages[this.index]);
    }

    private void jRadioButton18ActionPerformed(ActionEvent evt) {
        this.index = 16;
        this.also.setVisible(false);
        this.selform.setText(this.selected + "SYSTEM (DS 80)");
        this.dsk.setText(this.DSKImages[this.index]);
    }

    private void jRadioButton17ActionPerformed(ActionEvent evt) {
        this.index = 17;
        this.also.setVisible(true);
        this.selform.setText(this.selected + "IBM (SS 40)");
        this.dsk.setText(this.DSKImages[this.index]);
    }

    private void jRadioButton22ActionPerformed(ActionEvent evt) {
        this.index = 18;
        this.also.setVisible(false);
        this.selform.setText(this.selected + "IBM (DS 40)");
        this.dsk.setText(this.DSKImages[this.index]);
    }

    private void jRadioButton21ActionPerformed(ActionEvent evt) {
        this.index = 19;
        this.also.setVisible(false);
        this.selform.setText(this.selected + "IBM (SS 80)");
        this.dsk.setText(this.DSKImages[this.index]);
    }

    private void jRadioButton19ActionPerformed(ActionEvent evt) {
        this.index = 20;
        this.also.setVisible(false);
        this.selform.setText(this.selected + "IBM (DS 80)");
        this.dsk.setText(this.DSKImages[this.index]);
    }

    private void jRadioButton23ActionPerformed(ActionEvent evt) {
        this.index = 22;
        this.also.setVisible(false);
        this.selform.setText(this.selected + "VORTEX (DS 80)");
        this.dsk.setText(this.DSKImages[this.index]);
    }

    private void jRadioButton20ActionPerformed(ActionEvent evt) {
        this.index = 21;
        this.also.setVisible(false);
        this.selform.setText(this.selected + "ULTRAFORM");
        this.dsk.setText(this.DSKImages[this.index]);
    }

    private void jButton6ActionPerformed(ActionEvent evt) {
        this.formatDisk(this.index);
    }

    private void cdriveActionPerformed(ActionEvent evt) {
        this.also.setText("Also format drive " + this.drive[this.cdrive.getSelectedIndex()].toUpperCase());
    }

    private void jMenuItem1ActionPerformed(ActionEvent evt) {
        this.checkDump();
        this.getFromDSK();
    }

    private void jMenuItem2ActionPerformed(ActionEvent evt) {
        this.checkDump();
        this.protect();
    }

    private void jMenuItem3ActionPerformed(ActionEvent evt) {
        this.checkDump();
        this.hide();
    }

    private void jMenuItem4ActionPerformed(ActionEvent evt) {
        this.checkDump();
        this.Delete();
    }

    private void jScrollPane1PropertyChange(PropertyChangeEvent evt) {
    }

    private void consoleMouseDragged(MouseEvent evt) {
        this.sizelist.setSelectedIndices(this.console.getSelectedIndices());
        this.userlist.setSelectedIndices(this.console.getSelectedIndices());
        this.system.setSelectedIndices(this.console.getSelectedIndices());
        this.protec.setSelectedIndices(this.console.getSelectedIndices());
        this.selectedFiles = this.console.getSelectedIndices();
        this.updateRenName();
    }

    private void consoleComponentMoved(ComponentEvent evt) {
        this.sizelist.scrollRectToVisible(this.console.getVisibleRect());
        this.userlist.scrollRectToVisible(this.console.getVisibleRect());
        this.system.scrollRectToVisible(this.console.getVisibleRect());
        this.protec.scrollRectToVisible(this.console.getVisibleRect());
    }

    private void consoleMouseReleased(MouseEvent evt) {
        this.sizelist.setSelectedIndices(this.console.getSelectedIndices());
        this.userlist.setSelectedIndices(this.console.getSelectedIndices());
        this.system.setSelectedIndices(this.console.getSelectedIndices());
        this.protec.setSelectedIndices(this.console.getSelectedIndices());
        this.selectedFiles = this.console.getSelectedIndices();
        this.updateRenName();
    }

    private void consoleMousePressed(MouseEvent evt) {
        this.sizelist.setSelectedIndices(this.console.getSelectedIndices());
        this.userlist.setSelectedIndices(this.console.getSelectedIndices());
        this.system.setSelectedIndices(this.console.getSelectedIndices());
        this.protec.setSelectedIndices(this.console.getSelectedIndices());
        this.selectedFiles = this.console.getSelectedIndices();
        this.updateRenName();
    }

    private void consoleMouseClicked(MouseEvent evt) {
        this.sizelist.setSelectedIndices(this.console.getSelectedIndices());
        this.userlist.setSelectedIndices(this.console.getSelectedIndices());
        this.system.setSelectedIndices(this.console.getSelectedIndices());
        this.protec.setSelectedIndices(this.console.getSelectedIndices());
        this.selectedFiles = this.console.getSelectedIndices();
        this.updateRenName();
    }

    private void systemMouseClicked(MouseEvent evt) {
        this.sizelist.setSelectedIndices(this.system.getSelectedIndices());
        this.userlist.setSelectedIndices(this.system.getSelectedIndices());
        this.console.setSelectedIndices(this.system.getSelectedIndices());
        this.protec.setSelectedIndices(this.system.getSelectedIndices());
        this.selectedFiles = this.console.getSelectedIndices();
        this.updateRenName();
    }

    private void systemMouseDragged(MouseEvent evt) {
        this.sizelist.setSelectedIndices(this.system.getSelectedIndices());
        this.userlist.setSelectedIndices(this.system.getSelectedIndices());
        this.console.setSelectedIndices(this.system.getSelectedIndices());
        this.protec.setSelectedIndices(this.system.getSelectedIndices());
        this.selectedFiles = this.console.getSelectedIndices();
        this.updateRenName();
    }

    private void systemMousePressed(MouseEvent evt) {
        this.sizelist.setSelectedIndices(this.system.getSelectedIndices());
        this.userlist.setSelectedIndices(this.system.getSelectedIndices());
        this.console.setSelectedIndices(this.system.getSelectedIndices());
        this.protec.setSelectedIndices(this.system.getSelectedIndices());
        this.selectedFiles = this.console.getSelectedIndices();
        this.updateRenName();
    }

    private void systemMouseReleased(MouseEvent evt) {
        this.sizelist.setSelectedIndices(this.system.getSelectedIndices());
        this.userlist.setSelectedIndices(this.system.getSelectedIndices());
        this.console.setSelectedIndices(this.system.getSelectedIndices());
        this.protec.setSelectedIndices(this.system.getSelectedIndices());
        this.selectedFiles = this.console.getSelectedIndices();
        this.updateRenName();
    }

    private void protecMouseClicked(MouseEvent evt) {
        this.sizelist.setSelectedIndices(this.protec.getSelectedIndices());
        this.userlist.setSelectedIndices(this.protec.getSelectedIndices());
        this.console.setSelectedIndices(this.protec.getSelectedIndices());
        this.system.setSelectedIndices(this.protec.getSelectedIndices());
        this.selectedFiles = this.console.getSelectedIndices();
        this.updateRenName();
    }

    private void protecMouseDragged(MouseEvent evt) {
        this.sizelist.setSelectedIndices(this.protec.getSelectedIndices());
        this.userlist.setSelectedIndices(this.protec.getSelectedIndices());
        this.console.setSelectedIndices(this.protec.getSelectedIndices());
        this.system.setSelectedIndices(this.protec.getSelectedIndices());
        this.selectedFiles = this.console.getSelectedIndices();
        this.updateRenName();
    }

    private void protecMousePressed(MouseEvent evt) {
        this.sizelist.setSelectedIndices(this.protec.getSelectedIndices());
        this.userlist.setSelectedIndices(this.protec.getSelectedIndices());
        this.console.setSelectedIndices(this.protec.getSelectedIndices());
        this.system.setSelectedIndices(this.protec.getSelectedIndices());
        this.selectedFiles = this.console.getSelectedIndices();
        this.updateRenName();
    }

    private void protecMouseReleased(MouseEvent evt) {
        this.sizelist.setSelectedIndices(this.protec.getSelectedIndices());
        this.userlist.setSelectedIndices(this.protec.getSelectedIndices());
        this.console.setSelectedIndices(this.protec.getSelectedIndices());
        this.system.setSelectedIndices(this.protec.getSelectedIndices());
        this.selectedFiles = this.console.getSelectedIndices();
        this.updateRenName();
    }

    private void sizelistMouseClicked(MouseEvent evt) {
        this.protec.setSelectedIndices(this.sizelist.getSelectedIndices());
        this.userlist.setSelectedIndices(this.sizelist.getSelectedIndices());
        this.console.setSelectedIndices(this.sizelist.getSelectedIndices());
        this.system.setSelectedIndices(this.sizelist.getSelectedIndices());
        this.selectedFiles = this.console.getSelectedIndices();
        this.updateRenName();
    }

    private void sizelistMouseDragged(MouseEvent evt) {
        this.protec.setSelectedIndices(this.sizelist.getSelectedIndices());
        this.userlist.setSelectedIndices(this.sizelist.getSelectedIndices());
        this.console.setSelectedIndices(this.sizelist.getSelectedIndices());
        this.system.setSelectedIndices(this.sizelist.getSelectedIndices());
        this.selectedFiles = this.console.getSelectedIndices();
        this.updateRenName();
    }

    private void sizelistMousePressed(MouseEvent evt) {
        this.protec.setSelectedIndices(this.sizelist.getSelectedIndices());
        this.userlist.setSelectedIndices(this.sizelist.getSelectedIndices());
        this.console.setSelectedIndices(this.sizelist.getSelectedIndices());
        this.system.setSelectedIndices(this.sizelist.getSelectedIndices());
        this.selectedFiles = this.console.getSelectedIndices();
        this.updateRenName();
    }

    private void sizelistMouseReleased(MouseEvent evt) {
        this.protec.setSelectedIndices(this.sizelist.getSelectedIndices());
        this.userlist.setSelectedIndices(this.sizelist.getSelectedIndices());
        this.console.setSelectedIndices(this.sizelist.getSelectedIndices());
        this.system.setSelectedIndices(this.sizelist.getSelectedIndices());
        this.selectedFiles = this.console.getSelectedIndices();
        this.updateRenName();
    }

    private void userlistMouseClicked(MouseEvent evt) {
        this.protec.setSelectedIndices(this.userlist.getSelectedIndices());
        this.sizelist.setSelectedIndices(this.userlist.getSelectedIndices());
        this.console.setSelectedIndices(this.userlist.getSelectedIndices());
        this.system.setSelectedIndices(this.userlist.getSelectedIndices());
        this.selectedFiles = this.console.getSelectedIndices();
        this.updateRenName();
    }

    private void userlistMouseDragged(MouseEvent evt) {
        this.protec.setSelectedIndices(this.userlist.getSelectedIndices());
        this.sizelist.setSelectedIndices(this.userlist.getSelectedIndices());
        this.console.setSelectedIndices(this.userlist.getSelectedIndices());
        this.system.setSelectedIndices(this.userlist.getSelectedIndices());
        this.selectedFiles = this.console.getSelectedIndices();
        this.updateRenName();
    }

    private void userlistMousePressed(MouseEvent evt) {
        this.protec.setSelectedIndices(this.userlist.getSelectedIndices());
        this.sizelist.setSelectedIndices(this.userlist.getSelectedIndices());
        this.console.setSelectedIndices(this.userlist.getSelectedIndices());
        this.system.setSelectedIndices(this.userlist.getSelectedIndices());
        this.selectedFiles = this.console.getSelectedIndices();
        this.updateRenName();
    }

    private void userlistMouseReleased(MouseEvent evt) {
        this.protec.setSelectedIndices(this.userlist.getSelectedIndices());
        this.sizelist.setSelectedIndices(this.userlist.getSelectedIndices());
        this.console.setSelectedIndices(this.userlist.getSelectedIndices());
        this.system.setSelectedIndices(this.userlist.getSelectedIndices());
        this.selectedFiles = this.console.getSelectedIndices();
        this.updateRenName();
    }

    private void jButton4ActionPerformed(ActionEvent evt) {
        this.writeEyeCatcher();
        this.DIR(this.drives);
    }

    private void jButton7ActionPerformed(ActionEvent evt) {
        this.rename(this.renamefield.getText());
    }

    private void jButton8ActionPerformed(ActionEvent evt) {
        this.writeFileTo();
    }

    private void jButton9ActionPerformed(ActionEvent evt) {
        this.changeUser();
    }

    private void jButton10ActionPerformed(ActionEvent evt) {
        this.txtinfo.setSelected(true);
        this.DIR(this.drives);
        this.txtinfo.setSelected(false);
    }

    private void trackBoxItemStateChanged(ItemEvent evt) {
        try {
            int startoff = 512;
            int trackIndex = this.trackBox.getSelectedIndex();
            int trackstart = (256 + this.diskTracks[this.trackBox.getSelectedIndex()].length) * trackIndex;
            startoff += trackstart;
            String unsorted = this.sectors[this.sectorBox.getSelectedIndex()];
            int sectorIndex = 0;
            for (int i = 0; i < this.sectorsSorted.length; ++i) {
                if (!unsorted.equals(this.sectors[i])) continue;
                sectorIndex = i;
            }
            startoff += sectorIndex * (this.diskTracks[this.trackBox.getSelectedIndex()].length / this.filesystem.getSectorIDs().length);
            this.edit.setIndex(startoff /= 16);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.edit.update(this.edit.getGraphics());
    }

    private void sectorBoxItemStateChanged(ItemEvent evt) {
        try {
            int startoff = 512;
            int trackIndex = this.trackBox.getSelectedIndex();
            int trackstart = (256 + this.diskTracks[this.trackBox.getSelectedIndex()].length) * trackIndex;
            startoff += trackstart;
            String unsorted = this.sectorsSorted[this.sectorBox.getSelectedIndex()];
            int sectorIndex = 0;
            for (int i = 0; i < this.sectorsSorted.length; ++i) {
                if (!unsorted.equals(this.sectors[i])) continue;
                sectorIndex = i;
            }
            startoff += sectorIndex * (this.diskTracks[this.trackBox.getSelectedIndex()].length / this.filesystem.getSectorIDs().length);
            this.edit.setIndex(startoff /= 16);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.edit.update(this.edit.getGraphics());
    }

    private void jButton11ActionPerformed(ActionEvent evt) {
        this.saveHexDump();
    }

    public void saveHexDump() {
        String disk = Settings.get("file.drive" + Integer.toString(this.drives), "empty");
        if (!disk.equals("empty")) {
            byte[] diskImage = this.edit.getContent();
            try {
                int drive = this.drives;
                File exp = new File(disk);
                BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(exp));
                bos.write(diskImage);
                bos.close();
                if (drive == 0) {
                    CPC.up0 = true;
                }
                if (drive == 1) {
                    CPC.up1 = true;
                }
                this.DIR(drive);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void jTabbedPane1StateChanged(ChangeEvent evt) {
        if (this.edit != null && this.edit.changed) {
            int n = JOptionPane.showConfirmDialog(this, "You edited the disk.\r\nSave changes?", "Please confirm", 0);
            if (n == 0) {
                this.saveHexDump();
            } else {
                this.DIR(this.drives);
            }
        }
        this.hexi.setVisible(this.jTabbedPane1.getSelectedIndex() == 4);
    }

    public void loadDisk(int drive) {
        if (drive == 0) {
            this.drives = 0;
            this.loadDSK(Settings.get("file.drive" + Integer.toString(0), "empty"));
        }
        if (drive == 1) {
            this.drives = 1;
            this.loadDSK(Settings.get("file.drive" + Integer.toString(1), "empty"));
        }
    }

    public String getRealName(String read, Boolean protect, Boolean hidden) {
        int p = (read.charAt(9) & 0x7F) + (protect != false ? 128 : 0);
        int h = (read.charAt(10) & 0x7F) + (hidden != false ? 128 : 0);
        String result = "";
        block4: for (int i = 0; i < read.length(); ++i) {
            if (i < 9 || i > 10) {
                result = result + read.charAt(i);
                continue;
            }
            switch (i) {
                case 9: {
                    result = result + (char)p;
                    continue block4;
                }
                case 10: {
                    result = result + (char)h;
                }
            }
        }
        return result;
    }

    public void updateRenName() {
        try {
            String get = this.items[this.selectedFiles[0]].toString();
            this.renamefield.setText(get);
            this.getInfo();
        }
        catch (Exception ex) {
            this.renamefield.setText("");
            this.getInfo();
        }
    }

    public void getInfo() {
        byte[] checkdata = null;
        if (this.selectedFiles == null || this.folder == null) {
            return;
        }
        String disk = Settings.get("file.drive" + Integer.toString(this.drives), "empty");
        if (disk == null) {
            return;
        }
        this.filesystem.loadDisk(disk);
        this.com = "";
        this.actualdsk = this.BufferDisk();
        try {
            String get = this.items[this.selectedFiles[0]].toString();
            String prot = this.rdonly[this.selectedFiles[0]].toString();
            String hidd = this.hidden[this.selectedFiles[0]].toString();
            System.out.println(prot);
            System.out.println(hidd);
            boolean isprotected = prot.length() > 2;
            boolean ishidden = hidd.length() > 2;
            String diskFile = this.getRealName(get, isprotected, ishidden);
            checkdata = this.filesystem.readFile(disk, diskFile);
            if (this.actualdsk.contains(System.getProperty("user.home") + "/javacpc/temp")) {
                this.actualdsk = this.eraseTemp();
            }
        }
        catch (Exception get) {
            // empty catch block
        }
        if (checkdata != null && checkdata.length > 0) {
            this.filename.setText(this.items[this.selectedFiles[0]].toString());
            if (this.CheckAMSDOS(checkdata)) {
                int i;
                String in = "";
                for (i = 1; i < 12; ++i) {
                    in = in + (char)checkdata[i];
                }
                this.realname.setText(in);
                i = Device.getWord(checkdata, 21);
                in = "#" + Util.hex((short)i);
                this.start.setText(in);
                i = Device.getWord(checkdata, 26);
                in = "#" + Util.hex((short)i);
                this.exec.setText(in);
                i = checkdata.length - 128;
                in = "#" + Util.hex((short)i);
                this.filesize.setText(in);
                i = checkdata[18];
                in = "UNKNOWN";
                if (i == 0) {
                    in = "BASIC";
                }
                if (i == 1) {
                    in = "BASIC (protected)";
                }
                if (i == 2) {
                    in = "BINARY";
                }
                if (i == 3) {
                    in = "BINARY (protected)";
                }
                if (i == 4) {
                    in = "IMAGE";
                }
                if (i == 5) {
                    in = "IMAGE (protected)";
                }
                if (i == 6) {
                    in = "ASCII";
                }
                if (i == 7) {
                    in = "ASCII (protected)";
                }
                this.filetype.setText(in);
            } else {
                this.realname.setText("");
                this.start.setText("");
                this.exec.setText("");
                int i = checkdata.length;
                String in = "#" + Util.hex((short)i);
                this.filesize.setText(in);
                this.filetype.setText("HEADERLESS");
            }
        }
    }

    public static int ChecksumAMSDOS(byte[] pHeader) {
        int Checksum2 = 0;
        for (int i = 0; i < 67; ++i) {
            int CheckSumByte = pHeader[i] & 0xFF;
            Checksum2 += CheckSumByte;
        }
        return Checksum2;
    }

    public boolean CheckAMSDOS(byte[] pHeader) {
        int ChecksumFromHeader = pHeader[67] & 0xFF | (pHeader[68] & 0xFF) << 8;
        int CalculatedChecksum = DSKUtil.ChecksumAMSDOS(pHeader);
        if (ChecksumFromHeader == CalculatedChecksum && ChecksumFromHeader != 0) {
            System.out.println("With header");
            return true;
        }
        System.out.println("Without header");
        return false;
    }

    public static void main(final String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                DSKUtil util = new DSKUtil();
                util.add(util.disktools);
                util.pack();
                util.setVisible(true);
                util.setResizable(true);
                if (args != null && args.length > 0) {
                    if (args[0].toLowerCase().endsWith(".dsk")) {
                        util.loadDSK(args[0]);
                    }
                    if (args.length > 1 && args[1].toLowerCase().endsWith(".dsk")) {
                        util.drives = 1;
                        util.loadDSK(args[1]);
                        util.drives = 0;
                        util.DIR(0);
                    }
                }
            }
        });
    }

    public static String dumpBytes(byte[] buffer) {
        return DSKUtil.dumpBytes(buffer, 0, buffer.length, true, true, true);
    }

    public static String dumpBytes(byte[] buffer, int start) {
        return DSKUtil.dumpBytes(buffer, 0, buffer.length, true, true, true, start);
    }

    public static String dumpBytes(int[] buffer) {
        return DSKUtil.dumpBytes(buffer, 0, buffer.length, true, true, true);
    }

    public static String dumpBytes(byte[] buffer, int offset, int length, boolean showAddr, boolean showChars, boolean lineFeed) {
        StringBuffer buff = new StringBuffer(80 * ((length += offset) + 15) / 16);
        for (int i = offset; i < length; i += 16) {
            int j;
            String end = "";
            if (showAddr) {
                buff.append(DSKUtil.hex(i) + ": ");
            }
            for (j = 0; j < 16 && i + j < length; ++j) {
                byte data = buffer[i + j];
                buff.append(DSKUtil.hex(data) + " ");
                end = end + (data >= 32 && data < 127 ? (char)data : (char)'.');
            }
            while (j < 16) {
                buff.append("   ");
                ++j;
            }
            if (showChars) {
                buff.append(end);
            }
            if (!lineFeed) continue;
            buff.append("\n");
        }
        return buff.toString();
    }

    public static String dumpBytes(byte[] buffer, int offset, int length, boolean showAddr, boolean showChars, boolean lineFeed, int start) {
        StringBuffer buff = new StringBuffer(80 * ((length += offset) + 15) / 16);
        for (int i = offset; i < length; i += 16) {
            int j;
            String end = "";
            if (showAddr) {
                buff.append(DSKUtil.hex(i + start) + ": ");
            }
            for (j = 0; j < 16 && i + j < length; ++j) {
                byte data = buffer[i + j];
                buff.append(DSKUtil.hex(data) + " ");
                end = end + (data >= 32 && data < 127 ? (char)data : (char)'.');
            }
            while (j < 16) {
                buff.append("   ");
                ++j;
            }
            if (showChars) {
                buff.append(end);
            }
            if (!lineFeed) continue;
            buff.append("\n");
        }
        return buff.toString();
    }

    public static String dumpBytes(int[] buffer, int offset, int length, boolean showAddr, boolean showChars, boolean lineFeed) {
        StringBuffer buff = new StringBuffer(80 * ((length += offset) + 15) / 16);
        for (int i = offset; i < length; i += 16) {
            int j;
            String end = "";
            if (showAddr) {
                buff.append(DSKUtil.hex(i) + ": ");
            }
            for (j = 0; j < 16 && i + j < length; ++j) {
                byte data = (byte)buffer[i + j];
                buff.append(DSKUtil.hex(data) + " ");
                end = end + (data >= 32 && data < 127 ? (char)data : (char)'.');
            }
            while (j < 16) {
                buff.append("   ");
                ++j;
            }
            if (showChars) {
                buff.append(end);
            }
            if (!lineFeed) continue;
            buff.append("\n");
        }
        return buff.toString();
    }

    public static String hex(byte value) {
        return "" + HEX_CHARS.charAt((value & 0xF0) >> 4) + HEX_CHARS.charAt(value & 0xF);
    }

    public static String hex(short value) {
        return DSKUtil.hex((byte)(value >> 8)) + DSKUtil.hex((byte)value);
    }

    public static String hex(int value) {
        return DSKUtil.hex((short)(value >> 16)) + DSKUtil.hex((short)value);
    }

    private class DropListener
    extends DropTargetAdapter {
        private DropListener() {
        }

        @Override
        public void drop(DropTargetDropEvent droptarget) {
            try {
                Transferable t = droptarget.getTransferable();
                if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    droptarget.acceptDrop(3);
                    Object userObject = t.getTransferData(DataFlavor.javaFileListFlavor);
                    if (userObject instanceof List) {
                        int i;
                        int count = 0;
                        String[] names = new String[1000];
                        for (int i2 = 0; i2 < names.length; ++i2) {
                            try {
                                names[i2] = ((List)userObject).get(i2).toString();
                                if (names[i2].toLowerCase().endsWith(".dsk")) {
                                    DSKUtil.this.loadDSK(names[i2]);
                                    return;
                                }
                                ++count;
                                continue;
                            }
                            catch (Exception e) {
                                break;
                            }
                        }
                        String[] get = new String[count];
                        for (i = 0; i < count; ++i) {
                            get[i] = names[i];
                        }
                        DSKUtil.this.com = "";
                        for (i = 0; i < count; ++i) {
                            DSKUtil.this.writeToDsk(get[i]);
                        }
                    }
                    droptarget.dropComplete(true);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

