/*
 * Decompiled with CFR 0.152.
 */
package jemu.ui.paint;

import com.jhlabs.image.ContrastFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jemu.system.cpc.CPC;
import jemu.system.cpc.GateArray;

public class FOSPaint
extends JFrame {
    final URL icons = this.getClass().getResource("FOSIcon.png");
    final Image Icons = this.getToolkit().getImage(this.icons);
    BufferedImage renderBuffer = new BufferedImage(512, 256, 1);
    BufferedImage displayBuffer = new BufferedImage(512, 512, 1);
    int[] fixedPalette = new int[]{0, 0xFFFFFF};
    FileDialog loadDiag;
    FileDialog saveDiag;
    String filepath;
    String filename;
    Image test;
    ContrastFilter contrastfilter = new ContrastFilter();
    float[] gain = new float[]{0.0f, 0.01f, 0.02f, 0.03f, 0.04f, 0.05f, 0.06f, 0.07f, 0.08f, 0.09f, 0.1f, 0.11f, 0.12f, 0.13f, 0.14f, 0.15f, 0.16f, 0.17f, 0.18f, 0.19f, 0.2f, 0.21f, 0.22f, 0.23f, 0.24f, 0.25f, 0.26f, 0.27f, 0.28f, 0.29f, 0.3f, 0.31f, 0.32f, 0.33f, 0.34f, 0.35f, 0.36f, 0.37f, 0.38f, 0.39f, 0.4f, 0.41f, 0.42f, 0.43f, 0.44f, 0.45f, 0.46f, 0.47f, 0.48f, 0.49f, 0.5f, 0.51f, 0.52f, 0.53f, 0.54f, 0.55f, 0.56f, 0.57f, 0.58f, 0.59f, 0.6f, 0.61f, 0.62f, 0.63f, 0.64f, 0.65f, 0.66f, 0.67f, 0.68f, 0.69f, 0.7f, 0.71f, 0.72f, 0.73f, 0.74f, 0.75f, 0.76f, 0.77f, 0.78f, 0.79f, 0.8f, 0.81f, 0.82f, 0.83f, 0.84f, 0.85f, 0.86f, 0.87f, 0.88f, 0.89f, 0.9f, 0.91f, 0.92f, 0.93f, 0.94f, 0.95f, 0.96f, 0.97f, 0.98f, 0.99f, 1.0f};
    boolean dlevel = true;
    int ditherval = 20;
    private JSlider bright;
    private JSlider contrast;
    private JButton jButton1;
    private JButton jButton2;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JSlider jSlider1;
    private JTextField jTextField1;

    public void init() {
        GateArray.cpc.SetFOS();
    }

    void Save() {
        String name = this.jTextField1.getText();
        while (name.length() < 8) {
            name = name + " ";
        }
        name = name + ".HGB";
        try {
            byte[] namebytes = name.getBytes("UTF-8");
            int addr = 36956;
            for (int i = 0; i < namebytes.length; ++i) {
                CPC.POKE(addr + i, namebytes[i]);
            }
            CPC.POKE(16383, 1);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void Import() {
        if (this.loadDiag == null) {
            this.loadDiag = new FileDialog((Frame)this, "Import Picture", 0);
        }
        this.loadDiag.setVisible(true);
        String path = this.loadDiag.getDirectory();
        String file = this.loadDiag.getFile();
        if (file == null || path == null) {
            return;
        }
        this.Import(path, file);
    }

    void reImport() {
        if (this.test == null) {
            return;
        }
        this.Import(this.test);
    }

    void Import(Image test2) {
        this.displayBuffer.getGraphics().drawImage(test2, 0, 0, this);
        this.contrastfilter.setBrightness(this.gain[this.bright.getValue()] * 2.0f);
        this.contrastfilter.setContrast(this.gain[this.contrast.getValue()] * 2.0f);
        this.contrastfilter.filter(this.displayBuffer, this.displayBuffer);
        this.renderBuffer.getGraphics().drawImage(this.displayBuffer, 0, 0, 512, 256, this);
        this.buildCPCScreen(this.renderBuffer);
        this.displayBuffer.getGraphics().drawImage(this.renderBuffer, 0, 0, 512, 512, this);
        this.displayBuffer.getGraphics().drawImage(this.Icons, 0, 0, this);
        this.jLabel1.setIcon(new ImageIcon(this.displayBuffer));
        for (int x = 0; x < 512; ++x) {
            for (int y = 0; y < 256; ++y) {
                int color = this.renderBuffer.getRGB(x, y);
                if (color == -1) {
                    CPC.PLOTFOS(x, y, 1, 2);
                    continue;
                }
                CPC.PLOTFOS(x, y, 0, 2);
            }
        }
    }

    void Import(String path, String file) {
        this.filepath = path;
        this.filename = file;
        try {
            BufferedImage imp = ImageIO.read(new File(path + file));
            this.test = imp.getScaledInstance(512, -1, 4);
            if (this.test.getHeight(this) < 512) {
                this.test = imp.getScaledInstance(-1, 512, 4);
            }
            this.Import(this.test);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public FOSPaint() {
        this.initComponents();
        this.displayBuffer.getGraphics().drawImage(this.Icons, 0, 0, this);
        this.displayBuffer.getGraphics().drawImage(this.Icons, 0, 0, this);
    }

    public void buildCPCScreen(BufferedImage image) {
        boolean dither = true;
        if (this.ditherval > 118) {
            dither = false;
        }
        int[][] cpComp = new int[this.fixedPalette.length][3];
        for (int k = 0; k < this.fixedPalette.length; ++k) {
            cpComp[k][0] = FOSPaint.red(this.fixedPalette[k]);
            cpComp[k][1] = FOSPaint.green(this.fixedPalette[k]);
            cpComp[k][2] = FOSPaint.blue(this.fixedPalette[k]);
        }
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                int pixel = image.getRGB(x, y);
                int pixelR = FOSPaint.red(pixel);
                int pixelG = FOSPaint.green(pixel);
                int pixelB = FOSPaint.blue(pixel);
                int minimumDistance = 195076;
                int ncIndex = -1;
                for (int j = 0; j < this.fixedPalette.length; ++j) {
                    int rDiff = pixelR - cpComp[j][0];
                    int gDiff = pixelG - cpComp[j][1];
                    int bDiff = pixelB - cpComp[j][2];
                    int distance = (int)((double)(rDiff * rDiff) * 0.299 + (double)(gDiff * gDiff) * 0.587 + (double)(bDiff * bDiff) * 0.114);
                    if (distance >= minimumDistance) continue;
                    minimumDistance = distance;
                    ncIndex = j;
                }
                image.setRGB(x, y, this.fixedPalette[ncIndex]);
                if (!dither) continue;
                for (int i = 0; i < 4; ++i) {
                    int yCoor;
                    int xCoor = i == 0 ? x + 1 : (i == 1 ? x - 1 : (i == 2 ? x : x + 1));
                    int n = yCoor = i == 0 ? y : y + 1;
                    if (xCoor < 0 || xCoor >= image.getWidth() || yCoor >= image.getHeight()) continue;
                    double factor = i == 0 ? 7.0 / (double)this.ditherval : (i == 1 ? 3.0 / (double)this.ditherval : (i == 2 ? 5.0 / (double)this.ditherval : 1.0 / (double)this.ditherval));
                    int p = image.getRGB(xCoor, yCoor);
                    int newRed = (int)Math.round((double)FOSPaint.red(p) + factor * (double)(pixelR - cpComp[ncIndex][0]));
                    int newGreen = (int)Math.round((double)FOSPaint.green(p) + factor * (double)(pixelG - cpComp[ncIndex][1]));
                    int newBlue = (int)Math.round((double)FOSPaint.blue(p) + factor * (double)(pixelB - cpComp[ncIndex][2]));
                    if (newRed < 0) {
                        newRed = 0;
                    }
                    if (newRed > 255) {
                        newRed = 255;
                    }
                    if (newGreen < 0) {
                        newGreen = 0;
                    }
                    if (newGreen > 255) {
                        newGreen = 255;
                    }
                    if (newBlue < 0) {
                        newBlue = 0;
                    }
                    if (newBlue > 255) {
                        newBlue = 255;
                    }
                    image.setRGB(xCoor, yCoor, -16777216 + (newRed << 16) + (newGreen << 8) + newBlue);
                }
            }
        }
    }

    public static int red(int argb) {
        return argb >> 16 & 0xFF;
    }

    public static int green(int argb) {
        return argb >> 8 & 0xFF;
    }

    public static int blue(int argb) {
        return argb & 0xFF;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jPanel2 = new JPanel();
        this.jButton1 = new JButton();
        this.jLabel2 = new JLabel();
        this.jSlider1 = new JSlider();
        this.jLabel3 = new JLabel();
        this.bright = new JSlider();
        this.contrast = new JSlider();
        this.jLabel4 = new JLabel();
        this.jTextField1 = new JTextField();
        this.jButton2 = new JButton();
        this.setTitle("FutureOS Wallpaper Tool");
        this.jPanel1.setPreferredSize(new Dimension(512, 600));
        this.jPanel1.setLayout(new BorderLayout());
        this.jLabel1.setPreferredSize(new Dimension(512, 512));
        this.jPanel1.add((Component)this.jLabel1, "First");
        this.jPanel2.setPreferredSize(new Dimension(512, 180));
        this.jButton1.setText("Import");
        this.jButton1.setFocusable(false);
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FOSPaint.this.jButton1ActionPerformed(evt);
            }
        });
        this.jLabel2.setText("Dither:");
        this.jSlider1.setMaximum(120);
        this.jSlider1.setMinimum(10);
        this.jSlider1.setValue(20);
        this.jSlider1.setInverted(true);
        this.jSlider1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                FOSPaint.this.jSlider1StateChanged(evt);
            }
        });
        this.jLabel3.setText("Brightness:");
        this.bright.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                FOSPaint.this.brightStateChanged(evt);
            }
        });
        this.contrast.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                FOSPaint.this.brightStateChanged(evt);
            }
        });
        this.jLabel4.setText("Contrast:");
        this.jTextField1.setFont(new Font("Monospaced", 1, 11));
        this.jTextField1.setText("BACKGRND");
        this.jTextField1.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                FOSPaint.this.jTextField1KeyReleased(evt);
            }
        });
        this.jButton2.setText("Save");
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FOSPaint.this.jButton2ActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jButton1, -1, -1, Short.MAX_VALUE).addComponent(this.jTextField1).addComponent(this.jButton2, -1, -1, Short.MAX_VALUE)).addGap(18, 18, 18).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jLabel4, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel3, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel2, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSlider1, -1, -1, Short.MAX_VALUE).addComponent(this.bright, -1, 351, Short.MAX_VALUE).addComponent(this.contrast, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton1).addComponent(this.jLabel2)).addComponent(this.jSlider1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.bright, -2, 0, Short.MAX_VALUE).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jTextField1, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.contrast, -2, 0, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.jButton2))).addGap(76, 76, 76)));
        this.jPanel1.add((Component)this.jPanel2, "Center");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, 616, Short.MAX_VALUE));
        this.pack();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.Import();
    }

    private void jSlider1StateChanged(ChangeEvent evt) {
        this.ditherval = this.jSlider1.getValue();
        this.reImport();
    }

    private void brightStateChanged(ChangeEvent evt) {
        this.reImport();
    }

    private void jTextField1KeyReleased(KeyEvent evt) {
        String g = this.jTextField1.getText();
        while (g.length() > 8) {
            g = g.substring(0, g.length() - 1);
        }
        g = g.toUpperCase();
        this.jTextField1.setText(g);
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.Save();
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(FOSPaint.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(FOSPaint.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(FOSPaint.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(FOSPaint.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new FOSPaint().setVisible(true);
            }
        });
    }
}

