/*
 * Decompiled with CFR 0.152.
 */
package jemu.ui.paint;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.border.EtchedBorder;
import jemu.core.device.Computer;
import jemu.settings.Settings;
import jemu.system.cpc.GraphicsDecoder;
import jemu.ui.paint.ImageImporter;
import jemu.ui.paint.PaintCanvas;

public class ImagePreview
extends JComponent
implements PropertyChangeListener {
    final URL cpcicon = this.getClass().getResource("cpc.gif");
    ImageIcon thumbnail = null;
    File file = null;
    JLabel label = new JLabel(){

        @Override
        public void setText(String text) {
            super.setText("  " + text);
        }
    };
    JCheckBox box = new JCheckBox("Larger");
    PaintCanvas canv = new PaintCanvas();
    ImageImporter imageImporter = new ImageImporter();
    GraphicsDecoder decoder = new GraphicsDecoder();
    protected int thumbWidth = 200;

    public ImagePreview(final JFileChooser fc) {
        this.box.setSelected(Settings.getBoolean("thumbsize", false));
        this.thumbWidth = this.box.isSelected() ? 320 : 190;
        this.setPreferredSize(new Dimension(this.thumbWidth + 20, 200));
        this.setBorder(new EtchedBorder());
        this.setLayout(new BorderLayout());
        this.add((Component)this.box, "North");
        this.add((Component)this.label, "South");
        this.box.setFocusable(false);
        this.box.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                ImagePreview.this.loadImage();
                ImagePreview.this.repaint();
                fc.updateUI();
                Settings.setBoolean("thumbsize", ImagePreview.this.box.isSelected());
            }
        });
        fc.addPropertyChangeListener(this);
    }

    public static boolean CheckAMSDOS(byte[] pHeader) {
        int CalculatedChecksum;
        try {
            CalculatedChecksum = Computer.ChecksumAMSDOS(pHeader);
        }
        catch (Exception e) {
            return false;
        }
        int ChecksumFromHeader = pHeader[67] & 0xFF | (pHeader[68] & 0xFF) << 8;
        if (ChecksumFromHeader == CalculatedChecksum && ChecksumFromHeader != 0) {
            System.out.println("Has AMSDOS header");
            return true;
        }
        System.out.println("Without header");
        return false;
    }

    public void loadImage() {
        try {
            if (this.file == null) {
                this.thumbnail = null;
                return;
            }
            this.thumbWidth = this.box.isSelected() ? 320 : 190;
            this.setPreferredSize(new Dimension(this.thumbWidth + 20, 200));
            Image buffer = null;
            try {
                if (this.file.getPath().toLowerCase().endsWith(".scr") || this.file.getPath().toLowerCase().endsWith(".sna")) {
                    if (this.file.getPath().toLowerCase().endsWith(".sna")) {
                        this.label.setText("CPC - SNA");
                    } else if (this.file.length() < 18000L) {
                        this.label.setText("CPC - SCR 16k");
                    } else {
                        this.label.setText("CPC - SCR 32k");
                    }
                    buffer = this.getToolkit().getImage(this.cpcicon);
                } else if (this.file.getPath().toLowerCase().endsWith(".drw")) {
                    this.label.setText("CPC - DRW - 320x200px");
                    try {
                        byte[] buff = new byte[(int)this.file.length()];
                        BufferedInputStream bin = new BufferedInputStream(new FileInputStream(this.file));
                        bin.read(buff);
                        bin.close();
                        BufferedImage doodle = this.canv.importDoodle(buff, false);
                        buffer = doodle.getScaledInstance(this.thumbWidth, -1, 4);
                    }
                    catch (Exception buff) {}
                } else {
                    buffer = this.imageImporter.readImage(this.file.getPath());
                    this.label.setText(this.imageImporter.getFileType() + " - " + buffer.getWidth(null) + "x" + buffer.getHeight(null) + "px");
                }
            }
            catch (Exception e) {
                buffer = this.getToolkit().getImage(this.cpcicon);
                this.label.setText("Unknown format");
            }
            ImageIcon tmpIcon = new ImageIcon(buffer);
            this.thumbnail = tmpIcon.getIconWidth() > this.thumbWidth ? new ImageIcon(tmpIcon.getImage().getScaledInstance(this.thumbWidth, -1, 4)) : tmpIcon;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        boolean update = false;
        String prop = e.getPropertyName();
        if ("directoryChanged".equals(prop)) {
            this.file = null;
            update = true;
        } else if ("SelectedFileChangedProperty".equals(prop)) {
            this.file = (File)e.getNewValue();
            update = true;
        }
        if (update) {
            this.thumbnail = null;
            if (this.isShowing()) {
                this.loadImage();
                this.repaint();
            }
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.thumbnail == null) {
            this.loadImage();
        }
        if (this.thumbnail != null) {
            int x = this.getWidth() / 2 - this.thumbnail.getIconWidth() / 2;
            int y = this.getHeight() / 2 - this.thumbnail.getIconHeight() / 2;
            if (y < 0) {
                y = 0;
            }
            if (x < 5) {
                x = 5;
            }
            this.thumbnail.paintIcon(this, g, x, y);
        }
    }
}

