/*
 * Decompiled with CFR 0.152.
 */
package jemu.ui.paint;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import jemu.core.device.internalfilesystem.ImageExporter;
import jemu.system.cpc.CPC;
import jemu.system.cpc.GateArray;
import jemu.ui.Display;
import jemu.ui.JEMU;
import jemu.ui.paint.PaintCanvas;

public class MovieMaker
extends JFrame {
    private ArrayList<DropTarget> dropTargetList = new ArrayList();
    int sw;
    int sh;
    FileDialog quart;
    int[] xpos = new int[]{0, 160, 0, 160};
    int[] ypos = new int[]{0, 0, 100, 100};
    FileDialog fial;
    FileDialog fias;
    boolean isExporting = false;
    ImageExporter exporter = new ImageExporter();
    int[] fps = new int[]{8, 10, 15, 20, 25, 30, 50};
    int smode = 1;
    public JLabel counter;
    public JCheckBox exact;
    public JCheckBox inklock;
    private JButton jButton1;
    private JButton jButton2;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JButton loadB;
    public static JCheckBox loop;
    public JLabel max;
    public JButton mode;
    private JButton mode1;
    public JProgressBar moviepos;
    public JToggleButton nextB;
    private JButton playB;
    public JToggleButton prevB;
    private JButton recB;
    private JButton saveB;
    public JComboBox<String> speed;
    private JButton stopB;
    public JDesktopPane watch;

    public MovieMaker() {
        DropListener myListener = new DropListener();
        if (Display.doublesize) {
            this.sw = 80;
            this.sh = 480;
        } else {
            this.sw = 40;
            this.sh = 240;
        }
        this.initComponents();
        MovieMaker.registerDropListener(this.dropTargetList, this, myListener);
    }

    private void Quarterize() {
        int i;
        if (this.isExporting) {
            return;
        }
        if (this.quart == null) {
            this.quart = new FileDialog((Frame)this, "Select first picture:", 0);
        }
        this.quart.setVisible(true);
        String a = this.quart.getFile();
        if (a == null) {
            return;
        }
        a = this.quart.getDirectory();
        String[] files = new File(a).list();
        BufferedImage buffer = new BufferedImage(320, 200, 1);
        Graphics2D g = buffer.createGraphics();
        int pos = 0;
        int filelength = 0;
        int clength = 0;
        BufferedImage[] read = new BufferedImage[4];
        File z = new File(a + "/quarter/");
        if (!z.exists()) {
            z.mkdir();
        }
        for (i = 0; i < files.length; ++i) {
            if (!files[i].toLowerCase().endsWith(".jpg") && !files[i].toLowerCase().endsWith(".png") && !files[i].toLowerCase().endsWith(".bmp") && !files[i].toLowerCase().endsWith(".gif")) continue;
            ++filelength;
        }
        try {
            for (i = 0; i < files.length; ++i) {
                if (!files[i].toLowerCase().endsWith(".jpg") && !files[i].toLowerCase().endsWith(".png") && !files[i].toLowerCase().endsWith(".bmp") && !files[i].toLowerCase().endsWith(".gif")) continue;
                if (pos == 0) {
                    g.setColor(Color.BLACK);
                    g.fillRect(0, 0, 320, 200);
                }
                read[pos] = ImageIO.read(new BufferedInputStream(new FileInputStream(new File(a + files[i]))));
                if (++pos != 4) continue;
                for (int k = 0; k < 4; ++k) {
                    g.drawImage(read[k], this.xpos[k], this.ypos[k], 160, 100, this);
                }
                String index = "" + clength++;
                while (index.length() < 8) {
                    index = "0" + index;
                }
                index = a + "/quarter/output_" + index + ".png";
                z = new File(index);
                ImageIO.write((RenderedImage)buffer, "PNG", z);
                pos = 0;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void TransformMovie(final MovieMaker maker) {
        if (this.isExporting) {
            return;
        }
        Thread t = new Thread(){

            @Override
            public void run() {
                MovieMaker.this.isExporting = true;
                if (MovieMaker.this.fial == null) {
                    MovieMaker.this.fial = new FileDialog((Frame)maker, "Transform ANI", 0);
                }
                MovieMaker.this.fial.setFile("*.ani");
                MovieMaker.this.fial.setVisible(true);
                String a = MovieMaker.this.fial.getFile();
                if (a == null || !a.toLowerCase().endsWith(".ani")) {
                    return;
                }
                a = MovieMaker.this.fial.getDirectory() + MovieMaker.this.fial.getFile();
                if (MovieMaker.this.fias == null) {
                    MovieMaker.this.fias = new FileDialog((Frame)maker, "Export SCR", 1);
                }
                MovieMaker.this.fias.setFile("*.scr");
                MovieMaker.this.fias.setVisible(true);
                String b = MovieMaker.this.fial.getFile();
                if (b == null) {
                    return;
                }
                b = MovieMaker.this.fias.getDirectory();
                if (b.contains(".")) {
                    String[] bb = b.split(".");
                    b = bb[0];
                }
                long offset = 1L;
                try {
                    RandomAccessFile buffer = new RandomAccessFile(a, "rw");
                    long frames = (buffer.length() - 18L) / 16384L;
                    System.out.println("Frames found: " + frames);
                    buffer.seek(offset);
                    byte[] scrinfo = new byte[17];
                    buffer.read(scrinfo);
                    int i = 0;
                    while ((long)i < frames) {
                        byte[] screen = new byte[16384];
                        buffer.read(screen);
                        String FrameName = "" + i;
                        while (FrameName.length() < 8) {
                            FrameName = "0" + FrameName;
                        }
                        String intern = FrameName;
                        FrameName = b + "/" + FrameName + ".scr";
                        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(new File(FrameName)));
                        for (int t = 0; t < GateArray.cpc.SCR_CODE.length; ++t) {
                            screen[2000 + t] = (byte)GateArray.cpc.SCR_CODE[t];
                        }
                        System.arraycopy(scrinfo, 0, screen, 6096, scrinfo.length);
                        screen = MovieMaker.this.exporter.makeHeader(2, 49152, 16384, 0, intern, screen);
                        bos.write(screen);
                        bos.close();
                        if (!MovieMaker.this.isExporting) break;
                        ++i;
                    }
                    buffer.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        t.start();
    }

    private static void registerDropListener(ArrayList<DropTarget> list, Container basePanel, DropListener myListener) {
        list.add(new DropTarget(basePanel, myListener));
        Component[] components = basePanel.getComponents();
        for (int i = 0; i < components.length; ++i) {
            Component component = components[i];
            if (component instanceof Container) {
                MovieMaker.registerDropListener(list, (Container)component, myListener);
                continue;
            }
            list.add(new DropTarget(component, myListener));
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jLabel4 = new JLabel();
        this.inklock = new JCheckBox();
        this.mode = new JButton();
        loop = new JCheckBox();
        this.exact = new JCheckBox();
        this.speed = new JComboBox();
        this.jButton2 = new JButton();
        this.mode1 = new JButton();
        this.watch = new JDesktopPane(){

            @Override
            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                if (JEMU.large) {
                    g.drawImage(Display.image, 0, 0, 320, 200, 64, MovieMaker.this.sw, 704, MovieMaker.this.sh, this);
                } else {
                    g.drawImage(Display.image, 0, 0, 320, 200, 32, MovieMaker.this.sw, 352, MovieMaker.this.sh, this);
                }
            }
        };
        this.moviepos = new JProgressBar();
        this.nextB = new JToggleButton();
        this.prevB = new JToggleButton();
        this.loadB = new JButton();
        this.saveB = new JButton();
        this.playB = new JButton();
        this.stopB = new JButton();
        this.jButton1 = new JButton();
        this.jLabel3 = new JLabel();
        this.counter = new JLabel();
        this.max = new JLabel();
        this.recB = new JButton();
        this.setDefaultCloseOperation(3);
        this.setTitle("JavaCPC MovieMaker");
        this.setAlwaysOnTop(true);
        this.setResizable(false);
        this.jLabel2.setFont(new Font("Tahoma", 2, 11));
        this.jLabel2.setText("JavaCPC MovieMaker 1.2");
        this.jLabel2.setEnabled(false);
        this.jLabel4.setHorizontalAlignment(4);
        this.jLabel4.setText("Total:");
        this.inklock.setText("Lock INKs");
        this.inklock.setFocusPainted(false);
        this.inklock.setFocusable(false);
        this.mode.setText("MODE 1");
        this.mode.setFocusPainted(false);
        this.mode.setFocusable(false);
        this.mode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MovieMaker.this.modeActionPerformed(evt);
            }
        });
        loop.setText("Loop");
        loop.setFocusPainted(false);
        loop.setFocusable(false);
        this.exact.setText("Fast");
        this.exact.setFocusPainted(false);
        this.exact.setFocusable(false);
        this.exact.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MovieMaker.this.exactActionPerformed(evt);
            }
        });
        this.speed.setModel(new DefaultComboBoxModel<String>(new String[]{"8 FPS", "10 FPS", "15 FPS", "20 FPS", "25 FPS", "30 FPS", "50 FPS"}));
        this.speed.setSelectedIndex(5);
        this.jButton2.setText("ANI to SCR");
        this.jButton2.setFocusable(false);
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MovieMaker.this.jButton2ActionPerformed(evt);
            }
        });
        this.mode1.setText("1/4 Size");
        this.mode1.setFocusPainted(false);
        this.mode1.setFocusable(false);
        this.mode1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MovieMaker.this.mode1ActionPerformed(evt);
            }
        });
        this.watch.setBorder(BorderFactory.createBevelBorder(1));
        this.watch.setMaximumSize(new Dimension(320, 200));
        this.watch.setMinimumSize(new Dimension(320, 200));
        this.nextB.setText(">");
        this.nextB.setFocusPainted(false);
        this.nextB.setFocusable(false);
        this.nextB.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                MovieMaker.this.nextBMousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                MovieMaker.this.nextBMouseReleased(evt);
            }
        });
        this.prevB.setText("<");
        this.prevB.setFocusPainted(false);
        this.prevB.setFocusable(false);
        this.prevB.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                MovieMaker.this.prevBMousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                MovieMaker.this.prevBMouseReleased(evt);
            }
        });
        this.loadB.setText("Load");
        this.loadB.setFocusPainted(false);
        this.loadB.setFocusable(false);
        this.loadB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MovieMaker.this.loadBActionPerformed(evt);
            }
        });
        this.saveB.setText("Save");
        this.saveB.setFocusPainted(false);
        this.saveB.setFocusable(false);
        this.saveB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MovieMaker.this.saveBActionPerformed(evt);
            }
        });
        this.playB.setText("Play");
        this.playB.setFocusPainted(false);
        this.playB.setFocusable(false);
        this.playB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MovieMaker.this.playBActionPerformed(evt);
            }
        });
        this.stopB.setText("Pause");
        this.stopB.setFocusPainted(false);
        this.stopB.setFocusable(false);
        this.stopB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MovieMaker.this.stopBActionPerformed(evt);
            }
        });
        this.jButton1.setText("Stop");
        this.jButton1.setFocusPainted(false);
        this.jButton1.setFocusable(false);
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MovieMaker.this.jButton1ActionPerformed(evt);
            }
        });
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setText("Frame:");
        this.counter.setHorizontalAlignment(4);
        this.counter.setText("0");
        this.counter.setBorder(BorderFactory.createEtchedBorder());
        this.max.setHorizontalAlignment(4);
        this.max.setText("0");
        this.max.setBorder(BorderFactory.createEtchedBorder());
        this.recB.setText("Rec.");
        this.recB.setFocusPainted(false);
        this.recB.setFocusable(false);
        this.recB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MovieMaker.this.recBActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.recB).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.inklock).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.exact).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(loop)).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent(this.prevB).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.moviepos, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nextB)).addComponent(this.watch, GroupLayout.Alignment.TRAILING, -2, 320, -2).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent(this.loadB, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.saveB).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.playB).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.stopB).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1)).addComponent(this.jLabel2, -2, 192, -2).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(GroupLayout.Alignment.LEADING, jPanel1Layout.createSequentialGroup().addComponent(this.jLabel4, -2, 44, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.max, -2, 40, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.mode1, -1, -1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.LEADING, jPanel1Layout.createSequentialGroup().addComponent(this.jLabel3, -2, 44, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.counter, -2, 40, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.mode, -1, -1, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.speed, 0, -1, Short.MAX_VALUE).addComponent(this.jButton2, -1, -1, Short.MAX_VALUE))));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.watch, -2, 200, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.moviepos, -2, 22, -2).addComponent(this.prevB).addComponent(this.nextB)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.loadB).addComponent(this.saveB).addComponent(this.playB).addComponent(this.stopB).addComponent(this.jButton1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.inklock).addComponent(this.exact).addComponent(loop).addComponent(this.recB)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.counter).addComponent(this.mode).addComponent(this.speed, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.max).addComponent(this.mode1).addComponent(this.jButton2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jLabel2).addGap(0, 0, 0)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.jPanel1, -2, -1, -2).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void stopBActionPerformed(ActionEvent evt) {
        CPC.playmovie = false;
    }

    private void playBActionPerformed(ActionEvent evt) {
        CPC.playmovie = true;
        CPC.initmovie = true;
        CPC.movieFPS = this.fps[this.speed.getSelectedIndex()];
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        CPC.playmovie = false;
        CPC.moviecount = 0;
        PaintCanvas.stop = true;
    }

    private void prevBMouseReleased(MouseEvent evt) {
        this.prevB.setSelected(false);
    }

    private void nextBMouseReleased(MouseEvent evt) {
        this.nextB.setSelected(false);
    }

    private void prevBMousePressed(MouseEvent evt) {
        this.prevB.setSelected(true);
    }

    private void nextBMousePressed(MouseEvent evt) {
        this.nextB.setSelected(true);
    }

    private void saveBActionPerformed(ActionEvent evt) {
        PaintCanvas.savemovie = true;
    }

    private void loadBActionPerformed(ActionEvent evt) {
        PaintCanvas.loadmovie = true;
    }

    private void recBActionPerformed(ActionEvent evt) {
        PaintCanvas.recordmovie = true;
    }

    private void modeActionPerformed(ActionEvent evt) {
        this.smode = GateArray.getSMode();
        if (this.smode == 1) {
            this.smode = 2;
            this.mode.setText("MODE 2");
            CPC.POKE(36863, 2);
        } else if (this.smode == 2) {
            this.smode = 0;
            this.mode.setText("MODE 0");
            CPC.POKE(36863, 3);
        } else if (this.smode == 0) {
            this.smode = 1;
            this.mode.setText("MODE 1");
            CPC.POKE(36863, 1);
        }
        if (PaintCanvas.MODE == PaintCanvas.MODE_IMPORT) {
            PaintCanvas.recalculate = 1;
        }
    }

    private void exactActionPerformed(ActionEvent evt) {
        PaintCanvas.moviemake = 0;
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        if (!this.isExporting) {
            this.TransformMovie(this);
        } else {
            this.isExporting = false;
        }
    }

    private void mode1ActionPerformed(ActionEvent evt) {
        this.Quarterize();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new MovieMaker().setVisible(true);
            }
        });
    }

    private class DropListener
    extends DropTargetAdapter {
        private DropListener() {
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            try {
                Transferable t = dtde.getTransferable();
                if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    dtde.acceptDrop(3);
                    Object userObject = t.getTransferData(DataFlavor.javaFileListFlavor);
                    if (userObject instanceof List) {
                        String fileName;
                        PaintCanvas.dragname = fileName = ((List)userObject).get(0).toString();
                    }
                    dtde.dropComplete(true);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

